/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3danimation_python.h"

// main header
#include "qt3danimation_qkeyframeanimation_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DAnimation;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QKeyframeAnimationWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QKeyframeAnimationWrapper::QKeyframeAnimationWrapper(::QObject * parent) : Qt3DAnimation::QKeyframeAnimation(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QKeyframeAnimationWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QKeyframeAnimationWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QKeyframeAnimationWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QKeyframeAnimationWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QKeyframeAnimationWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QKeyframeAnimation.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QKeyframeAnimationWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QKeyframeAnimation.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QKeyframeAnimationWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QKeyframeAnimationWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DAnimation::QKeyframeAnimation::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QKeyframeAnimationWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DAnimation::QKeyframeAnimation::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QKeyframeAnimationWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QKeyframeAnimationWrapper *>(this));
        return Qt3DAnimation::QKeyframeAnimation::qt_metacast(_clname);
}

QKeyframeAnimationWrapper::~QKeyframeAnimationWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DAnimation_QKeyframeAnimation_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DAnimation::QKeyframeAnimation >()))
        return -1;

    ::QKeyframeAnimationWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QKeyframeAnimation", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QKeyframeAnimation::QKeyframeAnimation(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QKeyframeAnimation(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QKeyframeAnimation(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QKeyframeAnimation_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_Qt3DAnimation_QKeyframeAnimation_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_Qt3DAnimation_QKeyframeAnimation_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QKeyframeAnimation(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QKeyframeAnimationWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QKeyframeAnimationWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DAnimation::QKeyframeAnimation >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DAnimation_QKeyframeAnimation_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DAnimation_QKeyframeAnimation_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DAnimation_QKeyframeAnimation_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DAnimation_QKeyframeAnimationFunc_addKeyframe(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.addKeyframe";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QKeyframeAnimation::addKeyframe(Qt3DCore::QTransform*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QTRANSFORM_IDX]), (pyArg)))) {
        overloadId = 0; // addKeyframe(Qt3DCore::QTransform*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QKeyframeAnimationFunc_addKeyframe_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DCore::QTransform *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addKeyframe(Qt3DCore::QTransform*)
            cppSelf->addKeyframe(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QKeyframeAnimationFunc_addKeyframe_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QKeyframeAnimationFunc_easing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.easing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // easing()const
            QEasingCurve cppResult = const_cast<const ::Qt3DAnimation::QKeyframeAnimation *>(cppSelf)->easing();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DAnimation_QKeyframeAnimationFunc_endMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.endMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // endMode()const
            Qt3DAnimation::QKeyframeAnimation::RepeatMode cppResult = const_cast<const ::Qt3DAnimation::QKeyframeAnimation *>(cppSelf)->endMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_REPEATMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DAnimation_QKeyframeAnimationFunc_framePositions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.framePositions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // framePositions()const
            QVector<float > cppResult = const_cast<const ::Qt3DAnimation::QKeyframeAnimation *>(cppSelf)->framePositions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_FLOAT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DAnimation_QKeyframeAnimationFunc_keyframeList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.keyframeList";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // keyframeList()const
            QVector<Qt3DCore::QTransform* > cppResult = const_cast<const ::Qt3DAnimation::QKeyframeAnimation *>(cppSelf)->keyframeList();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DCORE_QTRANSFORMPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DAnimation_QKeyframeAnimationFunc_removeKeyframe(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.removeKeyframe";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QKeyframeAnimation::removeKeyframe(Qt3DCore::QTransform*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QTRANSFORM_IDX]), (pyArg)))) {
        overloadId = 0; // removeKeyframe(Qt3DCore::QTransform*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QKeyframeAnimationFunc_removeKeyframe_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DCore::QTransform *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeKeyframe(Qt3DCore::QTransform*)
            cppSelf->removeKeyframe(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QKeyframeAnimationFunc_removeKeyframe_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setEasing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.setEasing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QKeyframeAnimation::setEasing(QEasingCurve)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), (pyArg)))) {
        overloadId = 0; // setEasing(QEasingCurve)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setEasing_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEasingCurve cppArg0_local;
        ::QEasingCurve *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEASINGCURVE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setEasing(QEasingCurve)
            cppSelf->setEasing(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setEasing_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setEndMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.setEndMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QKeyframeAnimation::setEndMode(Qt3DAnimation::QKeyframeAnimation::RepeatMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_REPEATMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setEndMode(Qt3DAnimation::QKeyframeAnimation::RepeatMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setEndMode_TypeError;

    // Call function/method
    {
        ::Qt3DAnimation::QKeyframeAnimation::RepeatMode cppArg0{Qt3DAnimation::QKeyframeAnimation::None};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEndMode(Qt3DAnimation::QKeyframeAnimation::RepeatMode)
            cppSelf->setEndMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setEndMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setFramePositions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.setFramePositions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QKeyframeAnimation::setFramePositions(QVector<float>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_FLOAT_IDX], (pyArg)))) {
        overloadId = 0; // setFramePositions(QVector<float>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setFramePositions_TypeError;

    // Call function/method
    {
        ::QVector<float > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFramePositions(QVector<float>)
            cppSelf->setFramePositions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setFramePositions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setKeyframes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.setKeyframes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QKeyframeAnimation::setKeyframes(QVector<Qt3DCore::QTransform*>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_Qt3DAnimationTypeConverters[SBK_QT3DANIMATION_QVECTOR_QT3DCORE_QTRANSFORMPTR_IDX], (pyArg)))) {
        overloadId = 0; // setKeyframes(QVector<Qt3DCore::QTransform*>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setKeyframes_TypeError;

    // Call function/method
    {
        ::QVector<Qt3DCore::QTransform* > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setKeyframes(QVector<Qt3DCore::QTransform*>)
            cppSelf->setKeyframes(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setKeyframes_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setStartMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.setStartMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QKeyframeAnimation::setStartMode(Qt3DAnimation::QKeyframeAnimation::RepeatMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_REPEATMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setStartMode(Qt3DAnimation::QKeyframeAnimation::RepeatMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setStartMode_TypeError;

    // Call function/method
    {
        ::Qt3DAnimation::QKeyframeAnimation::RepeatMode cppArg0{Qt3DAnimation::QKeyframeAnimation::None};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStartMode(Qt3DAnimation::QKeyframeAnimation::RepeatMode)
            cppSelf->setStartMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setStartMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setTarget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.setTarget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QKeyframeAnimation::setTarget(Qt3DCore::QTransform*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QTRANSFORM_IDX]), (pyArg)))) {
        overloadId = 0; // setTarget(Qt3DCore::QTransform*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setTarget_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::Qt3DCore::QTransform *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTarget(Qt3DCore::QTransform*)
            cppSelf->setTarget(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setTarget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setTargetName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.setTargetName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QKeyframeAnimation::setTargetName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setTargetName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setTargetName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTargetName(QString)
            cppSelf->setTargetName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setTargetName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QKeyframeAnimationFunc_startMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.startMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startMode()const
            Qt3DAnimation::QKeyframeAnimation::RepeatMode cppResult = const_cast<const ::Qt3DAnimation::QKeyframeAnimation *>(cppSelf)->startMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_REPEATMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DAnimation_QKeyframeAnimationFunc_target(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.target";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // target()const
            Qt3DCore::QTransform * cppResult = const_cast<const ::Qt3DAnimation::QKeyframeAnimation *>(cppSelf)->target();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QTRANSFORM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DAnimation_QKeyframeAnimationFunc_targetName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.targetName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // targetName()const
            QString cppResult = const_cast<const ::Qt3DAnimation::QKeyframeAnimation *>(cppSelf)->targetName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DAnimation_QKeyframeAnimation_PropertyStrings[] = {
    "easing::",
    "endMode::",
    "framePositions::",
    "startMode::",
    "target::",
    "targetName::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DAnimation_QKeyframeAnimation_methods[] = {
    {"addKeyframe", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QKeyframeAnimationFunc_addKeyframe), METH_O},
    {"easing", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QKeyframeAnimationFunc_easing), METH_NOARGS},
    {"endMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QKeyframeAnimationFunc_endMode), METH_NOARGS},
    {"framePositions", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QKeyframeAnimationFunc_framePositions), METH_NOARGS},
    {"keyframeList", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QKeyframeAnimationFunc_keyframeList), METH_NOARGS},
    {"removeKeyframe", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QKeyframeAnimationFunc_removeKeyframe), METH_O},
    {"setEasing", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setEasing), METH_O},
    {"setEndMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setEndMode), METH_O},
    {"setFramePositions", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setFramePositions), METH_O},
    {"setKeyframes", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setKeyframes), METH_O},
    {"setStartMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setStartMode), METH_O},
    {"setTarget", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setTarget), METH_O},
    {"setTargetName", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QKeyframeAnimationFunc_setTargetName), METH_O},
    {"startMode", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QKeyframeAnimationFunc_startMode), METH_NOARGS},
    {"target", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QKeyframeAnimationFunc_target), METH_NOARGS},
    {"targetName", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QKeyframeAnimationFunc_targetName), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DAnimation_QKeyframeAnimation_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DAnimation::QKeyframeAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QKeyframeAnimationWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DAnimation_QKeyframeAnimation_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DAnimation_QKeyframeAnimation_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DAnimation_QKeyframeAnimation_Type = nullptr;
static SbkObjectType *Sbk_Qt3DAnimation_QKeyframeAnimation_TypeF(void)
{
    return _Sbk_Qt3DAnimation_QKeyframeAnimation_Type;
}

static PyType_Slot Sbk_Qt3DAnimation_QKeyframeAnimation_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DAnimation_QKeyframeAnimation_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DAnimation_QKeyframeAnimation_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DAnimation_QKeyframeAnimation_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DAnimation_QKeyframeAnimation_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DAnimation_QKeyframeAnimation_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DAnimation_QKeyframeAnimation_spec = {
    "2:PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DAnimation_QKeyframeAnimation_slots
};

} //extern "C"

static void *Sbk_Qt3DAnimation_QKeyframeAnimation_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DAnimation::QKeyframeAnimation *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DAnimation_QKeyframeAnimation_RepeatMode_PythonToCpp_Qt3DAnimation_QKeyframeAnimation_RepeatMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DAnimation::QKeyframeAnimation::RepeatMode *>(cppOut) =
        static_cast<::Qt3DAnimation::QKeyframeAnimation::RepeatMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DAnimation_QKeyframeAnimation_RepeatMode_PythonToCpp_Qt3DAnimation_QKeyframeAnimation_RepeatMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_REPEATMODE_IDX]))
        return Qt3DAnimation_QKeyframeAnimation_RepeatMode_PythonToCpp_Qt3DAnimation_QKeyframeAnimation_RepeatMode;
    return {};
}
static PyObject *Qt3DAnimation_QKeyframeAnimation_RepeatMode_CppToPython_Qt3DAnimation_QKeyframeAnimation_RepeatMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DAnimation::QKeyframeAnimation::RepeatMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_REPEATMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QKeyframeAnimation_PythonToCpp_QKeyframeAnimation_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DAnimation_QKeyframeAnimation_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QKeyframeAnimation_PythonToCpp_QKeyframeAnimation_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DAnimation_QKeyframeAnimation_TypeF())))
        return QKeyframeAnimation_PythonToCpp_QKeyframeAnimation_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QKeyframeAnimation_PTR_CppToPython_QKeyframeAnimation(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DAnimation::QKeyframeAnimation *>(const_cast<void *>(cppIn)), Sbk_Qt3DAnimation_QKeyframeAnimation_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DAnimation_QKeyframeAnimation_SignatureStrings[] = {
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.addKeyframe(self,keyframe:PySide2.Qt3DCore.Qt3DCore.QTransform)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.easing(self)->PySide2.QtCore.QEasingCurve",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.endMode(self)->PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.RepeatMode",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.framePositions(self)->QVector[float]",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.keyframeList(self)->QVector[PySide2.Qt3DCore.Qt3DCore.QTransform]",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.removeKeyframe(self,keyframe:PySide2.Qt3DCore.Qt3DCore.QTransform)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.setEasing(self,easing:PySide2.QtCore.QEasingCurve)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.setEndMode(self,mode:PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.RepeatMode)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.setFramePositions(self,positions:QVector[float])",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.setKeyframes(self,keyframes:QVector[PySide2.Qt3DCore.Qt3DCore.QTransform])",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.setStartMode(self,mode:PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.RepeatMode)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.setTarget(self,target:PySide2.Qt3DCore.Qt3DCore.QTransform)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.setTargetName(self,name:QString)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.startMode(self)->PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.RepeatMode",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.target(self)->PySide2.Qt3DCore.Qt3DCore.QTransform",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.targetName(self)->QString",
    nullptr}; // Sentinel

void init_Qt3DAnimation_QKeyframeAnimation(PyObject *enclosingClass)
{
    _Sbk_Qt3DAnimation_QKeyframeAnimation_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QKeyframeAnimation",
        "Qt3DAnimation::QKeyframeAnimation*",
        &Sbk_Qt3DAnimation_QKeyframeAnimation_spec,
        &Shiboken::callCppDestructor< ::Qt3DAnimation::QKeyframeAnimation >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QABSTRACTANIMATION_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DAnimation_QKeyframeAnimation_Type);
    InitSignatureStrings(pyType, Qt3DAnimation_QKeyframeAnimation_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DAnimation_QKeyframeAnimation_Type), Sbk_Qt3DAnimation_QKeyframeAnimation_PropertyStrings);
    SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DAnimation_QKeyframeAnimation_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DAnimation_QKeyframeAnimation_TypeF(),
        QKeyframeAnimation_PythonToCpp_QKeyframeAnimation_PTR,
        is_QKeyframeAnimation_PythonToCpp_QKeyframeAnimation_PTR_Convertible,
        QKeyframeAnimation_PTR_CppToPython_QKeyframeAnimation);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DAnimation::QKeyframeAnimation");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DAnimation::QKeyframeAnimation*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DAnimation::QKeyframeAnimation&");
    Shiboken::Conversions::registerConverterName(converter, "QKeyframeAnimation");
    Shiboken::Conversions::registerConverterName(converter, "QKeyframeAnimation*");
    Shiboken::Conversions::registerConverterName(converter, "QKeyframeAnimation&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DAnimation::QKeyframeAnimation).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QKeyframeAnimationWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DAnimation_QKeyframeAnimation_TypeF(), &Sbk_Qt3DAnimation_QKeyframeAnimation_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'RepeatMode'.
    SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_REPEATMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DAnimation_QKeyframeAnimation_TypeF(),
        "RepeatMode",
        "2:PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.RepeatMode",
        "Qt3DAnimation::QKeyframeAnimation::RepeatMode");
    if (!SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_REPEATMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_REPEATMODE_IDX],
        Sbk_Qt3DAnimation_QKeyframeAnimation_TypeF(), "None_", (long) Qt3DAnimation::QKeyframeAnimation::RepeatMode::None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_REPEATMODE_IDX],
        Sbk_Qt3DAnimation_QKeyframeAnimation_TypeF(), "Constant", (long) Qt3DAnimation::QKeyframeAnimation::RepeatMode::Constant))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_REPEATMODE_IDX],
        Sbk_Qt3DAnimation_QKeyframeAnimation_TypeF(), "Repeat", (long) Qt3DAnimation::QKeyframeAnimation::RepeatMode::Repeat))
        return;
    // Register converter for enum 'Qt3DAnimation::QKeyframeAnimation::RepeatMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_REPEATMODE_IDX],
            Qt3DAnimation_QKeyframeAnimation_RepeatMode_CppToPython_Qt3DAnimation_QKeyframeAnimation_RepeatMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DAnimation_QKeyframeAnimation_RepeatMode_PythonToCpp_Qt3DAnimation_QKeyframeAnimation_RepeatMode,
            is_Qt3DAnimation_QKeyframeAnimation_RepeatMode_PythonToCpp_Qt3DAnimation_QKeyframeAnimation_RepeatMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QKEYFRAMEANIMATION_REPEATMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DAnimation::QKeyframeAnimation::RepeatMode");
        Shiboken::Conversions::registerConverterName(converter, "QKeyframeAnimation::RepeatMode");
        Shiboken::Conversions::registerConverterName(converter, "RepeatMode");
    }
    // End of 'RepeatMode' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DAnimation_QKeyframeAnimation_TypeF(), &::Qt3DAnimation::QKeyframeAnimation::staticMetaObject);
    qRegisterMetaType< ::Qt3DAnimation::QKeyframeAnimation::RepeatMode >("QKeyframeAnimation::RepeatMode");
    qRegisterMetaType< ::Qt3DAnimation::QKeyframeAnimation::RepeatMode >("Qt3DAnimation::QKeyframeAnimation::RepeatMode");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DAnimation_QKeyframeAnimation_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DAnimation_QKeyframeAnimation_TypeF(), &::Qt3DAnimation::QKeyframeAnimation::staticMetaObject, sizeof(QKeyframeAnimationWrapper));
}
