/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qt3danimation_python.h"

// main header
#include "qt3danimation_qanimationcliploader_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace Qt3DAnimation;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAnimationClipLoaderWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAnimationClipLoaderWrapper::QAnimationClipLoaderWrapper(::Qt3DCore::QNode * parent) : Qt3DAnimation::QAnimationClipLoader(parent)
{
    resetPyMethodCache();
    // ... middle
}

QAnimationClipLoaderWrapper::QAnimationClipLoaderWrapper(const ::QUrl & source, ::Qt3DCore::QNode * parent) : Qt3DAnimation::QAnimationClipLoader(source, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QAnimationClipLoaderWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAnimationClipLoaderWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAnimationClipLoaderWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAnimationClipLoaderWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAnimationClipLoaderWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAnimationClipLoader.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAnimationClipLoaderWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAnimationClipLoader.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QAnimationClipLoaderWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QAnimationClipLoaderWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Qt3DAnimation::QAnimationClipLoader::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAnimationClipLoaderWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Qt3DAnimation::QAnimationClipLoader::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAnimationClipLoaderWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAnimationClipLoaderWrapper *>(this));
        return Qt3DAnimation::QAnimationClipLoader::qt_metacast(_clname);
}

QAnimationClipLoaderWrapper::~QAnimationClipLoaderWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Qt3DAnimation_QAnimationClipLoader_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Qt3DAnimation::QAnimationClipLoader >()))
        return -1;

    ::QAnimationClipLoaderWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationClipLoader.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QAnimationClipLoader", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QAnimationClipLoader::QAnimationClipLoader(Qt3DCore::QNode*)
    // 1: QAnimationClipLoader::QAnimationClipLoader(QUrl,Qt3DCore::QNode*)
    if (numArgs == 0) {
        overloadId = 0; // QAnimationClipLoader(Qt3DCore::QNode*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QAnimationClipLoader(QUrl,Qt3DCore::QNode*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QAnimationClipLoader(QUrl,Qt3DCore::QNode*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QAnimationClipLoader(Qt3DCore::QNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QAnimationClipLoader_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QAnimationClipLoader(Qt3DCore::QNode * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DAnimation_QAnimationClipLoader_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[0]))))
                            goto Sbk_Qt3DAnimation_QAnimationClipLoader_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::Qt3DCore::QNode *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QAnimationClipLoader(Qt3DCore::QNode*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QAnimationClipLoaderWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QAnimationClipLoaderWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QAnimationClipLoader(const QUrl & source, Qt3DCore::QNode * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_Qt3DAnimation_QAnimationClipLoader_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DCoreTypes[SBK_QT3DCORE_QNODE_IDX]), (pyArgs[1]))))
                            goto Sbk_Qt3DAnimation_QAnimationClipLoader_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::Qt3DCore::QNode *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QAnimationClipLoader(QUrl,Qt3DCore::QNode*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QAnimationClipLoaderWrapper(*cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QAnimationClipLoaderWrapper(*cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Qt3DAnimation::QAnimationClipLoader >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Qt3DAnimation_QAnimationClipLoader_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_Qt3DAnimation_QAnimationClipLoader_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_Qt3DAnimation_QAnimationClipLoader_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Qt3DAnimation_QAnimationClipLoaderFunc_setSource(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QAnimationClipLoader *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCLIPLOADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationClipLoader.setSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAnimationClipLoader::setSource(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // setSource(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Qt3DAnimation_QAnimationClipLoaderFunc_setSource_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSource(QUrl)
            cppSelf->setSource(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_Qt3DAnimation_QAnimationClipLoaderFunc_setSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_Qt3DAnimation_QAnimationClipLoaderFunc_source(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QAnimationClipLoader *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCLIPLOADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationClipLoader.source";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // source()const
            QUrl cppResult = const_cast<const ::Qt3DAnimation::QAnimationClipLoader *>(cppSelf)->source();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Qt3DAnimation_QAnimationClipLoaderFunc_status(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Qt3DAnimation::QAnimationClipLoader *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCLIPLOADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationClipLoader.status";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // status()const
            Qt3DAnimation::QAnimationClipLoader::Status cppResult = const_cast<const ::Qt3DAnimation::QAnimationClipLoader *>(cppSelf)->status();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCLIPLOADER_STATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Qt3DAnimation_QAnimationClipLoader_PropertyStrings[] = {
    "source::",
    "status:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_Qt3DAnimation_QAnimationClipLoader_methods[] = {
    {"setSource", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QAnimationClipLoaderFunc_setSource), METH_O},
    {"source", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QAnimationClipLoaderFunc_source), METH_NOARGS},
    {"status", reinterpret_cast<PyCFunction>(Sbk_Qt3DAnimation_QAnimationClipLoaderFunc_status), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_Qt3DAnimation_QAnimationClipLoader_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::Qt3DAnimation::QAnimationClipLoader *>(Shiboken::Conversions::cppPointer(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCLIPLOADER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAnimationClipLoaderWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Qt3DAnimation_QAnimationClipLoader_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Qt3DAnimation_QAnimationClipLoader_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Qt3DAnimation_QAnimationClipLoader_Type = nullptr;
static SbkObjectType *Sbk_Qt3DAnimation_QAnimationClipLoader_TypeF(void)
{
    return _Sbk_Qt3DAnimation_QAnimationClipLoader_Type;
}

static PyType_Slot Sbk_Qt3DAnimation_QAnimationClipLoader_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Qt3DAnimation_QAnimationClipLoader_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Qt3DAnimation_QAnimationClipLoader_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Qt3DAnimation_QAnimationClipLoader_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Qt3DAnimation_QAnimationClipLoader_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Qt3DAnimation_QAnimationClipLoader_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Qt3DAnimation_QAnimationClipLoader_spec = {
    "2:PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationClipLoader",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Qt3DAnimation_QAnimationClipLoader_slots
};

} //extern "C"

static void *Sbk_Qt3DAnimation_QAnimationClipLoader_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::Qt3DAnimation::QAnimationClipLoader *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Qt3DAnimation_QAnimationClipLoader_Status_PythonToCpp_Qt3DAnimation_QAnimationClipLoader_Status(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Qt3DAnimation::QAnimationClipLoader::Status *>(cppOut) =
        static_cast<::Qt3DAnimation::QAnimationClipLoader::Status>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Qt3DAnimation_QAnimationClipLoader_Status_PythonToCpp_Qt3DAnimation_QAnimationClipLoader_Status_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCLIPLOADER_STATUS_IDX]))
        return Qt3DAnimation_QAnimationClipLoader_Status_PythonToCpp_Qt3DAnimation_QAnimationClipLoader_Status;
    return {};
}
static PyObject *Qt3DAnimation_QAnimationClipLoader_Status_CppToPython_Qt3DAnimation_QAnimationClipLoader_Status(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Qt3DAnimation::QAnimationClipLoader::Status *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCLIPLOADER_STATUS_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAnimationClipLoader_PythonToCpp_QAnimationClipLoader_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Qt3DAnimation_QAnimationClipLoader_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAnimationClipLoader_PythonToCpp_QAnimationClipLoader_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Qt3DAnimation_QAnimationClipLoader_TypeF())))
        return QAnimationClipLoader_PythonToCpp_QAnimationClipLoader_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAnimationClipLoader_PTR_CppToPython_QAnimationClipLoader(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::Qt3DAnimation::QAnimationClipLoader *>(const_cast<void *>(cppIn)), Sbk_Qt3DAnimation_QAnimationClipLoader_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Qt3DAnimation_QAnimationClipLoader_SignatureStrings[] = {
    "1:PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationClipLoader(self,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "0:PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationClipLoader(self,source:PySide2.QtCore.QUrl,parent:PySide2.Qt3DCore.Qt3DCore.QNode=nullptr)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationClipLoader.setSource(self,source:PySide2.QtCore.QUrl)",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationClipLoader.source(self)->PySide2.QtCore.QUrl",
    "PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationClipLoader.status(self)->PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationClipLoader.Status",
    nullptr}; // Sentinel

void init_Qt3DAnimation_QAnimationClipLoader(PyObject *enclosingClass)
{
    _Sbk_Qt3DAnimation_QAnimationClipLoader_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "QAnimationClipLoader",
        "Qt3DAnimation::QAnimationClipLoader*",
        &Sbk_Qt3DAnimation_QAnimationClipLoader_spec,
        &Shiboken::callCppDestructor< ::Qt3DAnimation::QAnimationClipLoader >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QABSTRACTANIMATIONCLIP_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DAnimation_QAnimationClipLoader_Type);
    InitSignatureStrings(pyType, Qt3DAnimation_QAnimationClipLoader_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Qt3DAnimation_QAnimationClipLoader_Type), Sbk_Qt3DAnimation_QAnimationClipLoader_PropertyStrings);
    SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCLIPLOADER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Qt3DAnimation_QAnimationClipLoader_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Qt3DAnimation_QAnimationClipLoader_TypeF(),
        QAnimationClipLoader_PythonToCpp_QAnimationClipLoader_PTR,
        is_QAnimationClipLoader_PythonToCpp_QAnimationClipLoader_PTR_Convertible,
        QAnimationClipLoader_PTR_CppToPython_QAnimationClipLoader);

    Shiboken::Conversions::registerConverterName(converter, "Qt3DAnimation::QAnimationClipLoader");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DAnimation::QAnimationClipLoader*");
    Shiboken::Conversions::registerConverterName(converter, "Qt3DAnimation::QAnimationClipLoader&");
    Shiboken::Conversions::registerConverterName(converter, "QAnimationClipLoader");
    Shiboken::Conversions::registerConverterName(converter, "QAnimationClipLoader*");
    Shiboken::Conversions::registerConverterName(converter, "QAnimationClipLoader&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Qt3DAnimation::QAnimationClipLoader).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAnimationClipLoaderWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_Qt3DAnimation_QAnimationClipLoader_TypeF(), &Sbk_Qt3DAnimation_QAnimationClipLoader_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Status'.
    SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCLIPLOADER_STATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Qt3DAnimation_QAnimationClipLoader_TypeF(),
        "Status",
        "2:PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationClipLoader.Status",
        "Qt3DAnimation::QAnimationClipLoader::Status");
    if (!SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCLIPLOADER_STATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCLIPLOADER_STATUS_IDX],
        Sbk_Qt3DAnimation_QAnimationClipLoader_TypeF(), "NotReady", (long) Qt3DAnimation::QAnimationClipLoader::Status::NotReady))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCLIPLOADER_STATUS_IDX],
        Sbk_Qt3DAnimation_QAnimationClipLoader_TypeF(), "Ready", (long) Qt3DAnimation::QAnimationClipLoader::Status::Ready))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCLIPLOADER_STATUS_IDX],
        Sbk_Qt3DAnimation_QAnimationClipLoader_TypeF(), "Error", (long) Qt3DAnimation::QAnimationClipLoader::Status::Error))
        return;
    // Register converter for enum 'Qt3DAnimation::QAnimationClipLoader::Status'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCLIPLOADER_STATUS_IDX],
            Qt3DAnimation_QAnimationClipLoader_Status_CppToPython_Qt3DAnimation_QAnimationClipLoader_Status);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Qt3DAnimation_QAnimationClipLoader_Status_PythonToCpp_Qt3DAnimation_QAnimationClipLoader_Status,
            is_Qt3DAnimation_QAnimationClipLoader_Status_PythonToCpp_Qt3DAnimation_QAnimationClipLoader_Status_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_Qt3DAnimationTypes[SBK_QT3DANIMATION_QANIMATIONCLIPLOADER_STATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Qt3DAnimation::QAnimationClipLoader::Status");
        Shiboken::Conversions::registerConverterName(converter, "QAnimationClipLoader::Status");
        Shiboken::Conversions::registerConverterName(converter, "Status");
    }
    // End of 'Status' enum.

    PySide::Signal::registerSignals(Sbk_Qt3DAnimation_QAnimationClipLoader_TypeF(), &::Qt3DAnimation::QAnimationClipLoader::staticMetaObject);
    qRegisterMetaType< ::Qt3DAnimation::QAnimationClipLoader::Status >("QAnimationClipLoader::Status");
    qRegisterMetaType< ::Qt3DAnimation::QAnimationClipLoader::Status >("Qt3DAnimation::QAnimationClipLoader::Status");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_Qt3DAnimation_QAnimationClipLoader_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_Qt3DAnimation_QAnimationClipLoader_TypeF(), &::Qt3DAnimation::QAnimationClipLoader::staticMetaObject, sizeof(QAnimationClipLoaderWrapper));
}
