import { sample } from 'openapi-sampler';
var MessageHelpers = (function () {
    function MessageHelpers() {
    }
    MessageHelpers.generateExample = function (schema, options) {
        if (options === void 0) { options = {}; }
        try {
            return this.sanitizeExample(sample(schema, options)) || '';
        }
        catch (e) {
            return '';
        }
    };
    MessageHelpers.sanitizeExample = function (schema) {
        var _this = this;
        if (typeof schema === 'object' && schema && !Array.isArray(schema)) {
            return Object.entries(schema).reduce(function (obj, _a) {
                var propertyName = _a[0], property = _a[1];
                if (!propertyName.startsWith('x-parser-') &&
                    !propertyName.startsWith('x-schema-private-')) {
                    obj[propertyName] = _this.sanitizeExample(property);
                }
                return obj;
            }, {});
        }
        return schema;
    };
    MessageHelpers.getPayloadExamples = function (msg) {
        var examples = msg.examples();
        if (Array.isArray(examples) && examples.some(function (e) { return e.payload; })) {
            var messageExamples = examples
                .flatMap(function (e) {
                if (!e.payload) {
                    return;
                }
                return {
                    name: e.name,
                    summary: e.summary,
                    example: e.payload,
                };
            })
                .filter(Boolean);
            if (messageExamples.length > 0) {
                return messageExamples;
            }
        }
        var payload = msg.payload();
        if (payload && payload.examples()) {
            return payload.examples().map(function (example) { return ({ example: example }); });
        }
        return;
    };
    MessageHelpers.getHeadersExamples = function (msg) {
        var examples = msg.examples();
        if (Array.isArray(examples) && examples.some(function (e) { return e.headers; })) {
            var messageExamples = examples
                .flatMap(function (e) {
                if (!e.headers) {
                    return;
                }
                return {
                    name: e.name,
                    summary: e.summary,
                    example: e.headers,
                };
            })
                .filter(Boolean);
            if (messageExamples.length > 0) {
                return messageExamples;
            }
        }
        var headers = msg.headers();
        if (headers && headers.examples()) {
            return headers.examples().map(function (example) { return ({ example: example }); });
        }
        return;
    };
    return MessageHelpers;
}());
export { MessageHelpers };
//# sourceMappingURL=message.js.map