var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import React, { useState, useContext } from 'react';
import { CollapseButton } from '../../components';
import { useConfig, useSpec } from '../../contexts';
import { PUBLISH_LABEL_DEFAULT_TEXT, SUBSCRIBE_LABEL_DEFAULT_TEXT, } from '../../constants';
var SidebarContext = React.createContext({
    setShowSidebar: function (value) { return value; },
});
export var Sidebar = function () {
    var _a = useState(false), showSidebar = _a[0], setShowSidebar = _a[1];
    var asyncapi = useSpec();
    var info = asyncapi.info();
    var logo = info.ext('x-logo');
    var components = asyncapi.hasComponents() && asyncapi.components();
    var messages = components && components.messages();
    var schemas = components && components.schemas();
    var hasOperations = asyncapi.hasChannels() &&
        Object.values(asyncapi.channels()).some(function (channel) { return channel.hasPublish() || channel.hasSubscribe(); });
    var messagesList = messages && Object.keys(messages).length > 0 && (React.createElement("li", { className: "mb-3 mt-9" },
        React.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#messages", onClick: function () { return setShowSidebar(false); } }, "Messages"),
        React.createElement("ul", { className: "text-sm mt-2" }, Object.entries(messages).map(function (_a) {
            var messageName = _a[0], message = _a[1];
            return (React.createElement("li", { key: messageName },
                React.createElement("a", { className: "flex break-words no-underline text-gray-700 mt-2 hover:text-gray-900", href: "#message-".concat(messageName), onClick: function () { return setShowSidebar(false); } },
                    React.createElement("div", { className: "break-all inline-block" }, message.uid()))));
        }))));
    var schemasList = schemas && Object.keys(schemas).length > 0 && (React.createElement("li", { className: "mb-3 mt-9" },
        React.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#schemas", onClick: function () { return setShowSidebar(false); } }, "Schemas"),
        React.createElement("ul", { className: "text-sm mt-2" }, Object.keys(schemas).map(function (schemaName) { return (React.createElement("li", { key: schemaName },
            React.createElement("a", { className: "flex break-words no-underline text-gray-700 mt-2 hover:text-gray-900", href: "#schema-".concat(schemaName), onClick: function () { return setShowSidebar(false); } },
                React.createElement("div", { className: "break-all inline-block" }, schemaName)))); }))));
    return (React.createElement(SidebarContext.Provider, { value: { setShowSidebar: setShowSidebar } },
        React.createElement("div", { className: "burger-menu rounded-full h-16 w-16 bg-white fixed bottom-16 right-8 flex items-center justify-center z-30 cursor-pointer shadow-md bg-teal-500", onClick: function () { return setShowSidebar(function (prev) { return !prev; }); }, "data-lol": showSidebar },
            React.createElement("svg", { viewBox: "0 0 100 70", width: "40", height: "30", className: "fill-current text-gray-200" },
                React.createElement("rect", { width: "100", height: "10" }),
                React.createElement("rect", { y: "30", width: "100", height: "10" }),
                React.createElement("rect", { y: "60", width: "100", height: "10" }))),
        React.createElement("div", { className: "".concat(showSidebar ? 'block fixed w-full' : 'hidden', " sidebar relative w-64 max-h-screen h-full bg-gray-200 shadow z-20") },
            React.createElement("div", { className: "".concat(showSidebar ? 'w-full' : '', " block fixed max-h-screen h-full font-sans px-4 pt-8 pb-16 overflow-y-auto bg-gray-200") },
                React.createElement("div", { className: "sidebar--content" },
                    React.createElement("div", null, logo ? (React.createElement("img", { src: logo, alt: "".concat(info.title(), " logo, ").concat(info.version(), " version") })) : (React.createElement("h1", { className: "text-2xl font-light" },
                        info.title(),
                        " ",
                        info.version()))),
                    React.createElement("ul", { className: "text-sm mt-10 relative" },
                        React.createElement("li", { className: "mb-3" },
                            React.createElement("a", { className: "text-gray-700 no-underline hover:text-gray-900", href: "#introduction", onClick: function () { return setShowSidebar(false); } }, "Introduction")),
                        asyncapi.hasServers() && (React.createElement("li", { className: "mb-3 mt-9" },
                            React.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#servers", onClick: function () { return setShowSidebar(false); } }, "Servers"),
                            React.createElement(ServersList, null))),
                        hasOperations && (React.createElement(React.Fragment, null,
                            React.createElement("li", { className: "mb-3 mt-9" },
                                React.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#operations", onClick: function () { return setShowSidebar(false); } }, "Operations"),
                                React.createElement(OperationsList, null)),
                            messagesList,
                            schemasList))))))));
};
function filterObjectsByTags(tags, objects) {
    var taggedObjects = new Set();
    var tagged = new Map();
    tags.forEach(function (tag) {
        var taggedForTag = [];
        objects.forEach(function (obj) {
            var object = obj.object;
            if (typeof object.tags !== 'function') {
                return;
            }
            var objectTags = (object.tags() || []).map(function (t) { return t.name(); });
            var hasTag = objectTags.includes(tag);
            if (hasTag) {
                taggedForTag.push(obj);
                taggedObjects.add(obj);
            }
        });
        tagged.set(tag, taggedForTag);
    });
    var untagged = [];
    objects.forEach(function (obj) {
        if (!taggedObjects.has(obj)) {
            untagged.push(obj);
        }
    });
    return { tagged: tagged, untagged: untagged };
}
var ServersList = function () {
    var sidebarConfig = useConfig().sidebar;
    var asyncapi = useSpec();
    var servers = asyncapi.servers();
    var showServers = (sidebarConfig === null || sidebarConfig === void 0 ? void 0 : sidebarConfig.showServers) || 'byDefault';
    if (showServers === 'byDefault') {
        return (React.createElement("ul", { className: "text-sm mt-2" }, Object.keys(servers).map(function (serverName) { return (React.createElement(ServerItem, { serverName: serverName, key: serverName })); })));
    }
    var specTagNames;
    if (showServers === 'bySpecTags') {
        specTagNames = (asyncapi.tags() || []).map(function (tag) { return tag.name(); });
    }
    else {
        var serverTagNamesSet_1 = new Set();
        Object.values(servers).forEach(function (server) {
            if (typeof server.tags !== 'function') {
                return;
            }
            server.tags().forEach(function (t) { return serverTagNamesSet_1.add(t.name()); });
        });
        specTagNames = Array.from(serverTagNamesSet_1);
    }
    var serializedServers = Object.entries(servers).map(function (_a) {
        var serverName = _a[0], server = _a[1];
        return ({
            name: serverName,
            object: server,
            data: {},
        });
    });
    var _a = filterObjectsByTags(specTagNames, serializedServers), tagged = _a.tagged, untagged = _a.untagged;
    return (React.createElement("ul", { className: "text-sm mt-2" },
        Array.from(tagged.entries()).map(function (_a) {
            var tag = _a[0], taggedServers = _a[1];
            return (React.createElement("li", { key: tag },
                React.createElement(ItemsByTagItem, { tagName: tag }, taggedServers.map(function (_a) {
                    var serverName = _a.name;
                    return (React.createElement(ServerItem, { serverName: serverName, key: serverName }));
                }))));
        }),
        untagged.length > 0 ? (React.createElement("li", null,
            React.createElement(ItemsByTagItem, { tagName: "Untagged" }, untagged.map(function (_a) {
                var serverName = _a.name;
                return (React.createElement(ServerItem, { serverName: serverName, key: serverName }));
            })))) : null));
};
var OperationsList = function () {
    var sidebarConfig = useConfig().sidebar;
    var asyncapi = useSpec();
    var channels = asyncapi.channels();
    var showOperations = (sidebarConfig === null || sidebarConfig === void 0 ? void 0 : sidebarConfig.showOperations) || 'byDefault';
    var operations = [];
    Object.entries(channels).forEach(function (_a) {
        var channelName = _a[0], channel = _a[1];
        if (channel.hasPublish()) {
            var operation = channel.publish();
            operations.push({
                name: "publish-".concat(channelName),
                object: operation,
                data: { channelName: channelName, kind: 'publish', summary: operation.summary() },
            });
        }
        if (channel.hasSubscribe()) {
            var operation = channel.subscribe();
            operations.push({
                name: "subscribe-".concat(channelName),
                object: operation,
                data: { channelName: channelName, kind: 'subscribe', summary: operation.summary() },
            });
        }
    });
    if (showOperations === 'byDefault') {
        return (React.createElement("ul", { className: "text-sm mt-2" }, operations.map(function (_a) {
            var name = _a.name, data = _a.data;
            return (React.createElement(OperationItem, __assign({ key: name }, data)));
        })));
    }
    var operationTagNames;
    if (showOperations === 'bySpecTags') {
        operationTagNames = (asyncapi.tags() || []).map(function (tag) { return tag.name(); });
    }
    else {
        var operationTagNamesSet_1 = new Set();
        Object.values(operations).forEach(function (_a) {
            var object = _a.object;
            if (typeof object.tags !== 'function') {
                return;
            }
            object.tags().forEach(function (t) { return operationTagNamesSet_1.add(t.name()); });
        });
        operationTagNames = Array.from(operationTagNamesSet_1);
    }
    var _a = filterObjectsByTags(operationTagNames, operations), tagged = _a.tagged, untagged = _a.untagged;
    return (React.createElement("ul", { className: "text-sm mt-2" },
        Array.from(tagged.entries()).map(function (_a) {
            var tag = _a[0], taggedOperations = _a[1];
            return (React.createElement("li", { key: tag },
                React.createElement(ItemsByTagItem, { tagName: tag }, taggedOperations.map(function (_a) {
                    var name = _a.name, data = _a.data;
                    return (React.createElement(OperationItem, __assign({ key: name }, data)));
                }))));
        }),
        untagged.length > 0 ? (React.createElement("li", null,
            React.createElement(ItemsByTagItem, { tagName: "Untagged" }, untagged.map(function (_a) {
                var name = _a.name, data = _a.data;
                return (React.createElement(OperationItem, __assign({ key: name }, data)));
            })))) : null));
};
var OperationItem = function (_a) {
    var channelName = _a.channelName, summary = _a.summary, kind = _a.kind;
    var config = useConfig();
    var setShowSidebar = useContext(SidebarContext).setShowSidebar;
    var isPublish = kind === 'publish';
    var label = '';
    if (isPublish) {
        label = config.publishLabel || PUBLISH_LABEL_DEFAULT_TEXT;
    }
    else {
        label = config.subscribeLabel || SUBSCRIBE_LABEL_DEFAULT_TEXT;
    }
    return (React.createElement("li", null,
        React.createElement("a", { className: "flex no-underline text-gray-700 mb-2 hover:text-gray-900", href: "#operation-".concat(kind, "-").concat(channelName), onClick: function () { return setShowSidebar(false); } },
            React.createElement("span", { className: "".concat(isPublish ? 'bg-blue-600' : 'bg-green-600', " font-bold h-6 no-underline text-white uppercase p-1 mr-2 rounded text-xs"), title: isPublish ? 'Publish' : 'Subscribe' }, label),
            React.createElement("span", { className: "break-all inline-block" }, summary || channelName))));
};
var ServerItem = function (_a) {
    var serverName = _a.serverName;
    var setShowSidebar = useContext(SidebarContext).setShowSidebar;
    return (React.createElement("li", null,
        React.createElement("a", { className: "flex no-underline text-gray-700 mb-2 hover:text-gray-900", href: "#server-".concat(serverName), onClick: function () { return setShowSidebar(false); } },
            React.createElement("span", { className: "break-all inline-block" }, serverName))));
};
var ItemsByTagItem = function (_a) {
    var tagName = _a.tagName, children = _a.children;
    var _b = useState(false), expand = _b[0], setExpand = _b[1];
    return (React.createElement("div", null,
        React.createElement(CollapseButton, { onClick: function () { return setExpand(function (prev) { return !prev; }); }, chevronProps: {
                className: expand ? '-rotate-180' : '-rotate-90',
            } },
            React.createElement("span", { className: "text-sm inline-block mt-1 font-extralight" }, tagName)),
        React.createElement("ul", { className: "".concat(expand ? 'block' : 'hidden', " text-sm mt-2 font-light") }, children)));
};
//# sourceMappingURL=Sidebar.js.map