/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.polyglot.PolyglotBindings;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotValueDispatch;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;

final class PolyglotBindingsValue
extends PolyglotValueDispatch {
    final Object delegateBindings;
    final Map<String, Object> values;

    PolyglotBindingsValue(PolyglotLanguageContext context2, PolyglotBindings bindings) {
        super(context2.getImpl(), context2.getLanguageInstance());
        this.values = context2.context.polyglotBindings;
        this.delegateBindings = context2.asValue(bindings);
    }

    @Override
    public Object getMember(Object context2, Object receiver, String key) {
        return this.values.get(key);
    }

    @Override
    public Set<String> getMemberKeys(Object context2, Object receiver) {
        return this.values.keySet();
    }

    @Override
    public boolean removeMember(Object context2, Object receiver, String key) {
        Object result2 = this.values.remove(key);
        return result2 != null;
    }

    @Override
    public void putMember(Object context2, Object receiver, String key, Object member) {
        this.values.put(key, ((PolyglotLanguageContext)context2).context.asValue(member));
    }

    @Override
    public boolean hasMembers(Object context2, Object receiver) {
        return true;
    }

    @Override
    public boolean hasMember(Object context2, Object receiver, String key) {
        return this.values.containsKey(key);
    }

    @Override
    public <T> T asClass(Object context2, Object receiver, Class<T> targetType) {
        return this.impl.getAPIAccess().callValueAs(this.delegateBindings, targetType);
    }

    @Override
    public <T> T asTypeLiteral(Object context2, Object receiver, Class<T> rawType, Type type) {
        return this.impl.getAPIAccess().callValueAs(this.delegateBindings, rawType, type);
    }

    @Override
    public String toStringImpl(PolyglotLanguageContext context2, Object receiver) {
        return this.delegateBindings.toString();
    }

    @Override
    public Object getMetaObjectImpl(PolyglotLanguageContext context2, Object receiver) {
        return this.impl.getAPIAccess().callValueGetMetaObject(this.delegateBindings);
    }
}

