/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.structure;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestFileUtils;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpHeaderField;
import com.intellij.httpClient.http.request.psi.HttpImportBlock;
import com.intellij.httpClient.http.request.psi.HttpIncludeFilePath;
import com.intellij.httpClient.http.request.psi.HttpPreRequestHandler;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.psi.HttpRequestBody;
import com.intellij.httpClient.http.request.psi.HttpRequestName;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.httpClient.http.request.psi.HttpResponseHandler;
import com.intellij.httpClient.http.request.psi.HttpRunBlock;
import com.intellij.httpClient.http.request.structure.StructureHelperKt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestStructureViewElement
extends PsiTreeElementBase<PsiElement>
implements ColoredItemPresentation {
    private final String myPresentationText;
    private final String myLocation;
    private final Icon myIcon;
    private final boolean myIsValid;
    private static final String GRAPHQL_QUERY = "query";
    private static final String GRAPHQL_MUTATION = "mutation";
    private static final String GRAPHQL_SUBSCRIPTION = "subscription";

    private HttpRequestStructureViewElement(@NotNull PsiElement element, @NotNull String text2, @Nullable String location, @Nullable Icon icon, boolean isValid) {
        if (element == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(1);
        }
        super(element);
        this.myPresentationText = text2;
        this.myLocation = location;
        this.myIcon = icon;
        this.myIsValid = isValid;
    }

    @NotNull
    public static StructureViewTreeElement create(@NotNull PsiElement element, @Nullable String text2, @Nullable Icon icon) {
        if (element == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(2);
        }
        return HttpRequestStructureViewElement.create(element, text2, null, icon);
    }

    @NotNull
    public static StructureViewTreeElement create(@NotNull PsiElement element, @Nullable String text2, @Nullable String location, @Nullable Icon icon) {
        if (element == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(3);
        }
        return new HttpRequestStructureViewElement(element, StringUtil.notNullize((String)text2, (String)"<not defined>"), location, icon, StringUtil.isNotEmpty((String)text2));
    }

    @NotNull
    public static StructureViewTreeElement createRequest(@NotNull PsiElement element, @NotNull String text2, @Nullable String location, @NotNull Icon icon, boolean isValid) {
        if (element == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(4);
        }
        if (text2 == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(5);
        }
        if (icon == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(6);
        }
        return new HttpRequestStructureViewElement(element, text2, location, icon, isValid);
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        PsiElement element = this.getElement();
        if (element instanceof HttpRequestPsiFile) {
            ArrayList<StructureViewTreeElement> children = new ArrayList<StructureViewTreeElement>();
            List imports = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)element, HttpImportBlock.class);
            imports.forEach(importBlock -> children.add(HttpRequestStructureViewElement.createImport(importBlock)));
            Object[] blocks = HttpRequestPsiUtils.getExecutionBlocks((PsiFile)element);
            if (!ArrayUtil.isEmpty((Object[])blocks)) {
                PsiFile file = element.getContainingFile();
                HttpRequestVariableSubstitutor substitutor2 = HttpRequestVariableSubstitutor.getDefault(element.getProject(), file);
                for (Object block : blocks) {
                    StructureViewTreeElement view = block instanceof HttpRunBlock ? HttpRequestStructureViewElement.createRunView((HttpRunBlock)block) : HttpRequestStructureViewElement.createRequestView((HttpRequestBlock)block, substitutor2);
                    children.add(view);
                }
                ArrayList<StructureViewTreeElement> arrayList = children;
                if (arrayList == null) {
                    HttpRequestStructureViewElement.$$$reportNull$$$0(7);
                }
                return arrayList;
            }
        } else if (element instanceof HttpRequest) {
            return HttpRequestStructureViewElement.getChildren((HttpRequest)element);
        }
        List list2 = ContainerUtil.emptyList();
        if (list2 == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private static StructureViewTreeElement createRunView(HttpRunBlock runBlock) {
        HttpIncludeFilePath includeFilePath = runBlock.getIncludeFilePath();
        HttpRequestName requestName = runBlock.getRequestName();
        if (includeFilePath != null) {
            return HttpRequestStructureViewElement.create((PsiElement)runBlock, RestClientBundle.message("http.client.structure.run.file", new Object[0]), includeFilePath.getPresentablePath(), AllIcons.RunConfigurations.TestState.Run_run);
        }
        assert (requestName != null);
        return HttpRequestStructureViewElement.create((PsiElement)runBlock, RestClientBundle.message("http.client.structure.run.named.request", new Object[0]), requestName.getName(), AllIcons.RunConfigurations.TestState.Run);
    }

    private static StructureViewTreeElement createRequestView(HttpRequestBlock requestBlock, HttpRequestVariableSubstitutor substitutor2) {
        HttpRequest request = requestBlock.getRequest();
        String originalHost = request.getHttpHost(substitutor2);
        HttpRequestTarget target = request.getRequestTarget();
        String path = target != null ? target.getHttpPath(substitutor2) : null;
        boolean isEmpty = StringUtil.isEmpty((String)path);
        StringBuilder location = new StringBuilder();
        if (!isEmpty) {
            location.append(StringUtil.notNullize((String)originalHost, (String)"<not defined>"));
        }
        String text2 = StructureHelperKt.provideStructureText(originalHost, path, request);
        return HttpRequestStructureViewElement.createRequest((PsiElement)request, text2, location.isEmpty() ? null : location.toString(), StructureHelperKt.provideIcon(request), StringUtil.isNotEmpty((String)originalHost));
    }

    private static StructureViewTreeElement createImport(HttpImportBlock importBlock) {
        String presentablePath = importBlock.getIncludeFilePath().getPresentablePath();
        return HttpRequestStructureViewElement.create((PsiElement)importBlock, RestClientBundle.message("http.client.structure.import", new Object[0]), presentablePath, AllIcons.Ide.External_link_arrow);
    }

    @NotNull
    private static List<StructureViewTreeElement> getChildren(HttpRequest element) {
        HttpResponseHandler responseHandler;
        HttpRequestBody body2;
        List<HttpHeaderField> headers2;
        SmartList elements = new SmartList();
        HttpPreRequestHandler preRequestHandler = element.getPreRequestHandler();
        if (preRequestHandler != null) {
            elements.add((Object)HttpRequestStructureViewElement.create((PsiElement)preRequestHandler, RestClientBundle.message("http.client.structure.request.pre.handler", new Object[0]), AllIcons.Actions.Play_first));
        }
        if (!(headers2 = element.getHeaderFieldList()).isEmpty()) {
            HttpRequestVariableSubstitutor substitutor2 = HttpRequestVariableSubstitutor.getDefault(element.getProject(), element.getContainingFile());
            headers2.forEach(header -> {
                StructureViewTreeElement headerElement = HttpRequestStructureViewElement.create((PsiElement)header, header.getName(), header.getValue(substitutor2), AllIcons.Json.Array);
                elements.add((Object)headerElement);
            });
        }
        if ((body2 = element.getRequestBody()) != null) {
            Icon icon;
            String mimeType = StringUtil.notNullize((String)element.getMimeType(), (String)"<not defined>");
            FileType fileType = HttpRequestFileUtils.findFileType(mimeType);
            Icon icon2 = icon = fileType == null ? AllIcons.FileTypes.Any_type : fileType.getIcon();
            if (element.getHttpMethod().equalsIgnoreCase("GRAPHQL")) {
                String methodType = HttpRequestStructureViewElement.graphQlMethodType(body2.getText());
                if (methodType != null) {
                    elements.add((Object)HttpRequestStructureViewElement.create((PsiElement)body2, methodType, icon));
                }
            } else {
                elements.add((Object)HttpRequestStructureViewElement.create((PsiElement)body2, RestClientBundle.message("http.client.structure.request.body", new Object[0]) + " " + mimeType, icon));
            }
        }
        if ((responseHandler = element.getResponseHandler()) != null) {
            elements.add((Object)HttpRequestStructureViewElement.create((PsiElement)responseHandler, RestClientBundle.message("http.client.structure.response.handler", new Object[0]), AllIcons.Actions.Play_last));
        }
        List list2 = elements.isEmpty() ? ContainerUtil.emptyList() : elements;
        if (list2 == null) {
            HttpRequestStructureViewElement.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Nullable
    private static String graphQlMethodType(String body2) {
        String trimmedBody = body2.trim();
        if (trimmedBody.startsWith(GRAPHQL_QUERY)) {
            return GRAPHQL_QUERY;
        }
        if (trimmedBody.startsWith(GRAPHQL_MUTATION)) {
            return GRAPHQL_MUTATION;
        }
        if (trimmedBody.startsWith(GRAPHQL_SUBSCRIPTION)) {
            return GRAPHQL_SUBSCRIPTION;
        }
        return null;
    }

    public String getLocationString() {
        return this.myLocation;
    }

    public boolean isSearchInLocationString() {
        return true;
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        if (!this.myIsValid) {
            return CodeInsightColors.ERRORS_ATTRIBUTES;
        }
        return null;
    }

    @Nullable
    public String getPresentableText() {
        return this.myPresentationText;
    }

    public Icon getIcon(boolean open) {
        if (this.myIcon != null) {
            return this.myIcon;
        }
        return super.getIcon(open);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/structure/HttpRequestStructureViewElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/structure/HttpRequestStructureViewElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenBase";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

