/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution;

import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.execution.adapters.HttpClientBasicHeader;
import com.intellij.httpClient.execution.adapters.HttpClientContentType;
import com.intellij.httpClient.execution.adapters.HttpClientResponseStatusLine;
import com.intellij.httpClient.execution.common.CommonClientResponse;
import com.intellij.httpClient.execution.common.CommonClientResponseProperty;
import com.intellij.httpClient.execution.common.StructuredPresentableClientResponse;
import com.intellij.httpClient.execution.common.StructuredPresentationHeader;
import com.intellij.httpClient.http.request.run.HttpRequestExecutionHelperService;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RestClientResponse
extends CommonClientResponse,
StructuredPresentableClientResponse {
    @NotNull
    public HttpClientContentType getContentType();

    @NotNull
    public HttpClientResponseStatusLine getStatusLine();

    @NotNull
    public List<? extends HttpClientBasicHeader> getAllHeaders();

    @Override
    @NotNull
    default public String getStatusPresentation() {
        if (this.getStatusLine().getStatusCode() != Integer.MAX_VALUE) {
            String string = Integer.toString(this.getStatusLine().getStatusCode());
            if (string == null) {
                RestClientResponse.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = HttpClientExecutorBundle.message("rest.client.request.error.status", new Object[0]);
        if (string == null) {
            RestClientResponse.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    default public String getPresentationHeader() {
        String string = StringUtil.join(this.getStructuredPresentationHeader().getElements(), StructuredPresentationHeader.Element::getText, (String)"\n");
        if (string == null) {
            RestClientResponse.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    default public StructuredPresentationHeader getStructuredPresentationHeader() {
        List<? extends HttpClientBasicHeader> headers2 = this.getAllHeaders();
        HttpClientBasicHeader contentType = (HttpClientBasicHeader)ContainerUtil.find(headers2, header -> "Content-Type".equalsIgnoreCase(header.getName()));
        String summary = contentType != null ? HttpClientExecutorBundle.message("http.response.headers.with.content.type.summary", contentType.toString()) : HttpClientExecutorBundle.message("http.response.headers.without.content.type.summary", new Object[0]);
        return new StructuredPresentationHeader(List.of(new StructuredPresentationHeader.Element.JustText(this.getStatusLine().toString()), new StructuredPresentationHeader.Element.Summarized(RestClientResponse.toString(headers2), summary)));
    }

    @Override
    @NotNull
    default public String getPresentationFooter() {
        Object text2 = RestClientResponse.getStatusText(this.getStatusLine(), this.getExecutionTime());
        int length2 = this.getBody().getLength();
        if (length2 >= 0 && length2 != Integer.MAX_VALUE) {
            text2 = (String)text2 + "; Content length: " + length2 + " bytes (" + StringUtil.formatFileSize((long)length2) + ")";
        }
        String string = text2;
        if (string == null) {
            RestClientResponse.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    default public FileType suggestFileTypeForPresentation() {
        HttpRequestExecutionHelperService service = HttpRequestExecutionHelperService.getInstance();
        return service != null ? service.suggestFileType(this.getContentType().getMimeType()) : null;
    }

    @NotNull
    default public <T> RestClientResponse withAdditionalProperty(@NotNull CommonClientResponseProperty<T> property, T value2) {
        if (property == null) {
            RestClientResponse.$$$reportNull$$$0(4);
        }
        this.set(property, value2);
        RestClientResponse restClientResponse2 = this;
        if (restClientResponse2 == null) {
            RestClientResponse.$$$reportNull$$$0(5);
        }
        return restClientResponse2;
    }

    default public RestClientResponse withHeaders(@NotNull List<HttpClientBasicHeader> headers2) {
        if (headers2 == null) {
            RestClientResponse.$$$reportNull$$$0(6);
        }
        return this;
    }

    @NotNull
    private static String toString(@NotNull List<? extends HttpClientBasicHeader> headers2) {
        if (headers2 == null) {
            RestClientResponse.$$$reportNull$$$0(7);
        }
        StringBuilder builder = new StringBuilder();
        for (HttpClientBasicHeader httpClientBasicHeader : headers2) {
            builder.append(httpClientBasicHeader.getName()).append(": ");
            if (httpClientBasicHeader.getValue() != null) {
                builder.append(httpClientBasicHeader.getValue());
            }
            builder.append("\n");
        }
        String string = builder.toString();
        if (string == null) {
            RestClientResponse.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String getStatusText(@NotNull HttpClientResponseStatusLine statusLine, @Nullable Long time) {
        if (statusLine == null) {
            RestClientResponse.$$$reportNull$$$0(9);
        }
        String text2 = "Response code: " + statusLine.getStatusCode();
        String status = statusLine.getReasonPhrase();
        if (status != null && !status.isEmpty()) {
            text2 = text2 + " (" + status + ")";
        }
        if (time != null) {
            text2 = text2 + "; Time: " + time + "ms (" + StringUtil.formatDuration((long)time) + ")";
        }
        String string = text2;
        if (string == null) {
            RestClientResponse.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 6, 7, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/execution/RestClientResponse";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationHeader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationFooter";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/execution/RestClientResponse";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withAdditionalProperty";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withAdditionalProperty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withHeaders";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStatusText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 6, 7, 9 -> new IllegalArgumentException(string);
        };
    }
}

