/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.generation;

import com.intellij.httpClient.actions.generation.HttpRequestUrlQueryParameters;
import com.intellij.microservices.oas.OasEndpointPath;
import com.intellij.microservices.oas.OasOperation;
import com.intellij.microservices.oas.OasParameter;
import com.intellij.microservices.oas.OasParameterIn;
import com.intellij.microservices.oas.OasSchema;
import com.intellij.microservices.oas.OasSchemaFormat;
import com.intellij.microservices.oas.OasSchemaType;
import com.intellij.microservices.oas.OasSpecificationProvider;
import com.intellij.microservices.oas.OpenApiSpecification;
import com.intellij.microservices.url.UrlPathModelKt;
import com.intellij.microservices.url.UrlQueryParameter;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolverManager;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u001a*\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0003\u001a\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u000e\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u0011"}, d2={"computeRequestQueryParametersFor", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlQueryParameters;", "urlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "project", "Lcom/intellij/openapi/project/Project;", "resolveRequests", "", "Lcom/intellij/microservices/url/UrlResolveRequest;", "computeRequestQuery", "", "", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlQueryParameters$QueryValueType;", "fallbackQueryParameters", "oasSchemaToQueryType", "schema", "Lcom/intellij/microservices/oas/OasSchema;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpRequestQueryParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestQueryParameters.kt\ncom/intellij/httpClient/actions/generation/HttpRequestQueryParametersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1557#2:91\n1628#2,3:92\n774#2:95\n865#2,2:96\n1187#2,2:98\n1261#2,4:100\n1187#2,2:105\n1261#2,4:107\n1#3:104\n*S KotlinDebug\n*F\n+ 1 HttpRequestQueryParameters.kt\ncom/intellij/httpClient/actions/generation/HttpRequestQueryParametersKt\n*L\n48#1:91\n48#1:92,3\n68#1:95\n68#1:96,2\n69#1:98,2\n69#1:100,4\n75#1:105,2\n75#1:107,4\n*E\n"})
public final class HttpRequestQueryParametersKt {
    @RequiresReadLock
    @NotNull
    public static final HttpRequestUrlQueryParameters computeRequestQueryParametersFor(@NotNull UrlTargetInfo urlTargetInfo) {
        Intrinsics.checkNotNullParameter((Object)urlTargetInfo, (String)"urlTargetInfo");
        return new HttpRequestUrlQueryParameters.Simple(HttpRequestQueryParametersKt.computeRequestQuery(urlTargetInfo));
    }

    @RequiresReadLock
    @NotNull
    public static final HttpRequestUrlQueryParameters computeRequestQueryParametersFor(@NotNull Project project, @NotNull List<UrlResolveRequest> resolveRequests) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(resolveRequests, (String)"resolveRequests");
        return new HttpRequestUrlQueryParameters.Simple(HttpRequestQueryParametersKt.computeRequestQuery(project, resolveRequests));
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, HttpRequestUrlQueryParameters.QueryValueType> computeRequestQuery(Project project, List<UrlResolveRequest> resolveRequests) {
        Map map2;
        void $this$mapTo$iv$iv;
        UrlResolverManager urlResolver = UrlResolverManager.Companion.getInstance(project);
        Set resolvedTargets = UrlPathModelKt.filterBestUrlPathMatches$default((Iterable)SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)resolveRequests), arg_0 -> HttpRequestQueryParametersKt.computeRequestQuery$lambda$0(urlResolver, arg_0))), null, (int)2, null);
        Iterable $this$map$iv = resolvedTargets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object entry : $this$mapTo$iv$iv) {
            void it;
            UrlTargetInfo urlTargetInfo = (UrlTargetInfo)entry;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(HttpRequestQueryParametersKt.computeRequestQuery((UrlTargetInfo)it));
        }
        List queryFromContexts = (List)destination$iv$iv;
        Map $this$computeRequestQuery_u24lambda_u242 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        for (Map query : queryFromContexts) {
            for (Map.Entry entry : query.entrySet()) {
                String name = (String)entry.getKey();
                HttpRequestUrlQueryParameters.QueryValueType type = (HttpRequestUrlQueryParameters.QueryValueType)((Object)entry.getValue());
                if ($this$computeRequestQuery_u24lambda_u242.containsKey(name)) continue;
                $this$computeRequestQuery_u24lambda_u242.put(name, type);
            }
        }
        return MapsKt.build((Map)map2);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    private static final Map<String, HttpRequestUrlQueryParameters.QueryValueType> computeRequestQuery(UrlTargetInfo urlTargetInfo) {
        Map<String, HttpRequestUrlQueryParameters.QueryValueType> map2;
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        OpenApiSpecification openApiSpecification = OasSpecificationProvider.Companion.getOasSpecification(urlTargetInfo);
        if (openApiSpecification == null) {
            return HttpRequestQueryParametersKt.fallbackQueryParameters(urlTargetInfo);
        }
        OpenApiSpecification oas = openApiSpecification;
        Object object = (OasEndpointPath)CollectionsKt.firstOrNull((Iterable)oas.getPaths());
        if (object == null || (object = object.getOperations()) == null || (object = (OasOperation)CollectionsKt.firstOrNull((Iterable)((Iterable)object))) == null || (object = object.getParameters()) == null) {
            return HttpRequestQueryParametersKt.fallbackQueryParameters(urlTargetInfo);
        }
        Object parameters = object;
        Iterable $this$filter$iv = (Iterable)parameters;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OasParameter it = (OasParameter)element$iv$iv;
            boolean bl = false;
            if (!(it.getInPlace() == OasParameterIn.QUERY)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map<String, HttpRequestUrlQueryParameters.QueryValueType> destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map<String, HttpRequestUrlQueryParameters.QueryValueType> map3 = destination$iv$iv2;
            OasParameter it = (OasParameter)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)((Object)HttpRequestQueryParametersKt.oasSchemaToQueryType(it.getSchema())));
            map3.put((String)pair.getFirst(), (HttpRequestUrlQueryParameters.QueryValueType)((Object)pair.getSecond()));
        }
        Map<String, HttpRequestUrlQueryParameters.QueryValueType> it = map2 = destination$iv$iv2;
        boolean bl = false;
        Map<String, HttpRequestUrlQueryParameters.QueryValueType> map4 = !it.isEmpty() ? map2 : null;
        if (map4 == null) {
            map4 = HttpRequestQueryParametersKt.fallbackQueryParameters(urlTargetInfo);
        }
        return map4;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, HttpRequestUrlQueryParameters.QueryValueType> fallbackQueryParameters(UrlTargetInfo urlTargetInfo) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = urlTargetInfo.getQueryParameters();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            UrlQueryParameter it = (UrlQueryParameter)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)((Object)HttpRequestUrlQueryParameters.QueryValueType.UNKNOWN));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private static final HttpRequestUrlQueryParameters.QueryValueType oasSchemaToQueryType(OasSchema schema) {
        if (schema == null) {
            return HttpRequestUrlQueryParameters.QueryValueType.UNKNOWN;
        }
        if (schema.getFormat() == OasSchemaFormat.UUID) {
            return HttpRequestUrlQueryParameters.QueryValueType.UUID;
        }
        OasSchemaType oasSchemaType = schema.getType();
        return switch (oasSchemaType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oasSchemaType.ordinal()]) {
            case 1 -> HttpRequestUrlQueryParameters.QueryValueType.INTEGER;
            case 2 -> HttpRequestUrlQueryParameters.QueryValueType.NUMBER;
            case 3 -> HttpRequestUrlQueryParameters.QueryValueType.STRING;
            case 4 -> HttpRequestUrlQueryParameters.QueryValueType.BOOLEAN;
            case -1, 5, 6 -> HttpRequestUrlQueryParameters.QueryValueType.UNKNOWN;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Sequence computeRequestQuery$lambda$0(UrlResolverManager $urlResolver, UrlResolveRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.asSequence((Iterable)$urlResolver.resolve(it));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OasSchemaType.values().length];
            try {
                nArray[OasSchemaType.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OasSchemaType.NUMBER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OasSchemaType.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OasSchemaType.BOOLEAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OasSchemaType.OBJECT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OasSchemaType.ARRAY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

