/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker;

import com.github.javafaker.Faker;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class Code {
    private final Faker faker;
    private static final String[] REPORTING_BODY_IDENTIFIERS = new String[]{"01", "10", "30", "33", "35", "44", "45", "49", "50", "51", "52", "53", "54", "86", "91", "98", "99"};
    private static final int[] GTIN_8_CHECK_DIGITS = new int[]{3, 1, 3, 1, 3, 1, 3};
    private static final int[] GTIN_13_CHECK_DIGITS = new int[]{1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3};

    protected Code(Faker faker) {
        this.faker = faker;
    }

    public String isbnGs1() {
        return this.faker.regexify("978|979");
    }

    public String isbnGroup() {
        return this.faker.regexify("[0-1]");
    }

    public String isbnRegistrant() {
        int ct = this.faker.random().nextInt(6) + 1;
        switch (ct) {
            case 6: {
                return this.faker.number().numberBetween(0, 1) + this.faker.number().digit() + "-" + this.faker.number().digits(6);
            }
            case 5: {
                return this.faker.number().numberBetween(200, 699) + "-" + this.faker.number().digits(5);
            }
            case 4: {
                return this.faker.number().numberBetween(7000, 8499) + "-" + this.faker.number().digits(4);
            }
            case 3: {
                return this.faker.number().numberBetween(85000, 89999) + "-" + this.faker.number().digits(3);
            }
            case 2: {
                return this.faker.number().numberBetween(900000, 949999) + "-" + this.faker.number().digits(2);
            }
            case 1: {
                return this.faker.number().numberBetween(9500000, 9999999) + "-" + this.faker.number().digits(1);
            }
        }
        throw new IllegalStateException("Invalid random " + ct);
    }

    public String isbn10() {
        return this.isbn10(false);
    }

    public String isbn10(boolean separator) {
        StringBuilder isbn10;
        int checkDigit = this.isbn10CheckDigit(isbn10 = new StringBuilder().append(this.faker.expression("#{code.isbn_group}")).append('-').append(this.faker.expression("#{code.isbn_registrant}")).append('-'));
        isbn10.append(checkDigit != 10 ? Integer.valueOf(checkDigit) : "X");
        return separator ? isbn10.toString() : this.stripIsbnSeparator(isbn10);
    }

    public String isbn13() {
        return this.isbn13(false);
    }

    public String isbn13(boolean separator) {
        StringBuilder isbn13 = new StringBuilder().append(this.faker.expression("#{code.isbn_gs1}")).append('-').append(this.faker.expression("#{code.isbn_group}")).append('-').append(this.faker.expression("#{code.isbn_registrant}")).append('-');
        int checkDigit = this.isbn13CheckDigit(isbn13);
        isbn13.append(checkDigit);
        return separator ? isbn13.toString() : this.stripIsbnSeparator(isbn13);
    }

    private final int isbn10CheckDigit(CharSequence t) {
        String value2 = this.stripIsbnSeparator(t);
        int sum = 0;
        for (int i = 0; i < value2.length(); ++i) {
            sum += (i + 1) * NumberUtils.toInt((String)value2.substring(i, i + 1));
        }
        return sum % 11;
    }

    private final int isbn13CheckDigit(CharSequence t) {
        String value2 = this.stripIsbnSeparator(t);
        int sum = 0;
        int multiplier = 0;
        for (int i = 0; i < value2.length(); ++i) {
            multiplier = i % 2 == 0 ? 1 : 3;
            sum += multiplier * NumberUtils.toInt((String)value2.subSequence(i, i + 1).toString());
        }
        return (10 - sum % 10) % 10;
    }

    private final String stripIsbnSeparator(CharSequence t) {
        return t.toString().replaceAll("-", "");
    }

    public String asin() {
        return this.faker.resolve("code.asin");
    }

    public String imei() {
        char[] str = new char[15];
        int len = str.length;
        String arr = this.faker.options().option(REPORTING_BODY_IDENTIFIERS);
        str[0] = arr.charAt(0);
        str[1] = arr.charAt(1);
        for (int i = 2; i < len - 1; ++i) {
            str[i] = Character.forDigit(this.faker.number().numberBetween(0, 9), 10);
        }
        int lenOffset = (len + 1) % 2;
        int t = 0;
        int sum = 0;
        for (int i = 0; i < len - 1; ++i) {
            if ((i + lenOffset) % 2 != 0) {
                t = Character.getNumericValue(str[i]) * 2;
                if (t > 9) {
                    t -= 9;
                }
                sum += t;
                continue;
            }
            sum += Character.getNumericValue(str[i]);
        }
        str[len - 1] = Character.forDigit((10 - sum % 10) % 10, 10);
        return new String(str);
    }

    public String ean8() {
        return this.gtin8();
    }

    public String gtin8() {
        char[] values = this.faker.regexify("\\d{7}").toCharArray();
        int sum = 0;
        for (int i = 0; i < values.length; ++i) {
            sum += Character.getNumericValue(values[i]) * GTIN_8_CHECK_DIGITS[i];
        }
        int checkDigit = 10 - sum % 10;
        if (checkDigit == 10) {
            return new String(ArrayUtils.add((char[])values, (char)Character.forDigit(0, 10)));
        }
        return new String(ArrayUtils.add((char[])values, (char)Character.forDigit(checkDigit, 10)));
    }

    public String ean13() {
        return this.gtin13();
    }

    public String gtin13() {
        char[] values = this.faker.regexify("\\d{12}").toCharArray();
        int sum = 0;
        for (int i = 0; i < values.length; ++i) {
            sum += Character.getNumericValue(values[i]) * GTIN_13_CHECK_DIGITS[i];
        }
        int checkDigit = 10 - sum % 10;
        if (checkDigit == 10) {
            return new String(ArrayUtils.add((char[])values, (char)Character.forDigit(0, 10)));
        }
        return new String(ArrayUtils.add((char[])values, (char)Character.forDigit(checkDigit, 10)));
    }
}

