/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac;

import com.intellij.icons.AllIcons;
import com.intellij.ide.startup.importSettings.TransferableIdeId;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.TransferSettingsProvider;
import com.intellij.ide.startup.importSettings.providers.vsmac.VSMacSettingsProcessor;
import com.intellij.ide.startup.importSettings.transfer.backend.models.IdeVersion;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac.VSMacTransferSettingsProviderKt;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.SmartList;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\tH\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\tH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/VSMacTransferSettingsProvider;", "Lcom/intellij/ide/startup/importSettings/providers/TransferSettingsProvider;", "<init>", "()V", "transferableIdeId", "Lcom/intellij/ide/startup/importSettings/TransferableIdeId;", "getTransferableIdeId", "()Lcom/intellij/ide/startup/importSettings/TransferableIdeId;", "name", "", "getName", "()Ljava/lang/String;", "isAvailable", "", "hasDataToImport", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getIdeVersions", "Lcom/intellij/util/SmartList;", "Lcom/intellij/ide/startup/importSettings/transfer/backend/models/IdeVersion;", "skipIds", "", "getIdeVersion", "version", "detectVSForMacVersion", "getLastUsed", "Ljava/util/Date;", "intellij.ide.startup.importSettings"})
public final class VSMacTransferSettingsProvider
implements TransferSettingsProvider {
    @NotNull
    private final TransferableIdeId transferableIdeId = TransferableIdeId.VisualStudioForMac;
    @NotNull
    private final String name;

    public VSMacTransferSettingsProvider() {
        this.name = "Visual Studio for Mac";
    }

    @Override
    @NotNull
    public TransferableIdeId getTransferableIdeId() {
        return this.transferableIdeId;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAvailable() {
        return SystemInfoRt.isMac;
    }

    @Override
    @Nullable
    public Object hasDataToImport(@NotNull Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(null){
            int label;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Path path = Paths.get(VSMacSettingsProcessor.Companion.getVsPreferences$intellij_ide_startup_importSettings(), new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                        return Boxing.boxBoolean((boolean)Files.isDirectory(path, new LinkOption[0]));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public SmartList<IdeVersion> getIdeVersions(@NotNull List<String> skipIds) {
        Intrinsics.checkNotNullParameter(skipIds, (String)"skipIds");
        String version = this.detectVSForMacVersion();
        return version == null ? new SmartList() : new SmartList((Object)this.getIdeVersion(version));
    }

    private final IdeVersion getIdeVersion(String version) {
        TransferableIdeId transferableIdeId = this.getTransferableIdeId();
        Icon icon = AllIcons.TransferSettings.Vsmac;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Vsmac");
        Icon icon2 = icon;
        Date date = this.getLastUsed(version);
        return new IdeVersion(transferableIdeId, null, "VSMAC", icon2, "Visual Studio for Mac", null, () -> VSMacTransferSettingsProvider.getIdeVersion$lambda$0(version), date, this, 0, 544, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String detectVSForMacVersion() {
        Path pathToDir = Paths.get(VSMacSettingsProcessor.Companion.getVsPreferences$intellij_ide_startup_importSettings(), new String[0]);
        if (!Files.isDirectory(pathToDir, new LinkOption[0])) {
            return null;
        }
        long max = 0L;
        String lastUsedVersion = null;
        AutoCloseable autoCloseable = Files.list(pathToDir);
        Throwable throwable = null;
        try {
            Stream files = (Stream)autoCloseable;
            boolean bl = false;
            Iterator iterator = files.iterator();
            while (iterator.hasNext()) {
                long lastModificationTime;
                String maybeVersion;
                File recentlyUsedFile;
                Path path = (Path)iterator.next();
                if (!Files.isDirectory(path, new LinkOption[0]) && Files.isHidden(path) || !(recentlyUsedFile = VSMacSettingsProcessor.Companion.getGeneralSettingsFile$intellij_ide_startup_importSettings(maybeVersion = ((Object)path.getFileName()).toString())).exists() || max >= (lastModificationTime = recentlyUsedFile.lastModified())) continue;
                max = lastModificationTime;
                lastUsedVersion = maybeVersion;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return lastUsedVersion;
    }

    private final Date getLastUsed(String version) {
        Date date;
        File recentlyUsedFile = VSMacSettingsProcessor.Companion.getGeneralSettingsFile$intellij_ide_startup_importSettings(version);
        try {
            date = new Date(recentlyUsedFile.lastModified());
        }
        catch (Throwable t) {
            VSMacTransferSettingsProviderKt.access$getLogger$p().warn(t);
            date = null;
        }
        return date;
    }

    private static final Settings getIdeVersion$lambda$0(String $version) {
        return new VSMacSettingsProcessor().getProcessedSettings($version);
    }
}

