/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.powerfuldataviewer;

import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.python.scientific.powerfuldataviewer.DataViewTableImpl;
import com.intellij.python.scientific.powerfuldataviewer.HeaderCellComponent;
import com.intellij.python.scientific.powerfuldataviewer.HeaderCellRenderer;
import com.intellij.python.scientific.powerfuldataviewer.HeaderClickable;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Producer;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.containerview.ColumnFilter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;

public class HeaderMouseListener
extends MouseAdapter {
    private final DataViewTableImpl myTable;
    private final JTableHeader myHeader;
    private int myHoveredColumn = -1;
    private final TableCellRenderer myRenderer;
    private final JBLabel myHintComponent = new JBLabel();
    private JBPopup myHintPopup;
    private final ComponentPopupBuilder myHintPopupBuilder;
    Component component;

    public HeaderMouseListener(DataViewTableImpl table) {
        this.myHintComponent.setIcon(HeaderCellComponent.ACTIVE_FILTER_ICON);
        this.myHintPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myHintComponent, null).setMovable(false).setCancelOnClickOutside(false).setCancelOnOtherWindowOpen(true);
        this.myTable = table;
        this.myHeader = this.myTable.getTableHeader();
        this.myRenderer = new HeaderCellRenderer(this.myTable, false, (Producer<Integer>)((Producer)() -> this.myHoveredColumn));
        this.myHintComponent.setBorder(JBUI.Borders.empty((int)2));
    }

    public Producer<Integer> getColumnHoverProducer() {
        return () -> this.myHoveredColumn;
    }

    private void repaintHovered() {
        if (this.myHoveredColumn != -1) {
            this.myHeader.repaint(this.myHeader.getHeaderRect(this.myHoveredColumn));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        TableColumnModel columnModel = this.myTable.getColumnModel();
        int index = columnModel.getColumnIndexAtX(e.getX());
        if (index != this.myHoveredColumn) {
            ColumnFilter filter;
            if (this.myHintPopup != null) {
                this.myHintPopup.closeOk(null);
            }
            if ((filter = this.myTable.getColumnFilter(index)) != null) {
                Rectangle rect = this.myHeader.getHeaderRect(index);
                String modeStr = filter.getMode() == ColumnFilter.Mode.EXPRESSION ? PyBundle.message((String)"debugger.dataviewer.header.filter.hint.mode.expression", (Object[])new Object[0]) : (filter.getMode() == ColumnFilter.Mode.SUBSTRING ? PyBundle.message((String)"debugger.dataviewer.header.filter.hint.mode.substring", (Object[])new Object[0]) : PyBundle.message((String)"debugger.dataviewer.header.filter.hint.mode.regex", (Object[])new Object[0]));
                this.myHintComponent.setText(PyBundle.message((String)"debugger.dataviewer.header.filter.hint", (Object[])new Object[]{modeStr, filter.getFilter()}));
                this.myHintPopup = this.myHintPopupBuilder.createPopup();
                this.myHintPopup.show(new RelativePoint((Component)this.myHeader, new Point(rect.x, rect.y + rect.height)));
            }
            this.repaintHovered();
            this.myHoveredColumn = index;
            this.repaintHovered();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.repaintHovered();
        this.myHoveredColumn = -1;
        if (this.myHintPopup != null) {
            this.myHintPopup.closeOk(null);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.myHeader.getCursor().getType() == 0) {
            TableColumnModel columnModel = this.myTable.getColumnModel();
            int index = columnModel.getColumnIndexAtX(e.getX());
            if (index == -1) {
                return;
            }
            Rectangle rect = this.myHeader.getHeaderRect(index);
            if (rect.contains(e.getPoint())) {
                int rx = e.getX() - rect.x;
                int ry = e.getY();
                this.component = this.myRenderer.getTableCellRendererComponent((JTable)((Object)this.myTable), this.myTable.getHeaderValueAt(index), false, false, 0, index);
                this.component.setBounds(rect);
                this.doLayoutRecursive(this.component);
                this.component.revalidate();
                Component dest = SwingUtilities.getDeepestComponentAt(this.component, rx, ry);
                if (dest instanceof HeaderClickable) {
                    HeaderClickable button = (HeaderClickable)((Object)dest);
                    button.click(e, index);
                }
            }
        }
    }

    void doLayoutRecursive(@NotNull Component parent) {
        if (parent == null) {
            HeaderMouseListener.$$$reportNull$$$0(0);
        }
        parent.doLayout();
        if (parent instanceof Container && parent.isVisible()) {
            for (Component comp : ((Container)parent).getComponents()) {
                this.doLayoutRecursive(comp);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/python/scientific/powerfuldataviewer/HeaderMouseListener", "doLayoutRecursive"));
    }
}

