/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.docker;

import com.google.common.base.Joiner;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.compose.beans.RestartPolicy;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.compose.DockerComposeServiceUtil;
import com.intellij.docker.remote.compose.process.DockerComposeProcessUtil;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.docker.PyDockerBundle;
import com.intellij.python.docker.PyDockerProcessUtil;
import com.intellij.python.docker.PyDockerSkeletonGeneratorBase;
import com.intellij.python.docker.compose.PyDockerComposeProcessConnectionData;
import com.intellij.python.remoteInterpreter.PyRemoteInterpreterCommandLineUtil;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.skeletons.LineWiseProcessOutputListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDockerComposeSkeletonGenerator
extends PyDockerSkeletonGeneratorBase {
    private static final String ROOT_USER_ID = "0";

    public PyDockerComposeSkeletonGenerator(@Nullable Project project, @NotNull String skeletonsPath, @NotNull Sdk sdk) {
        if (skeletonsPath == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(1);
        }
        super(project, skeletonsPath, sdk);
    }

    @NotNull
    protected ProcessOutput getProcessOutput(@NotNull String homePath, String @NotNull [] commandLine, @Nullable String stdin, @Nullable Map<String, String> extraEnv, int timeout) throws InvalidSdkException {
        if (homePath == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(2);
        }
        if (commandLine == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(3);
        }
        return this.runProcessWithOptionalLineOutputListener(homePath, Arrays.asList(commandLine), extraEnv, stdin, timeout, null);
    }

    @NotNull
    protected ProcessOutput runProcessWithLineOutputListener(@NotNull String homePath, @NotNull List<String> cmd, @NotNull Map<String, String> env, @Nullable String stdin, int timeout, @NotNull LineWiseProcessOutputListener listener) throws ExecutionException, InvalidSdkException {
        if (homePath == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(4);
        }
        if (cmd == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(5);
        }
        if (env == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(6);
        }
        if (listener == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(7);
        }
        return this.runProcessWithOptionalLineOutputListener(homePath, cmd, env, stdin, timeout, listener);
    }

    @NotNull
    private ProcessOutput runProcessWithOptionalLineOutputListener(@NotNull String path2, @NotNull List<String> cmd, @Nullable Map<String, String> env, @Nullable String stdin, int timeout, @Nullable LineWiseProcessOutputListener listener) throws InvalidSdkException {
        ProcessOutput processOutput;
        if (path2 == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(8);
        }
        if (cmd == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(9);
        }
        Object[] extendedCommandLine = PyDockerComposeSkeletonGenerator.addUnbuffered(path2, ArrayUtil.toStringArray(cmd));
        try {
            ComposeServiceRunCmd serviceRunCmd = this.buildDockerComposeRunCmd(env, (String[])extendedCommandLine).withRemove(true).withNoPty(Boolean.valueOf(true));
            KillableColoredProcessHandler handler = serviceRunCmd.execute();
            if (listener != null) {
                handler.addProcessListener((ProcessListener)new LineWiseProcessOutputListener.Adapter(listener));
            }
            if (stdin != null) {
                PyDockerComposeSkeletonGenerator.sendLineToProcessInput((BaseProcessHandler)handler, (String)stdin);
            }
            processOutput = new CapturingProcessRunner((BaseProcessHandler)handler).runProcess(timeout);
        }
        catch (ProcessNotCreatedException e) {
            LOG.debug("Unable to execute command ", new Object[]{Joiner.on((String)" ").join(extendedCommandLine), e});
            DockerComposeCliUtil.notifyDockerComposeExecutionFailed((Project)this.getProject(), (ProcessNotCreatedException)e);
            throw PyDockerComposeSkeletonGenerator.propagateRecoverableException((Exception)((Object)e));
        }
        catch (ExecutionException | ServerRuntimeException | IOException e) {
            LOG.debug("Unable to execute command ", new Object[]{Joiner.on((String)" ").join(extendedCommandLine), e});
            throw PyDockerComposeSkeletonGenerator.propagateRecoverableException((Exception)e);
        }
        if (processOutput == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(10);
        }
        return processOutput;
    }

    @NotNull
    private ComposeServiceRunCmd buildDockerComposeRunCmd(@Nullable Map<String, String> extraEnv, String @NotNull [] extendedCommandLine) throws ServerRuntimeException, RemoteSdkException, IOException {
        if (extendedCommandLine == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(11);
        }
        PyDockerComposeProcessConnectionData data = this.getProcessConnectionData();
        PyRemotePathMapper pathMapper = this.createPathMappings(this.getProject(), (PyRemoteSdkAdditionalDataBase)this.getRemoteSdkAdditionalData());
        Pair<String[], String> commandWithWorkingDir = PyRemoteInterpreterCommandLineUtil.buildRemoteCommandLine((AbstractPathMapper)pathMapper, extendedCommandLine, null, data.getInterpreterPath());
        RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)this.getProject());
        SharedVolume helpersSharedVolume = PyDockerProcessUtil.getPyCharmHelpersSharedVolume(dockerRuntime);
        String skeletonsVolume = this.prepareSkeletonsVolume();
        VolumesBuilder volumesBinds = VolumesBuilder.builder();
        volumesBinds.addBoundVolume("/opt/pycharm/skeletons", skeletonsVolume);
        ComposeServiceRunCmd composeServiceRunCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime).runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withServiceName(data.getComposeServiceName())).withCommand((String[])commandWithWorkingDir.getFirst())).withWorkingDir((String)commandWithWorkingDir.getSecond())).withEnvironment(extraEnv)).withSharedVolume(helpersSharedVolume)).withVolumes(volumesBinds.build())).withRestartPolicy((RestartPolicy)RestartPolicy.noRestart());
        if (composeServiceRunCmd == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(12);
        }
        return composeServiceRunCmd;
    }

    @Override
    @NotNull
    protected String setupSkeletonsVolume() throws ExecutionException, ServerRuntimeException {
        String serviceUID;
        String volumeName = this.getSkeletonsVolumeName();
        PyDockerComposeProcessConnectionData data = this.getProcessConnectionData();
        String serviceName = data.getComposeServiceName();
        RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)this.getProject());
        List composeFilePaths = ContainerUtil.map(data.getComposeFilePaths(), x$0 -> Path.of(x$0, new String[0]));
        try {
            serviceUID = DockerComposeServiceUtil.getServiceUID((RemoteDockerRuntime)dockerRuntime, (List)composeFilePaths, data.getEnvs(), (String)serviceName, null);
        }
        catch (IOException e) {
            throw PyDockerComposeSkeletonGenerator.propagateRemoteSdkException(PyDockerBundle.message("failed.to.get.effective.user.for.compose.service", new Object[0]), e);
        }
        if (StringUtil.isNotEmpty((String)serviceUID)) {
            LOG.debug("UID of the user of Docker Compose service \"" + serviceName + "\" is " + serviceUID + ", permissions setup for skeletons volume \"" + volumeName + "\" required");
            try {
                DockerComposeServiceUtil.changeOwnershipOfVolume((RemoteDockerRuntime)dockerRuntime, (List)composeFilePaths, data.getEnvs(), (String)serviceName, (String)serviceUID, (String)volumeName, (String)"/opt/pycharm/skeletons", null);
            }
            catch (ExecutionException | IOException e) {
                throw PyDockerComposeSkeletonGenerator.propagateRemoteSdkException(PyDockerBundle.message("failed.to.change.owner.skeletons.volume", new Object[0]), e);
            }
        } else {
            LOG.debug("User for service \"" + serviceName + "\" is default (root)");
        }
        String string = volumeName;
        if (string == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Contract(value="_, _ -> fail")
    @NotNull
    private static RemoteSdkException propagateRemoteSdkException(@NotNull @NlsContexts.DialogMessage String message, @NotNull Throwable t) throws RemoteSdkException {
        String localizedMessageOfCause;
        if (message == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(14);
        }
        if (t == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(15);
        }
        if (StringUtil.isNotEmpty((String)(localizedMessageOfCause = t.getLocalizedMessage()))) {
            throw new RemoteSdkException(PyDockerBundle.message("remote.sdk.exception.message.with.cause", message, localizedMessageOfCause), t);
        }
        throw new RemoteSdkException(message, t);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    static String extractServiceUserId(@NotNull ProcessOutput processOutput) {
        if (processOutput == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(16);
        }
        if (!processOutput.checkSuccess(LOG)) return ROOT_USER_ID;
        String stdout = processOutput.getStdout().trim();
        try (Scanner scanner = new Scanner(stdout);){
            String lastLine = null;
            while (scanner.hasNextLine()) {
                lastLine = scanner.nextLine();
            }
            if (lastLine != null) {
                String string;
                try {
                    String string2 = String.valueOf(Long.parseLong(lastLine));
                    string = string2;
                }
                catch (NumberFormatException e) {
                    LOG.debug("The last line of Docker Compose stdout does not contain effective user ID: " + lastLine);
                    return ROOT_USER_ID;
                }
                if (string != null) return string;
                PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(17);
                return string;
            }
            LOG.debug("Docker Compose stdout of the command to get effective user ID is empty");
            return ROOT_USER_ID;
        }
    }

    @NotNull
    private PyDockerComposeProcessConnectionData getProcessConnectionData() {
        PyRemoteSdkAdditionalData sdkAdditionalData = this.getRemoteSdkAdditionalData();
        PyDockerComposeProcessConnectionData pyDockerComposeProcessConnectionData = PyDockerProcessUtil.getPyDockerComposeProcessConnectionData((PyRemoteSdkAdditionalDataBase)sdkAdditionalData);
        if (pyDockerComposeProcessConnectionData == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(18);
        }
        return pyDockerComposeProcessConnectionData;
    }

    @Override
    @NotNull
    protected RemoteDockerRuntime createDockerRuntime() throws ServerRuntimeException, RemoteSdkException {
        RemoteDockerRuntime remoteDockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)this.getProcessConnectionData().getAccount(), (Project)this.getProject());
        if (remoteDockerRuntime == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(19);
        }
        return remoteDockerRuntime;
    }

    @Override
    protected void doDownloadSources(@NotNull String srcRemotePath, @NotNull File targetLocalDir, @NotNull VolumesBuilder volumesBinds, @Nullable Map<String, String> map) throws IOException, RemoteSdkException, ServerRuntimeException {
        RemoteDockerApplicationRuntime serviceApplicationRuntime;
        if (srcRemotePath == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(20);
        }
        if (targetLocalDir == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(21);
        }
        if (volumesBinds == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(22);
        }
        PyDockerComposeProcessConnectionData data = this.getProcessConnectionData();
        RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)this.getProject());
        DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
        ComposeServiceRunCmd runServiceCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)serviceClient.runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withServiceName(data.getComposeServiceName())).withCommand(new String[]{"/bin/true"})).withVolumes(volumesBinds.build())).withRestartPolicy((RestartPolicy)RestartPolicy.noRestart());
        try {
            String containerNameOrId = runServiceCmd.execDetached();
            serviceApplicationRuntime = DockerComposeProcessUtil.getDockerComposeContainer((RemoteDockerRuntime)dockerRuntime, (String)containerNameOrId);
        }
        catch (RemoteSdkException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw new RemoteSdkException(PyDockerBundle.message("download.failed", new Object[0]));
        }
        serviceApplicationRuntime.downloadDirectoryAndRemove(srcRemotePath, targetLocalDir, map, data.getAccount().getMachine());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12, 13, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skeletonsPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/docker/PyDockerComposeSkeletonGenerator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendedCommandLine";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutput";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcRemotePath";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLocalDir";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumesBinds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/docker/PyDockerComposeSkeletonGenerator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithOptionalLineOutputListener";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDockerComposeRunCmd";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "setupSkeletonsVolume";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "extractServiceUserId";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessConnectionData";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createDockerRuntime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithLineOutputListener";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithOptionalLineOutputListener";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildDockerComposeRunCmd";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "propagateRemoteSdkException";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractServiceUserId";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doDownloadSources";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 12, 13, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

