/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.actions.ActionController;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0017\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u001a\u0010\u0013\u001a\u00020\u0014*\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\f\u001a\u00020\tH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/log/visible/CompoundVisibleGraph;", "CommitId", "", "Lcom/intellij/vcs/log/graph/VisibleGraph;", "firstGraph", "secondGraph", "<init>", "(Lcom/intellij/vcs/log/graph/VisibleGraph;Lcom/intellij/vcs/log/graph/VisibleGraph;)V", "getVisibleCommitCount", "", "getRowInfo", "Lcom/intellij/vcs/log/graph/RowInfo;", "visibleRow", "getVisibleRowIndex", "id", "(Ljava/lang/Object;)Ljava/lang/Integer;", "getActionController", "Lcom/intellij/vcs/log/graph/actions/ActionController;", "getRecommendedWidth", "containsRow", "", "intellij.platform.vcs.log.impl"})
public final class CompoundVisibleGraph<CommitId>
implements VisibleGraph<CommitId> {
    @NotNull
    private final VisibleGraph<CommitId> firstGraph;
    @NotNull
    private final VisibleGraph<CommitId> secondGraph;

    public CompoundVisibleGraph(@NotNull VisibleGraph<CommitId> firstGraph, @NotNull VisibleGraph<CommitId> secondGraph) {
        Intrinsics.checkNotNullParameter(firstGraph, (String)"firstGraph");
        Intrinsics.checkNotNullParameter(secondGraph, (String)"secondGraph");
        this.firstGraph = firstGraph;
        this.secondGraph = secondGraph;
    }

    public int getVisibleCommitCount() {
        return Math.max(this.firstGraph.getVisibleCommitCount(), this.secondGraph.getVisibleCommitCount());
    }

    @NotNull
    public RowInfo<CommitId> getRowInfo(int visibleRow) {
        RowInfo rowInfo;
        if (this.containsRow(this.firstGraph, visibleRow)) {
            RowInfo rowInfo2 = this.firstGraph.getRowInfo(visibleRow);
            rowInfo = rowInfo2;
            Intrinsics.checkNotNullExpressionValue((Object)rowInfo2, (String)"getRowInfo(...)");
        } else if (this.containsRow(this.secondGraph, visibleRow)) {
            RowInfo rowInfo3 = this.secondGraph.getRowInfo(visibleRow);
            rowInfo = rowInfo3;
            Intrinsics.checkNotNullExpressionValue((Object)rowInfo3, (String)"getRowInfo(...)");
        } else {
            throw new IllegalStateException(StringsKt.trimMargin$default((String)("Cannot get visibleRow=" + visibleRow + " from firstGraph=" + this.firstGraph.getVisibleCommitCount() + " \n                 and secondGraph=" + this.secondGraph.getVisibleCommitCount()), null, (int)1, null).toString());
        }
        return rowInfo;
    }

    @Nullable
    public Integer getVisibleRowIndex(@NotNull CommitId id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Integer n = this.firstGraph.getVisibleRowIndex(id);
        if (n == null) {
            n = this.secondGraph.getVisibleRowIndex(id);
        }
        return n;
    }

    @NotNull
    public ActionController<CommitId> getActionController() {
        ActionController actionController = this.secondGraph.getActionController();
        Intrinsics.checkNotNullExpressionValue((Object)actionController, (String)"getActionController(...)");
        return actionController;
    }

    public int getRecommendedWidth() {
        return this.secondGraph.getRecommendedWidth();
    }

    private final boolean containsRow(VisibleGraph<CommitId> $this$containsRow, int visibleRow) {
        return 0 <= visibleRow ? visibleRow < $this$containsRow.getVisibleCommitCount() : false;
    }
}

