/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.configuration;

import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.TextMateBundle;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.bundles.TextMateBundleReader;
import org.jetbrains.plugins.textmate.configuration.TextMateConfigurableBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\b\u0010\u0011\u001a\u00020\nH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/textmate/configuration/TextMateBundlesListPanel;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "myBundlesList", "Lcom/intellij/ui/CheckBoxList;", "Lorg/jetbrains/plugins/textmate/configuration/TextMateConfigurableBundle;", "getState", "", "setState", "", "bundles", "", "createMainComponent", "Ljavax/swing/JPanel;", "isModified", "", "dispose", "Companion", "intellij.textmate"})
@SourceDebugExtension(value={"SMAP\nTextMateBundlesListPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateBundlesListPanel.kt\norg/jetbrains/plugins/textmate/configuration/TextMateBundlesListPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n808#2,11:162\n*S KotlinDebug\n*F\n+ 1 TextMateBundlesListPanel.kt\norg/jetbrains/plugins/textmate/configuration/TextMateBundlesListPanel\n*L\n78#1:162,11\n*E\n"})
public final class TextMateBundlesListPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CheckBoxList<TextMateConfigurableBundle> myBundlesList = (CheckBoxList)new CheckBoxList<TextMateConfigurableBundle>(){
        {
            this.setSelectionMode(2);
            ListSpeedSearch.installOn((JList)((JList)((Object)this)), arg_0 -> 1._init_$lambda$1(1::_init_$lambda$0, arg_0));
        }

        protected String getSecondaryText(int index) {
            String string;
            TextMateConfigurableBundle textMateConfigurableBundle = (TextMateConfigurableBundle)this.getItemAt(index);
            if (textMateConfigurableBundle != null) {
                TextMateConfigurableBundle bundle = textMateConfigurableBundle;
                boolean bl = false;
                string = bundle.getBuiltin() ? TextMateBundle.message("title.built.in", new Object[0]) : PathUtil.toSystemDependentName((String)bundle.getPath());
            } else {
                string = null;
            }
            return string;
        }

        private static final String _init_$lambda$0(JCheckBox box) {
            Intrinsics.checkNotNullParameter((Object)box, (String)"box");
            return box.getText();
        }

        private static final String _init_$lambda$1(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }
    };
    @NotNull
    private static final String TEXTMATE_LAST_ADDED_BUNDLE = "textmate.last.added.bundle";

    @NotNull
    public final Set<TextMateConfigurableBundle> getState() {
        Set result = new HashSet();
        int n = this.myBundlesList.getItemsCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.myBundlesList.getItemAt(i);
            Intrinsics.checkNotNull((Object)object);
            result.add(TextMateConfigurableBundle.copy$default((TextMateConfigurableBundle)object, null, null, this.myBundlesList.isItemSelected(i), false, 11, null));
        }
        return result;
    }

    public final void setState(@NotNull Collection<TextMateConfigurableBundle> bundles) {
        Intrinsics.checkNotNullParameter(bundles, (String)"bundles");
        this.myBundlesList.clear();
        Iterable iterable = bundles;
        Comparator comparator = NaturalComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"INSTANCE");
        Comparator comparator2 = comparator;
        for (TextMateConfigurableBundle bean : CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(comparator2){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                TextMateConfigurableBundle textMateConfigurableBundle = (TextMateConfigurableBundle)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                TextMateConfigurableBundle p0 = (TextMateConfigurableBundle)b;
                String string = p0.getName();
                bl = false;
                String string2 = p0.getName();
                return comparator.compare(string, string2);
            }
        })) {
            this.myBundlesList.addItem((Object)bean, bean.getName(), bean.getEnabled());
        }
    }

    @NotNull
    public final JPanel createMainComponent() {
        return (JPanel)BuilderKt.panel(arg_0 -> TextMateBundlesListPanel.createMainComponent$lambda$9(this, arg_0));
    }

    public final boolean isModified(@NotNull Set<TextMateConfigurableBundle> bundles) {
        Intrinsics.checkNotNullParameter(bundles, (String)"bundles");
        return !Intrinsics.areEqual(this.getState(), bundles);
    }

    public void dispose() {
    }

    private static final Unit createMainComponent$lambda$9$lambda$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()};
        String string = TextMateBundle.message("textmate.configuration.description", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.text$default((Row)$this$row, (String)string, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final CharSequence createMainComponent$lambda$9$lambda$8$lambda$2$lambda$1(JCheckBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final void createMainComponent$lambda$9$lambda$8$lambda$2(TextMateBundlesListPanel this$0, AnActionButton it) {
        void $this$filterIsInstanceTo$iv$iv;
        List list = this$0.myBundlesList.getSelectedValuesList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedValuesList(...)");
        Object[] $this$filterIsInstance$iv = (Object[])list;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JCheckBox)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List bundlesToDelete = (List)destination$iv$iv;
        if (!((Collection)bundlesToDelete).isEmpty()) {
            String message = CollectionsKt.joinToString$default((Iterable)bundlesToDelete, (CharSequence)"\n", null, null, (int)0, null, TextMateBundlesListPanel::createMainComponent$lambda$9$lambda$8$lambda$2$lambda$1, (int)30, null);
            objectArray = new Object[]{bundlesToDelete.size()};
            String string = TextMateBundle.message("textmate.remove.title", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            MessageDialogBuilder.YesNo yesNo = MessageDialogBuilder.Companion.yesNo(string, message);
            String string2 = CommonBundle.message((String)"button.remove", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            MessageDialogBuilder.YesNo yesNo2 = (MessageDialogBuilder.YesNo)yesNo.yesText(string2);
            String string3 = CommonBundle.getCancelButtonText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCancelButtonText(...)");
            if (((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)yesNo2.noText(string3)).icon(null)).ask((Component)this$0.myBundlesList)) {
                ListUtil.removeSelectedItems((JList)((JList)this$0.myBundlesList));
            }
        }
    }

    private static final TextMateBundleReader createMainComponent$lambda$9$lambda$8$lambda$6$lambda$4(VirtualFile $bundleDirectory) {
        return TextMateService.getInstance().readBundle($bundleDirectory.toNioPath());
    }

    private static final void createMainComponent$lambda$9$lambda$8$lambda$6(TextMateBundlesListPanel this$0, Row $this_row, AnActionButton it) {
        VirtualFile virtualFile;
        String string = PropertiesComponent.getInstance().getValue(TEXTMATE_LAST_ADDED_BUNDLE);
        if (string != null) {
            String lastAddedBundlePath = string;
            boolean bl = false;
            virtualFile = LocalFileSystem.getInstance().findFileByPath(lastAddedBundlePath);
        } else {
            virtualFile = null;
        }
        VirtualFile fileToSelect = virtualFile;
        FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createMultipleFoldersDescriptor();
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)chooserDescriptor, (Component)((Component)this$0.myBundlesList), null, (VirtualFile)fileToSelect);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"chooseFiles(...)");
        VirtualFile[] bundleDirectories = virtualFileArray;
        if (!(bundleDirectories.length == 0)) {
            String errorMessage = null;
            for (VirtualFile bundleDirectory : bundleDirectories) {
                Object $this$createMainComponent_u24lambda_u249_u24lambda_u248_u24lambda_u246_u24lambda_u245;
                PropertiesComponent.getInstance().setValue(TEXTMATE_LAST_ADDED_BUNDLE, bundleDirectory.getPath());
                ThrowableComputable readBundleProcess = () -> TextMateBundlesListPanel.createMainComponent$lambda$9$lambda$8$lambda$6$lambda$4(bundleDirectory);
                Object[] objectArray = $this_row;
                try {
                    $this$createMainComponent_u24lambda_u249_u24lambda_u248_u24lambda_u246_u24lambda_u245 = objectArray;
                    boolean bl = false;
                    $this$createMainComponent_u24lambda_u249_u24lambda_u248_u24lambda_u246_u24lambda_u245 = Result.constructor-impl((Object)((TextMateBundleReader)ProgressManager.getInstance().runProcessWithProgressSynchronously(readBundleProcess, TextMateBundle.message("button.add.bundle", new Object[0]), true, null)));
                }
                catch (Throwable bl) {
                    $this$createMainComponent_u24lambda_u249_u24lambda_u248_u24lambda_u246_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                objectArray = $this$createMainComponent_u24lambda_u249_u24lambda_u248_u24lambda_u246_u24lambda_u245;
                TextMateBundleReader bundleReader = (TextMateBundleReader)(Result.isFailure-impl((Object)objectArray) ? null : objectArray);
                if (bundleReader != null) {
                    String bundleDirectoryPath;
                    Intrinsics.checkNotNullExpressionValue((Object)bundleDirectory.getPath(), (String)"getPath(...)");
                    boolean alreadyAdded = false;
                    int n = this$0.myBundlesList.getItemsCount();
                    for (int i = 0; i < n; ++i) {
                        TextMateConfigurableBundle item = (TextMateConfigurableBundle)this$0.myBundlesList.getItemAt(i);
                        if (item == null || !Intrinsics.areEqual((Object)FileUtil.toSystemIndependentName((String)bundleDirectoryPath), (Object)item.getPath())) continue;
                        this$0.myBundlesList.clearSelection();
                        this$0.myBundlesList.setSelectedIndex(i);
                        UIUtil.scrollListToVisibleIfNeeded((JList)((JList)this$0.myBundlesList));
                        alreadyAdded = true;
                        break;
                    }
                    if (alreadyAdded) continue;
                    TextMateConfigurableBundle item = new TextMateConfigurableBundle(bundleReader.getBundleName(), bundleDirectoryPath, true, false);
                    this$0.myBundlesList.addItem((Object)item, item.getName(), true);
                    continue;
                }
                objectArray = new Object[]{bundleDirectory.getPresentableUrl()};
                errorMessage = TextMateBundle.message("message.textmate.bundle.error", objectArray);
            }
            if (errorMessage != null) {
                Messages.showErrorDialog(errorMessage, (String)TextMateBundle.message("title.textmate.bundle.error", new Object[0]));
            }
        }
    }

    private static final boolean createMainComponent$lambda$9$lambda$8$lambda$7(TextMateBundlesListPanel this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        for (int index : this$0.myBundlesList.getSelectedIndices()) {
            TextMateConfigurableBundle bean;
            TextMateConfigurableBundle textMateConfigurableBundle = bean = (TextMateConfigurableBundle)this$0.myBundlesList.getItemAt(index);
            Intrinsics.checkNotNull((Object)textMateConfigurableBundle);
            if (!textMateConfigurableBundle.getBuiltin()) continue;
            return false;
        }
        return true;
    }

    private static final Unit createMainComponent$lambda$9$lambda$8(TextMateBundlesListPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JPanel jPanel = ToolbarDecorator.createDecorator((JList)((JList)this$0.myBundlesList)).setRemoveAction(arg_0 -> TextMateBundlesListPanel.createMainComponent$lambda$9$lambda$8$lambda$2(this$0, arg_0)).setAddAction(arg_0 -> TextMateBundlesListPanel.createMainComponent$lambda$9$lambda$8$lambda$6(this$0, $this$row, arg_0)).setRemoveActionUpdater(arg_0 -> TextMateBundlesListPanel.createMainComponent$lambda$9$lambda$8$lambda$7(this$0, arg_0)).disableUpDownActions().createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        $this$row.cell((JComponent)jPanel).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createMainComponent$lambda$9(TextMateBundlesListPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, TextMateBundlesListPanel::createMainComponent$lambda$9$lambda$0, (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TextMateBundlesListPanel.createMainComponent$lambda$9$lambda$8(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/textmate/configuration/TextMateBundlesListPanel$Companion;", "", "<init>", "()V", "TEXTMATE_LAST_ADDED_BUNDLE", "", "intellij.textmate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

