/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.deployment.ui.DockerTextFieldWithBrowseButton;
import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DockerBindingsFieldBase<B>
extends DockerTextFieldWithBrowseButton {
    private final List<B> myBindings = new LinkedList<B>();

    DockerBindingsFieldBase() {
    }

    public List<B> getBindings() {
        return Collections.unmodifiableList(this.myBindings);
    }

    public void setBindings(@NotNull List<B> list2, boolean notifyChanges) {
        if (list2 == null) {
            DockerBindingsFieldBase.$$$reportNull$$$0(0);
        }
        if (this.myBindings.equals(list2)) {
            return;
        }
        this.myBindings.clear();
        this.myBindings.addAll(list2);
        this.setText(this.stringifyAll(list2));
        if (notifyChanges) {
            this.fireStateChanged();
        }
    }

    protected abstract String stringify(@NotNull B var1);

    protected String stringifyAll(@NotNull List<B> list2) {
        if (list2 == null) {
            DockerBindingsFieldBase.$$$reportNull$$$0(1);
        }
        return this.stringifyAll(list2, " ");
    }

    protected String stringifyAll(@NotNull List<B> list2, String delimiter) {
        if (list2 == null) {
            DockerBindingsFieldBase.$$$reportNull$$$0(2);
        }
        return list2.stream().filter(Objects::nonNull).map(this::stringify).collect(Collectors.joining(delimiter));
    }

    protected static AbstractTableCellEditor newComboEditor(final String ... options) {
        return new AbstractTableCellEditor(){
            private JBComboBoxTableCellEditorComponent myCombo;

            public Object getCellEditorValue() {
                return this.myCombo.getEditorValue();
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column2) {
                this.myCombo = new JBComboBoxTableCellEditorComponent(table);
                this.myCombo.setCell(table, row, column2);
                this.myCombo.setOptions((Object[])options);
                this.myCombo.setDefaultValue(value == null ? options[0] : value);
                return this.myCombo;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "list";
        objectArray2[1] = "com/intellij/docker/deployment/ui/DockerBindingsFieldBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setBindings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "stringifyAll";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private final JPanel myPanel = new JPanel();

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column2) {
            if (!(value instanceof Boolean)) {
                this.myPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                return this.myPanel;
            }
            this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.setSelected((Boolean)value);
            return this;
        }
    }

    protected static abstract class BindingsTableBase<B>
    extends ListTableWithButtons<B> {
        protected BindingsTableBase() {
        }

        public List<B> getBindings() {
            return super.getElements();
        }

        private static class ColumnBase<B>
        extends ListTableWithButtons.ElementsColumnInfoBase<B> {
            private final Function<? super B, String> myGetter;

            ColumnBase(@NotNull @NlsContexts.ColumnName String name2, @NotNull Function<? super B, Object> getter) {
                if (name2 == null) {
                    ColumnBase.$$$reportNull$$$0(0);
                }
                if (getter == null) {
                    ColumnBase.$$$reportNull$$$0(1);
                }
                super(name2);
                this.myGetter = getter.andThen(o -> o == null ? "" : String.valueOf(o));
            }

            @Nullable
            protected String getDescription(B element) {
                return null;
            }

            @Nullable
            public String valueOf(B element) {
                return this.myGetter.apply(element);
            }

            public boolean isCellEditable(B element) {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "getter";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/deployment/ui/DockerBindingsFieldBase$BindingsTableBase$ColumnBase";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        protected static class StringColumnBase<B>
        extends ColumnBase<B> {
            private final BiConsumer<? super B, ? super String> mySetter;

            public StringColumnBase(@NotNull @NlsContexts.ColumnName String name2, @NotNull Function<? super B, Object> getter, @NotNull BiConsumer<? super B, ? super String> setter) {
                if (name2 == null) {
                    StringColumnBase.$$$reportNull$$$0(0);
                }
                if (getter == null) {
                    StringColumnBase.$$$reportNull$$$0(1);
                }
                if (setter == null) {
                    StringColumnBase.$$$reportNull$$$0(2);
                }
                super(name2, getter);
                this.mySetter = setter;
            }

            public void setValue(B binding, String value) {
                this.mySetter.accept(binding, this.normalizeValue(value));
            }

            protected String normalizeValue(String valueFromEditor) {
                return StringUtil.nullize((String)valueFromEditor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "getter";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "setter";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/deployment/ui/DockerBindingsFieldBase$BindingsTableBase$StringColumnBase";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        protected static class IntegerColumnBase<B>
        extends ColumnBase<B> {
            private final BiConsumer<? super B, ? super Integer> myIntSetter;
            private final boolean myAllowNull;

            public IntegerColumnBase(@NotNull @NlsContexts.ColumnName String name2, @NotNull Function<? super B, Object> getter, @NotNull BiConsumer<? super B, ? super Integer> setter) {
                if (name2 == null) {
                    IntegerColumnBase.$$$reportNull$$$0(0);
                }
                if (getter == null) {
                    IntegerColumnBase.$$$reportNull$$$0(1);
                }
                if (setter == null) {
                    IntegerColumnBase.$$$reportNull$$$0(2);
                }
                this(name2, getter, setter, true);
            }

            public IntegerColumnBase(@NotNull @NlsContexts.ColumnName String name2, @NotNull Function<? super B, Object> getter, @NotNull BiConsumer<? super B, ? super Integer> setter, boolean allowNull) {
                if (name2 == null) {
                    IntegerColumnBase.$$$reportNull$$$0(3);
                }
                if (getter == null) {
                    IntegerColumnBase.$$$reportNull$$$0(4);
                }
                if (setter == null) {
                    IntegerColumnBase.$$$reportNull$$$0(5);
                }
                super(name2, getter);
                this.myIntSetter = setter;
                this.myAllowNull = allowNull;
            }

            public void setValue(B binding, String value) {
                if (value == null || value.trim().isEmpty()) {
                    if (this.myAllowNull) {
                        this.myIntSetter.accept(binding, null);
                    } else {
                        this.reportErrorValue(value);
                    }
                    return;
                }
                value = value.trim();
                try {
                    this.myIntSetter.accept(binding, Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    this.reportErrorValue(value);
                }
            }

            protected void reportErrorValue(String badValue) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "getter";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[0] = "setter";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/deployment/ui/DockerBindingsFieldBase$BindingsTableBase$IntegerColumnBase";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        protected static class BooleanColumnBase<B>
        extends ColumnInfo<B, Boolean> {
            private final BooleanRenderer myRenderer;
            private final BiConsumer<? super B, ? super Boolean> mySetter;
            private final Function<? super B, Boolean> myGetter;

            public BooleanColumnBase(@NotNull @NlsContexts.ColumnName String name2, @NotNull Function<? super B, Boolean> getter, @NotNull BiConsumer<? super B, ? super Boolean> setter) {
                if (name2 == null) {
                    BooleanColumnBase.$$$reportNull$$$0(0);
                }
                if (getter == null) {
                    BooleanColumnBase.$$$reportNull$$$0(1);
                }
                if (setter == null) {
                    BooleanColumnBase.$$$reportNull$$$0(2);
                }
                super(name2);
                this.myRenderer = new BooleanRenderer();
                this.myGetter = getter;
                this.mySetter = setter;
            }

            public boolean isCellEditable(B b) {
                return true;
            }

            public TableCellRenderer getRenderer(B element) {
                return this.myRenderer;
            }

            @Nullable
            public Boolean valueOf(B element) {
                return this.myGetter.apply(element);
            }

            public void setValue(B element, Boolean value) {
                this.mySetter.accept(element, value);
            }

            @Nullable
            public String getMaxStringValue() {
                return "yes";
            }

            @Nullable
            public TableCellEditor getEditor(B binding) {
                return new BooleanTableCellEditor();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "getter";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "setter";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/deployment/ui/DockerBindingsFieldBase$BindingsTableBase$BooleanColumnBase";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    protected static class BindingsDialogBase<B>
    extends DialogWrapper {
        private final DockerBindingsFieldBase<B> myParent;
        private final BindingsTableBase<B> myTable;
        private final JPanel myPanel;

        public BindingsDialogBase(@NotNull DockerBindingsFieldBase<B> parent, @NotNull BindingsTableBase<B> table) {
            if (parent == null) {
                BindingsDialogBase.$$$reportNull$$$0(0);
            }
            if (table == null) {
                BindingsDialogBase.$$$reportNull$$$0(1);
            }
            super(parent, true);
            this.myParent = parent;
            this.myPanel = new JPanel(new BorderLayout());
            this.myTable = table;
            this.myTable.setValues(parent.getBindings());
            this.myPanel.add((Component)this.myTable.getComponent(), "Center");
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myPanel;
        }

        public void setEmptyText(@NotNull @Nls String emptyText) {
            if (emptyText == null) {
                BindingsDialogBase.$$$reportNull$$$0(2);
            }
            this.myTable.getTableView().getEmptyText().setText(emptyText);
        }

        protected void doOKAction() {
            this.myTable.stopEditing();
            this.myParent.setBindings(this.myTable.getBindings(), true);
            super.doOKAction();
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return ((Object)this.myParent).getClass().getName() + ".v173.dialogSize";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "emptyText";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/deployment/ui/DockerBindingsFieldBase$BindingsDialogBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setEmptyText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

