/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceProvider;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/typescript/compiler/TypeScriptLanguageServiceProvider;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "allServices", "", "Lcom/intellij/lang/javascript/service/JSLanguageService;", "getAllServices", "()Ljava/util/List;", "getService", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isHighlightingCandidate", "", "Companion", "intellij.javascript.impl"})
public final class TypeScriptLanguageServiceProvider
implements JSLanguageServiceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public TypeScriptLanguageServiceProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    @NotNull
    public List<JSLanguageService> getAllServices() {
        return CollectionsKt.listOf((Object)this.project.getService(TypeScriptServerServiceImpl.class));
    }

    @Override
    @Nullable
    public JSLanguageService getService(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JSLanguageService service = this.getAllServices().get(0);
        return service.isAcceptable(file) ? service : null;
    }

    @Override
    public boolean isHighlightingCandidate(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return TypeScriptLanguageServiceUtil.isJavaScriptOrTypeScriptFileType(file.getFileType());
    }

    @Deprecated(message="Use TypeScriptLanguageServiceUtil.isJavaScriptOrTypeScriptFileType()")
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/typescript/compiler/TypeScriptLanguageServiceProvider$Companion;", "", "<init>", "()V", "isJavaScriptOrTypeScriptFileType", "", "type", "Lcom/intellij/openapi/fileTypes/FileType;", "intellij.javascript.impl"})
    @ApiStatus.ScheduledForRemoval
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use TypeScriptLanguageServiceUtil.isJavaScriptOrTypeScriptFileType()")
        @ApiStatus.ScheduledForRemoval
        public final boolean isJavaScriptOrTypeScriptFileType(@NotNull FileType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return TypeScriptLanguageServiceUtil.isJavaScriptOrTypeScriptFileType(type2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

