/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Stack;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public abstract class JSElementIterator
implements Iterator<PsiElement> {
    private final boolean reverse;
    private final int minTextOffset;
    private final int maxTextOffset;
    private final Stack<PsiElement> elementStack;
    private PsiElement next;
    private boolean retrieveNext;

    public JSElementIterator(@NotNull JSElement element, boolean reverse, int minTextOffset, int maxTextOffset) {
        if (element == null) {
            JSElementIterator.$$$reportNull$$$0(0);
        }
        this.reverse = reverse;
        this.minTextOffset = minTextOffset;
        this.maxTextOffset = maxTextOffset;
        this.retrieveNext = true;
        this.elementStack = new Stack();
        this.elementStack.push((Object)element);
    }

    protected abstract boolean visitElement(PsiElement var1);

    private void findNext() {
        PsiElement element = null;
        boolean pass = false;
        if (!this.elementStack.empty()) {
            do {
                int elementTextOffset;
                int elementTextEndOffset;
                if ((elementTextEndOffset = (elementTextOffset = (element = (PsiElement)this.elementStack.pop()).getTextOffset()) + element.getTextLength()) < this.minTextOffset || elementTextOffset > this.maxTextOffset) continue;
                pass = this.visitElement(element);
                this.pushChildren(element.getChildren(), this.reverse ? elementTextOffset : elementTextEndOffset);
            } while (!pass && !this.elementStack.empty());
        }
        this.next = pass ? element : null;
        this.retrieveNext = false;
    }

    private void pushChildren(PsiElement[] children, int elementTextOffset) {
        int childTextOffset = elementTextOffset;
        if (this.reverse) {
            for (int index = 0; index < children.length && childTextOffset <= this.maxTextOffset; ++index) {
                PsiElement child = children[index];
                childTextOffset = child.getTextOffset();
                if (childTextOffset > this.maxTextOffset) continue;
                this.elementStack.push((Object)child);
            }
        } else {
            for (int index = children.length - 1; index >= 0 && childTextOffset >= this.minTextOffset; --index) {
                PsiElement child = children[index];
                childTextOffset = child.getTextOffset() + child.getTextLength();
                if (childTextOffset < this.minTextOffset) continue;
                this.elementStack.push((Object)child);
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.retrieveNext) {
            this.findNext();
        }
        return this.next != null;
    }

    @Override
    public PsiElement next() {
        if (this.retrieveNext) {
            this.findNext();
        }
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        this.retrieveNext = true;
        return this.next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSElementIterator", "<init>"));
    }
}

