/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports;

import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSImportCandidate
extends Iconable {
    @NlsSafe
    @NotNull
    public String getName();

    @Nullable
    public PsiElement getElement();

    @Nullable
    public JSImportDescriptor getDescriptor();

    @Nullable
    default public VirtualFile getElementFile() {
        return PsiUtilCore.getVirtualFile((PsiElement)this.getElement());
    }

    @Nullable
    default public Icon getIcon(@Iconable.IconFlags int flags) {
        PsiElement element = this.getElement();
        return element != null ? element.getIcon(flags) : null;
    }

    default public int getPriority() {
        return 1;
    }

    @NotNull
    default public String getContainerText() {
        JSImportDescriptor item = this.getDescriptor();
        if (item == null) {
            return "";
        }
        JSImportExportType type2 = item.getImportType();
        String suffix = type2.isComposite() ? "." + this.getName() : "";
        String string = JSImportCandidate.getContainerForDescriptor(item) + suffix;
        if (string == null) {
            JSImportCandidate.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static String getContainerForDescriptor(JSImportDescriptor item) {
        JSModuleDescriptor moduleDescriptor = item.getModuleDescriptor();
        PsiElement module = moduleDescriptor.getModule();
        if (module instanceof JSFile && !((JSFile)module).isCommonJSModule()) {
            String string = ((JSFile)module).getName();
            if (string == null) {
                JSImportCandidate.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = "\"" + item.getModuleName() + "\"";
        if (string == null) {
            JSImportCandidate.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/modules/imports/JSImportCandidate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerForDescriptor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

