/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSConsecutiveCommasInArrayLiteralInspection;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLastCommaInArrayLiteralInspection
extends JSInspection {
    @Override
    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        return new JSElementVisitor(){

            @Override
            public void visitJSArrayLiteralExpression(@NotNull JSArrayLiteralExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DialectDetector.isTypeScript((PsiElement)node) || DialectDetector.isES6((PsiElement)node)) {
                    return;
                }
                PsiElement child = JSLastCommaInArrayLiteralInspection.findErrorNode(node);
                if (child != null) {
                    JSPrefixExpression prefixExpr;
                    if (!DialectDetector.isActionScript((PsiElement)node) && (prefixExpr = (JSPrefixExpression)ObjectUtils.tryCast((Object)node.getParent(), JSPrefixExpression.class)) != null && prefixExpr.getOperationSign() == JSTokenTypes.MINUS) {
                        return;
                    }
                    ASTNode prev = TreeUtil.skipWhitespaceAndComments((ASTNode)child.getNode().getTreePrev(), (boolean)false);
                    LocalQuickFixAndIntentionActionOnPsiElement fix = prev != null && prev.getElementType() == JSStubElementTypes.EMPTY_EXPRESSION ? new RemoveCommaAndInsertUndefined(prev.getPsi()) : JSFixFactory.getInstance().removeASTNodeFix("javascript.validation.message.remove.unneeded.comma.fix", child);
                    holder.registerProblem(child, JavaScriptBundle.message("javascript.validation.message.unneeded.comma", new Object[0]), new LocalQuickFix[]{fix});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSLastCommaInArrayLiteralInspection$1", "visitJSArrayLiteralExpression"));
            }
        };
    }

    @Nullable
    public static PsiElement findErrorNode(@NotNull JSArrayLiteralExpression node) {
        PsiElement lastChild;
        PsiElement child;
        if (node == null) {
            JSLastCommaInArrayLiteralInspection.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = child = (lastChild = node.getLastChild()) != null ? lastChild.getPrevSibling() : null;
        if (child == null) {
            return null;
        }
        ASTNode childNode = TreeUtil.skipWhitespaceAndComments((ASTNode)child.getNode(), (boolean)false);
        if (childNode != null && childNode.getElementType() == JSTokenTypes.COMMA) {
            return childNode.getPsi();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSLastCommaInArrayLiteralInspection", "findErrorNode"));
    }

    private static class RemoveCommaAndInsertUndefined
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected RemoveCommaAndInsertUndefined(@Nullable PsiElement element) {
            super(element);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiElement undefined;
            PsiElement parent;
            if (project == null) {
                RemoveCommaAndInsertUndefined.$$$reportNull$$$0(0);
            }
            if (file == null) {
                RemoveCommaAndInsertUndefined.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                RemoveCommaAndInsertUndefined.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                RemoveCommaAndInsertUndefined.$$$reportNull$$$0(3);
            }
            if ((parent = (undefined = JSConsecutiveCommasInArrayLiteralInspection.InsertUndefinedFix.replaceWithUndefined(startElement)).getParent()) instanceof JSArrayLiteralExpression) {
                PsiElement comma = JSLastCommaInArrayLiteralInspection.findErrorNode((JSArrayLiteralExpression)parent);
                assert (comma != null);
                JSFixFactory.getInstance().removeASTNodeFix("javascript.validation.message.remove.unneeded.comma.fix", comma).invoke(project, file, editor, comma, comma);
            }
        }

        @NotNull
        public String getText() {
            String string = JavaScriptBundle.message("javascript.validation.message.remove.unneeded.comma.fix", new Object[0]);
            if (string == null) {
                RemoveCommaAndInsertUndefined.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                RemoveCommaAndInsertUndefined.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSLastCommaInArrayLiteralInspection$RemoveCommaAndInsertUndefined";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSLastCommaInArrayLiteralInspection$RemoveCommaAndInsertUndefined";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

