/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.flow.ErrorObject;
import com.intellij.lang.javascript.flow.ExtraMessageObject;
import com.intellij.lang.javascript.flow.Location;
import com.intellij.lang.javascript.flow.MessageObject;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u0004\u0018\u00010\nJ6\u0010\u000b\u001a\u0004\u0018\u00010\f2\u000e\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f2\n\u0010\u0010\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\u00162\n\u0010\u0010\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0017\u001a\u00020\fH\u0002J\"\u0010\u0018\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\n\u0010\u0010\u001a\u00060\u000ej\u0002`\u000fH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/flow/FlowJSAnnotationBuilder;", "", "targetFilePath", "", "baseDirectoryPath", "errorObject", "Lcom/intellij/lang/javascript/flow/ErrorObject;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/lang/javascript/flow/ErrorObject;)V", "toAnnotationResult", "Lcom/intellij/lang/javascript/service/JSLanguageServiceAnnotationResult;", "addMessage", "Lcom/intellij/lang/javascript/flow/Location;", "errorText", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "errorDetails", "messageObject", "Lcom/intellij/lang/javascript/flow/MessageObject;", "addLink", "", "addLinkOpenTag", "", "location", "addChildren", "extra", "", "Lcom/intellij/lang/javascript/flow/ExtraMessageObject;", "intellij.javascript.impl"})
public final class FlowJSAnnotationBuilder {
    @Nullable
    private final String targetFilePath;
    @NotNull
    private final String baseDirectoryPath;
    @NotNull
    private final ErrorObject errorObject;

    public FlowJSAnnotationBuilder(@Nullable String targetFilePath, @NotNull String baseDirectoryPath, @NotNull ErrorObject errorObject) {
        Intrinsics.checkNotNullParameter((Object)baseDirectoryPath, (String)"baseDirectoryPath");
        Intrinsics.checkNotNullParameter((Object)errorObject, (String)"errorObject");
        this.targetFilePath = targetFilePath;
        this.baseDirectoryPath = baseDirectoryPath;
        this.errorObject = errorObject;
    }

    @Nullable
    public final JSLanguageServiceAnnotationResult toAnnotationResult() {
        StringBuilder errorText = new StringBuilder();
        StringBuilder errorDetails = new StringBuilder();
        MessageObject message = this.errorObject.getMessage();
        errorDetails.append("Flow: ");
        Location mainLocation = this.addMessage(errorText, errorDetails, message, false);
        if (this.targetFilePath != null && mainLocation != null && !FileUtil.pathsEqual((String)this.targetFilePath, (String)mainLocation.getFilePath())) {
            return null;
        }
        List<ExtraMessageObject> extra = this.errorObject.getExtra();
        Collection collection = extra;
        if (!(collection == null || collection.isEmpty())) {
            errorDetails.append("<br/>");
            this.addChildren(extra, errorDetails);
        }
        Location location = mainLocation;
        Location location2 = mainLocation;
        Location location3 = mainLocation;
        Location location4 = mainLocation;
        Location location5 = mainLocation;
        return new JSLanguageServiceAnnotationResult(errorText.toString(), errorDetails.toString(), location != null ? location.getFilePath() : null, this.errorObject.getErrorCategory(), location2 != null ? location2.getLine() : 0, location3 != null ? location3.getColumn() : 0, location4 != null ? location4.getLineEnd() : 0, location5 != null ? location5.getColumnEnd() : 0);
    }

    private final Location addMessage(StringBuilder errorText, StringBuilder errorDetails, MessageObject messageObject, boolean addLink) {
        String descr = messageObject.getDescr();
        Location location = messageObject.getLocation();
        errorDetails.append(XmlUtil.escape((String)descr));
        StringBuilder stringBuilder = errorText;
        if (stringBuilder != null) {
            stringBuilder.append(descr);
        }
        if (location != null && addLink) {
            errorDetails.append(": ");
            this.addLinkOpenTag(errorDetails, location);
            errorDetails.append(FileUtil.getRelativePath((String)this.baseDirectoryPath, (String)location.getFilePath(), (char)File.separatorChar)).append(":").append(location.getLine()).append("</a>");
        }
        return location;
    }

    private final void addLinkOpenTag(StringBuilder errorDetails, Location location) {
        errorDetails.append("<a href='#navigation_logical/").append(location.getFilePath()).append(":").append(location.getLine()).append(":").append(location.getColumn()).append("'>");
    }

    private final void addChildren(List<? extends ExtraMessageObject> extra, StringBuilder errorDetails) {
        for (ExtraMessageObject extraMessageObject : extra) {
            MessageObject message = extraMessageObject.getMessage();
            errorDetails.append("<br/>");
            this.addMessage(null, errorDetails, message, true);
        }
    }
}

