/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.columns;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.columns.ColumnAccessor;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnResolutionContext;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.impl.DataRowImplKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.ColumnAccessorImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010*\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\f\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006B\u0013\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u00c6\u0003J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0096\u0003J\u0017\u0010\u0018\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0096\u0001J\u0019\u0010\u001b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u00c6\u0001J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u00d6\u0003J\u0011\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0011H\u0096\u0003J#\u0010!\u001a\b\u0012\u0004\u0012\u0002H#0\u0003\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%H\u0096\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\u00042\u000e\u0010'\u001a\n\u0012\u0002\b\u00030(j\u0002`)H\u0016J\u001a\u0010*\u001a\u0004\u0018\u00010\u00042\u000e\u0010'\u001a\n\u0012\u0002\b\u00030(j\u0002`)H\u0016J\t\u0010+\u001a\u00020\u0011H\u00d6\u0001J\u0011\u0010,\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0002H\u0096\u0001J\t\u0010-\u001a\u00020\u0016H\u0096\u0001J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020/H\u0096\u0003J\u0010\u00100\u001a\u00020\u00022\b\b\u0002\u00101\u001a\u00020\u0002J\u0011\u00102\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0002H\u0096\u0001J\u000f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000204H\u0096\u0001J\u0017\u00103\u001a\b\u0012\u0004\u0012\u00020\u0002042\u0006\u0010\"\u001a\u00020\u0011H\u0096\u0001J\b\u0010\u0005\u001a\u00020\u0002H\u0016J\b\u00105\u001a\u0004\u0018\u00010\u0000J\b\u0010\u0007\u001a\u00020\u0000H\u0016J\u0011\u00106\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0002H\u0086\u0002J\u0017\u00106\u001a\u00020\u00002\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000208H\u0086\u0002J\u0011\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0000H\u0086\u0002J\u0010\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0002H\u0016J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0002J\u001f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010=\u001a\u00020\u00112\u0006\u0010>\u001a\u00020\u0011H\u0096\u0001J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0011J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u0011J\b\u0010C\u001a\u00020\u0002H\u0016R\u0011\u0010\t\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "", "", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnAccessor;", "", "name", "(Ljava/lang/String;)V", "path", "(Ljava/util/List;)V", "columnName", "getColumnName", "()Ljava/lang/String;", "parentName", "getParentName", "getPath", "()Ljava/util/List;", "size", "", "getSize", "()I", "component1", "contains", "", "element", "containsAll", "elements", "", "copy", "drop", "dropFirst", "dropLast", "equals", "other", "get", "index", "C", "column", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "getValue", "row", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lorg/jetbrains/kotlinx/dataframe/AnyRow;", "getValueOrNull", "hashCode", "indexOf", "isEmpty", "iterator", "", "joinToString", "separator", "lastIndexOf", "listIterator", "", "parent", "plus", "otherPath", "", "rename", "newName", "replaceLast", "subList", "fromIndex", "toIndex", "take", "first", "takeLast", "last", "toString", "core"})
public final class ColumnPath
implements List<String>,
ColumnAccessor<Object>,
KMappedMarker {
    @NotNull
    private final List<String> path;

    public ColumnPath(@NotNull List<String> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        this.path = path;
    }

    @NotNull
    public final List<String> getPath() {
        return this.path;
    }

    public int getSize() {
        return this.path.size();
    }

    public boolean contains(@NotNull String element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.path.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.path.containsAll(elements);
    }

    @Override
    @NotNull
    public String get(int index) {
        return this.path.get(index);
    }

    public int indexOf(@NotNull String element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.path.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return this.path.iterator();
    }

    public int lastIndexOf(@NotNull String element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.path.lastIndexOf(element);
    }

    @Override
    @NotNull
    public ListIterator<String> listIterator() {
        return this.path.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<String> listIterator(int index) {
        return this.path.listIterator(index);
    }

    @Override
    @NotNull
    public List<String> subList(int fromIndex, int toIndex) {
        return this.path.subList(fromIndex, toIndex);
    }

    public ColumnPath(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(CollectionsKt.listOf((Object)name));
    }

    @NotNull
    public final ColumnPath drop(int size) {
        return new ColumnPath(CollectionsKt.drop((Iterable)this.path, (int)size));
    }

    @Nullable
    public final ColumnPath parent() {
        return this.path.isEmpty() ? null : this.dropLast(1);
    }

    @NotNull
    public final ColumnPath dropLast(int size) {
        return new ColumnPath(CollectionsKt.dropLast(this.path, (int)size));
    }

    public static /* synthetic */ ColumnPath dropLast$default(ColumnPath columnPath, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return columnPath.dropLast(n);
    }

    @NotNull
    public final ColumnPath dropFirst(int size) {
        return new ColumnPath(CollectionsKt.drop((Iterable)this.path, (int)size));
    }

    public static /* synthetic */ ColumnPath dropFirst$default(ColumnPath columnPath, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return columnPath.dropFirst(n);
    }

    @NotNull
    public final ColumnPath plus(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new ColumnPath(CollectionsKt.plus((Collection)this.path, (Object)name));
    }

    @NotNull
    public final ColumnPath plus(@NotNull ColumnPath otherPath) {
        Intrinsics.checkNotNullParameter((Object)otherPath, (String)"otherPath");
        return new ColumnPath(CollectionsKt.plus((Collection)this.path, (Iterable)otherPath.path));
    }

    @NotNull
    public final ColumnPath plus(@NotNull Iterable<String> otherPath) {
        Intrinsics.checkNotNullParameter(otherPath, (String)"otherPath");
        return new ColumnPath(CollectionsKt.plus((Collection)this.path, otherPath));
    }

    @NotNull
    public final ColumnPath take(int first2) {
        return new ColumnPath(CollectionsKt.take((Iterable)this.path, (int)first2));
    }

    @NotNull
    public final ColumnPath replaceLast(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new ColumnPath(this.path.size() < 2 ? CollectionsKt.listOf((Object)name) : CollectionsKt.plus((Collection)CollectionsKt.dropLast(this.path, (int)1), (Object)name));
    }

    @NotNull
    public final ColumnPath takeLast(int last2) {
        return new ColumnPath(CollectionsKt.takeLast(this.path, (int)last2));
    }

    @Override
    @NotNull
    public ColumnPath path() {
        return this;
    }

    @Override
    @NotNull
    public String name() {
        return (String)CollectionsKt.last(this.path);
    }

    @NotNull
    public final String getColumnName() {
        return this.name();
    }

    @Nullable
    public final String getParentName() {
        return this.path.size() > 1 ? this.path.get(this.path.size() - 2) : null;
    }

    @NotNull
    public ColumnPath rename(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return new ColumnPath(CollectionsKt.plus((Collection)CollectionsKt.dropLast(this.path, (int)1), (Object)newName));
    }

    @Override
    @Nullable
    public Object getValue(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        return DataRowImplKt.getOwner(row).get(this).get(row.index());
    }

    @Override
    @Nullable
    public Object getValueOrNull(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        DataColumn<?> dataColumn = DataRowImplKt.getOwner(row).getColumnOrNull(this);
        return dataColumn != null ? dataColumn.get(row.index()) : null;
    }

    @NotNull
    public String toString() {
        return this.path.toString();
    }

    @NotNull
    public final String joinToString(@NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        return CollectionsKt.joinToString$default((Iterable)this.path, (CharSequence)separator, null, null, (int)0, null, null, (int)62, null);
    }

    public static /* synthetic */ String joinToString$default(ColumnPath columnPath, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/";
        }
        return columnPath.joinToString(string);
    }

    @Override
    @NotNull
    public <C> ColumnAccessor<C> get(@NotNull ColumnReference<? extends C> column2) {
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return new ColumnAccessorImpl(this.plus(column2.path()));
    }

    @Override
    @NotNull
    public ColumnAccessor<Object> getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
        return ColumnAccessor.DefaultImpls.getValue(this, thisRef, property);
    }

    @Override
    @Nullable
    public ColumnWithPath<Object> resolveSingle(@NotNull ColumnResolutionContext context) {
        return ColumnAccessor.DefaultImpls.resolveSingle(this, context);
    }

    @Override
    @NotNull
    public List<ColumnWithPath<Object>> resolve(@NotNull ColumnResolutionContext context) {
        return ColumnAccessor.DefaultImpls.resolve(this, context);
    }

    @NotNull
    public final List<String> component1() {
        return this.path;
    }

    @NotNull
    public final ColumnPath copy(@NotNull List<String> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return new ColumnPath(path);
    }

    public static /* synthetic */ ColumnPath copy$default(ColumnPath columnPath, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = columnPath.path;
        }
        return columnPath.copy(list);
    }

    @Override
    public int hashCode() {
        return ((Object)this.path).hashCode();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ColumnPath)) {
            return false;
        }
        ColumnPath columnPath = (ColumnPath)other;
        return Intrinsics.areEqual(this.path, columnPath.path);
    }

    @Override
    public boolean add(String element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void add(int index, String element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends String> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public String remove(int index) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<String> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public String set(int index, String element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super String> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

