/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.copyright.CopyrightManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFileProcessor {
    private static final Logger LOG = Logger.getInstance((String)AbstractFileProcessor.class.getName());
    private final Project myProject;
    private final Module myModule;
    private final PsiFile file;
    private final PsiFile[] files;
    private final @NlsContexts.ProgressText String message;
    private final @NlsContexts.ProgressTitle String title;
    private final boolean myWithModalProgress;

    protected abstract Runnable preprocessFile(PsiFile var1, boolean var2) throws IncorrectOperationException;

    protected AbstractFileProcessor(@NotNull Project project, @NotNull PsiFile file, @NotNull @NlsContexts.ProgressTitle String title, @NotNull @NlsContexts.ProgressText String message, boolean withModalProgress) {
        if (project == null) {
            AbstractFileProcessor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            AbstractFileProcessor.$$$reportNull$$$0(1);
        }
        if (title == null) {
            AbstractFileProcessor.$$$reportNull$$$0(2);
        }
        if (message == null) {
            AbstractFileProcessor.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myModule = null;
        this.file = file;
        this.files = null;
        this.message = message;
        this.title = title;
        this.myWithModalProgress = withModalProgress;
    }

    protected AbstractFileProcessor(@NotNull Project project, PsiFile @NotNull [] files, @NotNull @NlsContexts.ProgressTitle String title, @NotNull @NlsContexts.ProgressText String message, boolean withModalProgress) {
        if (project == null) {
            AbstractFileProcessor.$$$reportNull$$$0(4);
        }
        if (title == null) {
            AbstractFileProcessor.$$$reportNull$$$0(5);
        }
        if (message == null) {
            AbstractFileProcessor.$$$reportNull$$$0(6);
        }
        if (files == null) {
            AbstractFileProcessor.$$$reportNull$$$0(7);
        }
        this.myProject = project;
        this.myModule = null;
        this.file = null;
        this.files = files;
        this.message = message;
        this.title = title;
        this.myWithModalProgress = withModalProgress;
    }

    public void run() {
        if (this.files != null) {
            this.process(this.files);
        } else if (this.file != null) {
            this.process(this.file);
        } else if (this.myModule != null) {
            this.process(this.myModule);
        } else {
            this.process(this.myProject);
        }
    }

    private void process(@NotNull PsiFile file) {
        if (file == null) {
            AbstractFileProcessor.$$$reportNull$$$0(8);
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file)) {
            return;
        }
        this.execute((Computable<Runnable>)((Computable)() -> {
            try {
                return this.preprocessFile(file, true);
            }
            catch (IncorrectOperationException incorrectoperationexception) {
                LOG.error((Throwable)incorrectoperationexception);
                return null;
            }
        }));
    }

    private Runnable prepareFiles(@NotNull List<? extends PsiFile> files) {
        if (files == null) {
            AbstractFileProcessor.$$$reportNull$$$0(9);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        String msg = null;
        double fraction = 0.0;
        if (indicator != null) {
            msg = indicator.getText();
            fraction = indicator.getFraction();
            indicator.setText(this.message);
        }
        Runnable[] runnables = new Runnable[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            PsiFile pfile = files.get(i);
            if (pfile == null) {
                LOG.debug("Unexpected null file at " + i);
                continue;
            }
            if (indicator != null) {
                if (indicator.isCanceled()) {
                    return null;
                }
                indicator.setFraction((double)i / (double)files.size());
            }
            if (pfile.isWritable()) {
                try {
                    runnables[i] = this.preprocessFile(pfile, true);
                }
                catch (IncorrectOperationException incorrectoperationexception) {
                    LOG.error((Throwable)incorrectoperationexception);
                }
            }
            files.set(i, null);
        }
        if (indicator != null) {
            indicator.setText(msg);
            indicator.setFraction(fraction);
        }
        return () -> {
            ProgressIndicator indicator1 = ProgressManager.getInstance().getProgressIndicator();
            String msg1 = null;
            double fraction1 = 0.0;
            if (indicator1 != null) {
                msg1 = indicator1.getText();
                fraction1 = indicator1.getFraction();
                indicator1.setText(this.message);
            }
            for (int j = 0; j < runnables.length; ++j) {
                Runnable runnable;
                if (indicator1 != null) {
                    if (indicator1.isCanceled()) {
                        return;
                    }
                    indicator1.setFraction((double)j / (double)runnables.length);
                }
                if ((runnable = runnables[j]) != null) {
                    runnable.run();
                }
                runnables[j] = null;
            }
            if (indicator1 != null) {
                indicator1.setText(msg1);
                indicator1.setFraction(fraction1);
            }
        };
    }

    private void process(PsiFile @NotNull [] files) {
        if (files == null) {
            AbstractFileProcessor.$$$reportNull$$$0(10);
        }
        this.execute((Computable<Runnable>)((Computable)() -> this.prepareFiles(new ArrayList<PsiFile>(Arrays.asList(files)))));
    }

    private void process(@NotNull Project project) {
        if (project == null) {
            AbstractFileProcessor.$$$reportNull$$$0(11);
        }
        ArrayList pfiles = new ArrayList();
        this.runWithProgress(() -> AbstractFileProcessor.findFiles(project, (List<? super PsiFile>)pfiles));
        this.handleFiles(pfiles);
    }

    private void process(@NotNull Module module) {
        if (module == null) {
            AbstractFileProcessor.$$$reportNull$$$0(12);
        }
        ArrayList pfiles = new ArrayList();
        this.runWithProgress(() -> AbstractFileProcessor.findFiles(module, (List<? super PsiFile>)pfiles));
        this.handleFiles(pfiles);
    }

    private static void findFiles(@NotNull Project project, List<? super PsiFile> files) {
        Module[] modules;
        if (project == null) {
            AbstractFileProcessor.$$$reportNull$$$0(13);
        }
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            AbstractFileProcessor.findFiles(module, files);
        }
    }

    private static void findFiles(@NotNull Module module, @NotNull List<? super PsiFile> files) {
        VirtualFile[] roots;
        if (module == null) {
            AbstractFileProcessor.$$$reportNull$$$0(14);
        }
        if (files == null) {
            AbstractFileProcessor.$$$reportNull$$$0(15);
        }
        ModuleFileIndex idx = ModuleRootManager.getInstance((Module)module).getFileIndex();
        for (VirtualFile root : roots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            ApplicationManager.getApplication().runReadAction(() -> idx.iterateContentUnderDirectory(root, dir -> {
                PsiDirectory psiDir;
                if (dir.isDirectory() && (psiDir = PsiManager.getInstance((Project)module.getProject()).findDirectory(dir)) != null) {
                    AbstractFileProcessor.findFiles(files, psiDir, false);
                }
                return true;
            }));
        }
    }

    private void handleFiles(@NotNull List<? extends PsiFile> files) {
        if (files == null) {
            AbstractFileProcessor.$$$reportNull$$$0(16);
        }
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        for (PsiFile psiFile : files) {
            list.add(psiFile.getVirtualFile());
        }
        if (!ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(list).hasReadonlyFiles() && !files.isEmpty()) {
            this.execute((Computable<Runnable>)((Computable)() -> this.prepareFiles(files)));
        }
    }

    private static void findFiles(@NotNull List<? super PsiFile> files, @NotNull PsiDirectory directory, boolean subdirs) {
        PsiFile[] locals;
        if (files == null) {
            AbstractFileProcessor.$$$reportNull$$$0(17);
        }
        if (directory == null) {
            AbstractFileProcessor.$$$reportNull$$$0(18);
        }
        Project project = directory.getProject();
        for (PsiFile psiFile : locals = directory.getFiles()) {
            CopyrightProfile opts = CopyrightManager.getInstance(project).getCopyrightOptions(psiFile);
            if (opts == null || !FileTypeUtil.isSupportedFile(psiFile)) continue;
            files.add((PsiFile)psiFile);
        }
        if (subdirs) {
            for (PsiFile psiFile : directory.getSubdirectories()) {
                AbstractFileProcessor.findFiles(files, (PsiDirectory)psiFile, true);
            }
        }
    }

    private void runWithProgress(@NotNull Runnable action) {
        if (action == null) {
            AbstractFileProcessor.$$$reportNull$$$0(19);
        }
        if (this.myWithModalProgress) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(action, this.title, true, this.myProject);
        } else {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            action.run();
        }
    }

    private void execute(@NotNull Computable<Runnable> readAction) {
        if (readAction == null) {
            AbstractFileProcessor.$$$reportNull$$$0(20);
        }
        Runnable[] writeAction = new Runnable[1];
        this.runWithProgress(() -> ApplicationManager.getApplication().runReadAction(() -> {
            writeAction[0] = (Runnable)readAction.compute();
        }));
        if (writeAction[0] != null) {
            WriteCommandAction.writeCommandAction((Project)this.myProject).withName(this.title).run(() -> writeAction[0].run());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readAction";
                break;
            }
        }
        objectArray2[1] = "com/maddyhome/idea/copyright/actions/AbstractFileProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareFiles";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "findFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "handleFiles";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithProgress";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

