/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorKt;
import org.jetbrains.plugins.github.api.data.GHReaction;
import org.jetbrains.plugins.github.api.data.GHReactionContent;
import org.jetbrains.plugins.github.pullrequest.data.GHReactionsService;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHReactionsServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHReactionsService;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "<init>", "(Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;)V", "addReaction", "Lorg/jetbrains/plugins/github/api/data/GHReaction;", "subjectId", "", "reaction", "Lorg/jetbrains/plugins/github/api/data/GHReactionContent;", "(Ljava/lang/String;Lorg/jetbrains/plugins/github/api/data/GHReactionContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeReaction", "intellij.vcs.github"})
public final class GHReactionsServiceImpl
implements GHReactionsService {
    @NotNull
    private final GithubApiRequestExecutor requestExecutor;
    @NotNull
    private final GHRepositoryCoordinates repository;

    public GHReactionsServiceImpl(@NotNull GithubApiRequestExecutor requestExecutor, @NotNull GHRepositoryCoordinates repository) {
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.requestExecutor = requestExecutor;
        this.repository = repository;
    }

    @Override
    @Nullable
    public Object addReaction(@NotNull String subjectId, @NotNull GHReactionContent reaction, @NotNull Continuation<? super GHReaction> $completion) {
        GithubApiRequest.Post.GQLQuery<GHReaction> request2 = GHGQLRequests.Comment.INSTANCE.addReaction(this.repository.getServerPath(), subjectId, reaction);
        return GithubApiRequestExecutorKt.executeSuspend(this.requestExecutor, (GithubApiRequest)request2, $completion);
    }

    @Override
    @Nullable
    public Object removeReaction(@NotNull String subjectId, @NotNull GHReactionContent reaction, @NotNull Continuation<? super GHReaction> $completion) {
        GithubApiRequest.Post.GQLQuery<GHReaction> request2 = GHGQLRequests.Comment.INSTANCE.removeReaction(this.repository.getServerPath(), subjectId, reaction);
        return GithubApiRequestExecutorKt.executeSuspend(this.requestExecutor, (GithubApiRequest)request2, $completion);
    }
}

