/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n25#3:393\n25#3:394\n25#3:395\n25#3:396\n25#3:397\n25#3:398\n25#3:399\n25#3:400\n25#3:401\n25#3:402\n25#3:403\n25#3:404\n25#3:405\n25#3:406\n25#3:407\n25#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 54079756967310L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1823707980 + (char)-20823, -1823707980 + -((char)-22078), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1823707980 + (char)-20824, -1823707980 + -31362, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 132015804826620L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.l();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1394978010 + (char)-3413, -1395109080 - -((char)-15399), (int)l2) + string + WindowsNamedPipeAgentIpc.b(1394978010 + (char)-3414, -1395109080 - -((char)-9362), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1394978010 + (char)-3415, -1394978010 + -((char)-2554), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l2;
                    block15: {
                        block16: {
                            l2 = 9820179577538L;
                            Object object = this.lock;
                            bl2 = SshAgentIpcService.l();
                            synchronized (object) {
                                boolean bl3;
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(1884393390 - (char)-22286, 1884393390 - (char)-21193, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1884393390 - (char)-22289, -1884393390 - -((char)-2663), (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    windowsNamedPipeAgentIpc = this;
                                    if (bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1884393390 - (char)-22288, 1884393390 - (char)-2654, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1884393390 - (char)-22275, 1884262320 + (char)-1225, (int)l2) + ErrorToolsKt.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1884393390 - (char)-22274, -1884393390 - -((char)-12401), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1884393390 - (char)-22288, 1884393390 - (char)-2654, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1884393390 - (char)-22277, -1884393390 - -((char)-2454), (int)l2));
                            if (ActionTimestamp.J() == null) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.J(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l2 = 75227255060347L;
                    bl = SshAgentIpcService.J();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (!bl) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (!bl) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        boolean bl;
        long l2;
        block27: {
            block28: {
                l2 = 78331442945712L;
                boolean bl2 = SshAgentIpcService.l();
                this.assertConnectionThread();
                bl = bl2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl4 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (bl) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-170653140 - -30868, 170653140 - (char)-25729, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-170653140 - -30880, -170653140 - -((char)-2990), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-170653140 - -30875, -170653140 - -((char)-23567), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-170653140 - -30880, -170653140 - -((char)-2990), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-170653140 - -30874, -170653140 - -((char)-7685), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-170653140 - -30868, 170653140 - (char)-25729, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-170653140 - -30880, -170653140 - -((char)-2990), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-170653140 - -30873, -170653140 - -((char)-27573), (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (bl) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl8 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-170653140 - -30868, 170653140 - (char)-25729, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-170653140 - -30880, -170653140 - -((char)-2990), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-170653140 - -30872, -170653140 - -((char)-28875), (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-170653140 - -30880, -170653140 - -((char)-2990), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-170653140 - -30895, 170653140 - (char)-23657, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl9;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl10 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (bl) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl9 = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl9) {
                boolean bl11 = false;
                String string = WindowsNamedPipeAgentIpc.b(-170653140 - -30880, -170653140 - -((char)-2990), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-170653140 - -30874, -170653140 - -((char)-7685), (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl12 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-170653140 - -30868, 170653140 - (char)-25729, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-170653140 - -30880, -170653140 - -((char)-2990), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-170653140 - -30894, 170653140 - (char)-6344, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 47044350024413L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1573233210 + 17910, 1573233210 - 4535, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 36526197449467L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1795527930 + (char)-17635, -1795527930 + -((char)-15712), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "I\u00ef\u00e4Q\u0093\u008ag\u00eb\n\u00ea&:) \u00f0\u0084\u0004y\u00ba\u0014+L\u00a8#\u0001\u0006H\u00ffmn\u000f~\u00ceQ\u00cd!N\u000b\u00f4\u0013";
                        var4_3 = "I\u00ef\u00e4Q\u0093\u008ag\u00eb\n\u00ea&:) \u00f0\u0084\u0004y\u00ba\u0014+L\u00a8#\u0001\u0006H\u00ffmn\u000f~\u00ceQ\u00cd!N\u000b\u00f4\u0013".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 54;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 5;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 124;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 73;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 83;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 33;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 42;
                                        break;
                                    }
                                    default: {
                                        v11 = 23;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x72ED) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 21;
                            case 1 -> 191;
                            case 2 -> 69;
                            case 3 -> 101;
                            case 4 -> 173;
                            case 5 -> 172;
                            case 6 -> 26;
                            case 7 -> 147;
                            case 8 -> 88;
                            case 9 -> 12;
                            case 10 -> 111;
                            case 11 -> 211;
                            case 12 -> 251;
                            case 13 -> 163;
                            case 14 -> 95;
                            case 15 -> 200;
                            case 16 -> 30;
                            case 17 -> 161;
                            case 18 -> 47;
                            case 19 -> 77;
                            case 20 -> 254;
                            case 21 -> 46;
                            case 22 -> 87;
                            case 23 -> 215;
                            case 24 -> 39;
                            case 25 -> 11;
                            case 26 -> 36;
                            case 27 -> 58;
                            case 28 -> 169;
                            case 29 -> 128;
                            case 30 -> 240;
                            case 31 -> 155;
                            case 32 -> 84;
                            case 33 -> 78;
                            case 34 -> 171;
                            case 35 -> 114;
                            case 36 -> 55;
                            case 37 -> 118;
                            case 38 -> 41;
                            case 39 -> 125;
                            case 40 -> 98;
                            case 41 -> 197;
                            case 42 -> 239;
                            case 43 -> 29;
                            case 44 -> 45;
                            case 45 -> 186;
                            case 46 -> 248;
                            case 47 -> 110;
                            case 48 -> 51;
                            case 49 -> 136;
                            case 50 -> 94;
                            case 51 -> 183;
                            case 52 -> 137;
                            case 53 -> 109;
                            case 54 -> 15;
                            case 55 -> 141;
                            case 56 -> 230;
                            case 57 -> 71;
                            case 58 -> 90;
                            case 59 -> 96;
                            case 60 -> 207;
                            case 61 -> 202;
                            case 62 -> 3;
                            case 63 -> 64;
                            case 64 -> 231;
                            case 65 -> 124;
                            case 66 -> 123;
                            case 67 -> 19;
                            case 68 -> 185;
                            case 69 -> 218;
                            case 70 -> 157;
                            case 71 -> 42;
                            case 72 -> 31;
                            case 73 -> 156;
                            case 74 -> 205;
                            case 75 -> 192;
                            case 76 -> 223;
                            case 77 -> 25;
                            case 78 -> 27;
                            case 79 -> 203;
                            case 80 -> 244;
                            case 81 -> 170;
                            case 82 -> 247;
                            case 83 -> 17;
                            case 84 -> 149;
                            case 85 -> 165;
                            case 86 -> 201;
                            case 87 -> 175;
                            case 88 -> 178;
                            case 89 -> 190;
                            case 90 -> 138;
                            case 91 -> 62;
                            case 92 -> 105;
                            case 93 -> 126;
                            case 94 -> 2;
                            case 95 -> 75;
                            case 96 -> 113;
                            case 97 -> 214;
                            case 98 -> 189;
                            case 99 -> 188;
                            case 100 -> 216;
                            case 101 -> 108;
                            case 102 -> 166;
                            case 103 -> 210;
                            case 104 -> 91;
                            case 105 -> 135;
                            case 106 -> 206;
                            case 107 -> 60;
                            case 108 -> 79;
                            case 109 -> 20;
                            case 110 -> 9;
                            case 111 -> 237;
                            case 112 -> 112;
                            case 113 -> 32;
                            case 114 -> 143;
                            case 115 -> 122;
                            case 116 -> 208;
                            case 117 -> 72;
                            case 118 -> 117;
                            case 119 -> 7;
                            case 120 -> 225;
                            case 121 -> 154;
                            case 122 -> 74;
                            case 123 -> 100;
                            case 124 -> 82;
                            case 125 -> 177;
                            case 126 -> 213;
                            case 127 -> 67;
                            case 128 -> 65;
                            case 129 -> 187;
                            case 130 -> 217;
                            case 131 -> 209;
                            case 132 -> 43;
                            case 133 -> 246;
                            case 134 -> 229;
                            case 135 -> 59;
                            case 136 -> 106;
                            case 137 -> 18;
                            case 138 -> 99;
                            case 139 -> 76;
                            case 140 -> 146;
                            case 141 -> 252;
                            case 142 -> 199;
                            case 143 -> 194;
                            case 144 -> 198;
                            case 145 -> 250;
                            case 146 -> 236;
                            case 147 -> 182;
                            case 148 -> 180;
                            case 149 -> 184;
                            case 150 -> 28;
                            case 151 -> 242;
                            case 152 -> 48;
                            case 153 -> 66;
                            case 154 -> 253;
                            case 155 -> 102;
                            case 156 -> 151;
                            case 157 -> 37;
                            case 158 -> 127;
                            case 159 -> 150;
                            case 160 -> 158;
                            case 161 -> 119;
                            case 162 -> 221;
                            case 163 -> 129;
                            case 164 -> 35;
                            case 165 -> 219;
                            case 166 -> 107;
                            case 167 -> 232;
                            case 168 -> 52;
                            case 169 -> 226;
                            case 170 -> 70;
                            case 171 -> 243;
                            case 172 -> 181;
                            case 173 -> 235;
                            case 174 -> 179;
                            case 175 -> 238;
                            case 176 -> 255;
                            case 177 -> 131;
                            case 178 -> 120;
                            case 179 -> 196;
                            case 180 -> 57;
                            case 181 -> 121;
                            case 182 -> 167;
                            case 183 -> 5;
                            case 184 -> 86;
                            case 185 -> 97;
                            case 186 -> 139;
                            case 187 -> 204;
                            case 188 -> 144;
                            case 189 -> 241;
                            case 190 -> 130;
                            case 191 -> 212;
                            case 192 -> 49;
                            case 193 -> 4;
                            case 194 -> 81;
                            case 195 -> 227;
                            case 196 -> 228;
                            case 197 -> 93;
                            case 198 -> 61;
                            case 199 -> 224;
                            case 200 -> 38;
                            case 201 -> 222;
                            case 202 -> 162;
                            case 203 -> 53;
                            case 204 -> 1;
                            case 205 -> 44;
                            case 206 -> 193;
                            case 207 -> 92;
                            case 208 -> 134;
                            case 209 -> 16;
                            case 210 -> 50;
                            case 211 -> 220;
                            case 212 -> 6;
                            case 213 -> 195;
                            case 214 -> 234;
                            case 215 -> 68;
                            case 216 -> 73;
                            case 217 -> 104;
                            case 218 -> 140;
                            case 219 -> 89;
                            case 220 -> 153;
                            case 221 -> 85;
                            case 222 -> 33;
                            case 223 -> 56;
                            case 224 -> 63;
                            case 225 -> 164;
                            case 226 -> 14;
                            case 227 -> 142;
                            case 228 -> 0;
                            case 229 -> 24;
                            case 230 -> 159;
                            case 231 -> 34;
                            case 232 -> 40;
                            case 233 -> 168;
                            case 234 -> 54;
                            case 235 -> 133;
                            case 236 -> 132;
                            case 237 -> 148;
                            case 238 -> 8;
                            case 239 -> 103;
                            case 240 -> 83;
                            case 241 -> 22;
                            case 242 -> 116;
                            case 243 -> 176;
                            case 244 -> 233;
                            case 245 -> 160;
                            case 246 -> 249;
                            case 247 -> 174;
                            case 248 -> 10;
                            case 249 -> 145;
                            case 250 -> 23;
                            case 251 -> 13;
                            case 252 -> 115;
                            case 253 -> 152;
                            case 254 -> 245;
                            default -> 80;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (bl) {
                ActionTimestamp.J("Igb66b");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 4507070657290L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.J();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (!bl2) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1649909160 + (char)-28206, -1649909160 + -27241, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1649909160 + (char)-28210, 1649909160 + (char)-18916, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1649909160 + (char)-28229, -1649909160 + -((char)-16049), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1649909160 + (char)-28206, -1649909160 + -27241, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1649909160 + (char)-28210, 1649909160 + (char)-18916, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1649909160 + (char)-28230, 1649909160 + (char)-22078, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l2 = 125957969147355L;
                        boolean bl3 = SshAgentIpcService.J();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-536731650 + -30282, 536731650 + 9056, (int)l2));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (!bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (!bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-536731650 + -30281, 536731650 + (char)-28507, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (!bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l2;
        block25: {
            block26: {
                l2 = 25891562596869L;
                boolean bl2 = SshAgentIpcService.l();
                this.assertConnectionThread();
                bl = bl2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl4 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1499702940 + (char)-12327, -1499702940 + -((char)-21884), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1499702940 + (char)-12323, 1499702940 + 25647, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1499702940 + (char)-12340, -1499702940 + -((char)-23292), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1499702940 + (char)-12323, 1499702940 + 25647, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1499702940 + (char)-12329, 1499702940 + 29174, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1499702940 + (char)-12327, -1499702940 + -((char)-21884), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1499702940 + (char)-12323, 1499702940 + 25647, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1499702940 + (char)-12339, 1499702940 + (char)-15716, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl7 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1499702940 + (char)-12327, -1499702940 + -((char)-21884), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1499702940 + (char)-12323, 1499702940 + 25647, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1499702940 + (char)-12342, 1499702940 + (char)-32706, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl8 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl9 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1499702940 + (char)-12327, -1499702940 + -((char)-21884), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1499702940 + (char)-12323, 1499702940 + 25647, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1499702940 + (char)-12341, 1499702940 + 31475, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                boolean bl2;
                block16: {
                    l2 = 115104571677859L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                bl2 = SshAgentIpcService.l();
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-551935770 - -((char)-8211), 551804700 + (char)-1750, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-551935770 - -((char)-8199), -551804700 + -((char)-23433), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-551935770 - -((char)-8228), 551935770 - (char)-3904, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-551935770 - -((char)-8227), -551804700 + -((char)-21354), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-551935770 - -((char)-8211), 551804700 + (char)-1750, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-551935770 - -((char)-8199), -551804700 + -((char)-23433), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-551935770 - -((char)-8226), 551804700 + (char)-14716, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (bl2) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-551935770 - -((char)-8211), 551804700 + (char)-1750, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-551935770 - -((char)-8199), -551804700 + -((char)-23433), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-551935770 - -((char)-8225), 551804700 + (char)-20508, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-551935770 - -((char)-8211), 551804700 + (char)-1750, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-551935770 - -((char)-8199), -551804700 + -((char)-23433), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-551935770 - -((char)-8224), -551804700 + -((char)-3853), (int)l2));
                    if (bl2) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-551935770 - -((char)-8211), 551804700 + (char)-1750, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-551935770 - -((char)-8199), -551804700 + -((char)-23433), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-551935770 - -((char)-8223), 551804700 + (char)-20228, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\t\u00edP\u00e7i\u009f\u00fe\u00e5\u0014W\u0007\u00a3]\u00e9@A\u0004\u0083\n\u0004!\u0080P\u00b9\u009e\u00bdx\u00c6D\u0006\\\u00b6\u00fa\u008cV\u00b3\u0018\u008e~\u00f8B\u0000f~\u0000\u00ac\u00f7\u00ee\u00ee\u00bbV\u008c\u00dc\u00b2Y\t\u00fda\u00e6\u009dW\t\u00ca\u009e\u00ee\u00ef\u00a9LS\r5\u0005#C\u00152\u00b1\b\u00e0\u0096m\u00f9\u009czF\u00bb\u0005-\u0080\u00d4J\u0089\u001e\u0007\u0010\u0084<\u001em\u001f\u001b%\u0080\u0094\u0087\u00b8[N\u0019\u000bp\u00ec,q\u00f3\u00938Q\u00c2~\u00f6\u00b2N\u0010\u00fcF\u001f3:\u00bem\u0098\u0016B\u007f\"\u00c3\u00ba\u008e\u00ba\t\u00df=\u009a\u008at\u00c7\u00ce\u00e3h\u0010\u00f5\f>z\u001e\u0097\u00e9\u00bd\u0086\u00e6m\u00b6\u0081(\u00c6\u00e8?\u00d1\u0092VlInp\u0017\u00b9\u00d0Bv\u00dd\u0093\u00df9\u00fc\u0011o\u00c5\u008f\u009c7\u00b3\u00d5[\u00e3q6\u00e8>0(\u0092\u00b0\u0001\u00ab\u00b4}\u00f8\u00ebI\u0084C\u008e0P\u001aU\u00eb\u00c2,I\u00b7_[\u0002\u00dco\u009c.p\u00ff\b\u001c\u00b9\u00f2\u001co\u00c68,\f\u0097\u001e\u0093\u00f3^Y\u00f0\u00d8\u008c\u0002~.F9\u00afF\u00c5\u00e4\u009f\u00a7\u0000f\u0015)\b&T\u00bf\u00e7\f\u00adq\u00fd^\u00c9\u000e+\u00c4c2}\u00b3@\u00b4\u0019E\u0001\u00dfR\u009c\u00930\u00d8\u00d1XH\u009a\u00c9\u008e\u00ec\u00b0%F\u00aa3\u00ab\u00c2\u0015\u00ee\u00d4\u001e#x\u0094\u0085\u00f4i\u0099\u00f6\u00d1\u0012\u00db\u009e\u001f\u00d4\u00d5\u00fe\u0084Qz\u00f6\u00f9\u0018\u00dc3\fL7\u00db%\u00c2\u001f\u00a8\u000b2\u0097,\u001f\u00c7\u00f6\u00bb\u00bc\u0017\u00f6\"\u000b\u008b/\u0010\u00d5.\u009d\u00fe@M\u001dL\u0015\u009bh\u0012>i\u0088\u00fa\u009f\u00f3\u0006S\u009c\u00fe\u0089\u0090\u00a4P\u00bb'\u00e6\u00f5)l0\u00e98\u00b3\u00ed\u00aa\u000b\u0093\u0082B\u00c7fD\u0000N\u00e6\u00fa\u00f7\u0010)\u008c\u0089d\u001c\u00d0\u0017\u0000\u00ad\u0095\u00f7\u009d\u00d34ky\u0014\u00eb\u00aa~!\u0007Z\r%\u0085\u000e\u0007\u0086\u0007\u00fd\u009c\u00b5\u00db\u00fb#.(\u00a9\u00b3\u001di\u009d\u00ad\u0099$\u0085\u00b0\u00aa\u00b7X\u00cb\u0085<Q\u0019\u00af/CU\u00ab\u0094\u00c8r;/\u001f\u0010z4\u0099j\u00bc\u001fTZ1\u00bb\u000f\u00bb\u00b1\u0011\u0000\u00f4\u00ec\u0011\u00cf\u00e1@\u0087\u00f8]v\u00bb\"u\u00a0\u00ca*\u00d7\u00af&C\u0002\u008bp\u00e6#l\u00cc\u0085\u0094\u00aa3X[\u0085g\u0015R\u00aa\u0013\u0091\t\u0095\u00c1\u009a;'\u000e\u00d2U<\u009cQ\u007f\u00a5\u00bdw\u000eU1\u000bE\u001b\u00e8\u0093|A\u00a2qN ]:\u009d\u00b6B\u0083\u00c6n}}\u00b3>p}q\u00ac\u00db\u00f0w\n\u00e4?9\u00d3\u001e\u00c7\n\u00dc~\u00c7\u0018\u009b\u0081\u0012\u000en$\u00f6\u00d4Tm~\u00c3\u0087~\u0082\u00f0\u0082\u00af\u009b\u001d\rR\u0085\u001a)\u009c\u00cc\u00f7\u00a7p\u001e\u00d2u\u009cM\u00a3>^r\u0098\u00f3\u008b8\u0085\u008d]/N\u001c\u0091M;_{\"\u0096\u00fa\u00da\u0006\u009f\u00abT\u0095\u00a2\u00b1 ";
                var4_3 = "\t\u00edP\u00e7i\u009f\u00fe\u00e5\u0014W\u0007\u00a3]\u00e9@A\u0004\u0083\n\u0004!\u0080P\u00b9\u009e\u00bdx\u00c6D\u0006\\\u00b6\u00fa\u008cV\u00b3\u0018\u008e~\u00f8B\u0000f~\u0000\u00ac\u00f7\u00ee\u00ee\u00bbV\u008c\u00dc\u00b2Y\t\u00fda\u00e6\u009dW\t\u00ca\u009e\u00ee\u00ef\u00a9LS\r5\u0005#C\u00152\u00b1\b\u00e0\u0096m\u00f9\u009czF\u00bb\u0005-\u0080\u00d4J\u0089\u001e\u0007\u0010\u0084<\u001em\u001f\u001b%\u0080\u0094\u0087\u00b8[N\u0019\u000bp\u00ec,q\u00f3\u00938Q\u00c2~\u00f6\u00b2N\u0010\u00fcF\u001f3:\u00bem\u0098\u0016B\u007f\"\u00c3\u00ba\u008e\u00ba\t\u00df=\u009a\u008at\u00c7\u00ce\u00e3h\u0010\u00f5\f>z\u001e\u0097\u00e9\u00bd\u0086\u00e6m\u00b6\u0081(\u00c6\u00e8?\u00d1\u0092VlInp\u0017\u00b9\u00d0Bv\u00dd\u0093\u00df9\u00fc\u0011o\u00c5\u008f\u009c7\u00b3\u00d5[\u00e3q6\u00e8>0(\u0092\u00b0\u0001\u00ab\u00b4}\u00f8\u00ebI\u0084C\u008e0P\u001aU\u00eb\u00c2,I\u00b7_[\u0002\u00dco\u009c.p\u00ff\b\u001c\u00b9\u00f2\u001co\u00c68,\f\u0097\u001e\u0093\u00f3^Y\u00f0\u00d8\u008c\u0002~.F9\u00afF\u00c5\u00e4\u009f\u00a7\u0000f\u0015)\b&T\u00bf\u00e7\f\u00adq\u00fd^\u00c9\u000e+\u00c4c2}\u00b3@\u00b4\u0019E\u0001\u00dfR\u009c\u00930\u00d8\u00d1XH\u009a\u00c9\u008e\u00ec\u00b0%F\u00aa3\u00ab\u00c2\u0015\u00ee\u00d4\u001e#x\u0094\u0085\u00f4i\u0099\u00f6\u00d1\u0012\u00db\u009e\u001f\u00d4\u00d5\u00fe\u0084Qz\u00f6\u00f9\u0018\u00dc3\fL7\u00db%\u00c2\u001f\u00a8\u000b2\u0097,\u001f\u00c7\u00f6\u00bb\u00bc\u0017\u00f6\"\u000b\u008b/\u0010\u00d5.\u009d\u00fe@M\u001dL\u0015\u009bh\u0012>i\u0088\u00fa\u009f\u00f3\u0006S\u009c\u00fe\u0089\u0090\u00a4P\u00bb'\u00e6\u00f5)l0\u00e98\u00b3\u00ed\u00aa\u000b\u0093\u0082B\u00c7fD\u0000N\u00e6\u00fa\u00f7\u0010)\u008c\u0089d\u001c\u00d0\u0017\u0000\u00ad\u0095\u00f7\u009d\u00d34ky\u0014\u00eb\u00aa~!\u0007Z\r%\u0085\u000e\u0007\u0086\u0007\u00fd\u009c\u00b5\u00db\u00fb#.(\u00a9\u00b3\u001di\u009d\u00ad\u0099$\u0085\u00b0\u00aa\u00b7X\u00cb\u0085<Q\u0019\u00af/CU\u00ab\u0094\u00c8r;/\u001f\u0010z4\u0099j\u00bc\u001fTZ1\u00bb\u000f\u00bb\u00b1\u0011\u0000\u00f4\u00ec\u0011\u00cf\u00e1@\u0087\u00f8]v\u00bb\"u\u00a0\u00ca*\u00d7\u00af&C\u0002\u008bp\u00e6#l\u00cc\u0085\u0094\u00aa3X[\u0085g\u0015R\u00aa\u0013\u0091\t\u0095\u00c1\u009a;'\u000e\u00d2U<\u009cQ\u007f\u00a5\u00bdw\u000eU1\u000bE\u001b\u00e8\u0093|A\u00a2qN ]:\u009d\u00b6B\u0083\u00c6n}}\u00b3>p}q\u00ac\u00db\u00f0w\n\u00e4?9\u00d3\u001e\u00c7\n\u00dc~\u00c7\u0018\u009b\u0081\u0012\u000en$\u00f6\u00d4Tm~\u00c3\u0087~\u0082\u00f0\u0082\u00af\u009b\u001d\rR\u0085\u001a)\u009c\u00cc\u00f7\u00a7p\u001e\u00d2u\u009cM\u00a3>^r\u0098\u00f3\u008b8\u0085\u008d]/N\u001c\u0091M;_{\"\u0096\u00fa\u00da\u0006\u009f\u00abT\u0095\u00a2\u00b1 ".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 18;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "C \u001d#\u009a)Qq2\u001dE:\u00d8m\u0081S\u00f8\u00c8\u00cd\u00ee\u009d^\u008dj\u00f6\u00e4R\u00c2\u00faB\u00f3\u00fd|\u008chW\u0081M\u00a8";
                    var4_3 = "C \u001d#\u009a)Qq2\u001dE:\u00d8m\u0081S\u00f8\u00c8\u00cd\u00ee\u009d^\u008dj\u00f6\u00e4R\u00c2\u00faB\u00f3\u00fd|\u008chW\u0081M\u00a8".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 105;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 33;
                            break;
                        }
                        case 1: {
                            v15 = 59;
                            break;
                        }
                        case 2: {
                            v15 = 11;
                            break;
                        }
                        case 3: {
                            v15 = 76;
                            break;
                        }
                        case 4: {
                            v15 = 124;
                            break;
                        }
                        case 5: {
                            v15 = 18;
                            break;
                        }
                        default: {
                            v15 = 34;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x5C7B) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 156;
                case 1 -> 106;
                case 2 -> 198;
                case 3 -> 117;
                case 4 -> 9;
                case 5 -> 134;
                case 6 -> 90;
                case 7 -> 102;
                case 8 -> 225;
                case 9 -> 63;
                case 10 -> 161;
                case 11 -> 33;
                case 12 -> 252;
                case 13 -> 132;
                case 14 -> 92;
                case 15 -> 115;
                case 16 -> 85;
                case 17 -> 93;
                case 18 -> 5;
                case 19 -> 174;
                case 20 -> 127;
                case 21 -> 159;
                case 22 -> 182;
                case 23 -> 48;
                case 24 -> 128;
                case 25 -> 235;
                case 26 -> 8;
                case 27 -> 186;
                case 28 -> 39;
                case 29 -> 173;
                case 30 -> 96;
                case 31 -> 233;
                case 32 -> 202;
                case 33 -> 28;
                case 34 -> 211;
                case 35 -> 237;
                case 36 -> 187;
                case 37 -> 155;
                case 38 -> 100;
                case 39 -> 193;
                case 40 -> 2;
                case 41 -> 89;
                case 42 -> 77;
                case 43 -> 250;
                case 44 -> 236;
                case 45 -> 65;
                case 46 -> 133;
                case 47 -> 130;
                case 48 -> 72;
                case 49 -> 59;
                case 50 -> 180;
                case 51 -> 16;
                case 52 -> 23;
                case 53 -> 131;
                case 54 -> 51;
                case 55 -> 78;
                case 56 -> 46;
                case 57 -> 86;
                case 58 -> 50;
                case 59 -> 67;
                case 60 -> 87;
                case 61 -> 55;
                case 62 -> 197;
                case 63 -> 30;
                case 64 -> 13;
                case 65 -> 217;
                case 66 -> 138;
                case 67 -> 232;
                case 68 -> 95;
                case 69 -> 177;
                case 70 -> 99;
                case 71 -> 22;
                case 72 -> 164;
                case 73 -> 224;
                case 74 -> 71;
                case 75 -> 54;
                case 76 -> 104;
                case 77 -> 172;
                case 78 -> 110;
                case 79 -> 157;
                case 80 -> 223;
                case 81 -> 98;
                case 82 -> 84;
                case 83 -> 185;
                case 84 -> 162;
                case 85 -> 154;
                case 86 -> 26;
                case 87 -> 11;
                case 88 -> 94;
                case 89 -> 135;
                case 90 -> 192;
                case 91 -> 215;
                case 92 -> 73;
                case 93 -> 183;
                case 94 -> 114;
                case 95 -> 251;
                case 96 -> 116;
                case 97 -> 62;
                case 98 -> 29;
                case 99 -> 145;
                case 100 -> 143;
                case 101 -> 221;
                case 102 -> 214;
                case 103 -> 178;
                case 104 -> 19;
                case 105 -> 160;
                case 106 -> 88;
                case 107 -> 149;
                case 108 -> 245;
                case 109 -> 60;
                case 110 -> 49;
                case 111 -> 222;
                case 112 -> 243;
                case 113 -> 166;
                case 114 -> 234;
                case 115 -> 141;
                case 116 -> 126;
                case 117 -> 212;
                case 118 -> 120;
                case 119 -> 144;
                case 120 -> 253;
                case 121 -> 12;
                case 122 -> 80;
                case 123 -> 208;
                case 124 -> 167;
                case 125 -> 146;
                case 126 -> 56;
                case 127 -> 195;
                case 128 -> 27;
                case 129 -> 227;
                case 130 -> 203;
                case 131 -> 32;
                case 132 -> 119;
                case 133 -> 101;
                case 134 -> 254;
                case 135 -> 229;
                case 136 -> 139;
                case 137 -> 118;
                case 138 -> 52;
                case 139 -> 45;
                case 140 -> 206;
                case 141 -> 20;
                case 142 -> 6;
                case 143 -> 74;
                case 144 -> 42;
                case 145 -> 184;
                case 146 -> 4;
                case 147 -> 152;
                case 148 -> 25;
                case 149 -> 40;
                case 150 -> 38;
                case 151 -> 220;
                case 152 -> 218;
                case 153 -> 181;
                case 154 -> 171;
                case 155 -> 76;
                case 156 -> 163;
                case 157 -> 239;
                case 158 -> 97;
                case 159 -> 246;
                case 160 -> 209;
                case 161 -> 137;
                case 162 -> 151;
                case 163 -> 82;
                case 164 -> 41;
                case 165 -> 69;
                case 166 -> 18;
                case 167 -> 17;
                case 168 -> 113;
                case 169 -> 196;
                case 170 -> 53;
                case 171 -> 249;
                case 172 -> 194;
                case 173 -> 34;
                case 174 -> 91;
                case 175 -> 14;
                case 176 -> 121;
                case 177 -> 148;
                case 178 -> 43;
                case 179 -> 200;
                case 180 -> 199;
                case 181 -> 240;
                case 182 -> 153;
                case 183 -> 125;
                case 184 -> 170;
                case 185 -> 124;
                case 186 -> 188;
                case 187 -> 219;
                case 188 -> 107;
                case 189 -> 205;
                case 190 -> 140;
                case 191 -> 165;
                case 192 -> 238;
                case 193 -> 228;
                case 194 -> 21;
                case 195 -> 103;
                case 196 -> 190;
                case 197 -> 112;
                case 198 -> 68;
                case 199 -> 216;
                case 200 -> 75;
                case 201 -> 129;
                case 202 -> 255;
                case 203 -> 31;
                case 204 -> 109;
                case 205 -> 226;
                case 206 -> 191;
                case 207 -> 123;
                case 208 -> 61;
                case 209 -> 150;
                case 210 -> 36;
                case 211 -> 64;
                case 212 -> 1;
                case 213 -> 70;
                case 214 -> 10;
                case 215 -> 242;
                case 216 -> 81;
                case 217 -> 58;
                case 218 -> 230;
                case 219 -> 24;
                case 220 -> 105;
                case 221 -> 244;
                case 222 -> 35;
                case 223 -> 66;
                case 224 -> 201;
                case 225 -> 175;
                case 226 -> 213;
                case 227 -> 241;
                case 228 -> 189;
                case 229 -> 147;
                case 230 -> 207;
                case 231 -> 176;
                case 232 -> 169;
                case 233 -> 83;
                case 234 -> 204;
                case 235 -> 122;
                case 236 -> 168;
                case 237 -> 247;
                case 238 -> 179;
                case 239 -> 158;
                case 240 -> 3;
                case 241 -> 136;
                case 242 -> 248;
                case 243 -> 142;
                case 244 -> 108;
                case 245 -> 15;
                case 246 -> 0;
                case 247 -> 210;
                case 248 -> 57;
                case 249 -> 7;
                case 250 -> 79;
                case 251 -> 44;
                case 252 -> 47;
                case 253 -> 231;
                case 254 -> 111;
                default -> 37;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 83930101406883L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-2145484830 - -2479, 2145484830 - 32474, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l2 = 59102374209329L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.J();
                            try {
                                hANDLE2 = hANDLE;
                                if (!bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (!bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(670816260 - (char)-6654, 670816260 - (char)-622, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(670816260 - (char)-6653, 670816260 - (char)-9634, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(670816260 - (char)-6652, 670685190 + (char)-21370, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "F\u0084\t\u0096<\\\u0019\u00e4\u0010\u0001\u00f4\u00109\u00a5\u0012\u00d3t\u00cbo\u0098\u00f9\u00d2\u008c\u00d5v";
                    var4_3 = "F\u0084\t\u0096<\\\u0019\u00e4\u0010\u0001\u00f4\u00109\u00a5\u0012\u00d3t\u00cbo\u0098\u00f9\u00d2\u008c\u00d5v".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 36;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00b5\u00a2\u00d4\u00f1T5m \u00d8\u00cd\u0007\u0016<\u00fc\u00e2f\u008c\u00bb\u0004\u008d\u00a9\u007f?\u00ef]\u00c5;\u00c3\u00a4\u001f9\u00bc/I\u00e5v\u0086[\u001e\r\u009ciB\u0080\u00fb\u00c8\u00c5\u008e\f\u00fa\u00d9\u0013\u0095\u00a2\u00b7\u00d0$}/";
                        var4_3 = "\u00b5\u00a2\u00d4\u00f1T5m \u00d8\u00cd\u0007\u0016<\u00fc\u00e2f\u008c\u00bb\u0004\u008d\u00a9\u007f?\u00ef]\u00c5;\u00c3\u00a4\u001f9\u00bc/I\u00e5v\u0086[\u001e\r\u009ciB\u0080\u00fb\u00c8\u00c5\u008e\f\u00fa\u00d9\u0013\u0095\u00a2\u00b7\u00d0$}/".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 74;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 3;
                                break;
                            }
                            case 1: {
                                v15 = 78;
                                break;
                            }
                            case 2: {
                                v15 = 15;
                                break;
                            }
                            case 3: {
                                v15 = 78;
                                break;
                            }
                            case 4: {
                                v15 = 114;
                                break;
                            }
                            case 5: {
                                v15 = 79;
                                break;
                            }
                            default: {
                                v15 = 94;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFD532) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 24;
                    case 1 -> 70;
                    case 2 -> 41;
                    case 3 -> 217;
                    case 4 -> 161;
                    case 5 -> 12;
                    case 6 -> 108;
                    case 7 -> 99;
                    case 8 -> 49;
                    case 9 -> 238;
                    case 10 -> 144;
                    case 11 -> 81;
                    case 12 -> 193;
                    case 13 -> 26;
                    case 14 -> 47;
                    case 15 -> 118;
                    case 16 -> 160;
                    case 17 -> 89;
                    case 18 -> 50;
                    case 19 -> 237;
                    case 20 -> 137;
                    case 21 -> 157;
                    case 22 -> 101;
                    case 23 -> 140;
                    case 24 -> 240;
                    case 25 -> 252;
                    case 26 -> 239;
                    case 27 -> 4;
                    case 28 -> 66;
                    case 29 -> 33;
                    case 30 -> 46;
                    case 31 -> 176;
                    case 32 -> 200;
                    case 33 -> 122;
                    case 34 -> 27;
                    case 35 -> 14;
                    case 36 -> 159;
                    case 37 -> 22;
                    case 38 -> 2;
                    case 39 -> 3;
                    case 40 -> 61;
                    case 41 -> 109;
                    case 42 -> 221;
                    case 43 -> 68;
                    case 44 -> 171;
                    case 45 -> 112;
                    case 46 -> 20;
                    case 47 -> 136;
                    case 48 -> 17;
                    case 49 -> 226;
                    case 50 -> 170;
                    case 51 -> 119;
                    case 52 -> 8;
                    case 53 -> 54;
                    case 54 -> 253;
                    case 55 -> 76;
                    case 56 -> 166;
                    case 57 -> 168;
                    case 58 -> 55;
                    case 59 -> 69;
                    case 60 -> 34;
                    case 61 -> 114;
                    case 62 -> 134;
                    case 63 -> 131;
                    case 64 -> 19;
                    case 65 -> 181;
                    case 66 -> 163;
                    case 67 -> 177;
                    case 68 -> 142;
                    case 69 -> 73;
                    case 70 -> 225;
                    case 71 -> 210;
                    case 72 -> 45;
                    case 73 -> 151;
                    case 74 -> 105;
                    case 75 -> 90;
                    case 76 -> 77;
                    case 77 -> 215;
                    case 78 -> 126;
                    case 79 -> 247;
                    case 80 -> 104;
                    case 81 -> 0;
                    case 82 -> 219;
                    case 83 -> 74;
                    case 84 -> 116;
                    case 85 -> 155;
                    case 86 -> 98;
                    case 87 -> 194;
                    case 88 -> 158;
                    case 89 -> 182;
                    case 90 -> 71;
                    case 91 -> 233;
                    case 92 -> 124;
                    case 93 -> 37;
                    case 94 -> 44;
                    case 95 -> 185;
                    case 96 -> 154;
                    case 97 -> 214;
                    case 98 -> 172;
                    case 99 -> 208;
                    case 100 -> 53;
                    case 101 -> 204;
                    case 102 -> 57;
                    case 103 -> 244;
                    case 104 -> 149;
                    case 105 -> 206;
                    case 106 -> 48;
                    case 107 -> 139;
                    case 108 -> 58;
                    case 109 -> 67;
                    case 110 -> 59;
                    case 111 -> 184;
                    case 112 -> 36;
                    case 113 -> 87;
                    case 114 -> 6;
                    case 115 -> 97;
                    case 116 -> 32;
                    case 117 -> 164;
                    case 118 -> 93;
                    case 119 -> 179;
                    case 120 -> 138;
                    case 121 -> 10;
                    case 122 -> 31;
                    case 123 -> 232;
                    case 124 -> 230;
                    case 125 -> 234;
                    case 126 -> 5;
                    case 127 -> 241;
                    case 128 -> 143;
                    case 129 -> 21;
                    case 130 -> 251;
                    case 131 -> 249;
                    case 132 -> 39;
                    case 133 -> 162;
                    case 134 -> 150;
                    case 135 -> 203;
                    case 136 -> 153;
                    case 137 -> 94;
                    case 138 -> 178;
                    case 139 -> 65;
                    case 140 -> 231;
                    case 141 -> 123;
                    case 142 -> 96;
                    case 143 -> 7;
                    case 144 -> 236;
                    case 145 -> 250;
                    case 146 -> 113;
                    case 147 -> 92;
                    case 148 -> 187;
                    case 149 -> 148;
                    case 150 -> 220;
                    case 151 -> 216;
                    case 152 -> 86;
                    case 153 -> 84;
                    case 154 -> 229;
                    case 155 -> 248;
                    case 156 -> 75;
                    case 157 -> 130;
                    case 158 -> 255;
                    case 159 -> 133;
                    case 160 -> 60;
                    case 161 -> 165;
                    case 162 -> 82;
                    case 163 -> 135;
                    case 164 -> 13;
                    case 165 -> 246;
                    case 166 -> 211;
                    case 167 -> 147;
                    case 168 -> 242;
                    case 169 -> 103;
                    case 170 -> 218;
                    case 171 -> 18;
                    case 172 -> 40;
                    case 173 -> 80;
                    case 174 -> 190;
                    case 175 -> 102;
                    case 176 -> 192;
                    case 177 -> 79;
                    case 178 -> 111;
                    case 179 -> 152;
                    case 180 -> 198;
                    case 181 -> 207;
                    case 182 -> 35;
                    case 183 -> 72;
                    case 184 -> 9;
                    case 185 -> 25;
                    case 186 -> 78;
                    case 187 -> 222;
                    case 188 -> 128;
                    case 189 -> 121;
                    case 190 -> 202;
                    case 191 -> 83;
                    case 192 -> 195;
                    case 193 -> 42;
                    case 194 -> 254;
                    case 195 -> 56;
                    case 196 -> 125;
                    case 197 -> 91;
                    case 198 -> 167;
                    case 199 -> 23;
                    case 200 -> 95;
                    case 201 -> 199;
                    case 202 -> 117;
                    case 203 -> 186;
                    case 204 -> 212;
                    case 205 -> 188;
                    case 206 -> 227;
                    case 207 -> 51;
                    case 208 -> 174;
                    case 209 -> 100;
                    case 210 -> 62;
                    case 211 -> 110;
                    case 212 -> 15;
                    case 213 -> 169;
                    case 214 -> 196;
                    case 215 -> 209;
                    case 216 -> 115;
                    case 217 -> 145;
                    case 218 -> 228;
                    case 219 -> 28;
                    case 220 -> 38;
                    case 221 -> 52;
                    case 222 -> 189;
                    case 223 -> 205;
                    case 224 -> 64;
                    case 225 -> 129;
                    case 226 -> 1;
                    case 227 -> 180;
                    case 228 -> 120;
                    case 229 -> 141;
                    case 230 -> 127;
                    case 231 -> 29;
                    case 232 -> 63;
                    case 233 -> 43;
                    case 234 -> 106;
                    case 235 -> 183;
                    case 236 -> 235;
                    case 237 -> 107;
                    case 238 -> 173;
                    case 239 -> 201;
                    case 240 -> 88;
                    case 241 -> 156;
                    case 242 -> 223;
                    case 243 -> 16;
                    case 244 -> 245;
                    case 245 -> 191;
                    case 246 -> 213;
                    case 247 -> 243;
                    case 248 -> 146;
                    case 249 -> 224;
                    case 250 -> 175;
                    case 251 -> 30;
                    case 252 -> 11;
                    case 253 -> 132;
                    case 254 -> 85;
                    default -> 197;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 36156222772811L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u0015Rx*HpiL\t\u0012Xk \u00052tP\u001e";
                    var5_4 = "\u0015Rx*HpiL\t\u0012Xk \u00052tP\u001e".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 58;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 68;
                                    break;
                                }
                                case 1: {
                                    v11 = 13;
                                    break;
                                }
                                case 2: {
                                    v11 = 48;
                                    break;
                                }
                                case 3: {
                                    v11 = 126;
                                    break;
                                }
                                case 4: {
                                    v11 = 23;
                                    break;
                                }
                                case 5: {
                                    v11 = 38;
                                    break;
                                }
                                default: {
                                    v11 = 96;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 84492954030694L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u001a/\u0014\rE\u0001^\u0004\u001c1\u0018\u0017\n\u0010.\u0013\u0017I\u0003F:/\u001a\t\u0010.\u0013\u0017I\u0003F6%\r\u0017(\u000e\u001aC\u000e\\6\"\t\u0010B\u0007";
                    var5_4 = "\u001a/\u0014\rE\u0001^\u0004\u001c1\u0018\u0017\n\u0010.\u0013\u0017I\u0003F:/\u001a\t\u0010.\u0013\u0017I\u0003F6%\r\u0017(\u000e\u001aC\u000e\\6\"\t\u0010B\u0007".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 29;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "QlSK\u0004O\u0014\u0006QlSK\bE";
                        var5_4 = "QlSK\u0004O\u0014\u0006QlSK\bE".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 92;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 78;
                                break;
                            }
                            case 1: {
                                v15 = 92;
                                break;
                            }
                            case 2: {
                                v15 = 96;
                                break;
                            }
                            case 3: {
                                v15 = 100;
                                break;
                            }
                            case 4: {
                                v15 = 49;
                                break;
                            }
                            case 5: {
                                v15 = 125;
                                break;
                            }
                            default: {
                                v15 = 47;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n25#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 54999713808009L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1637457510 - -((char)-4770), 1637457510 - (char)-12291, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 3590192044869L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u001c\u0014{Z\u0001\u0003\u00e2^\u0010\u0005c\u00cb\u00b2e\u00db\r\u001b\u00ce\u008b\u008f\t\u008c\u00b2]s\u00d1v\u00834\u0010]\u00aa\u0084\u00e8\u00d7\u00f5BO\u00a4\u0017o\u0016\u00f1\u00aevo\u0005\u0005\u00f8~\u0003B38\"\u00c8/\u008bI\u00f9\u00cc\u00ae\u009a\u00a5\u008en\u00ec\u00a98\u00b3\u00a5\u00f8\u00f2TG\u00d1\u00bb\u00e5\u00f4#j\u00beXnz\u0081\u00f1\u00f3\u00f9\u00abl\u00cf\u001c\u00a02\u00d5\u00a1/\u00b3f\u00e2<\u008c[";
                    var4_3 = "\u001c\u0014{Z\u0001\u0003\u00e2^\u0010\u0005c\u00cb\u00b2e\u00db\r\u001b\u00ce\u008b\u008f\t\u008c\u00b2]s\u00d1v\u00834\u0010]\u00aa\u0084\u00e8\u00d7\u00f5BO\u00a4\u0017o\u0016\u00f1\u00aevo\u0005\u0005\u00f8~\u0003B38\"\u00c8/\u008bI\u00f9\u00cc\u00ae\u009a\u00a5\u008en\u00ec\u00a98\u00b3\u00a5\u00f8\u00f2TG\u00d1\u00bb\u00e5\u00f4#j\u00beXnz\u0081\u00f1\u00f3\u00f9\u00abl\u00cf\u001c\u00a02\u00d5\u00a1/\u00b3f\u00e2<\u008c[".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 102;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00a0\u009a\u0002\u00d7>+F\u00ad\u001dra\u0083\t%P'LE\u009dI\u00fd}\u00a6@rT\u001a\u00e47\u00b7=\u0014]8\u00e1O\u00b5\u00f3\u00f26\u0096\u0003\u0083\u00e3{e\n\u00c3f\u001d\u00a5(V\u00db~\u00c2\u0001\u000eU\u00f6\tgA\u009d\u00bd\u0088j\u001c;\u00c2+\u00d8\u0091q?X\u00a6[FR\u00e3V1\u00ad,\u00f4\u00a5*\u009e\u0010\u00a6G\u00ca";
                        var4_3 = "\u00a0\u009a\u0002\u00d7>+F\u00ad\u001dra\u0083\t%P'LE\u009dI\u00fd}\u00a6@rT\u001a\u00e47\u00b7=\u0014]8\u00e1O\u00b5\u00f3\u00f26\u0096\u0003\u0083\u00e3{e\n\u00c3f\u001d\u00a5(V\u00db~\u00c2\u0001\u000eU\u00f6\tgA\u009d\u00bd\u0088j\u001c;\u00c2+\u00d8\u0091q?X\u00a6[FR\u00e3V1\u00ad,\u00f4\u00a5*\u009e\u0010\u00a6G\u00ca".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 53;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 72;
                                break;
                            }
                            case 1: {
                                v15 = 54;
                                break;
                            }
                            case 2: {
                                v15 = 115;
                                break;
                            }
                            case 3: {
                                v15 = 81;
                                break;
                            }
                            case 4: {
                                v15 = 23;
                                break;
                            }
                            case 5: {
                                v15 = 123;
                                break;
                            }
                            default: {
                                v15 = 39;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x3071) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 200;
                    case 1 -> 28;
                    case 2 -> 171;
                    case 3 -> 104;
                    case 4 -> 36;
                    case 5 -> 113;
                    case 6 -> 111;
                    case 7 -> 102;
                    case 8 -> 189;
                    case 9 -> 12;
                    case 10 -> 237;
                    case 11 -> 153;
                    case 12 -> 38;
                    case 13 -> 143;
                    case 14 -> 132;
                    case 15 -> 149;
                    case 16 -> 167;
                    case 17 -> 7;
                    case 18 -> 190;
                    case 19 -> 210;
                    case 20 -> 77;
                    case 21 -> 251;
                    case 22 -> 147;
                    case 23 -> 207;
                    case 24 -> 231;
                    case 25 -> 202;
                    case 26 -> 55;
                    case 27 -> 172;
                    case 28 -> 246;
                    case 29 -> 247;
                    case 30 -> 109;
                    case 31 -> 2;
                    case 32 -> 226;
                    case 33 -> 39;
                    case 34 -> 186;
                    case 35 -> 124;
                    case 36 -> 49;
                    case 37 -> 94;
                    case 38 -> 42;
                    case 39 -> 235;
                    case 40 -> 151;
                    case 41 -> 76;
                    case 42 -> 33;
                    case 43 -> 182;
                    case 44 -> 177;
                    case 45 -> 41;
                    case 46 -> 185;
                    case 47 -> 50;
                    case 48 -> 13;
                    case 49 -> 181;
                    case 50 -> 141;
                    case 51 -> 244;
                    case 52 -> 83;
                    case 53 -> 175;
                    case 54 -> 194;
                    case 55 -> 220;
                    case 56 -> 122;
                    case 57 -> 144;
                    case 58 -> 217;
                    case 59 -> 245;
                    case 60 -> 191;
                    case 61 -> 86;
                    case 62 -> 95;
                    case 63 -> 216;
                    case 64 -> 10;
                    case 65 -> 23;
                    case 66 -> 85;
                    case 67 -> 84;
                    case 68 -> 110;
                    case 69 -> 205;
                    case 70 -> 142;
                    case 71 -> 106;
                    case 72 -> 250;
                    case 73 -> 241;
                    case 74 -> 115;
                    case 75 -> 46;
                    case 76 -> 107;
                    case 77 -> 96;
                    case 78 -> 1;
                    case 79 -> 154;
                    case 80 -> 130;
                    case 81 -> 56;
                    case 82 -> 87;
                    case 83 -> 99;
                    case 84 -> 100;
                    case 85 -> 239;
                    case 86 -> 208;
                    case 87 -> 136;
                    case 88 -> 174;
                    case 89 -> 117;
                    case 90 -> 37;
                    case 91 -> 66;
                    case 92 -> 92;
                    case 93 -> 15;
                    case 94 -> 3;
                    case 95 -> 227;
                    case 96 -> 80;
                    case 97 -> 98;
                    case 98 -> 54;
                    case 99 -> 215;
                    case 100 -> 155;
                    case 101 -> 148;
                    case 102 -> 234;
                    case 103 -> 197;
                    case 104 -> 71;
                    case 105 -> 60;
                    case 106 -> 88;
                    case 107 -> 179;
                    case 108 -> 163;
                    case 109 -> 195;
                    case 110 -> 161;
                    case 111 -> 134;
                    case 112 -> 236;
                    case 113 -> 199;
                    case 114 -> 243;
                    case 115 -> 35;
                    case 116 -> 57;
                    case 117 -> 32;
                    case 118 -> 164;
                    case 119 -> 11;
                    case 120 -> 121;
                    case 121 -> 61;
                    case 122 -> 173;
                    case 123 -> 196;
                    case 124 -> 52;
                    case 125 -> 9;
                    case 126 -> 252;
                    case 127 -> 201;
                    case 128 -> 43;
                    case 129 -> 129;
                    case 130 -> 150;
                    case 131 -> 74;
                    case 132 -> 79;
                    case 133 -> 212;
                    case 134 -> 214;
                    case 135 -> 254;
                    case 136 -> 16;
                    case 137 -> 125;
                    case 138 -> 203;
                    case 139 -> 97;
                    case 140 -> 58;
                    case 141 -> 248;
                    case 142 -> 21;
                    case 143 -> 206;
                    case 144 -> 131;
                    case 145 -> 255;
                    case 146 -> 114;
                    case 147 -> 108;
                    case 148 -> 53;
                    case 149 -> 146;
                    case 150 -> 238;
                    case 151 -> 75;
                    case 152 -> 22;
                    case 153 -> 29;
                    case 154 -> 30;
                    case 155 -> 63;
                    case 156 -> 160;
                    case 157 -> 105;
                    case 158 -> 224;
                    case 159 -> 168;
                    case 160 -> 133;
                    case 161 -> 64;
                    case 162 -> 165;
                    case 163 -> 253;
                    case 164 -> 222;
                    case 165 -> 162;
                    case 166 -> 78;
                    case 167 -> 14;
                    case 168 -> 169;
                    case 169 -> 51;
                    case 170 -> 213;
                    case 171 -> 0;
                    case 172 -> 204;
                    case 173 -> 93;
                    case 174 -> 137;
                    case 175 -> 70;
                    case 176 -> 159;
                    case 177 -> 223;
                    case 178 -> 156;
                    case 179 -> 69;
                    case 180 -> 82;
                    case 181 -> 225;
                    case 182 -> 90;
                    case 183 -> 170;
                    case 184 -> 233;
                    case 185 -> 26;
                    case 186 -> 112;
                    case 187 -> 81;
                    case 188 -> 198;
                    case 189 -> 145;
                    case 190 -> 218;
                    case 191 -> 73;
                    case 192 -> 183;
                    case 193 -> 47;
                    case 194 -> 48;
                    case 195 -> 228;
                    case 196 -> 219;
                    case 197 -> 24;
                    case 198 -> 188;
                    case 199 -> 4;
                    case 200 -> 19;
                    case 201 -> 166;
                    case 202 -> 17;
                    case 203 -> 101;
                    case 204 -> 34;
                    case 205 -> 119;
                    case 206 -> 27;
                    case 207 -> 127;
                    case 208 -> 178;
                    case 209 -> 18;
                    case 210 -> 211;
                    case 211 -> 192;
                    case 212 -> 229;
                    case 213 -> 45;
                    case 214 -> 230;
                    case 215 -> 31;
                    case 216 -> 221;
                    case 217 -> 6;
                    case 218 -> 128;
                    case 219 -> 72;
                    case 220 -> 232;
                    case 221 -> 118;
                    case 222 -> 187;
                    case 223 -> 139;
                    case 224 -> 135;
                    case 225 -> 249;
                    case 226 -> 103;
                    case 227 -> 116;
                    case 228 -> 176;
                    case 229 -> 193;
                    case 230 -> 180;
                    case 231 -> 5;
                    case 232 -> 158;
                    case 233 -> 89;
                    case 234 -> 209;
                    case 235 -> 242;
                    case 236 -> 120;
                    case 237 -> 138;
                    case 238 -> 184;
                    case 239 -> 65;
                    case 240 -> 91;
                    case 241 -> 25;
                    case 242 -> 44;
                    case 243 -> 240;
                    case 244 -> 157;
                    case 245 -> 40;
                    case 246 -> 67;
                    case 247 -> 68;
                    case 248 -> 62;
                    case 249 -> 20;
                    case 250 -> 59;
                    case 251 -> 126;
                    case 252 -> 123;
                    case 253 -> 8;
                    case 254 -> 152;
                    default -> 140;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 44435184644242L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(546955110 + (char)-15662, 546955110 + (char)-15975, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 17857516972504L;
                    boolean bl = SshAgentIpcService.l();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(957073140 - 19329, 957073140 - 22633, (int)l2));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (bl2) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 90720669198422L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "i\u00e4*\u00b3\u00af\u0003\u00aa1\u0004";
                var4_3 = "i\u00e4*\u00b3\u00af\u0003\u00aa1\u0004".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 83;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 104;
                                break;
                            }
                            case 1: {
                                v11 = 70;
                                break;
                            }
                            case 2: {
                                v11 = 27;
                                break;
                            }
                            case 3: {
                                v11 = 59;
                                break;
                            }
                            case 4: {
                                v11 = 13;
                                break;
                            }
                            case 5: {
                                v11 = 47;
                                break;
                            }
                            default: {
                                v11 = 90;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFD2AA) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 10;
                    case 1 -> 230;
                    case 2 -> 140;
                    case 3 -> 90;
                    case 4 -> 42;
                    case 5 -> 242;
                    case 6 -> 186;
                    case 7 -> 52;
                    case 8 -> 204;
                    case 9 -> 48;
                    case 10 -> 91;
                    case 11 -> 182;
                    case 12 -> 170;
                    case 13 -> 110;
                    case 14 -> 94;
                    case 15 -> 180;
                    case 16 -> 161;
                    case 17 -> 246;
                    case 18 -> 133;
                    case 19 -> 57;
                    case 20 -> 191;
                    case 21 -> 36;
                    case 22 -> 99;
                    case 23 -> 177;
                    case 24 -> 79;
                    case 25 -> 192;
                    case 26 -> 188;
                    case 27 -> 153;
                    case 28 -> 232;
                    case 29 -> 8;
                    case 30 -> 122;
                    case 31 -> 213;
                    case 32 -> 124;
                    case 33 -> 199;
                    case 34 -> 114;
                    case 35 -> 236;
                    case 36 -> 125;
                    case 37 -> 112;
                    case 38 -> 85;
                    case 39 -> 62;
                    case 40 -> 45;
                    case 41 -> 172;
                    case 42 -> 183;
                    case 43 -> 234;
                    case 44 -> 88;
                    case 45 -> 210;
                    case 46 -> 40;
                    case 47 -> 87;
                    case 48 -> 22;
                    case 49 -> 169;
                    case 50 -> 51;
                    case 51 -> 46;
                    case 52 -> 131;
                    case 53 -> 109;
                    case 54 -> 160;
                    case 55 -> 139;
                    case 56 -> 61;
                    case 57 -> 154;
                    case 58 -> 4;
                    case 59 -> 147;
                    case 60 -> 205;
                    case 61 -> 120;
                    case 62 -> 26;
                    case 63 -> 149;
                    case 64 -> 101;
                    case 65 -> 18;
                    case 66 -> 6;
                    case 67 -> 151;
                    case 68 -> 37;
                    case 69 -> 226;
                    case 70 -> 223;
                    case 71 -> 237;
                    case 72 -> 76;
                    case 73 -> 222;
                    case 74 -> 152;
                    case 75 -> 80;
                    case 76 -> 181;
                    case 77 -> 195;
                    case 78 -> 69;
                    case 79 -> 97;
                    case 80 -> 27;
                    case 81 -> 115;
                    case 82 -> 58;
                    case 83 -> 31;
                    case 84 -> 81;
                    case 85 -> 129;
                    case 86 -> 156;
                    case 87 -> 252;
                    case 88 -> 157;
                    case 89 -> 64;
                    case 90 -> 55;
                    case 91 -> 70;
                    case 92 -> 116;
                    case 93 -> 227;
                    case 94 -> 245;
                    case 95 -> 250;
                    case 96 -> 135;
                    case 97 -> 21;
                    case 98 -> 14;
                    case 99 -> 158;
                    case 100 -> 74;
                    case 101 -> 174;
                    case 102 -> 253;
                    case 103 -> 53;
                    case 104 -> 39;
                    case 105 -> 130;
                    case 106 -> 78;
                    case 107 -> 93;
                    case 108 -> 249;
                    case 109 -> 208;
                    case 110 -> 24;
                    case 111 -> 247;
                    case 112 -> 7;
                    case 113 -> 212;
                    case 114 -> 84;
                    case 115 -> 1;
                    case 116 -> 196;
                    case 117 -> 126;
                    case 118 -> 20;
                    case 119 -> 105;
                    case 120 -> 255;
                    case 121 -> 103;
                    case 122 -> 95;
                    case 123 -> 184;
                    case 124 -> 165;
                    case 125 -> 34;
                    case 126 -> 134;
                    case 127 -> 145;
                    case 128 -> 86;
                    case 129 -> 3;
                    case 130 -> 218;
                    case 131 -> 136;
                    case 132 -> 54;
                    case 133 -> 117;
                    case 134 -> 16;
                    case 135 -> 15;
                    case 136 -> 111;
                    case 137 -> 5;
                    case 138 -> 19;
                    case 139 -> 25;
                    case 140 -> 202;
                    case 141 -> 148;
                    case 142 -> 127;
                    case 143 -> 248;
                    case 144 -> 207;
                    case 145 -> 113;
                    case 146 -> 47;
                    case 147 -> 72;
                    case 148 -> 219;
                    case 149 -> 56;
                    case 150 -> 9;
                    case 151 -> 107;
                    case 152 -> 155;
                    case 153 -> 106;
                    case 154 -> 137;
                    case 155 -> 159;
                    case 156 -> 214;
                    case 157 -> 32;
                    case 158 -> 96;
                    case 159 -> 89;
                    case 160 -> 239;
                    case 161 -> 119;
                    case 162 -> 49;
                    case 163 -> 144;
                    case 164 -> 71;
                    case 165 -> 178;
                    case 166 -> 164;
                    case 167 -> 198;
                    case 168 -> 68;
                    case 169 -> 143;
                    case 170 -> 41;
                    case 171 -> 162;
                    case 172 -> 11;
                    case 173 -> 251;
                    case 174 -> 82;
                    case 175 -> 43;
                    case 176 -> 60;
                    case 177 -> 50;
                    case 178 -> 13;
                    case 179 -> 211;
                    case 180 -> 194;
                    case 181 -> 100;
                    case 182 -> 168;
                    case 183 -> 17;
                    case 184 -> 118;
                    case 185 -> 197;
                    case 186 -> 167;
                    case 187 -> 235;
                    case 188 -> 238;
                    case 189 -> 175;
                    case 190 -> 243;
                    case 191 -> 75;
                    case 192 -> 150;
                    case 193 -> 166;
                    case 194 -> 209;
                    case 195 -> 12;
                    case 196 -> 142;
                    case 197 -> 121;
                    case 198 -> 0;
                    case 199 -> 146;
                    case 200 -> 141;
                    case 201 -> 104;
                    case 202 -> 92;
                    case 203 -> 77;
                    case 204 -> 221;
                    case 205 -> 229;
                    case 206 -> 216;
                    case 207 -> 220;
                    case 208 -> 33;
                    case 209 -> 231;
                    case 210 -> 38;
                    case 211 -> 63;
                    case 212 -> 30;
                    case 213 -> 73;
                    case 214 -> 35;
                    case 215 -> 215;
                    case 216 -> 185;
                    case 217 -> 201;
                    case 218 -> 225;
                    case 219 -> 65;
                    case 220 -> 132;
                    case 221 -> 128;
                    case 222 -> 29;
                    case 223 -> 163;
                    case 224 -> 2;
                    case 225 -> 240;
                    case 226 -> 224;
                    case 227 -> 233;
                    case 228 -> 67;
                    case 229 -> 66;
                    case 230 -> 228;
                    case 231 -> 244;
                    case 232 -> 171;
                    case 233 -> 102;
                    case 234 -> 200;
                    case 235 -> 189;
                    case 236 -> 98;
                    case 237 -> 28;
                    case 238 -> 206;
                    case 239 -> 83;
                    case 240 -> 173;
                    case 241 -> 254;
                    case 242 -> 190;
                    case 243 -> 187;
                    case 244 -> 203;
                    case 245 -> 217;
                    case 246 -> 108;
                    case 247 -> 193;
                    case 248 -> 138;
                    case 249 -> 176;
                    case 250 -> 59;
                    case 251 -> 179;
                    case 252 -> 23;
                    case 253 -> 44;
                    case 254 -> 123;
                    default -> 241;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

