/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.types;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyCallType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0014J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0014J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/vuejs/types/VueSourcePropType;", "Lcom/intellij/lang/javascript/psi/types/JSTypeBaseImpl;", "Lcom/intellij/lang/javascript/psi/types/JSCodeBasedType;", "typeSource", "Lcom/intellij/lang/javascript/psi/types/JSTypeSource;", "element", "Lcom/intellij/psi/PsiNamedElement;", "<init>", "(Lcom/intellij/lang/javascript/psi/types/JSTypeSource;Lcom/intellij/psi/PsiNamedElement;)V", "(Lcom/intellij/psi/PsiNamedElement;)V", "copyWithNewSource", "Lcom/intellij/lang/javascript/psi/JSType;", "source", "isEquivalentToWithSameClass", "", "type", "context", "Lcom/intellij/util/ProcessingContext;", "allowResolve", "substituteImpl", "Lcom/intellij/lang/javascript/psi/JSTypeSubstitutionContext;", "computeType", "hashCodeImpl", "", "buildTypeTextImpl", "", "format", "Lcom/intellij/lang/javascript/psi/JSType$TypeTextFormat;", "builder", "Lcom/intellij/lang/javascript/psi/JSTypeTextBuilder;", "intellij.vuejs"})
@SourceDebugExtension(value={"SMAP\nVueSourcePropType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueSourcePropType.kt\norg/jetbrains/vuejs/types/VueSourcePropType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class VueSourcePropType
extends JSTypeBaseImpl
implements JSCodeBasedType {
    @NotNull
    private final PsiNamedElement element;

    private VueSourcePropType(JSTypeSource typeSource, PsiNamedElement element) {
        super(typeSource);
        this.element = element;
    }

    public VueSourcePropType(@NotNull PsiNamedElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JSTypeSource jSTypeSource = JSTypeSourceFactory.createTypeSource((PsiElement)((PsiElement)element), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jSTypeSource, (String)"createTypeSource(...)");
        this(jSTypeSource, element);
    }

    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return (JSType)new VueSourcePropType(source, this.element);
    }

    protected boolean isEquivalentToWithSameClass(@NotNull JSType type2, @Nullable ProcessingContext context, boolean allowResolve) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return type2 instanceof VueSourcePropType && Intrinsics.areEqual((Object)((VueSourcePropType)type2).element, (Object)this.element);
    }

    @NotNull
    protected JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        JSType jSType;
        JSType jSType2;
        JSType jSType3;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JSType jSType4 = this.computeType(this.element);
        if (jSType4 != null && (jSType3 = jSType4.substitute(context)) != null && (jSType2 = VueUtilKt.fixPrimitiveTypes(jSType3)) != null) {
            jSType = jSType2;
        } else {
            JSAnyType jSAnyType = JSAnyType.get((JSTypeSource)this.getSource());
            Intrinsics.checkNotNullExpressionValue((Object)jSAnyType, (String)"get(...)");
            jSType = (JSType)jSAnyType;
        }
        return jSType;
    }

    private final JSType computeType(PsiNamedElement element) {
        JSType jSType;
        JSType jsDocType = VueUtilKt.getPropTypeFromDocComment(element);
        if (jsDocType != null) {
            return jsDocType;
        }
        PsiNamedElement psiNamedElement = element;
        if (psiNamedElement instanceof JSProperty) {
            jSType = VueUtilKt.getPropTypeFromPropOptions(((JSProperty)element).getValue());
        } else if (psiNamedElement instanceof JSImplicitElement) {
            jSType = VueUtilKt.getPropTypeFromGenericType(((JSImplicitElement)element).getJSType());
            if (jSType == null) {
                JSApplyCallType jSApplyCallType;
                JSType jSType2 = ((JSImplicitElement)element).getJSType();
                if (jSType2 != null) {
                    JSType it = jSType2;
                    boolean bl = false;
                    jSApplyCallType = new JSApplyCallType(it, it.getSource());
                } else {
                    jSApplyCallType = null;
                }
                if (jSApplyCallType != null) {
                    jSType = (JSType)jSApplyCallType;
                } else {
                    PsiElement psiElement = ((JSImplicitElement)element).getParent();
                    JSProperty jSProperty = psiElement instanceof JSProperty ? (JSProperty)psiElement : null;
                    jSType = VueUtilKt.getPropTypeFromPropOptions((JSExpression)(jSProperty != null ? jSProperty.getValue() : null));
                }
            }
        } else {
            jSType = null;
        }
        return jSType;
    }

    protected int hashCodeImpl() {
        String string = this.element.getName();
        return string != null ? string.hashCode() : 0;
    }

    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (format == JSType.TypeTextFormat.SIMPLE) {
            JSTypeTextBuilder jSTypeTextBuilder = builder.append("#VueSourcePropType: ");
            String string = this.element.getName();
            if (string == null) {
                string = "";
            }
            jSTypeTextBuilder.append(string);
            return;
        }
        this.substitute().buildTypeText(format, builder);
    }
}

