/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.libraries.vuex.types;

import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParameter;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.libraries.vuex.VuexUtils;
import org.jetbrains.vuejs.libraries.vuex.model.store.VuexStaticNamespace;
import org.jetbrains.vuejs.libraries.vuex.model.store.VuexStoreNamespace;
import org.jetbrains.vuejs.libraries.vuex.model.store.VuexStoreNamespaceKt;
import org.jetbrains.vuejs.libraries.vuex.types.VuexActionContextType;
import org.jetbrains.vuejs.libraries.vuex.types.VuexContainerPropertyTypeBase;
import org.jetbrains.vuejs.libraries.vuex.types.VuexStoreTypeProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u000bH\u0002J&\u0010\f\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/vuejs/libraries/vuex/types/VuexStoreTypeProvider;", "", "<init>", "()V", "addTypeFromResolveResult", "", "evaluator", "Lcom/intellij/lang/javascript/psi/resolve/JSTypeEvaluator;", "result", "Lcom/intellij/psi/PsiElement;", "isStoreField", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptField;", "getTypeConstructor", "Lkotlin/reflect/KFunction2;", "Lorg/jetbrains/vuejs/libraries/vuex/model/store/VuexStoreNamespace;", "Lorg/jetbrains/vuejs/libraries/vuex/types/VuexContainerPropertyTypeBase;", "name", "", "intellij.vuejs"})
@SourceDebugExtension(value={"SMAP\nVuexStoreTypeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VuexStoreTypeProvider.kt\norg/jetbrains/vuejs/libraries/vuex/types/VuexStoreTypeProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class VuexStoreTypeProvider {
    @NotNull
    public static final VuexStoreTypeProvider INSTANCE = new VuexStoreTypeProvider();

    private VuexStoreTypeProvider() {
    }

    public final boolean addTypeFromResolveResult(@NotNull JSTypeEvaluator evaluator, @NotNull PsiElement result) {
        Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (result instanceof TypeScriptField) {
            KFunction<VuexContainerPropertyTypeBase> kFunction = this.getTypeConstructor(((TypeScriptField)result).getName());
            if (kFunction == null) {
                return false;
            }
            KFunction<VuexContainerPropertyTypeBase> typeConstructor = kFunction;
            if (!this.isStoreField((TypeScriptField)result) || !VuexUtils.INSTANCE.isVuexContext(result)) {
                return false;
            }
            evaluator.addType((JSType)((Function2)typeConstructor).invoke((Object)result, (Object)VuexStaticNamespace.Companion.getEMPTY()));
            return true;
        }
        if (result instanceof JSParameter) {
            if (result instanceof TypeScriptParameter) {
                JSType it = ((TypeScriptParameter)result).getJSType();
                boolean bl = false;
                boolean bl2 = it != null && !JSTypeUtils.isAnyType((JSType)it);
                if (bl2) {
                    return false;
                }
            }
            if (VuexUtils.INSTANCE.isActionContextParameter(result)) {
                if (!VuexUtils.INSTANCE.isVuexContext(result)) {
                    return false;
                }
                evaluator.addType((JSType)new VuexActionContextType(result));
                return true;
            }
            String name = ((JSParameter)result).getName();
            KFunction<VuexContainerPropertyTypeBase> kFunction = this.getTypeConstructor(name);
            if (kFunction == null) {
                return false;
            }
            KFunction<VuexContainerPropertyTypeBase> typeConstructor = kFunction;
            JSParameter jSParameter = (JSParameter)result;
            String string = name;
            Intrinsics.checkNotNull((Object)string);
            VuexStoreNamespace vuexStoreNamespace = VuexStoreNamespaceKt.getNamespaceForGettersOrState(jSParameter, string);
            if (vuexStoreNamespace == null) {
                return false;
            }
            VuexStoreNamespace namespace = vuexStoreNamespace;
            if (!VuexUtils.INSTANCE.isVuexContext(result)) {
                return false;
            }
            evaluator.addType((JSType)((Function2)typeConstructor).invoke((Object)result, (Object)namespace));
            return true;
        }
        return false;
    }

    private final boolean isStoreField(TypeScriptField result) {
        VirtualFile virtualFile;
        JSQualifiedName jSQualifiedName = result.getNamespace();
        return Intrinsics.areEqual((Object)(jSQualifiedName != null ? jSQualifiedName.getQualifiedName() : null), (Object)"Store") && Intrinsics.areEqual((virtualFile = result.getContainingFile().getVirtualFile()) != null && (virtualFile = virtualFile.getParent()) != null && (virtualFile = virtualFile.getParent()) != null ? virtualFile.getName() : null, (Object)"vuex");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KFunction<VuexContainerPropertyTypeBase> getTypeConstructor(String name) {
        String string = name;
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case -878079793: {
                if (string.equals("rootState")) {
                    n = 1;
                }
                break;
            }
            case -198120058: {
                if (string.equals("rootGetters")) {
                    n = 2;
                }
                break;
            }
            case 109757585: {
                if (string.equals("state")) {
                    n = 1;
                }
                break;
            }
            case -74172216: {
                if (string.equals("getters")) {
                    n = 2;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                KFunction kFunction = (KFunction)getTypeConstructor.1.INSTANCE;
                return kFunction;
            }
            case 2: {
                KFunction kFunction = (KFunction)getTypeConstructor.2.INSTANCE;
                return kFunction;
            }
            default: {
                return null;
            }
        }
    }
}

