/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ThrowableConsumer;
import com.jetbrains.nodejs.run.profile.heap.GenericArray;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import org.jetbrains.annotations.NotNull;

public class FileBackedArray<T>
implements GenericArray<T> {
    private static final long ourSizeThreshold = 102400L;
    private final CloseableGenericArray<T> myFirstPartDelegate;
    private final CloseableGenericArray<T> myDelegate;
    private final long myFirstInSecondPart;

    public FileBackedArray(long size, @NotNull File file, @NotNull RawSerializer<T> serializer, @NotNull T nullObject, long l) throws IOException {
        long threshold;
        if (file == null) {
            FileBackedArray.$$$reportNull$$$0(0);
        }
        if (serializer == null) {
            FileBackedArray.$$$reportNull$$$0(1);
        }
        if (nullObject == null) {
            FileBackedArray.$$$reportNull$$$0(2);
        }
        long l2 = threshold = threshold < 0L ? 102400L : threshold;
        if (size * serializer.getRecordSize() > threshold) {
            this.myDelegate = new MyFileBased<T>(file, serializer, size - threshold, nullObject, threshold);
            this.myFirstPartDelegate = new MyArrayBased<Object>((Object[])Array.newInstance(nullObject.getClass(), (int)threshold));
            this.myFirstInSecondPart = threshold;
        } else {
            this.myDelegate = new MyArrayBased<Object>((Object[])Array.newInstance(nullObject.getClass(), (int)size));
            this.myFirstPartDelegate = this.myDelegate;
            this.myFirstInSecondPart = 0L;
        }
    }

    public void closeAndReplay(@NotNull ThrowableConsumer<T, IOException> consumer) throws IOException {
        if (consumer == null) {
            FileBackedArray.$$$reportNull$$$0(3);
        }
        this.myFirstPartDelegate.replay(consumer);
        if (this.myFirstInSecondPart > 0L) {
            this.myDelegate.replay(consumer);
        }
        this.close();
    }

    public void close() throws IOException {
        this.myFirstPartDelegate.close();
        this.myDelegate.close();
    }

    @Override
    public void set(long i, T t) throws IOException {
        if (i >= this.myFirstInSecondPart) {
            this.myDelegate.set(i, t);
        } else {
            this.myFirstPartDelegate.set(i, t);
        }
    }

    @Override
    public T get(long i) throws IOException {
        if (i >= this.myFirstInSecondPart) {
            return this.myDelegate.get(i);
        }
        return this.myFirstPartDelegate.get(i);
    }

    @Override
    public long size() {
        return this.myFirstInSecondPart + this.myDelegate.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullObject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/FileBackedArray";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "closeAndReplay";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyFileBased<T>
    implements CloseableGenericArray<T> {
        private File myFile;
        @NotNull
        private final RawSerializer<T> mySerializer;
        private final long mySize;
        private final T myNullObject;
        private final long myOffset;
        private RandomAccessFile myRaf;

        /*
         * WARNING - void declaration
         */
        private MyFileBased(@NotNull File file, @NotNull RawSerializer<T> serializer, long size, T nullObject, long l) throws IOException {
            void offset;
            if (file == null) {
                MyFileBased.$$$reportNull$$$0(0);
            }
            if (serializer == null) {
                MyFileBased.$$$reportNull$$$0(1);
            }
            this.myFile = file;
            this.mySerializer = serializer;
            this.mySize = size;
            this.myNullObject = nullObject;
            this.myOffset = offset;
            try (SequentialRawWriter<T> writer = new SequentialRawWriter<T>(this.myFile, serializer);){
                int j = 0;
                while ((long)j < this.mySize) {
                    writer.write(nullObject);
                    ++j;
                }
            }
            this.myRaf = new RandomAccessFile(file, "rw");
        }

        @Override
        public void set(long i, T t) throws IOException {
            this.myRaf.seek(this.mySerializer.getRecordSize() * (i - this.myOffset));
            this.mySerializer.write(this.myRaf, t);
        }

        @Override
        public T get(long i) throws IOException {
            long offset = (i - this.myOffset) * this.mySerializer.getRecordSize();
            if (this.myRaf.length() < offset + this.mySerializer.getRecordSize()) {
                return null;
            }
            this.myRaf.seek(offset);
            T read = this.mySerializer.read(this.myRaf);
            return this.myNullObject.equals(read) ? null : (T)read;
        }

        @Override
        public long size() {
            return this.mySize;
        }

        @Override
        public void close() throws IOException {
            if (this.myRaf != null) {
                this.myRaf.close();
                this.myRaf = null;
            }
            if (this.myFile != null) {
                FileUtil.delete((File)this.myFile);
                this.myFile = null;
            }
        }

        @Override
        public void replay(@NotNull ThrowableConsumer<T, IOException> consumer) throws IOException {
            if (consumer == null) {
                MyFileBased.$$$reportNull$$$0(2);
            }
            this.myRaf.close();
            this.myRaf = null;
            try (SequentialRawReader<T> reader = new SequentialRawReader<T>(this.myFile, this.mySerializer, this.mySize);){
                int i = 0;
                while ((long)i < this.mySize) {
                    consumer.consume(reader.read());
                    ++i;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serializer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/FileBackedArray$MyFileBased";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replay";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface CloseableGenericArray<T>
    extends GenericArray<T>,
    Closeable {
        public void replay(@NotNull ThrowableConsumer<T, IOException> var1) throws IOException;
    }

    private static final class MyArrayBased<T>
    implements CloseableGenericArray<T> {
        private T[] myArr;

        private MyArrayBased(T[] arr) {
            this.myArr = arr;
        }

        @Override
        public void set(long i, T t) {
            this.myArr[(int)i] = t;
        }

        @Override
        public T get(long i) {
            return this.myArr[(int)i];
        }

        @Override
        public long size() {
            return this.myArr.length;
        }

        @Override
        public void close() throws IOException {
            this.myArr = null;
        }

        @Override
        public void replay(@NotNull ThrowableConsumer<T, IOException> consumer) throws IOException {
            if (consumer == null) {
                MyArrayBased.$$$reportNull$$$0(0);
            }
            for (T t : this.myArr) {
                consumer.consume(t);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/nodejs/run/profile/heap/FileBackedArray$MyArrayBased", "replay"));
        }
    }
}

