/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.FilePathIconProvider;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesFileNameDecorator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBInsets;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserNodeRenderer
extends ColoredTreeCellRenderer {
    @NotNull
    private final BooleanGetter myShowFlatten;
    @Nullable
    private final Project myProject;
    @Nullable
    private final IssueLinkRenderer myIssueLinkRenderer;
    private final boolean myHighlightProblems;
    @Nullable
    private JBInsets myBackgroundInsets;

    public ChangesBrowserNodeRenderer(@Nullable Project project, @NotNull BooleanGetter showFlattenGetter, boolean highlightProblems) {
        if (showFlattenGetter == null) {
            ChangesBrowserNodeRenderer.$$$reportNull$$$0(0);
        }
        this.myShowFlatten = showFlattenGetter;
        this.myProject = project;
        this.myHighlightProblems = highlightProblems;
        this.myIssueLinkRenderer = project != null ? new IssueLinkRenderer(project, (SimpleColoredComponent)this) : null;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public boolean isShowFlatten() {
        return this.myShowFlatten.get();
    }

    @DirtyUI
    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            ChangesBrowserNodeRenderer.$$$reportNull$$$0(1);
        }
        ChangesBrowserNode node = (ChangesBrowserNode)value;
        node.render(tree, this, selected, expanded, hasFocus);
        SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)tree, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
    }

    public void appendFileName(@Nullable VirtualFile vFile, @NotNull @NlsSafe String fileName, Color color) {
        ChangesFileNameDecorator decorator;
        if (fileName == null) {
            ChangesBrowserNodeRenderer.$$$reportNull$$$0(2);
        }
        ChangesFileNameDecorator changesFileNameDecorator = decorator = this.myProject != null && !this.myProject.isDefault() && !this.myProject.isDisposed() ? ChangesFileNameDecorator.getInstance(this.myProject) : null;
        if (decorator != null) {
            decorator.appendFileName(this, vFile, fileName, color, this.myHighlightProblems);
        } else {
            this.append(fileName, new SimpleTextAttributes(0, color));
        }
    }

    public void clear() {
        this.setBackgroundInsets(null);
        this.setToolTipText(null);
        super.clear();
    }

    protected void doPaintFragmentBackground(@NotNull Graphics2D g, int index, @NotNull Color bgColor, int x, int y, int width, int height) {
        if (g == null) {
            ChangesBrowserNodeRenderer.$$$reportNull$$$0(3);
        }
        if (bgColor == null) {
            ChangesBrowserNodeRenderer.$$$reportNull$$$0(4);
        }
        if (this.myBackgroundInsets != null) {
            g.setColor(bgColor);
            g.fillRect(x + this.myBackgroundInsets.left, y + this.myBackgroundInsets.top, width - this.myBackgroundInsets.width(), height - this.myBackgroundInsets.height());
        } else {
            super.doPaintFragmentBackground(g, index, bgColor, x, y, width, height);
        }
    }

    public void appendTextWithIssueLinks(@NotNull @Nls String text, @NotNull SimpleTextAttributes baseStyle) {
        if (text == null) {
            ChangesBrowserNodeRenderer.$$$reportNull$$$0(5);
        }
        if (baseStyle == null) {
            ChangesBrowserNodeRenderer.$$$reportNull$$$0(6);
        }
        if (this.myIssueLinkRenderer != null) {
            this.myIssueLinkRenderer.appendTextWithLinks(text, baseStyle);
        } else {
            this.append(text, baseStyle);
        }
    }

    public void setIcon(@NotNull FilePath filePath, boolean isDirectory) {
        Icon icon;
        if (filePath == null) {
            ChangesBrowserNodeRenderer.$$$reportNull$$$0(7);
        }
        if ((icon = (Icon)FilePathIconProvider.EP_NAME.computeSafeIfAny(provider -> provider.getIcon(filePath, this.myProject))) != null) {
            this.setIcon(icon);
            return;
        }
        if (isDirectory) {
            this.setIcon(PlatformIcons.FOLDER_ICON);
            return;
        }
        this.setIcon(VcsUtil.getIcon((Project)this.myProject, (FilePath)filePath));
    }

    public void setBackgroundInsets(@Nullable JBInsets backgroundInsets) {
        this.myBackgroundInsets = backgroundInsets;
    }

    public boolean isShowingLocalChanges() {
        return this.myHighlightProblems;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showFlattenGetter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bgColor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseStyle";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendFileName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doPaintFragmentBackground";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "appendTextWithIssueLinks";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

