/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.google.common.collect.Iterables;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiTable;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SqlDropIndexedColumnInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlDropIndexedColumnInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlDropIndexedColumnInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlDropIndexedColumnInspection.$$$reportNull$$$0(2);
        }
        if (!dialect.getDbms().isTransactSql()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlAlterStatement(SqlAlterStatement o) {
                SqlReferenceExpression reference = o.getAlterTargetReference();
                if (reference == null || reference.getReferenceElementType().getTargetKind() != ObjectKind.TABLE) {
                    return;
                }
                PsiElement table = reference.resolve();
                if (!(table instanceof PsiTable)) {
                    return;
                }
                JBIterable<? extends DasIndex> indices = SqlDropIndexedColumnInspection.getIndices((PsiTable)table);
                JBIterable<? extends DasTableKey> keys = DasUtil.getTableKeys((DasTable)table);
                if (Iterables.isEmpty(indices)) {
                    return;
                }
                SyntaxTraverser traverser = (SyntaxTraverser)SqlImplUtil.sqlTraverser().expand(Conditions.notInstanceOf(SqlReferenceExpression.class));
                for (SqlAlterInstruction instruction : o.getAlterInstructions()) {
                    if (instruction.getInstructionType() != SqlCommonKeywords.SQL_DROP) continue;
                    for (SqlReferenceExpression element : ((SyntaxTraverser)traverser.withRoot((Object)instruction)).filter(SqlReferenceExpression.class)) {
                        String message;
                        String indexName;
                        PsiElement obj2;
                        if (element.getReferenceElementType().getTargetKind() != ObjectKind.COLUMN || !((obj2 = element.resolve()) instanceof DasColumn)) continue;
                        String columnName = ((DasColumn)obj2).getName();
                        for (DasIndex index : indices) {
                            if (!DasUtil.containsName(columnName, index.getColumnsRef())) continue;
                            indexName = index.getName();
                            message = SqlBundle.message((String)"inspection.message.attempt.to.dropping.indexed.column.choice.drop.index.before.dropping.this.column", (Object[])new Object[]{indexName, DasUtil.isNoName(indexName) ? 0 : 1});
                            this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)element, message, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                        }
                        for (DasTableKey key2 : keys) {
                            if (!DasUtil.containsName(columnName, key2.getColumnsRef())) continue;
                            indexName = key2.getName();
                            message = SqlBundle.message((String)"inspection.message.attempt.to.dropping.indexed.column.choice.drop.key.before.dropping.this.column", (Object[])new Object[]{indexName, DasUtil.isNoName(indexName) ? 0 : 1});
                            this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)element, message, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                        }
                    }
                }
            }
        };
    }

    @NotNull
    private static JBIterable<? extends DasIndex> getIndices(PsiTable table) {
        PsiFile file;
        JBIterable<? extends DasIndex> declaredIndices = DasUtil.getIndices(table);
        if (table instanceof SqlDefinition && (file = table.getContainingFile()) instanceof SqlFile) {
            JBIterable auxiliary = JBIterable.from((Iterable)((SqlFile)file).getDdl()).filter(DasIndex.class).filter(o -> {
                SqlReferenceExpression reference = ((SqlCreateIndexStatement)o).getTargetReference();
                return reference != null && reference.getReference().isReferenceTo((PsiElement)table);
            });
            JBIterable jBIterable = JBIterable.empty().append(declaredIndices).append((Iterable)auxiliary);
            if (jBIterable == null) {
                SqlDropIndexedColumnInspection.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        JBIterable<? extends DasIndex> jBIterable = declaredIndices;
        if (jBIterable == null) {
            SqlDropIndexedColumnInspection.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlDropIndexedColumnInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlDropIndexedColumnInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

