/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.owner;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicHierarchicalObject;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.references.BasicInlineObjectReference;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.ElementOwnerResolveAssistant;
import com.intellij.database.schemaEditor.owner.ElementMatcherImpl;
import com.intellij.database.schemaEditor.owner.ElementOwnerPullHelper;
import com.intellij.database.schemaEditor.owner.Id;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.EventListener;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ElementOwnerImpl
implements ElementOwner {
    private final EventDispatcher<ElementOwner.ElementListener> myDispatcher;
    private final ElementMatcherImpl myMatcher;
    private final ElementOwnerPullHelper myOriginalHelper;
    private final ConcurrentMap<BasicElement, Id<?>> myIds;
    private final ConcurrentMap<Id<?>, BasicElement> myRev;
    private final Set<Id<?>> myDrops;
    private final Set<BasicElement> myStrongRefs;
    private final BasicResolveAssistant myResolveAssistant;

    ElementOwnerImpl(@NotNull ElementMatcherImpl matcher, @Nullable ElementOwnerImpl originalOwner) {
        if (matcher == null) {
            ElementOwnerImpl.$$$reportNull$$$0(0);
        }
        this.myDispatcher = EventDispatcher.create(ElementOwner.ElementListener.class);
        this.myIds = ContainerUtil.createConcurrentWeakMap();
        this.myRev = CollectionFactory.createConcurrentWeakValueMap();
        this.myDrops = ConcurrentCollectionFactory.createConcurrentSet();
        this.myStrongRefs = ConcurrentCollectionFactory.createConcurrentSet();
        this.myResolveAssistant = new ElementOwnerResolveAssistant(this);
        this.myMatcher = matcher;
        this.myOriginalHelper = originalOwner == null ? null : new ElementOwnerPullHelper(this, originalOwner);
    }

    @Override
    public Iterable<? extends ElementIdentity<?>> getCached() {
        return JBIterable.from(this.myMatcher.getCachedIds()).filter(id -> id.getInlined() == null);
    }

    @NotNull
    private <T extends BasicElement> Id<T> computeIdIfAbsent(@NotNull T element, @NotNull Function<T, Id<T>> compute2) {
        if (element == null) {
            ElementOwnerImpl.$$$reportNull$$$0(1);
        }
        if (compute2 == null) {
            ElementOwnerImpl.$$$reportNull$$$0(2);
        }
        Id id = this.myIds.computeIfAbsent(element, e -> (Id)compute2.apply(e));
        if (id == null) {
            ElementOwnerImpl.$$$reportNull$$$0(3);
        }
        return id;
    }

    @NotNull
    protected <E extends BasicElement> Id<E> createId(@NotNull E element) {
        if (element == null) {
            ElementOwnerImpl.$$$reportNull$$$0(4);
        }
        Id<E> id = this.createIdImpl(element);
        if (id == null) {
            ElementOwnerImpl.$$$reportNull$$$0(5);
        }
        return id;
    }

    private <T extends BasicElement, S extends BasicElement> Id<T> createInlineId(S owner, BasicMetaReference<S, T> ref2, T orig) {
        return this.createInlineIdImpl(owner, ref2, orig);
    }

    @NotNull
    private <T extends BasicElement, S extends BasicElement> Id<T> createInlineIdImpl(S owner, BasicMetaReference<S, T> ref2, T orig) {
        Id<BasicElement> res2 = this.computeIdIfAbsent(orig, e -> new Id<BasicElement>(this.createIdImpl(owner), this.myMatcher, ref2, BasicMetaUtils.getMetaObject(orig), this.myMatcher.allocateId()));
        this.addTargetImpl(res2, orig);
        Id<BasicElement> id = res2;
        if (id == null) {
            ElementOwnerImpl.$$$reportNull$$$0(6);
        }
        return id;
    }

    <E extends BasicElement> boolean remap(@NotNull Id<E> id, @Nullable E element, @Nullable E newElement) {
        boolean wasStrong;
        if (id == null) {
            ElementOwnerImpl.$$$reportNull$$$0(7);
        }
        if (element != null && !this.myRev.remove(id, element)) {
            return false;
        }
        boolean bl = wasStrong = element != null && this.myStrongRefs.remove(element);
        if (newElement != null) {
            this.myIds.put(newElement, id);
            this.myRev.put(id, newElement);
            if (wasStrong) {
                this.myStrongRefs.add(newElement);
            }
        } else {
            this.myDrops.add(id);
        }
        return true;
    }

    protected <E extends BasicElement> void addResolution(@NotNull Id<E> id, @NotNull E element) {
        if (id == null) {
            ElementOwnerImpl.$$$reportNull$$$0(8);
        }
        if (element == null) {
            ElementOwnerImpl.$$$reportNull$$$0(9);
        }
        if (this.myOriginalHelper == null) {
            throw new AssertionError((Object)"Attempt to add resolution for original element");
        }
        this.addResolutionImpl(id, element);
    }

    private <E extends BasicElement> void addResolutionImpl(@Nullable Id<E> id, @Nullable E element) {
        if (id == null || element == null) {
            return;
        }
        Id<E> prev2 = this.myIds.putIfAbsent(element, id);
        if (prev2 != null) {
            if (prev2 != id) {
                throw new AssertionError((Object)"Attempt to override existing resolution");
            }
            return;
        }
        this.addTargetImpl(id, element);
        this.addResolutionImpl(id.getParentId(), element.getParent());
    }

    private <E extends BasicElement> void addTargetImpl(@NotNull Id<E> id, @Nullable E element) {
        if (id == null) {
            ElementOwnerImpl.$$$reportNull$$$0(10);
        }
        this.myRev.put(id, element);
        if (element instanceof BasicDataObject || element instanceof BasicRoot) {
            this.myStrongRefs.add(element);
        }
        this.myDrops.remove(id);
        ((ElementOwner.ElementListener)this.myDispatcher.getMulticaster()).onAdded(element, id);
    }

    private <E extends BasicElement> Id<E> createIdImpl(@Nullable E element) {
        if (element == null) {
            return null;
        }
        Id<BasicElement> res2 = this.computeIdIfAbsent(element, e -> new Id<BasicElement>(this.createIdImpl(element.getParent()), this.myMatcher, BasicMetaUtils.getMetaObject(element), this.myMatcher.allocateId()));
        this.addTargetImpl(res2, element);
        return res2;
    }

    @Override
    public <E extends BasicElement> void addMatch(@NotNull ElementIdentity<E> identity, @NotNull E element) {
        Id<E> id;
        if (identity == null) {
            ElementOwnerImpl.$$$reportNull$$$0(11);
        }
        if (element == null) {
            ElementOwnerImpl.$$$reportNull$$$0(12);
        }
        if ((id = ElementMatcherImpl.asId(identity)) != null) {
            this.addResolution(id, element);
        }
    }

    @Override
    public <E extends BasicElement> void addMatchAndPull(@NotNull ElementIdentity<E> identity, @NotNull E element) {
        Id<E> id;
        if (identity == null) {
            ElementOwnerImpl.$$$reportNull$$$0(13);
        }
        if (element == null) {
            ElementOwnerImpl.$$$reportNull$$$0(14);
        }
        if ((id = ElementMatcherImpl.asId(identity)) != null) {
            if (this.myOriginalHelper == null) {
                throw new AssertionError((Object)"Attempt to add match for original element");
            }
            this.myOriginalHelper.addMatchAndPull(id, element);
        }
    }

    @Nullable
    private <E extends BasicElement> Id<E> findId(@NotNull E e) {
        if (e == null) {
            ElementOwnerImpl.$$$reportNull$$$0(15);
        }
        return (Id)this.myIds.get(e);
    }

    @Nullable
    public <E extends BasicElement> Id<E> findIdentity(@Nullable E e) {
        return e == null ? null : this.findId(e);
    }

    @NotNull
    public <E extends BasicElement> Id<E> identify(@NotNull E e) {
        Id<E> id;
        if (e == null) {
            ElementOwnerImpl.$$$reportNull$$$0(16);
        }
        if ((id = this.findId(e)) != null) {
            Id<E> id2 = id;
            if (id2 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(17);
            }
            return id2;
        }
        Id<E> id3 = this.createId(e);
        if (id3 == null) {
            ElementOwnerImpl.$$$reportNull$$$0(18);
        }
        return id3;
    }

    @NotNull
    public <S extends BasicElement, T extends BasicElement> Id<T> identifyInlineRef(@NotNull S owner, @NotNull BasicMetaReference<S, T> metaRef, @NotNull T e) {
        Id<T> id;
        if (owner == null) {
            ElementOwnerImpl.$$$reportNull$$$0(19);
        }
        if (metaRef == null) {
            ElementOwnerImpl.$$$reportNull$$$0(20);
        }
        if (e == null) {
            ElementOwnerImpl.$$$reportNull$$$0(21);
        }
        if ((id = this.findId(e)) != null) {
            Id<T> id2 = id;
            if (id2 == null) {
                ElementOwnerImpl.$$$reportNull$$$0(22);
            }
            return id2;
        }
        if (this.myOriginalHelper != null) {
            ElementIdentity ownerId = this.identify(owner);
            this.myOriginalHelper.pullFromOriginal(ownerId);
            id = this.findId(e);
            if (id != null) {
                Id<T> id3 = id;
                if (id3 == null) {
                    ElementOwnerImpl.$$$reportNull$$$0(23);
                }
                return id3;
            }
        }
        Id<T> id4 = this.createInlineId(owner, metaRef, e);
        if (id4 == null) {
            ElementOwnerImpl.$$$reportNull$$$0(24);
        }
        return id4;
    }

    @Override
    @NotNull
    public <E extends BasicElement> JBIterable<ElementIdentity<E>> getChildren(@NotNull ElementIdentity<?> identity, @NotNull BasicMetaObject<E> childMeta) {
        Id<?> id;
        if (identity == null) {
            ElementOwnerImpl.$$$reportNull$$$0(25);
        }
        if (childMeta == null) {
            ElementOwnerImpl.$$$reportNull$$$0(26);
        }
        if ((id = ElementMatcherImpl.asId(identity)) == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                ElementOwnerImpl.$$$reportNull$$$0(27);
            }
            return jBIterable;
        }
        this.fillChildrenCacheUsingOriginal(id, childMeta);
        JBIterable jBIterable = JBIterable.from(this.myMatcher.getCachedChildren(id)).filter(cId -> cId.getMetaObject() == childMeta && !this.isDropped((ElementIdentity<?>)cId) && this.findElement((ElementIdentity)cId) != null).filterMap(cId -> ElementIdentity.tryCast(cId, childMeta)).collect();
        if (jBIterable == null) {
            ElementOwnerImpl.$$$reportNull$$$0(28);
        }
        return jBIterable;
    }

    @Override
    @Nullable
    public ElementIdentity<?> getParent(@NotNull ElementIdentity<?> identity) {
        Id<?> id;
        if (identity == null) {
            ElementOwnerImpl.$$$reportNull$$$0(29);
        }
        return (id = ElementMatcherImpl.asId(identity)) == null ? null : id.getParentId();
    }

    private <P extends BasicElement, E extends BasicElement> void fillChildrenCacheUsingOriginal(@NotNull Id<P> identity, @NotNull BasicMetaObject<E> childMeta) {
        if (identity == null) {
            ElementOwnerImpl.$$$reportNull$$$0(30);
        }
        if (childMeta == null) {
            ElementOwnerImpl.$$$reportNull$$$0(31);
        }
        if (this.myOriginalHelper != null) {
            this.myOriginalHelper.getOriginalOwner().fillChildrenCacheUsingOriginal(identity, childMeta);
            return;
        }
        if (!identity.onPull(childMeta)) {
            return;
        }
        P original = this.findElement(identity);
        if (original == null) {
            return;
        }
        for (BasicElement child : this.myMatcher.getObjectChildren(original, identity, childMeta)) {
            if (child instanceof BasicDataObject) {
                ElementIdentity cId = this.create(identity, (BasicMetaObject)childMeta);
                this.addResolutionImpl((Id<E>)cId, (E)child);
                continue;
            }
            this.identify(child);
        }
    }

    @Override
    @Nullable
    public <E extends BasicElement> E findOrCreate(@NotNull ElementIdentity<E> identity) {
        Id<?> parentId;
        if (identity == null) {
            ElementOwnerImpl.$$$reportNull$$$0(32);
        }
        Id<E> id = ElementMatcherImpl.asId(identity);
        E res2 = this.find(identity);
        if (res2 != null) {
            return this.ensureMutable(id, res2);
        }
        Id<?> id2 = parentId = id == null ? null : id.getParentId();
        if (parentId == null) {
            return null;
        }
        Object parent = this.findOrCreate(parentId);
        return this.createObject(parentId, (BasicElement)parent, id);
    }

    @Nullable
    private <E extends BasicElement> E createObject(@NotNull Id<?> parentId, @Nullable BasicElement parent, @NotNull Id<E> id) {
        BasicModel model;
        if (parentId == null) {
            ElementOwnerImpl.$$$reportNull$$$0(33);
        }
        if (id == null) {
            ElementOwnerImpl.$$$reportNull$$$0(34);
        }
        if (parent instanceof BasicHierarchicalObject) {
            BasicHierarchicalObject h = (BasicHierarchicalObject)parent;
            v0 = h.getModel();
        } else {
            v0 = model = null;
        }
        if (model == null) {
            return this.createObjectImpl(parentId, parent, id);
        }
        Ref res2 = Ref.create();
        model.mod(r -> res2.set(this.createObjectImpl(parentId, parent, id)));
        return (E)((BasicElement)res2.get());
    }

    @Nullable
    private <E extends BasicElement> E createObjectImpl(@NotNull Id<?> parentId, @Nullable BasicElement parent, @NotNull Id<E> id) {
        E res2;
        BasicMetaReference<BasicElement, BasicElement> inlined2;
        if (parentId == null) {
            ElementOwnerImpl.$$$reportNull$$$0(35);
        }
        if (id == null) {
            ElementOwnerImpl.$$$reportNull$$$0(36);
        }
        if ((inlined2 = id.getInlined(parent)) != null) {
            res2 = id.getMetaObject().newDataObject();
            if (parent != null) {
                inlined2.set(parent, (BasicElement)((Object)BasicInlineObjectReference.createMutable(res2)));
            }
        } else {
            res2 = this.createObj(parentId, parent, id.getMetaObject());
        }
        if (res2 == null) {
            return null;
        }
        if (this.myOriginalHelper != null) {
            this.addResolution(id, res2);
        } else if (res2.getModel() == null) {
            this.addResolutionImpl(id, res2);
        }
        return res2;
    }

    @NotNull
    private <E extends BasicElement> E ensureMutable(@Nullable Id<E> id, @NotNull E element) {
        Id<?> parentId;
        if (element == null) {
            ElementOwnerImpl.$$$reportNull$$$0(37);
        }
        Id<?> id2 = parentId = id == null ? null : id.getParentId();
        if (parentId == null) {
            E e = element;
            if (e == null) {
                ElementOwnerImpl.$$$reportNull$$$0(38);
            }
            return e;
        }
        E replacement = this.ensureMutableImpl(id, element);
        if (replacement == element) {
            E e = element;
            if (e == null) {
                ElementOwnerImpl.$$$reportNull$$$0(39);
            }
            return e;
        }
        Object parent = this.findOrCreate(parentId);
        if (parent == null) {
            E e = replacement;
            if (e == null) {
                ElementOwnerImpl.$$$reportNull$$$0(40);
            }
            return e;
        }
        BasicMetaReference<?, ?> inlined2 = id.getInlined(parent);
        if (inlined2 != null) {
            inlined2.set(parent, BasicInlineObjectReference.createMutable(replacement));
        }
        E e = replacement;
        if (e == null) {
            ElementOwnerImpl.$$$reportNull$$$0(41);
        }
        return e;
    }

    private <E extends BasicElement> E ensureMutableImpl(@NotNull Id<E> id, @NotNull E element) {
        if (id == null) {
            ElementOwnerImpl.$$$reportNull$$$0(42);
        }
        if (element == null) {
            ElementOwnerImpl.$$$reportNull$$$0(43);
        }
        if (id.getInlined() == null) {
            return element;
        }
        BasicDataObject o = (BasicDataObject)ObjectUtils.tryCast(element, BasicDataObject.class);
        if (o == null || !o.isFrozen()) {
            return element;
        }
        BasicElement existing2 = (BasicElement)this.myRev.remove(id);
        if (existing2 == null) {
            return element;
        }
        BasicDataObject res2 = o.copy();
        return (E)(this.remap(id, element, res2) ? res2 : element);
    }

    @Override
    public boolean isDropped(@NotNull ElementIdentity<?> identity) {
        if (identity == null) {
            ElementOwnerImpl.$$$reportNull$$$0(44);
        }
        return this.myDrops.contains(identity);
    }

    @Override
    @Nullable
    public <E extends BasicElement> E find(@NotNull ElementIdentity<E> identity) {
        if (identity == null) {
            ElementOwnerImpl.$$$reportNull$$$0(45);
        }
        if (this.isDropped(identity)) {
            return null;
        }
        Id<E> id = ElementMatcherImpl.asId(identity);
        if (id == null) {
            return null;
        }
        E res2 = this.findElement(id);
        if (res2 == null && this.myOriginalHelper != null) {
            res2 = this.myOriginalHelper.pullFromOriginal(id);
        }
        return res2;
    }

    @Nullable
    private <E extends BasicElement> E createObj(Id<?> parentId, BasicElement parent, BasicMetaObject<E> meta) {
        return this.createObjMod(parentId, (BasicModElement)parent, meta);
    }

    @Nullable
    private <E extends BasicModElement> E createObjMod(Id<?> parentId, BasicModElement parent, BasicMetaObject<E> meta) {
        if (parent == null) {
            return null;
        }
        ModFamily family = (ModFamily)BasicMetaUtils.getFamily(parent, meta);
        if (family == null) {
            return (E)((BasicModElement)meta.newDataObject());
        }
        if (family.isEmpty() && meta.kindOf(BasicArrangedElement.class) && this.myOriginalHelper != null) {
            this.myOriginalHelper.fillFamilyUsingOriginal(parentId, meta, family);
        }
        return family.createNewOne();
    }

    @Override
    public <E extends BasicElement> void drop(@NotNull ElementIdentity<E> identity) {
        Id<E> id;
        if (identity == null) {
            ElementOwnerImpl.$$$reportNull$$$0(46);
        }
        if ((id = ElementMatcherImpl.asId(identity)) == null) {
            return;
        }
        E e = this.find(id);
        if (e != null) {
            if (id.getInlined() != null) {
                this.dropInlineRef(id);
            } else if (!(e instanceof BasicDataObject)) {
                ((BasicModElement)e).drop();
            }
        }
        this.myDrops.add(id);
    }

    private <E extends BasicElement> void dropInlineRef(Id<E> id) {
        Id<?> parentId = id.getParentId();
        this.dropInlineRef(parentId, id.getInlined());
    }

    private <S extends BasicElement, T extends BasicElement> void dropInlineRef(Id<S> parentId, BasicMetaReference<S, T> inlined2) {
        Object parent;
        Object e = parent = parentId == null ? null : (Object)this.find(parentId);
        if (parent != null) {
            inlined2.set(parent, null);
        }
    }

    @NotNull
    public <E extends BasicElement> Id<E> create(@Nullable ElementIdentity<?> parent, @NotNull BasicMetaObject<E> meta) {
        if (meta == null) {
            ElementOwnerImpl.$$$reportNull$$$0(47);
        }
        ElementIdentity elementIdentity = this.myMatcher.create((ElementIdentity)parent, (BasicMetaObject)meta);
        if (elementIdentity == null) {
            ElementOwnerImpl.$$$reportNull$$$0(48);
        }
        return elementIdentity;
    }

    @NotNull
    public <E extends BasicElement> Id<E> register(@Nullable ElementIdentity<?> parent, @NotNull E object) {
        BasicModModel model;
        BasicElement p2;
        if (object == null) {
            ElementOwnerImpl.$$$reportNull$$$0(49);
        }
        if ((p2 = object.getParent()) != null && p2 != this.findElement(parent)) {
            throw new AssertionError((Object)"Invalid parent provided");
        }
        ElementIdentity res2 = this.create((ElementIdentity)parent, (BasicMetaObject)BasicMetaUtils.getMetaObject(object));
        this.addResolutionImpl((Id<E>)res2, object);
        if (this.myOriginalHelper != null && (model = (BasicModModel)ObjectUtils.tryCast((Object)object.getModel(), BasicModModel.class)) != null) {
            BaseModel.setResolveAssistant(model, this.getResolveAssistant());
        }
        ElementIdentity elementIdentity = res2;
        if (elementIdentity == null) {
            ElementOwnerImpl.$$$reportNull$$$0(50);
        }
        return elementIdentity;
    }

    @Override
    @NotNull
    public ElementMatcher getMatcher() {
        ElementMatcherImpl elementMatcherImpl = this.myMatcher;
        if (elementMatcherImpl == null) {
            ElementOwnerImpl.$$$reportNull$$$0(51);
        }
        return elementMatcherImpl;
    }

    @Override
    @Nullable
    public ElementOwnerImpl getOriginal() {
        return this.myOriginalHelper == null ? null : this.myOriginalHelper.getOriginalOwner();
    }

    @Override
    @NotNull
    public BasicResolveAssistant getResolveAssistant() {
        BasicResolveAssistant basicResolveAssistant = this.myResolveAssistant;
        if (basicResolveAssistant == null) {
            ElementOwnerImpl.$$$reportNull$$$0(52);
        }
        return basicResolveAssistant;
    }

    @Override
    public void addListener(@NotNull ElementOwner.ElementListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            ElementOwnerImpl.$$$reportNull$$$0(53);
        }
        if (parent == null) {
            ElementOwnerImpl.$$$reportNull$$$0(54);
        }
        this.myDispatcher.addListener((EventListener)listener2, parent);
    }

    @Override
    @Nullable
    public <E extends BasicElement> E findElement(@Nullable ElementIdentity<E> id) {
        E res2 = this.findElementImpl(id);
        return ElementMatcherImpl.isNull(res2) ? null : (E)res2;
    }

    @Nullable
    <E extends BasicElement> E findElementImpl(@Nullable ElementIdentity<E> id) {
        BasicElement res2 = id == null ? null : (BasicElement)this.myRev.get(id);
        return res2 == null ? null : (E)id.getMetaObject().tryCast(res2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 17, 18, 22, 23, 24, 27, 28, 38, 39, 40, 41, 48, 50, 51, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 12: 
            case 14: 
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compute";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 48: 
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/owner/ElementOwnerImpl";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 34: 
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: 
            case 13: 
            case 25: 
            case 29: 
            case 30: 
            case 32: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 15: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaRef";
                break;
            }
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childMeta";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentId";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/owner/ElementOwnerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeIdIfAbsent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createInlineIdImpl";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "identify";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "identifyInlineRef";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureMutable";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "register";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatcher";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveAssistant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeIdIfAbsent";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 48: 
            case 50: 
            case 51: 
            case 52: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createId";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "remap";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addResolution";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addTargetImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addMatch";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addMatchAndPull";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findId";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "identify";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "identifyInlineRef";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "fillChildrenCacheUsingOriginal";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreate";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createObject";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createObjectImpl";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "ensureMutable";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "ensureMutableImpl";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isDropped";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 17, 18, 22, 23, 24, 27, 28, 38, 39, 40, 41, 48, 50, 51, 52 -> new IllegalStateException(string);
        };
    }
}

