/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.view.DataSourcePromoNotificationListener;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.PlatformUtils;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

final class DatabaseToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    DatabaseToolWindowFactory() {
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            DatabaseToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            DatabaseToolWindowFactory.$$$reportNull$$$0(1);
        }
        toolWindow.setToHideOnEmptyContent(true);
        DatabaseView view = DatabaseView.getDatabaseView(project);
        Content content = view.setupToolWindow((ToolWindowEx)toolWindow);
        ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
        ApplicationManager.getApplication().invokeLater(() -> DataSourcePromoNotificationListener.showPromoNotificationIfNeeded(project));
    }

    public void init(@NotNull ToolWindow window) {
        if (window == null) {
            DatabaseToolWindowFactory.$$$reportNull$$$0(2);
        }
        window.setStripeShortTitleProvider(DatabaseBundle.messagePointer("toolwindow.stripe.Database.shortName", new Object[0]));
        if (!PlatformUtils.isDataGrip()) {
            return;
        }
        Supplier<@Nls String> title = DatabaseBundle.messagePointer("toolwindow.stripe.Database.inDataGrip", new Object[0]);
        window.setTitle(title.get());
        window.setStripeTitleProvider(title);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/DatabaseToolWindowFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

