/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx.legacy;

import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import net.loomchild.segment.AbstractTextIterator;
import net.loomchild.segment.srx.LanguageRule;
import net.loomchild.segment.srx.Rule;
import net.loomchild.segment.srx.SrxDocument;
import net.loomchild.segment.util.Util;

public class ScannerSrxTextIterator
extends AbstractTextIterator {
    private Scanner scanner;
    private Map<Pattern, Pattern> exceptionMap;
    private boolean noBreakRules;

    public ScannerSrxTextIterator(SrxDocument document, String languageCode, String text2, Map<String, Object> parameterMap) {
        this(document, languageCode, new Scanner(text2));
    }

    public ScannerSrxTextIterator(SrxDocument document, String languageCode, Reader reader, Map<String, Object> parameterMap) {
        this(document, languageCode, new Scanner(reader));
    }

    private ScannerSrxTextIterator(SrxDocument document, String languageCode, Scanner scanner) {
        List<LanguageRule> languageRuleList = document.getLanguageRuleList(languageCode);
        String separator = this.createSeparator(languageRuleList);
        this.scanner = scanner;
        this.scanner.useDelimiter(Pattern.compile(separator));
        this.exceptionMap = this.createExceptions(languageRuleList);
    }

    private String createSeparator(List<LanguageRule> languageRuleList) {
        this.noBreakRules = true;
        StringBuilder separator = new StringBuilder();
        for (LanguageRule languageRule : languageRuleList) {
            for (Rule rule : languageRule.getRuleList()) {
                if (!rule.isBreak()) continue;
                String regex = this.createBreakRegexLookahead(rule);
                if (regex.length() > 0) {
                    separator.append(regex);
                    separator.append("|");
                }
                this.noBreakRules = false;
            }
        }
        if (separator.length() > 0) {
            separator.deleteCharAt(separator.length() - 1);
            return "(?=" + separator.toString() + ")";
        }
        return "";
    }

    private Map<Pattern, Pattern> createExceptions(List<LanguageRule> languageRuleList) {
        LinkedHashMap<Pattern, Pattern> result2 = new LinkedHashMap<Pattern, Pattern>();
        StringBuilder exception = null;
        for (LanguageRule languageRule : languageRuleList) {
            for (Rule rule : languageRule.getRuleList()) {
                if (rule.isBreak()) {
                    Pattern pattern = Pattern.compile(this.createBreakRegexNoLookahead(rule));
                    Pattern exceptionPattern = exception != null ? Pattern.compile(exception.toString()) : null;
                    result2.put(pattern, exceptionPattern);
                    continue;
                }
                if (exception == null) {
                    exception = new StringBuilder();
                } else if (exception.length() > 0) {
                    exception.append("|");
                }
                exception.append(this.createExceptionRegex(rule));
            }
        }
        return result2;
    }

    private String createBreakRegexLookahead(Rule rule) {
        StringBuilder regex = new StringBuilder();
        if (rule.getAfterPattern().length() > 0 || rule.getBeforePattern().length() > 0) {
            regex.append("(?:");
            if (rule.getBeforePattern().length() > 0) {
                regex.append(rule.getBeforePattern());
            }
            if (rule.getAfterPattern().length() > 0) {
                regex.append(rule.getAfterPattern());
            }
            regex.append(")");
        }
        return regex.toString();
    }

    private String createBreakRegexNoLookahead(Rule rule) {
        StringBuilder regex = new StringBuilder();
        if (rule.getAfterPattern().length() > 0 || rule.getBeforePattern().length() > 0) {
            regex.append("\\G(");
            if (rule.getBeforePattern().length() > 0) {
                regex.append(rule.getBeforePattern());
            }
            regex.append(")(?=");
            if (rule.getAfterPattern().length() > 0) {
                regex.append(rule.getAfterPattern());
            }
            regex.append(")");
        }
        return regex.toString();
    }

    private String createExceptionRegex(Rule rule) {
        StringBuilder regex = new StringBuilder();
        if (rule.getAfterPattern().length() > 0 || rule.getBeforePattern().length() > 0) {
            regex.append("(?:(?<=");
            if (rule.getBeforePattern().length() > 0) {
                regex.append(Util.finitize(rule.getBeforePattern(), 100));
            }
            regex.append(")\\G(?=");
            if (rule.getAfterPattern().length() > 0) {
                regex.append(rule.getAfterPattern());
            }
            regex.append("))");
        }
        return regex.toString();
    }

    @Override
    public boolean hasNext() {
        return this.scanner.hasNext();
    }

    @Override
    public String next() {
        StringBuilder segment = new StringBuilder();
        do {
            segment.append(this.scanner.next());
        } while (this.scanner.hasNext() && (this.noBreakRules || this.isException(segment)));
        return segment.toString();
    }

    private boolean isException(StringBuilder segment) {
        if (this.exceptionMap.size() > 0) {
            for (Map.Entry<Pattern, Pattern> entry2 : this.exceptionMap.entrySet()) {
                String result2 = this.scanner.findWithinHorizon(entry2.getKey(), 100);
                if (result2 == null) continue;
                segment.append(result2);
                Pattern pattern = entry2.getValue();
                if (pattern != null) {
                    return this.scanner.findWithinHorizon(pattern, 1) != null;
                }
                return false;
            }
            throw new IllegalStateException("No matching rule found.");
        }
        return false;
    }
}

