/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.theme.PlotTheme;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.util.Insets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/SingleTilePlotLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayout;", "tileLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayout;", "plotTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PlotTheme;", "(Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayout;Lorg/jetbrains/letsPlot/core/plot/base/theme/PlotTheme;)V", "insets", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/Insets;", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayoutInfo;", "preferredSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "layoutByGeomSize", "geomSize", "layoutOuterSize", "outerSize", "tileInfoToPlotInfo", "tileInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "plot-builder"})
public final class SingleTilePlotLayout
implements PlotLayout {
    @NotNull
    private final TileLayout tileLayout;
    @NotNull
    private final PlotTheme plotTheme;
    @NotNull
    private final Insets insets;

    public SingleTilePlotLayout(@NotNull TileLayout tileLayout, @NotNull PlotTheme plotTheme) {
        Intrinsics.checkNotNullParameter((Object)tileLayout, (String)"tileLayout");
        Intrinsics.checkNotNullParameter((Object)plotTheme, (String)"plotTheme");
        this.tileLayout = tileLayout;
        this.plotTheme = plotTheme;
        this.insets = PlotLayoutUtil.INSTANCE.plotInsets(this.plotTheme.plotInset());
    }

    @Override
    @NotNull
    public PlotLayoutInfo doLayout(@NotNull DoubleVector preferredSize, @NotNull CoordProvider coordProvider) {
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        return this.tileLayout.getInsideOut() ? this.layoutByGeomSize(preferredSize, coordProvider) : this.layoutOuterSize(preferredSize, coordProvider);
    }

    private final PlotLayoutInfo layoutOuterSize(DoubleVector outerSize, CoordProvider coordProvider) {
        Thickness plotMargins = this.plotTheme.plotMargins();
        DoubleVector tilePreferredSize = outerSize.subtract(this.insets.getLeftTop()).subtract(this.insets.getRightBottom()).subtract(new DoubleVector(plotMargins.getWidth(), plotMargins.getHeight()));
        TileLayoutInfo tileInfo = this.tileLayout.doLayout(tilePreferredSize, coordProvider).withOffset(this.insets.getLeftTop());
        return this.tileInfoToPlotInfo(tileInfo);
    }

    private final PlotLayoutInfo layoutByGeomSize(DoubleVector geomSize, CoordProvider coordProvider) {
        TileLayoutInfo tileInfo = this.tileLayout.doLayout(geomSize, coordProvider).withOffset(this.insets.getLeftTop()).withNormalizedOrigin();
        return this.tileInfoToPlotInfo(tileInfo);
    }

    private final PlotLayoutInfo tileInfoToPlotInfo(TileLayoutInfo tileInfo) {
        return new PlotLayoutInfo(CollectionsKt.listOf((Object)tileInfo), this.insets);
    }
}

