/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.pos;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.pos.CompositionPos;
import org.jetbrains.letsPlot.core.plot.base.pos.DodgePos;
import org.jetbrains.letsPlot.core.plot.base.pos.DodgeVPos;
import org.jetbrains.letsPlot.core.plot.base.pos.FillPos;
import org.jetbrains.letsPlot.core.plot.base.pos.JitterDodgePos;
import org.jetbrains.letsPlot.core.plot.base.pos.JitterPos;
import org.jetbrains.letsPlot.core.plot.base.pos.NudgePos;
import org.jetbrains.letsPlot.core.plot.base.pos.StackPos;
import org.jetbrains.letsPlot.core.plot.base.pos.StackingMode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J%\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u0011\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u0016\u001a\u00020\u0004J)\u0010\u0017\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJC\u0010\u001b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010 J%\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/pos/PositionAdjustments;", "", "()V", "composition", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "firstPos", "secondPos", "dodge", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "groupCount", "", "width", "", "(Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;ILjava/lang/Double;)Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "dodgev", "height", "fill", "vjust", "stackingMode", "Lorg/jetbrains/letsPlot/core/plot/base/pos/StackingMode;", "(Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;Ljava/lang/Double;Lorg/jetbrains/letsPlot/core/plot/base/pos/StackingMode;)Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "identity", "jitter", "seed", "", "(Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Long;)Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "jitterDodge", "jitterWidth", "jitterHeight", "(Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;ILjava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Long;)Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "nudge", "(Ljava/lang/Double;Ljava/lang/Double;)Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "stack", "aes", "Meta", "plot-base"})
public final class PositionAdjustments {
    @NotNull
    public static final PositionAdjustments INSTANCE = new PositionAdjustments();

    private PositionAdjustments() {
    }

    @NotNull
    public final PositionAdjustment identity() {
        return new PositionAdjustment(){

            public boolean isIdentity() {
                return true;
            }

            @NotNull
            public DoubleVector translate(@NotNull DoubleVector v, @NotNull DataPointAesthetics p, @NotNull GeomContext ctx2) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
                return v;
            }

            public boolean handlesGroups() {
                return Meta.IDENTITY.handlesGroups();
            }
        };
    }

    @NotNull
    public final PositionAdjustment dodge(@NotNull Aesthetics aesthetics2, int groupCount2, @Nullable Double width2) {
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        return new DodgePos(aesthetics2, groupCount2, width2);
    }

    @NotNull
    public final PositionAdjustment dodgev(@NotNull Aesthetics aesthetics2, int groupCount2, @Nullable Double height) {
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        return new DodgeVPos(aesthetics2, groupCount2, height);
    }

    @NotNull
    public final PositionAdjustment stack(@NotNull Aesthetics aes2, @Nullable Double vjust, @NotNull StackingMode stackingMode) {
        Intrinsics.checkNotNullParameter((Object)aes2, (String)"aes");
        Intrinsics.checkNotNullParameter((Object)((Object)stackingMode), (String)"stackingMode");
        return new StackPos(aes2, vjust, stackingMode);
    }

    @NotNull
    public final PositionAdjustment fill(@NotNull Aesthetics aesthetics2, @Nullable Double vjust, @NotNull StackingMode stackingMode) {
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)((Object)stackingMode), (String)"stackingMode");
        return new FillPos(aesthetics2, vjust, stackingMode);
    }

    @NotNull
    public final PositionAdjustment jitter(@Nullable Double width2, @Nullable Double height, @Nullable Long seed) {
        return new JitterPos(width2, height, seed);
    }

    @NotNull
    public final PositionAdjustment nudge(@Nullable Double width2, @Nullable Double height) {
        return new NudgePos(width2, height);
    }

    @NotNull
    public final PositionAdjustment jitterDodge(@NotNull Aesthetics aesthetics2, int groupCount2, @Nullable Double width2, @Nullable Double jitterWidth, @Nullable Double jitterHeight, @Nullable Long seed) {
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        return new JitterDodgePos(aesthetics2, groupCount2, width2, jitterWidth, jitterHeight, seed);
    }

    @NotNull
    public final PositionAdjustment composition(@NotNull PositionAdjustment firstPos, @NotNull PositionAdjustment secondPos) {
        Intrinsics.checkNotNullParameter((Object)firstPos, (String)"firstPos");
        Intrinsics.checkNotNullParameter((Object)secondPos, (String)"secondPos");
        return new CompositionPos(firstPos, secondPos);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/pos/PositionAdjustments$Meta;", "", "handlesGroups", "", "(Ljava/lang/String;IZ)V", "IDENTITY", "DODGE", "STACK", "FILL", "JITTER", "NUDGE", "JITTER_DODGE", "plot-base"})
    public static final class Meta
    extends Enum<Meta> {
        private final boolean handlesGroups;
        public static final /* enum */ Meta IDENTITY = new Meta(false);
        public static final /* enum */ Meta DODGE = new Meta(true);
        public static final /* enum */ Meta STACK = new Meta(true);
        public static final /* enum */ Meta FILL = new Meta(true);
        public static final /* enum */ Meta JITTER = new Meta(false);
        public static final /* enum */ Meta NUDGE = new Meta(false);
        public static final /* enum */ Meta JITTER_DODGE = new Meta(true);
        private static final /* synthetic */ Meta[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Meta(boolean handlesGroups) {
            this.handlesGroups = handlesGroups;
        }

        public final boolean handlesGroups() {
            return this.handlesGroups;
        }

        public static Meta[] values() {
            return (Meta[])$VALUES.clone();
        }

        public static Meta valueOf(String value) {
            return Enum.valueOf(Meta.class, value);
        }

        @NotNull
        public static EnumEntries<Meta> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = metaArray = new Meta[]{Meta.IDENTITY, Meta.DODGE, Meta.STACK, Meta.FILL, Meta.JITTER, Meta.NUDGE, Meta.JITTER_DODGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

