/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.frontend.shelf.tree;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.platform.vcs.impl.frontend.VcsFrontendBundle;
import com.intellij.platform.vcs.impl.frontend.changes.UtilKt;
import com.intellij.platform.vcs.impl.frontend.shelf.tree.ChangesBrowserNodeRenderer;
import com.intellij.platform.vcs.impl.frontend.shelf.tree.EntityChangesBrowserNode;
import com.intellij.platform.vcs.impl.shared.rhizome.NodeEntity;
import com.intellij.platform.vcs.impl.shared.rhizome.ShelvedChangeEntity;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.PathUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u000f\u0010\u0010\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b\u0012H\u0016R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/vcs/impl/frontend/shelf/tree/ShelvedChangeNode;", "Lcom/intellij/platform/vcs/impl/frontend/shelf/tree/EntityChangesBrowserNode;", "Lcom/intellij/platform/vcs/impl/shared/rhizome/ShelvedChangeEntity;", "entity", "<init>", "(Lcom/intellij/platform/vcs/impl/shared/rhizome/ShelvedChangeEntity;)V", "getEntity", "()Lcom/intellij/platform/vcs/impl/shared/rhizome/ShelvedChangeEntity;", "render", "", "renderer", "Lcom/intellij/platform/vcs/impl/frontend/shelf/tree/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "doGetTextPresentation", "", "Lorg/jetbrains/annotations/Nls;", "intellij.platform.vcs.impl.frontend"})
@ApiStatus.Internal
public final class ShelvedChangeNode
extends EntityChangesBrowserNode<ShelvedChangeEntity> {
    @NotNull
    private final ShelvedChangeEntity entity;

    public ShelvedChangeNode(@NotNull ShelvedChangeEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super((NodeEntity)entity);
        this.entity = entity;
    }

    @NotNull
    public final ShelvedChangeEntity getEntity() {
        return this.entity;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderer), (String)"renderer");
        String path = this.entity.getFilePath();
        String directory = StringUtil.defaultIfEmpty((String)PathUtil.getParentPath((String)path), (String)VcsFrontendBundle.message("shelve.default.path.rendering", new Object[0]));
        String fileName = StringUtil.defaultIfEmpty((String)PathUtil.getFileName((String)path), (String)path);
        FileStatus fileStatus = UtilKt.findFileStatusById(this.entity.getFileStatus());
        if (fileStatus == null) {
            fileStatus = FileStatus.MODIFIED;
        }
        FileStatus fileStatus2 = fileStatus;
        renderer.append(fileName, new SimpleTextAttributes(0, fileStatus2.getColor()));
        if (this.entity.getAdditionalText() != null) {
            renderer.append(FontUtil.spaceAndThinSpace() + this.entity.getAdditionalText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (renderer.isShowFlatten()) {
            renderer.append(FontUtil.spaceAndThinSpace() + FileUtil.toSystemDependentName((String)directory), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        renderer.setIcon(FileTypeManager.getInstance().getFileTypeByFileName(fileName).getIcon());
    }

    @Override
    @Nullable
    public String doGetTextPresentation() {
        return PathUtil.getFileName((String)((ShelvedChangeEntity)this.getUserObject()).getFilePath());
    }
}

