/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.javascript.karma.KarmaConfig;
import com.intellij.javascript.karma.coverage.KarmaCoveragePeer;
import com.intellij.javascript.karma.execution.KarmaServerSettings;
import com.intellij.javascript.karma.server.KarmaJsSourcesLocator;
import com.intellij.javascript.karma.server.KarmaProcessOutputManager;
import com.intellij.javascript.karma.server.KarmaServerRegistry;
import com.intellij.javascript.karma.server.KarmaServerRestarter;
import com.intellij.javascript.karma.server.KarmaServerState;
import com.intellij.javascript.karma.server.KarmaServerTerminatedListener;
import com.intellij.javascript.karma.server.StreamEventHandler;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.javascript.karma.util.StreamEventListener;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KarmaServer {
    private static final Logger LOG = Logger.getInstance(KarmaServer.class);
    private final KarmaProcessOutputManager myProcessOutputManager;
    private final KarmaServerState myState;
    private final KarmaCoveragePeer myCoveragePeer;
    private final KarmaServerSettings myServerSettings;
    private final ConsoleCommandLineFolder myCommandLineFolder;
    private List<Runnable> myOnPortBoundCallbacks;
    private List<Runnable> myOnBrowsersReadyCallbacks;
    private Integer myExitCode;
    private final List<KarmaServerTerminatedListener> myTerminationCallbacks;
    private final Map<String, StreamEventHandler> myHandlers;
    private final MyDisposable myDisposable;
    private final KarmaServerRestarter myRestarter;
    private final int myProcessHashCode;
    private final NodeTargetRun myTargetRun;

    public KarmaServer(@NotNull Project project, @NotNull KarmaServerSettings serverSettings) throws IOException {
        if (project == null) {
            KarmaServer.$$$reportNull$$$0(0);
        }
        if (serverSettings == null) {
            KarmaServer.$$$reportNull$$$0(1);
        }
        this.myCommandLineFolder = new ConsoleCommandLineFolder(new String[0]);
        this.myOnPortBoundCallbacks = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myOnBrowsersReadyCallbacks = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myExitCode = null;
        this.myTerminationCallbacks = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myHandlers = new ConcurrentHashMap<String, StreamEventHandler>();
        this.myServerSettings = serverSettings;
        this.myCoveragePeer = serverSettings.isWithCoverage() ? new KarmaCoveragePeer() : null;
        KillableProcessHandler processHandler = KarmaServer.startServer(project, serverSettings, this.myCoveragePeer, this.myCommandLineFolder);
        this.myTargetRun = NodeTargetRun.getTargetRun((ProcessHandler)processHandler);
        this.myProcessHashCode = System.identityHashCode(processHandler.getProcess());
        String configurationFilePath = this.myServerSettings.getConfigurationFilePath();
        this.myState = new KarmaServerState(this, configurationFilePath, this.myServerSettings.getWorkingDirectorySystemDependent());
        this.myProcessOutputManager = new KarmaProcessOutputManager((ProcessHandler)processHandler, (Consumer<? super String>)((Consumer)this.myState::onStandardOutputLineAvailable));
        this.registerStreamEventHandlers();
        this.myProcessOutputManager.startNotify();
        this.myDisposable = new MyDisposable();
        Disposer.register((Disposable)KarmaServerRegistry.getInstance(project), (Disposable)this.myDisposable);
        this.myRestarter = new KarmaServerRestarter(configurationFilePath, this.myDisposable);
        final int processHashCode = System.identityHashCode(processHandler.getProcess());
        LOG.info("Karma server " + processHashCode + " started successfully: " + processHandler.getCommandLineForLog());
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                LOG.info("Karma server " + processHashCode + " terminated with exit code " + event.getExitCode());
                Disposer.dispose((Disposable)KarmaServer.this.myDisposable);
                KarmaServer.this.fireOnTerminated(event.getExitCode());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/karma/server/KarmaServer$1", "processTerminated"));
            }
        });
    }

    private void registerStreamEventHandlers() {
        if (this.myCoveragePeer != null) {
            this.myCoveragePeer.registerEventHandlers(this);
        }
        this.myProcessOutputManager.addStreamEventListener(new StreamEventListener(){

            @Override
            public void on(@NotNull String eventType, @NotNull String eventBody) {
                JsonElement jsonElement;
                if (eventType == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (eventBody == null) {
                    2.$$$reportNull$$$0(1);
                }
                LOG.info("Processing Karma event " + eventType + " " + eventBody);
                try {
                    jsonElement = JsonParser.parseString((String)eventBody);
                }
                catch (Exception e) {
                    LOG.warn("Cannot parse message from karma server: (eventType: " + eventType + ", eventBody: " + eventBody + ")");
                    return;
                }
                StreamEventHandler handler = KarmaServer.this.myHandlers.get(eventType);
                if (handler != null) {
                    handler.handle(jsonElement);
                } else {
                    LOG.warn("Cannot find handler for " + eventType);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "eventType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "eventBody";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/karma/server/KarmaServer$2";
                objectArray[2] = "on";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public KarmaServerSettings getServerSettings() {
        KarmaServerSettings karmaServerSettings = this.myServerSettings;
        if (karmaServerSettings == null) {
            KarmaServer.$$$reportNull$$$0(2);
        }
        return karmaServerSettings;
    }

    @NotNull
    public KarmaServerRestarter getRestarter() {
        KarmaServerRestarter karmaServerRestarter = this.myRestarter;
        if (karmaServerRestarter == null) {
            KarmaServer.$$$reportNull$$$0(3);
        }
        return karmaServerRestarter;
    }

    @Nullable
    public KarmaCoveragePeer getCoveragePeer() {
        return this.myCoveragePeer;
    }

    public void registerStreamEventHandler(@NotNull StreamEventHandler handler) {
        if (handler == null) {
            KarmaServer.$$$reportNull$$$0(4);
        }
        this.myHandlers.put(handler.getEventType(), handler);
    }

    @NotNull
    public ConsoleCommandLineFolder getCommandLineFolder() {
        ConsoleCommandLineFolder consoleCommandLineFolder = this.myCommandLineFolder;
        if (consoleCommandLineFolder == null) {
            KarmaServer.$$$reportNull$$$0(5);
        }
        return consoleCommandLineFolder;
    }

    @NotNull
    public NodeTargetRun getTargetRun() {
        NodeTargetRun nodeTargetRun = this.myTargetRun;
        if (nodeTargetRun == null) {
            KarmaServer.$$$reportNull$$$0(6);
        }
        return nodeTargetRun;
    }

    @NotNull
    private static KillableProcessHandler startServer(@NotNull Project project, @NotNull KarmaServerSettings serverSettings, @Nullable KarmaCoveragePeer coveragePeer, @NotNull ConsoleCommandLineFolder commandLineFolder) throws IOException {
        KillableProcessHandler processHandler;
        NodeTargetRun targetRun;
        if (project == null) {
            KarmaServer.$$$reportNull$$$0(7);
        }
        if (serverSettings == null) {
            KarmaServer.$$$reportNull$$$0(8);
        }
        if (commandLineFolder == null) {
            KarmaServer.$$$reportNull$$$0(9);
        }
        try {
            targetRun = KarmaServer.createTargetRun(project, serverSettings, coveragePeer, commandLineFolder);
        }
        catch (ExecutionException e) {
            throw new IOException("Cannot create command line", e);
        }
        try {
            processHandler = targetRun.startProcessEx().getProcessHandler();
        }
        catch (ExecutionException e) {
            throw new IOException("Cannot start Karma server", e);
        }
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        KillableProcessHandler killableProcessHandler = processHandler;
        if (killableProcessHandler == null) {
            KarmaServer.$$$reportNull$$$0(10);
        }
        return killableProcessHandler;
    }

    @NotNull
    private static NodeTargetRun createTargetRun(@NotNull Project project, @NotNull KarmaServerSettings serverSettings, @Nullable KarmaCoveragePeer coveragePeer, @NotNull ConsoleCommandLineFolder commandLineFolder) throws IOException, ExecutionException {
        if (project == null) {
            KarmaServer.$$$reportNull$$$0(11);
        }
        if (serverSettings == null) {
            KarmaServer.$$$reportNull$$$0(12);
        }
        if (commandLineFolder == null) {
            KarmaServer.$$$reportNull$$$0(13);
        }
        NodeTargetRun targetRun = new NodeTargetRun(serverSettings.getNodeInterpreter(), project, null, NodeTargetRunOptions.of((Boolean)false, (RunConfigurationBase)serverSettings.getRunConfiguration()));
        targetRun.setEnvData(serverSettings.getEnvData());
        TargetedCommandLineBuilder commandLine = targetRun.getCommandLineBuilder();
        commandLine.setWorkingDirectory(targetRun.path(serverSettings.getWorkingDirectorySystemDependent()));
        commandLine.setRedirectErrorStream(true);
        targetRun.addNodeOptionsWithExpandedMacros(false, serverSettings.getNodeOptions());
        if (Boolean.parseBoolean((String)serverSettings.getEnvData().getEnvs().get("KARMA_SERVER_WITH_INSPECT_BRK"))) {
            targetRun.addNodeOptionsWithExpandedMacros(false, "--inspect-brk=34598");
        }
        NodePackage pkg = serverSettings.getKarmaPackage();
        String configurationFilePath = serverSettings.getConfigurationFilePath();
        String userConfigFileName = PathUtil.getFileName((String)configurationFilePath);
        targetRun.path(KarmaJsSourcesLocator.getInstance().getKarmaIntellijPackageDir());
        boolean angularCli = KarmaUtil.isAngularCliPkg(pkg);
        if (angularCli) {
            if (pkg instanceof YarnPnpNodePackage) {
                ((YarnPnpNodePackage)pkg).addYarnRunToCommandLine(targetRun, null, true);
            } else {
                Path ngBinFile = KarmaServer.findPackageBinFile(pkg, project, targetRun.getInterpreter(), "@angular/cli", "ng", "./bin/ng.js");
                commandLine.addParameter(targetRun.path(ngBinFile));
            }
            commandLine.addParameter("test");
            commandLineFolder.addPlaceholderTexts(new String[]{"ng", "test"});
            Path configFile = KarmaJsSourcesLocator.getInstance().getIntellijConfigFile();
            SemVer version = pkg.getVersion();
            if (version == null || version.isGreaterOrEqualThan(6, 0, 0)) {
                String projectName = serverSettings.getAngularProjectName();
                if (projectName != null) {
                    commandLine.addParameter(projectName);
                    commandLineFolder.addPlaceholderText(projectName);
                }
                commandLine.addParameter("--karma-config");
                commandLine.addParameter(targetRun.path(configFile));
                commandLineFolder.addPlaceholderText("--karma-config=" + userConfigFileName);
                commandLine.addParameter("--source-map");
            } else {
                commandLine.addParameter("--config");
                commandLine.addParameter(targetRun.path(configFile));
                commandLineFolder.addPlaceholderText("--config=" + userConfigFileName);
            }
        } else if (KarmaUtil.isNxPkg(pkg)) {
            if (pkg instanceof YarnPnpNodePackage) {
                ((YarnPnpNodePackage)pkg).addYarnRunToCommandLine(targetRun, null, true);
            } else {
                Path nxBinFile = KarmaServer.findPackageBinFile(pkg, project, targetRun.getInterpreter(), "nx", "nx", "./bin/nx.js");
                commandLine.addParameter(targetRun.path(nxBinFile));
            }
            commandLine.addParameter("test");
            commandLineFolder.addPlaceholderTexts(new String[]{"nx", "test"});
            String projectName = serverSettings.getNxProjectName();
            if (projectName != null) {
                commandLine.addParameter(projectName);
                commandLineFolder.addPlaceholderText(projectName);
            }
            commandLine.addParameter("--karmaConfig");
            Path configFile = KarmaJsSourcesLocator.getInstance().getIntellijConfigFile();
            commandLine.addParameter(targetRun.path(configFile));
        } else {
            if (pkg instanceof YarnPnpNodePackage) {
                ((YarnPnpNodePackage)pkg).addYarnRunToCommandLine(targetRun, null, true);
            } else {
                Path karmaBinFile = KarmaServer.findPackageBinFile(pkg, project, targetRun.getInterpreter(), "karma", "karma", "./bin/karma");
                commandLine.addParameter(targetRun.path(karmaBinFile));
            }
            commandLine.addParameter("start");
            commandLine.addParameter(targetRun.path(KarmaJsSourcesLocator.getInstance().getIntellijConfigFile()));
            commandLineFolder.addPlaceholderTexts(new String[]{"karma", "start", userConfigFileName});
        }
        List karmaOptions = ParametersListUtil.parse((String)serverSettings.getKarmaOptions());
        commandLine.addParameters(karmaOptions);
        commandLineFolder.addPlaceholderTexts(karmaOptions);
        KarmaServer.setIntellijParameter(commandLine, "user_config", (TargetValue<String>)(configurationFilePath.isEmpty() ? TargetValue.fixed((Object)"") : targetRun.path(configurationFilePath)));
        if (coveragePeer != null) {
            KarmaServer.setIntellijParameter(commandLine, "coverage_temp_dir", (TargetValue<String>)targetRun.path(coveragePeer.getCoverageTempDir()));
            if (angularCli) {
                commandLine.addParameter("--code-coverage");
                commandLineFolder.addPlaceholderText("--code-coverage");
            }
        }
        if (serverSettings.isDebug()) {
            KarmaServer.setIntellijParameter(commandLine, "debug", (TargetValue<String>)TargetValue.fixed((Object)"true"));
        }
        NodeTargetRun nodeTargetRun = targetRun;
        if (nodeTargetRun == null) {
            KarmaServer.$$$reportNull$$$0(14);
        }
        return nodeTargetRun;
    }

    @NotNull
    private static Path findPackageBinFile(@NotNull NodePackage pkg, @NotNull Project project, @NotNull NodeJsInterpreter interpreter, @NlsSafe @NotNull String packageName, @NotNull String executableName, @Nullable String failoverBinRelativePath) throws ExecutionException {
        String error;
        if (pkg == null) {
            KarmaServer.$$$reportNull$$$0(15);
        }
        if (project == null) {
            KarmaServer.$$$reportNull$$$0(16);
        }
        if (interpreter == null) {
            KarmaServer.$$$reportNull$$$0(17);
        }
        if (packageName == null) {
            KarmaServer.$$$reportNull$$$0(18);
        }
        if (executableName == null) {
            KarmaServer.$$$reportNull$$$0(19);
        }
        if ((error = pkg.validateAndGetErrorMessage(packageName, project, interpreter)) != null) {
            throw new ExecutionException(error);
        }
        Path binFile = pkg.findBinFilePath(executableName, failoverBinRelativePath, interpreter);
        if (binFile == null) {
            throw new ExecutionException(JavaScriptBundle.message((String)"node.package.cannot.find.bin.file.dialog.message", (Object[])new Object[]{packageName}));
        }
        Path path = binFile;
        if (path == null) {
            KarmaServer.$$$reportNull$$$0(20);
        }
        return path;
    }

    private static void setIntellijParameter(@NotNull TargetedCommandLineBuilder commandLine, @NotNull String name, @NotNull TargetValue<String> value) {
        if (commandLine == null) {
            KarmaServer.$$$reportNull$$$0(21);
        }
        if (name == null) {
            KarmaServer.$$$reportNull$$$0(22);
        }
        if (value == null) {
            KarmaServer.$$$reportNull$$$0(23);
        }
        commandLine.addEnvironmentVariable("_INTELLIJ_KARMA_INTERNAL_PARAMETER_" + name, value);
    }

    public void shutdownAsync() {
        LOG.info("Shutting down asynchronously Karma server " + this.myProcessHashCode);
        ApplicationManager.getApplication().executeOnPooledThread(this::shutdown);
    }

    private void shutdown() {
        ProcessHandler processHandler = this.myProcessOutputManager.getProcessHandler();
        if (!processHandler.isProcessTerminated()) {
            ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)processHandler, (long)1000L, null);
        }
    }

    @NotNull
    public KarmaProcessOutputManager getProcessOutputManager() {
        KarmaProcessOutputManager karmaProcessOutputManager = this.myProcessOutputManager;
        if (karmaProcessOutputManager == null) {
            KarmaServer.$$$reportNull$$$0(24);
        }
        return karmaProcessOutputManager;
    }

    public boolean isPortBound() {
        return this.myState.getServerPort() != -1;
    }

    public int getServerPort() {
        return this.myState.getServerPort();
    }

    public void onPortBound(@NotNull Runnable callback) {
        if (callback == null) {
            KarmaServer.$$$reportNull$$$0(25);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myOnPortBoundCallbacks != null) {
                this.myOnPortBoundCallbacks.add(callback);
            } else {
                callback.run();
            }
        });
    }

    void fireOnPortBound() {
        UIUtil.invokeLaterIfNeeded(() -> {
            ArrayList<Runnable> callbacks = new ArrayList<Runnable>(this.myOnPortBoundCallbacks);
            this.myOnPortBoundCallbacks.clear();
            this.myOnPortBoundCallbacks = null;
            for (Runnable callback : callbacks) {
                callback.run();
            }
        });
    }

    public boolean areBrowsersReady() {
        return this.myState.areBrowsersReady();
    }

    public void onBrowsersReady(@NotNull Runnable callback) {
        if (callback == null) {
            KarmaServer.$$$reportNull$$$0(26);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myOnBrowsersReadyCallbacks != null) {
                this.myOnBrowsersReadyCallbacks.add(callback);
            } else {
                callback.run();
            }
        });
    }

    void fireOnBrowsersReady(boolean browsersReady) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (browsersReady) {
                ArrayList<Runnable> callbacks = new ArrayList<Runnable>(this.myOnBrowsersReadyCallbacks);
                this.myOnBrowsersReadyCallbacks.clear();
                this.myOnBrowsersReadyCallbacks = null;
                for (Runnable callback : callbacks) {
                    callback.run();
                }
            } else {
                this.myOnBrowsersReadyCallbacks = ContainerUtil.createLockFreeCopyOnWriteList();
            }
        });
    }

    public void onTerminated(@NotNull KarmaServerTerminatedListener terminationCallback) {
        if (terminationCallback == null) {
            KarmaServer.$$$reportNull$$$0(27);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myExitCode != null) {
                terminationCallback.onTerminated(this.myExitCode);
            } else {
                this.myTerminationCallbacks.add(terminationCallback);
            }
        });
    }

    public void removeTerminatedListener(@NotNull KarmaServerTerminatedListener listener) {
        if (listener == null) {
            KarmaServer.$$$reportNull$$$0(28);
        }
        UIUtil.invokeLaterIfNeeded(() -> this.myTerminationCallbacks.remove(listener));
    }

    private void fireOnTerminated(int exitCode) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myExitCode = exitCode;
            ArrayList<KarmaServerTerminatedListener> listeners = new ArrayList<KarmaServerTerminatedListener>(this.myTerminationCallbacks);
            this.myTerminationCallbacks.clear();
            for (KarmaServerTerminatedListener listener : listeners) {
                listener.onTerminated(exitCode);
            }
        });
    }

    @Nullable
    public KarmaConfig getKarmaConfig() {
        return this.myState.getKarmaConfig();
    }

    @NotNull
    public String formatUrlWithoutUrlRoot(@NotNull String path) {
        if (path == null) {
            KarmaServer.$$$reportNull$$$0(29);
        }
        return this.formatUrl(path, false);
    }

    @NotNull
    public String formatUrl(@NotNull String path) {
        if (path == null) {
            KarmaServer.$$$reportNull$$$0(30);
        }
        return this.formatUrl(path, true);
    }

    @NotNull
    private String formatUrl(@NotNull String path, boolean withUrlRoot) {
        KarmaConfig config;
        if (path == null) {
            KarmaServer.$$$reportNull$$$0(31);
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if ((config = this.myState.getKarmaConfig()) != null) {
            String baseUrl = config.getProtocol() + "//" + config.getHostname() + ":" + this.getServerPort();
            String urlRoot = config.getUrlRoot();
            if (!withUrlRoot || "/".equals(urlRoot)) {
                String string = baseUrl + (String)path;
                if (string == null) {
                    KarmaServer.$$$reportNull$$$0(32);
                }
                return string;
            }
            String string = baseUrl + config.getUrlRoot() + (String)path;
            if (string == null) {
                KarmaServer.$$$reportNull$$$0(33);
            }
            return string;
        }
        LOG.error("Karma config not ready");
        String string = "http://localhost:" + this.getServerPort() + (String)path;
        if (string == null) {
            KarmaServer.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessOutputManager.getProcessHandler();
        if (processHandler == null) {
            KarmaServer.$$$reportNull$$$0(35);
        }
        return processHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 10, 14, 20, 24, 32, 33, 34, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverSettings";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 20: 
            case 24: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/server/KarmaServer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineFolder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminationCallback";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/server/KarmaServer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestarter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineFolder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetRun";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "startServer";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetRun";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findPackageBinFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutputManager";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "formatUrl";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 20: 
            case 24: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerStreamEventHandler";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startServer";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTargetRun";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findPackageBinFile";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setIntellijParameter";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "onPortBound";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "onBrowsersReady";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "onTerminated";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeTerminatedListener";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "formatUrlWithoutUrlRoot";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "formatUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 10, 14, 20, 24, 32, 33, 34, 35 -> new IllegalStateException(string);
        };
    }

    private class MyDisposable
    implements Disposable {
        private final Runnable myRunnable = ConcurrencyUtil.once(() -> {
            LOG.info("Disposing Karma server " + KarmaServer.this.myProcessHashCode);
            if (KarmaServer.this.myCoveragePeer != null) {
                try {
                    NioFiles.deleteRecursively((Path)KarmaServer.this.myCoveragePeer.getCoverageTempDir());
                }
                catch (IOException e) {
                    LOG.warn("Failed to delete " + String.valueOf(KarmaServer.this.myCoveragePeer.getCoverageTempDir()), (Throwable)e);
                }
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (KarmaServer.this.myOnPortBoundCallbacks != null) {
                    KarmaServer.this.myOnPortBoundCallbacks.clear();
                }
                if (KarmaServer.this.myOnBrowsersReadyCallbacks != null) {
                    KarmaServer.this.myOnBrowsersReadyCallbacks.clear();
                }
            });
            KarmaServer.this.shutdownAsync();
        });

        private MyDisposable() {
        }

        public void dispose() {
            this.myRunnable.run();
        }
    }
}

