/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.dataflow.scope;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.ast.PyAstAnnotation;
import com.jetbrains.python.ast.PyAstClass;
import com.jetbrains.python.ast.PyAstDecorator;
import com.jetbrains.python.ast.PyAstDecoratorList;
import com.jetbrains.python.ast.PyAstElement;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstExpressionCodeFragment;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstNamedParameter;
import com.jetbrains.python.ast.PyAstTypeParameterList;
import com.jetbrains.python.ast.controlFlow.AstScopeOwner;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class ScopeUtilCore {
    @Nullable
    public static AstScopeOwner getScopeOwner(@Nullable PsiElement element) {
        StubBasedPsiElement stubBasedElement;
        StubElement stub;
        if (element == null) {
            return null;
        }
        if (element instanceof PyAstExpressionCodeFragment) {
            PsiElement context = element.getContext();
            return context instanceof AstScopeOwner ? (AstScopeOwner)context : ScopeUtilCore.getScopeOwner(context);
        }
        if (element instanceof StubBasedPsiElement && (stub = (stubBasedElement = (StubBasedPsiElement)element).getStub()) != null) {
            AstScopeOwner nextOwner;
            AstScopeOwner firstOwner = (AstScopeOwner)stub.getParentStubOfType(AstScopeOwner.class);
            if (firstOwner != null && !(firstOwner instanceof PsiFile)) {
                StubElement firstOwnerStub = ((StubBasedPsiElementBase)firstOwner).getGreenStub();
                assert (firstOwnerStub != null);
                nextOwner = (AstScopeOwner)firstOwnerStub.getParentStubOfType(AstScopeOwner.class);
            } else {
                nextOwner = null;
            }
            if (stub.getParentStubOfType(PyAstDecoratorList.class) != null) {
                return nextOwner;
            }
            return firstOwner;
        }
        return (AstScopeOwner)CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create((Object)ScopeUtilCore.calculateScopeOwnerByAST(element), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private static AstScopeOwner calculateScopeOwnerByAST(@Nullable PsiElement element) {
        PyAstFunction function;
        PyAstTypeParameterList typeParameterList;
        PyAstClass containingClass;
        AstScopeOwner firstOwner = (AstScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)element, AstScopeOwner.class);
        if (firstOwner == null) {
            return null;
        }
        AstScopeOwner nextOwner = (AstScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)firstOwner, AstScopeOwner.class);
        PyAstElement decoratorAncestor = (PyAstElement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAstDecorator.class, (boolean)false);
        if (decoratorAncestor != null && !PsiTreeUtil.isAncestor((PsiElement)decoratorAncestor, (PsiElement)firstOwner, (boolean)true)) {
            return nextOwner;
        }
        PyAstNamedParameter parameterAncestor = (PyAstNamedParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PyAstNamedParameter.class, (boolean)false);
        if (parameterAncestor != null && !PsiTreeUtil.isAncestor((PsiElement)parameterAncestor, (PsiElement)firstOwner, (boolean)true)) {
            PyAstFunction function2;
            PyAstTypeParameterList typeParameterList2;
            PyAstExpression defaultValue = parameterAncestor.getDefaultValue();
            PyAstAnnotation annotation = parameterAncestor.getAnnotation();
            if (firstOwner instanceof PyAstFunction && ((typeParameterList2 = (function2 = (PyAstFunction)firstOwner).getTypeParameterList()) == null && PsiTreeUtil.isAncestor((PsiElement)annotation, (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)defaultValue, (PsiElement)element, (boolean)false))) {
                return nextOwner;
            }
        }
        if ((containingClass = (PyAstClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyAstClass.class)) != null && PsiTreeUtil.isAncestor((PsiElement)containingClass.getSuperClassExpressionList(), (PsiElement)element, (boolean)false) && containingClass.getTypeParameterList() == null) {
            return nextOwner;
        }
        if (firstOwner instanceof PyAstFunction && ((typeParameterList = (function = (PyAstFunction)firstOwner).getTypeParameterList()) == null && PsiTreeUtil.isAncestor((PsiElement)function.getAnnotation(), (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)function.getTypeComment(), (PsiElement)element, (boolean)false))) {
            return nextOwner;
        }
        return firstOwner;
    }
}

