/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.uv;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.python.pyproject.PyProjectExtKt;
import com.intellij.python.pyproject.PyProjectToml;
import com.intellij.python.pyproject.PyProjectToolFactory;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.Result;
import com.jetbrains.python.packaging.common.PythonOutdatedPackage;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.requirements.psi.NameReq;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.uv.UvExtKt;
import com.jetbrains.python.sdk.uv.UvPackageManager;
import com.jetbrains.python.sdk.uv.UvPyProject;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.tuweni.toml.TomlParseError;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/sdk/uv/UvPackageVersionsInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "UvFileVisitor", "intellij.python.community.impl"})
@ApiStatus.Internal
public final class UvPackageVersionsInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new UvFileVisitor(holder, session);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0003J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000bH\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/sdk/uv/UvPackageVersionsInspection$UvFileVisitor;", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "guessModule", "Lcom/intellij/openapi/module/Module;", "element", "Lcom/intellij/psi/PsiElement;", "pyProjectTomlBlocking", "Lcom/intellij/openapi/vfs/VirtualFile;", "visitFile", "", "file", "Lcom/intellij/psi/PsiFile;", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nUvInspections.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UvInspections.kt\ncom/jetbrains/python/sdk/uv/UvPackageVersionsInspection$UvFileVisitor\n+ 2 Result.kt\ncom/jetbrains/python/Result\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n58#2,3:85\n1863#3:88\n1863#3:89\n1863#3,2:90\n1864#3:92\n1864#3:93\n*S KotlinDebug\n*F\n+ 1 UvInspections.kt\ncom/jetbrains/python/sdk/uv/UvPackageVersionsInspection$UvFileVisitor\n*L\n58#1:85,3\n62#1:88\n67#1:89\n68#1:90,2\n67#1:92\n62#1:93\n*E\n"})
    public static final class UvFileVisitor
    extends PsiElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public UvFileVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @RequiresBackgroundThread
        private final Module guessModule(PsiElement element) {
            return ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        }

        @RequiresBackgroundThread
        private final VirtualFile pyProjectTomlBlocking(Module $this$pyProjectTomlBlocking) {
            return BasePySdkExtKt.findAmongRoots($this$pyProjectTomlBlocking, "pyproject.toml");
        }

        /*
         * WARNING - void declaration
         */
        @RequiresBackgroundThread
        public void visitFile(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Module module = this.guessModule((PsiElement)file);
            if (module == null) {
                return;
            }
            Module module2 = module;
            Sdk sdk2 = PythonSdkUtil.findPythonSdk(module2);
            if (sdk2 == null) {
                return;
            }
            Sdk sdk3 = sdk2;
            if (!(UvExtKt.isUv(sdk3) && Intrinsics.areEqual((Object)file.getName(), (Object)"pyproject.toml") && Intrinsics.areEqual((Object)file.getVirtualFile(), (Object)this.pyProjectTomlBlocking(module2)))) {
                return;
            }
            InputStream inputStream = file.getVirtualFile().getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            Result<PyProjectToml, List<TomlParseError>> this_$iv = PyProjectToml.Companion.parse(inputStream);
            boolean $i$f$getOr = false;
            Result<PyProjectToml, List<TomlParseError>> result2 = this_$iv;
            if (result2 instanceof Result.Failure) {
                Result.Failure it = (Result.Failure)this_$iv;
                boolean bl = false;
                return;
            }
            if (!(result2 instanceof Result.Success)) {
                throw new NoWhenBranchMatchedException();
            }
            PyProjectToml pyProject = (PyProjectToml)((Result.Success)this_$iv).getResult();
            UvPyProject uvTool = (UvPyProject)pyProject.getTool((PyProjectToolFactory)UvPyProject.Companion);
            Project project = module2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PythonPackageManager it = PythonPackageManager.Companion.forSdk(project, sdk3);
            Object object = it instanceof UvPackageManager ? (UvPackageManager)it : null;
            if (object == null || (object = ((UvPackageManager)object).getOutdatedPackages()) == null) {
                return;
            }
            Object outdatedPackages = object;
            Iterable $this$forEach$iv = uvTool.matchOutdatedPackages(module2, pyProject, (Map<String, ? extends PythonOutdatedPackage>)outdatedPackages);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                NameReq pyReq = (NameReq)element$iv;
                boolean bl = false;
                Object object2 = new PsiElement[3];
                PsiElement psiElement = PyProjectExtKt.findTomlHeader((PsiElement)file, "project");
                object2[0] = psiElement != null ? PyProjectExtKt.findTomlValueByKey(psiElement, "dependencies") : null;
                PsiElement psiElement2 = PyProjectExtKt.findTomlHeader((PsiElement)file, "dependency-groups");
                object2[1] = psiElement2 != null ? PyProjectExtKt.findTomlValueByKey(psiElement2, "dev") : null;
                PsiElement psiElement3 = PyProjectExtKt.findTomlHeader((PsiElement)file, "tool.uv");
                object2[2] = psiElement3 != null ? PyProjectExtKt.findTomlValueByKey(psiElement3, "dev-dependencies") : null;
                object2 = CollectionsKt.listOfNotNull((Object[])object2);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    PsiElement psiArray = (PsiElement)element$iv2;
                    boolean bl2 = false;
                    Iterable $this$forEach$iv3 = PyProjectExtKt.findTomlLiteralsContaining(psiArray, pyReq.getDisplayName());
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        PsiElement psiLiteral = (PsiElement)element$iv3;
                        boolean bl3 = false;
                        Object[] objectArray = new Object[3];
                        objectArray[0] = pyReq.getDisplayName();
                        Object v = outdatedPackages.get(pyReq.getDisplayName());
                        Intrinsics.checkNotNull(v);
                        objectArray[1] = ((PythonOutdatedPackage)v).getVersion();
                        Object v2 = outdatedPackages.get(pyReq.getDisplayName());
                        Intrinsics.checkNotNull(v2);
                        objectArray[2] = ((PythonOutdatedPackage)v2).getLatestVersion();
                        this.holder.registerProblem(psiLiteral, PyBundle.message("python.sdk.inspection.message.version.outdated.latest", objectArray), ProblemHighlightType.WARNING, new LocalQuickFix[0]);
                    }
                }
            }
        }
    }
}

