/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.requirement;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.ast.PyAstImportElement;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibUtil;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.IgnoreRequirementFix;
import com.jetbrains.python.inspections.quickfix.PyGenerateRequirementsFileQuickFix;
import com.jetbrains.python.inspections.quickfix.PyInstallRequirementsFix;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageNameNormalizeUtilKt;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PySdkProvider;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\b\u0007\u0018\u0000 B2\u00020\u0001:\u0001BB'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0019H\u0016J.\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\fH\u0002J<\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001c2\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u001bH\u0002J\u0018\u0010%\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020#0\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010#2\u0006\u0010(\u001a\u00020\u0006H\u0002J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020\u0006H\u0002J\u0016\u0010.\u001a\u00020 2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bH\u0002J&\u00100\u001a\u00020 2\u0006\u0010-\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u00062\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0005H\u0002J\u0018\u00103\u001a\u00020 2\u0006\u00104\u001a\u0002052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u00106\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\f2\u0006\u00107\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u00108\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J8\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001c0\f2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u001b2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00052\f\u0010=\u001a\b\u0012\u0004\u0012\u00020<0>H\u0002J\u0010\u0010?\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010@\u001a\u0004\u0018\u00010#*\u00020\u001c2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020#0\u0005H\u0002J\u0018\u0010A\u001a\b\u0012\u0004\u0012\u00020<0\u001b*\b\u0012\u0004\u0012\u00020#0\u001bH\u0002R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/jetbrains/python/inspections/requirement/PyRequirementVisitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "ignoredPackages", "", "", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Ljava/util/Collection;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "myIgnoredPackages", "", "visitPyFile", "", "node", "Lcom/jetbrains/python/psi/PyFile;", "checkPackagesHaveBeenInstalled", "file", "Lcom/intellij/psi/PsiElement;", "module", "Lcom/intellij/openapi/module/Module;", "visitPyFromImportStatement", "Lcom/jetbrains/python/psi/PyFromImportStatement;", "visitPyImportStatement", "Lcom/jetbrains/python/psi/PyImportStatement;", "findUnsatisfiedRequirements", "", "Lcom/jetbrains/python/packaging/PyRequirement;", "manager", "Lcom/jetbrains/python/packaging/management/PythonPackageManager;", "isRequirementUnsatisfied", "", "requirement", "installedPackages", "Lcom/jetbrains/python/packaging/common/PythonPackage;", "modulePackages", "getRequirements", "collectPackagesInModule", "parsePackageNameAndVersion", "nameWithoutExtension", "checkPackageNameInRequirements", "importedExpression", "Lcom/jetbrains/python/psi/PyQualifiedExpression;", "isIgnoredOrStandardPackage", "packageName", "isPackageInPyPI", "packageNames", "isPackageSatisfied", "possiblePyPIPackageNames", "requirements", "isLocalModule", "packageReferenceExpression", "Lcom/jetbrains/python/psi/PyExpression;", "getRequirementsInclTransitive", "packageManager", "getListedRequirements", "getExtrasRequirements", "getTransitiveRequirements", "packages", "Lcom/jetbrains/python/packaging/PyPackage;", "visited", "", "isRunningPackagingTasks", "match", "toPyPackages", "Companion", "intellij.python.community.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPyRequirementVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyRequirementVisitor.kt\ncom/jetbrains/python/inspections/requirement/PyRequirementVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,257:1\n1#2:258\n1#2:276\n1#2:304\n1628#3,3:259\n1863#3,2:279\n774#3:281\n865#3,2:282\n1557#3:284\n1628#3,3:285\n1368#3:288\n1454#3,2:289\n1611#3,9:294\n1863#3:303\n1864#3:305\n1620#3:306\n1456#3,3:307\n1755#3,3:310\n1755#3,3:313\n1557#3:316\n1628#3,3:317\n1557#3:320\n1628#3,3:321\n295#3:324\n1734#3,3:325\n296#3:328\n1557#3:329\n1628#3,3:330\n37#4:262\n36#4,3:263\n11476#5,9:266\n13402#5:275\n13403#5:277\n11485#5:278\n3829#5:291\n4344#5,2:292\n*S KotlinDebug\n*F\n+ 1 PyRequirementVisitor.kt\ncom/jetbrains/python/inspections/requirement/PyRequirementVisitor\n*L\n82#1:276\n122#1:304\n65#1:259,3\n82#1:279,2\n94#1:281\n94#1:282,2\n105#1:284\n105#1:285,3\n119#1:288\n119#1:289,2\n122#1:294,9\n122#1:303\n122#1:305\n122#1:306\n119#1:307,3\n134#1:310,3\n171#1:313,3\n178#1:316\n178#1:317,3\n179#1:320\n179#1:321,3\n241#1:324\n243#1:325,3\n241#1:328\n247#1:329\n247#1:330,3\n73#1:262\n73#1:263,3\n82#1:266,9\n82#1:275\n82#1:277\n82#1:278\n120#1:291\n120#1:292,2\n*E\n"})
public final class PyRequirementVisitor
extends PyInspectionVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Set<String> myIgnoredPackages;
    @NotNull
    private static final String PACKAGE_NOT_LISTED = "INSP.requirements.package.containing.module.not.listed.in.project.requirements";
    @NotNull
    private static final String REQUIREMENT_NOT_SATISFIED = "INSP.requirements.package.requirements.not.satisfied";
    @NotNull
    private static final Set<String> METADATA_EXTENSIONS;
    @NotNull
    private static final String EMPTY_STRING = "";

    public PyRequirementVisitor(@Nullable ProblemsHolder holder, @NotNull Collection<String> ignoredPackages, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter(ignoredPackages, (String)"ignoredPackages");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(holder, context);
        this.myIgnoredPackages = CollectionsKt.toSet((Iterable)ignoredPackages);
    }

    @Override
    public void visitPyFile(@NotNull PyFile node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)node));
        if (module == null) {
            return;
        }
        Module module2 = module;
        this.checkPackagesHaveBeenInstalled((PsiElement)node, module2);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkPackagesHaveBeenInstalled(PsiElement file, Module module) {
        void destination$iv;
        void $this$mapTo$iv;
        List<PyRequirement> unsatisfied;
        List<PyRequirement> list;
        List<PyRequirement> list2;
        if (this.isRunningPackagingTasks(module)) {
            return;
        }
        Sdk sdk2 = PythonSdkUtil.findPythonSdk(module);
        if (sdk2 == null) {
            return;
        }
        Sdk sdk3 = sdk2;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PythonPackageManager manager = PythonPackageManager.Companion.forSdk(project, sdk3);
        Set<String> set = this.myIgnoredPackages;
        if (set != null) {
            Set<String> it = set;
            boolean bl = false;
            list2 = this.findUnsatisfiedRequirements(module, manager, it);
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        if ((unsatisfied = list).isEmpty()) {
            return;
        }
        String string = PyPackageUtil.requirementsToString(unsatisfied);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"requirementsToString(...)");
        String requirementsList = string;
        Object object = new Object[]{requirementsList, unsatisfied.size()};
        String string2 = PyPsiBundle.message(REQUIREMENT_NOT_SATISFIED, (Object[])object);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String message = string2;
        Object $this$checkPackagesHaveBeenInstalled_u24lambda_u243 = object = (List)new ArrayList();
        boolean bl = false;
        LocalQuickFix providedFix = (LocalQuickFix)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)PySdkProvider.EP_NAME.getExtensionList()), arg_0 -> PyRequirementVisitor.checkPackagesHaveBeenInstalled$lambda$3$lambda$1(module, arg_0)));
        LocalQuickFix localQuickFix = providedFix;
        if (localQuickFix == null) {
            localQuickFix = new PyInstallRequirementsFix(null, module, sdk3, unsatisfied, null, null, 48, null);
        }
        $this$checkPackagesHaveBeenInstalled_u24lambda_u243.add(localQuickFix);
        Iterable iterable = unsatisfied;
        Collection collection = new LinkedHashSet();
        Object object2 = $this$checkPackagesHaveBeenInstalled_u24lambda_u243;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            PyRequirement pyRequirement = (PyRequirement)item$iv;
            void var20_21 = destination$iv;
            boolean bl2 = false;
            String string3 = it.getPresentableTextWithoutVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPresentableTextWithoutVersion(...)");
            var20_21.add(string3);
        }
        Set set2 = (Set)destination$iv;
        object2.add(new IgnoreRequirementFix(set2));
        Object quickFixes = object;
        Collection $this$toTypedArray$iv = (Collection)quickFixes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        object = thisCollection$iv.toArray(new LocalQuickFix[0]);
        this.registerProblem(file, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, (LocalQuickFix[])Arrays.copyOf(object, ((Object)object).length));
    }

    @Override
    public void visitPyFromImportStatement(@NotNull PyFromImportStatement node) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PyReferenceExpression pyReferenceExpression = node.getImportSource();
            if (pyReferenceExpression == null) break block0;
            PyReferenceExpression it = pyReferenceExpression;
            boolean bl = false;
            this.checkPackageNameInRequirements(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitPyImportStatement(@NotNull PyImportStatement node) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PyAstImportElement[] pyAstImportElementArray = node.getImportElements();
        Intrinsics.checkNotNullExpressionValue((Object)pyAstImportElementArray, (String)"getImportElements(...)");
        Object[] $this$mapNotNull$iv = pyAstImportElementArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PyReferenceExpression it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            PyImportElement it = (PyImportElement)element$iv$iv;
            boolean bl2 = false;
            if (it.getImportReferenceExpression() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            PyReferenceExpression it = (PyReferenceExpression)element$iv;
            boolean bl = false;
            this.checkPackageNameInRequirements(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<PyRequirement> findUnsatisfiedRequirements(Module module, PythonPackageManager manager, Set<String> ignoredPackages) {
        void $this$filterTo$iv$iv;
        List<PyRequirement> list = this.getRequirements(module);
        if (list == null) {
            return CollectionsKt.emptyList();
        }
        List<PyRequirement> requirements = list;
        List<PythonPackage> installedPackages = manager.getInstalledPackages();
        List<PythonPackage> modulePackages = this.collectPackagesInModule(module);
        Iterable $this$filter$iv = requirements;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PyRequirement requirement = (PyRequirement)element$iv$iv;
            boolean bl = false;
            if (!this.isRequirementUnsatisfied(requirement, ignoredPackages, installedPackages, modulePackages)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isRequirementUnsatisfied(PyRequirement requirement, Set<String> ignoredPackages, List<? extends PythonPackage> installedPackages, List<? extends PythonPackage> modulePackages) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ignoredPackages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it;
            if (string2 == null) {
                string2 = EMPTY_STRING;
            }
            collection.add(PyPackageNameNormalizeUtilKt.normalizePackageName(string2));
        }
        if (((List)destination$iv$iv).contains(requirement.getName())) {
            return false;
        }
        boolean isSatisfiedInInstalled = this.match(requirement, (Collection<? extends PythonPackage>)installedPackages) != null;
        boolean isSatisfiedInModule = this.match(requirement, (Collection<? extends PythonPackage>)modulePackages) != null;
        return !isSatisfiedInInstalled && !isSatisfiedInModule;
    }

    private final List<PyRequirement> getRequirements(Module module) {
        List<PyRequirement> list = PyPackageUtil.getRequirementsFromTxt(module);
        if (list == null) {
            list = PyPackageUtil.findSetupPyRequires(module);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PythonPackage> collectPackagesInModule(Module module) {
        void $this$flatMapTo$iv$iv;
        Collection<VirtualFile> collection = PyUtil.getSourceRoots(module);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getSourceRoots(...)");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            VirtualFile srcRoot = (VirtualFile)element$iv$iv;
            boolean bl = false;
            VirtualFile[] virtualFileArray = VfsUtil.getChildren((VirtualFile)srcRoot);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            Object $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv2 : $this$filterTo$iv$iv) {
                VirtualFile file = (VirtualFile)element$iv$iv2;
                boolean bl2 = false;
                if (!CollectionsKt.contains((Iterable)METADATA_EXTENSIONS, (Object)file.getExtension())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PythonPackage it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv3 = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                VirtualFile metadataFile = (VirtualFile)element$iv$iv3;
                boolean bl4 = false;
                String string = metadataFile.getNameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
                if (this.parsePackageNameAndVersion(string) == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final PythonPackage parsePackageNameAndVersion(String nameWithoutExtension) {
        String[] components = Companion.splitNameIntoComponents(nameWithoutExtension);
        return components.length >= 2 ? new PythonPackage(components[0], components[1], false) : null;
    }

    private final void checkPackageNameInRequirements(PyQualifiedExpression importedExpression) {
        Object element$iv2;
        boolean bl;
        block11: {
            Iterable $this$any$iv = PyInspectionExtension.EP_NAME.getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    PyInspectionExtension it = (PyInspectionExtension)element$iv2;
                    boolean bl2 = false;
                    if (!it.ignorePackageNameInRequirements(importedExpression)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        PyExpression pyExpression = PyPsiUtils.getFirstQualifier(importedExpression);
        Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"getFirstQualifier(...)");
        PyExpression packageReferenceExpression = pyExpression;
        String string = packageReferenceExpression.getName();
        if (string == null) {
            return;
        }
        String packageName = string;
        if (this.isIgnoredOrStandardPackage(packageName)) {
            return;
        }
        String possiblePyPIPackageNames = PyPsiPackageUtil.INSTANCE.moduleToPackageName(packageName, EMPTY_STRING);
        if (!ApplicationManager.getApplication().isUnitTestMode() && !this.isPackageInPyPI(CollectionsKt.listOf(element$iv2 = new String[]{packageName, possiblePyPIPackageNames}))) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)packageReferenceExpression));
        if (module == null) {
            return;
        }
        Module module2 = module;
        Sdk sdk2 = PythonSdkUtil.findPythonSdk(module2);
        if (sdk2 == null) {
            return;
        }
        Sdk sdk3 = sdk2;
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PythonPackageManager packageManager = PythonPackageManager.Companion.forSdk(project, sdk3);
        Set<PyRequirement> requirements = this.getRequirementsInclTransitive(packageManager, module2);
        if (requirements == null) {
            return;
        }
        if (this.isPackageSatisfied(packageName, possiblePyPIPackageNames, (Collection<? extends PyRequirement>)requirements) || this.isLocalModule(packageReferenceExpression, module2)) {
            return;
        }
        Object[] objectArray = new Object[]{packageName};
        String string2 = PyPsiBundle.message(PACKAGE_NOT_LISTED, objectArray);
        objectArray = new LocalQuickFix[]{new PyGenerateRequirementsFileQuickFix(module2), new IgnoreRequirementFix(SetsKt.setOf((Object)packageName))};
        this.registerProblem((PsiElement)packageReferenceExpression, string2, ProblemHighlightType.WEAK_WARNING, null, (LocalQuickFix[])objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIgnoredOrStandardPackage(String packageName) {
        boolean bl;
        Set<String> set = this.myIgnoredPackages;
        if (set != null) {
            if (set.contains(packageName)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (Intrinsics.areEqual((Object)packageName, (Object)"setuptools")) return true;
        Collection<String> collection = PyStdlibUtil.getPackages();
        if (collection == null) return false;
        if (!collection.contains(packageName)) return false;
        return true;
    }

    private final boolean isPackageInPyPI(List<String> packageNames) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = packageNames;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!PyPIPackageUtil.INSTANCE.isInPyPI(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPackageSatisfied(String packageName, String possiblePyPIPackageNames, Collection<? extends PyRequirement> requirements) {
        PyRequirement it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = requirements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PyRequirement pyRequirement = (PyRequirement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        if (((List)destination$iv$iv).contains(PyPackageNameNormalizeUtilKt.normalizePackageName(packageName))) return true;
        $this$map$iv = requirements;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PyRequirement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        if (!((List)destination$iv$iv).contains(PyPackageNameNormalizeUtilKt.normalizePackageName(possiblePyPIPackageNames))) return false;
        return true;
    }

    private final boolean isLocalModule(PyExpression packageReferenceExpression, Module module) {
        PsiReference psiReference = packageReferenceExpression.getReference();
        if (psiReference == null) {
            return false;
        }
        PsiReference reference = psiReference;
        PsiElement psiElement = reference.resolve();
        if (psiElement == null) {
            return false;
        }
        PsiElement element = psiElement;
        if (element instanceof PsiDirectory) {
            return ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)((PsiDirectory)element).getVirtualFile(), (boolean)false);
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile file = psiFile;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        return ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)virtualFile2, (boolean)false);
    }

    private final Set<PyRequirement> getRequirementsInclTransitive(PythonPackageManager packageManager, Module module) {
        Set<PyRequirement> requirements = this.getListedRequirements(module);
        if (requirements == null) {
            return null;
        }
        List<PythonPackage> packages2 = packageManager.getInstalledPackages();
        return SetsKt.plus(this.getTransitiveRequirements(this.toPyPackages(packages2), (Collection<? extends PyRequirement>)requirements, new HashSet()), (Iterable)requirements);
    }

    private final Set<PyRequirement> getListedRequirements(Module module) {
        List<PyRequirement> list = this.getRequirements(module);
        if (list == null) {
            return null;
        }
        List<PyRequirement> requirements = list;
        List<PyRequirement> extrasRequirements = this.getExtrasRequirements(module);
        return CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)requirements, (Iterable)extrasRequirements));
    }

    private final List<PyRequirement> getExtrasRequirements(Module module) {
        Collection<List<PyRequirement>> collection;
        Map<String, List<PyRequirement>> map2 = PyPackageUtil.findSetupPyExtrasRequire(module);
        List list = map2 != null && (collection = map2.values()) != null ? CollectionsKt.flatten((Iterable)collection) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final Set<PyRequirement> getTransitiveRequirements(List<PyPackage> packages2, Collection<? extends PyRequirement> requirements, Set<PyPackage> visited) {
        Set result2 = new HashSet();
        for (PyRequirement pyRequirement : requirements) {
            PyPackage myPackage = pyRequirement.match((Collection<? extends PyPackage>)packages2);
            if (myPackage == null || !visited.add(myPackage)) continue;
            List<PyRequirement> list = myPackage.getRequirements();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getRequirements(...)");
            result2.addAll((Collection)this.getTransitiveRequirements(packages2, (Collection<? extends PyRequirement>)list, visited));
        }
        return result2;
    }

    private final boolean isRunningPackagingTasks(Module module) {
        Boolean value = (Boolean)module.getUserData(PythonPackageManager.Companion.getRUNNING_PACKAGING_TASKS());
        return value != null && value != false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final PythonPackage match(PyRequirement $this$match, Collection<? extends PythonPackage> packages2) {
        Object element$iv;
        Object v0;
        boolean bl;
        Iterable $this$firstOrNull$iv = packages2;
        boolean $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator.hasNext()) {
                v0 = null;
                return v0;
            }
            element$iv = iterator.next();
            PythonPackage pkg = (PythonPackage)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)$this$match.getName(), (Object)pkg.getName())) {
                boolean bl3;
                block7: {
                    List<PyRequirementVersionSpec> list = $this$match.getVersionSpecs();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getVersionSpecs(...)");
                    Iterable $this$all$iv = list;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            PyRequirementVersionSpec it = (PyRequirementVersionSpec)element$iv2;
                            boolean bl4 = false;
                            if (it.matches(pkg.getVersion())) continue;
                            bl3 = false;
                            break block7;
                        }
                        bl3 = true;
                    }
                }
                if (bl3) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v0 = element$iv;
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PyPackage> toPyPackages(List<? extends PythonPackage> $this$toPyPackages) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toPyPackages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PythonPackage pythonPackage = (PythonPackage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PyPackage(it.getName(), it.getVersion()));
        }
        return (List)destination$iv$iv;
    }

    private static final LocalQuickFix checkPackagesHaveBeenInstalled$lambda$3$lambda$1(Module $module, PySdkProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.createInstallPackagesQuickFix($module);
    }

    static {
        Object[] objectArray = new String[]{"egg-info", "dist-info"};
        METADATA_EXTENSIONS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/inspections/requirement/PyRequirementVisitor$Companion;", "", "<init>", "()V", "PACKAGE_NOT_LISTED", "", "REQUIREMENT_NOT_SATISFIED", "METADATA_EXTENSIONS", "", "EMPTY_STRING", "splitNameIntoComponents", "", "name", "(Ljava/lang/String;)[Ljava/lang/String;", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nPyRequirementVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyRequirementVisitor.kt\ncom/jetbrains/python/inspections/requirement/PyRequirementVisitor$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,257:1\n37#2:258\n36#2,3:259\n*S KotlinDebug\n*F\n+ 1 PyRequirementVisitor.kt\ncom/jetbrains/python/inspections/requirement/PyRequirementVisitor$Companion\n*L\n255#1:258\n255#1:259,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] splitNameIntoComponents(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            CharSequence charSequence = name2;
            Regex regex = new Regex("-");
            int n = 3;
            Collection $this$toTypedArray$iv = regex.split(charSequence, n);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new String[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

