/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookSchema;
import com.intellij.jupyter.core.jupyter.nbformat.schema.JupyterNotebookSchemaVersion;
import com.intellij.jupyter.core.jupyter.nbformat.schema.JupyterNotebookSchemaVersionKt;
import com.intellij.jupyter.core.jupyter.nbformat.schema.v3.V3JupyterNotebookSchema;
import com.intellij.jupyter.core.jupyter.nbformat.schema.v4.V4JupyterNotebookSchema;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000fR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookSchemaFactory;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "VERSION_FIELD_NAME", "", "MINOR_VERSION_FIELD_NAME", "createSchema", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookSchema;", "content", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getSchemaVersion", "Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookSchemaVersion;", "version", "intellij.jupyter.core"})
public final class JupyterNotebookSchemaFactory {
    @NotNull
    public static final JupyterNotebookSchemaFactory INSTANCE = new JupyterNotebookSchemaFactory();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String VERSION_FIELD_NAME = "nbformat";
    @NotNull
    private static final String MINOR_VERSION_FIELD_NAME = "nbformat_minor";

    private JupyterNotebookSchemaFactory() {
    }

    @NotNull
    public final JupyterNotebookSchema createSchema(@NotNull ObjectNode content) {
        JupyterNotebookSchema jupyterNotebookSchema;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        JupyterNotebookSchemaVersion schemaVersion = JupyterNotebookSchemaFactory.getSchemaVersion(content);
        if (schemaVersion != null) {
            jupyterNotebookSchema = this.createSchema(schemaVersion);
        } else {
            LOG.warn("Can't retrieve notebook version from the content. Using the default schema.");
            jupyterNotebookSchema = this.createSchema(JupyterNotebookSchemaVersionKt.getJUPYTER_NOTEBOOK_SCHEMA_VERSION_4_5());
        }
        return jupyterNotebookSchema;
    }

    @JvmStatic
    private static final JupyterNotebookSchemaVersion getSchemaVersion(ObjectNode content) {
        JsonNode jsonNode = content.get(VERSION_FIELD_NAME);
        Integer version = jsonNode != null ? Integer.valueOf(jsonNode.asInt()) : null;
        JsonNode jsonNode2 = content.get(MINOR_VERSION_FIELD_NAME);
        Integer minorVersion = jsonNode2 != null ? Integer.valueOf(jsonNode2.asInt()) : null;
        JupyterNotebookSchemaVersion schemaVersion = version != null && minorVersion != null ? new JupyterNotebookSchemaVersion(version, minorVersion) : null;
        return schemaVersion;
    }

    @NotNull
    public final JupyterNotebookSchema createSchema(@NotNull JupyterNotebookSchemaVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (version.getMajor() < 3) {
            LOG.warn("Undefined notebook version encountered: " + version);
        }
        return switch (version.getMajor()) {
            case 3 -> new V3JupyterNotebookSchema(version);
            case 4 -> {
                int var2_2 = version.getMinor();
                yield new V4JupyterNotebookSchema(version, 0 <= var2_2 ? var2_2 < 6 : false);
            }
            default -> new V4JupyterNotebookSchema(version, false);
        };
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

