/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.toolwindow;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.clones.configuration.DuplicatesBundle;
import com.jetbrains.clones.structures.TextFragment;
import com.jetbrains.clones.toolwindow.DiffController;
import com.jetbrains.clones.toolwindow.DuplicateInfo;
import com.jetbrains.clones.toolwindow.DuplicateNavigator;
import com.jetbrains.clones.toolwindow.RowPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001aH\u0002J\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\u0010\u0010 \u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/clones/toolwindow/DuplicatesList;", "Lcom/intellij/ui/components/JBList;", "Lcom/jetbrains/clones/toolwindow/DuplicateInfo;", "Lcom/intellij/openapi/Disposable;", "duplicates", "", "Lcom/jetbrains/clones/structures/TextFragment;", "diffController", "Lcom/jetbrains/clones/toolwindow/DiffController;", "<init>", "(Ljava/util/List;Lcom/jetbrains/clones/toolwindow/DiffController;)V", "rowPanel", "Lcom/jetbrains/clones/toolwindow/RowPanel;", "mouseRow", "", "Ljava/lang/Integer;", "mouseRowPosition", "Ljava/awt/Point;", "mainFragmentHighlighter", "Lcom/jetbrains/clones/toolwindow/DuplicateNavigator;", "navigatedFragmentHighlighter", "createDuplicateInfo", "duplicate", "showFullPath", "", "getRelativePath", "", "basePath", "path", "getRowPosition", "point", "row", "getCellRenderer", "Ljavax/swing/ListCellRenderer;", "dispose", "", "intellij.platform.duplicatesDetector"})
@SourceDebugExtension(value={"SMAP\nDuplicatesList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicatesList.kt\ncom/jetbrains/clones/toolwindow/DuplicatesList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1663#2,8:214\n1663#2,8:222\n1611#2,9:230\n1863#2:239\n1864#2:241\n1620#2:242\n1#3:240\n1#3:243\n*S KotlinDebug\n*F\n+ 1 DuplicatesList.kt\ncom/jetbrains/clones/toolwindow/DuplicatesList\n*L\n97#1:214,8\n98#1:222,8\n100#1:230,9\n100#1:239\n100#1:241\n100#1:242\n100#1:240\n*E\n"})
public final class DuplicatesList
extends JBList<DuplicateInfo>
implements Disposable {
    @NotNull
    private final DiffController diffController;
    @NotNull
    private final RowPanel rowPanel;
    @Nullable
    private Integer mouseRow;
    @Nullable
    private Point mouseRowPosition;
    @NotNull
    private final DuplicateNavigator mainFragmentHighlighter;
    @NotNull
    private final DuplicateNavigator navigatedFragmentHighlighter;

    /*
     * WARNING - void declaration
     */
    public DuplicatesList(@NotNull List<TextFragment> duplicates, @NotNull DiffController diffController) {
        void $this$mapNotNullTo$iv$iv;
        Object e$iv2;
        Intrinsics.checkNotNullParameter(duplicates, (String)"duplicates");
        Intrinsics.checkNotNullParameter((Object)diffController, (String)"diffController");
        this.diffController = diffController;
        this.rowPanel = new RowPanel();
        this.mainFragmentHighlighter = new DuplicateNavigator(this.diffController.getProject());
        this.navigatedFragmentHighlighter = new DuplicateNavigator(this.diffController.getProject());
        Iterable $this$distinctBy$iv = duplicates;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv2 : $this$distinctBy$iv) {
            TextFragment textFragment = (TextFragment)e$iv2;
            boolean bl = false;
            String key$iv = textFragment.getFile().getPath();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv2);
        }
        int uniqueFiles = ((Collection)list$iv).size();
        Iterable $this$distinctBy$iv2 = duplicates;
        boolean $i$f$distinctBy2 = false;
        HashSet<String> set$iv2 = new HashSet<String>();
        ArrayList list$iv2 = new ArrayList();
        for (Object e$iv3 : $this$distinctBy$iv2) {
            TextFragment textFragment = (TextFragment)e$iv3;
            boolean bl = false;
            String key$iv = textFragment.getFile().getPresentableName();
            if (!set$iv2.add(key$iv)) continue;
            list$iv2.add(e$iv3);
        }
        int uniqueNames = ((Collection)list$iv2).size();
        boolean showFullPath = uniqueFiles != uniqueNames;
        Iterable $this$mapNotNull$iv = duplicates;
        boolean $i$f$mapNotNull = false;
        e$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DuplicateInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TextFragment textFragment = (TextFragment)element$iv$iv;
            boolean bl2 = false;
            if (this.createDuplicateInfo(textFragment, showFullPath) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List duplicateInfos = (List)destination$iv$iv;
        this.setModel(JBList.createDefaultListModel((Iterable)duplicateInfos));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int row = this.locationToIndex(e.getPoint());
                if (e.getClickCount() == 2) {
                    navigatedFragmentHighlighter.highlightAndNavigate(((DuplicateInfo)this.getModel().getElementAt(row)).getRange());
                } else {
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                    Point rowPosition = this.getRowPosition(point, row);
                    DuplicateInfo duplicateInfo = (DuplicateInfo)this.getModel().getElementAt(row);
                    if (rowPanel.getLeftButton().getBounds().contains(rowPosition)) {
                        diffController.setLeft(duplicateInfo.getRange(), duplicateInfo.getDescription());
                    }
                    if (rowPanel.getRightButton().getBounds().contains(rowPosition)) {
                        diffController.setRight(duplicateInfo.getRange(), duplicateInfo.getDescription());
                    }
                    this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                mouseRow = null;
                mouseRowPosition = null;
                this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int row = this.locationToIndex(e.getPoint());
                mouseRow = row;
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                mouseRowPosition = this.getRowPosition(point, row);
                this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10) {
                    DuplicateInfo duplicateInfo = (DuplicateInfo)this.getSelectedValue();
                    navigatedFragmentHighlighter.highlightAndNavigate((RangeMarker)(duplicateInfo != null ? duplicateInfo.getRange() : null));
                }
            }
        });
        this.setSelectionMode(0);
        if (this.getModel().getSize() >= 2) {
            this.setSelectedIndex(0);
            DuplicateInfo $this$_init__u24lambda_u244 = (DuplicateInfo)this.getModel().getElementAt(0);
            boolean bl = false;
            this.mainFragmentHighlighter.highlightAndNavigate($this$_init__u24lambda_u244.getRange());
            this.diffController.setLeft($this$_init__u24lambda_u244.getRange(), $this$_init__u24lambda_u244.getDescription());
            DuplicateInfo $this$_init__u24lambda_u245 = (DuplicateInfo)this.getModel().getElementAt(1);
            boolean bl4 = false;
            this.diffController.setRight($this$_init__u24lambda_u245.getRange(), $this$_init__u24lambda_u245.getDescription());
        }
    }

    private final DuplicateInfo createDuplicateInfo(TextFragment duplicate, boolean showFullPath) {
        Document document = FileDocumentManager.getInstance().getDocument(duplicate.getFile());
        if (document == null) {
            return null;
        }
        Document document2 = document;
        RangeMarker rangeMarker = document2.createRangeMarker(duplicate.getRange());
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
        RangeMarker range = rangeMarker;
        int startLine = document2.getLineNumber(duplicate.getRange().getStartOffset());
        int endLine = document2.getLineNumber(duplicate.getRange().getEndOffset());
        String fileName = showFullPath ? this.getRelativePath(this.diffController.getProject().getBasePath(), duplicate.getFile().getPath()) : duplicate.getFile().getPresentableName();
        Object object = new Object[]{startLine + 1, endLine + 1, fileName};
        String description = DuplicatesBundle.INSTANCE.getMessage("duplicate.toolwindow.duplicate", (Object[])object);
        Object it = object = new DuplicateInfo(range, description);
        boolean bl = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)it));
        return object;
    }

    private final String getRelativePath(String basePath, String path) {
        if (basePath == null || path == null) {
            return path;
        }
        String string = FileUtil.getRelativePath((File)new File(basePath), (File)new File(path));
        if (string == null) {
            string = path;
        }
        return string;
    }

    private final Point getRowPosition(Point point, int row) {
        Point rowOffset = this.indexToLocation(row);
        return new Point(point.x - rowOffset.x, point.y - rowOffset.y);
    }

    @NotNull
    public ListCellRenderer<? super DuplicateInfo> getCellRenderer() {
        return (arg_0, arg_1, arg_2, arg_3, arg_4) -> DuplicatesList.getCellRenderer$lambda$7(this, arg_0, arg_1, arg_2, arg_3, arg_4);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.mainFragmentHighlighter);
        Disposer.dispose((Disposable)this.navigatedFragmentHighlighter);
    }

    private static final Component getCellRenderer$lambda$7(DuplicatesList this$0, JList list2, DuplicateInfo value, int index, boolean isSelected, boolean cellHasFocus) {
        RowPanel rowPanel;
        RowPanel $this$getCellRenderer_u24lambda_u247_u24lambda_u246 = rowPanel = this$0.rowPanel;
        boolean bl = false;
        $this$getCellRenderer_u24lambda_u247_u24lambda_u246.getLabel().setText(value.getDescription());
        $this$getCellRenderer_u24lambda_u247_u24lambda_u246.getLeftButton().setIcon(Intrinsics.areEqual((Object)this$0.diffController.getLeftRange(), (Object)value.getRange()) ? AllIcons.Duplicates.SendToTheLeft : AllIcons.Duplicates.SendToTheLeftGrayed);
        $this$getCellRenderer_u24lambda_u247_u24lambda_u246.getRightButton().setIcon(Intrinsics.areEqual((Object)this$0.diffController.getRightRange(), (Object)value.getRange()) ? AllIcons.Duplicates.SendToTheRight : AllIcons.Duplicates.SendToTheRightGrayed);
        Point rowPosition = this$0.mouseRowPosition;
        Integer n = this$0.mouseRow;
        int n2 = index;
        if (n != null && n == n2 && rowPosition != null) {
            if ($this$getCellRenderer_u24lambda_u247_u24lambda_u246.getLeftButton().getBounds().contains(rowPosition)) {
                $this$getCellRenderer_u24lambda_u247_u24lambda_u246.getLeftButton().setIcon(AllIcons.Duplicates.SendToTheLeft);
            }
            if ($this$getCellRenderer_u24lambda_u247_u24lambda_u246.getRightButton().getBounds().contains(rowPosition)) {
                $this$getCellRenderer_u24lambda_u247_u24lambda_u246.getRightButton().setIcon(AllIcons.Duplicates.SendToTheRight);
            }
        }
        UIUtil.changeBackGround((Component)$this$getCellRenderer_u24lambda_u247_u24lambda_u246, (Color)UIUtil.getListBackground((boolean)isSelected, (boolean)cellHasFocus));
        $this$getCellRenderer_u24lambda_u247_u24lambda_u246.getLabel().setForeground(UIUtil.getListForeground((boolean)isSelected, (boolean)cellHasFocus));
        return rowPanel;
    }
}

