/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.IgnoreSettingsType;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.PatternUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IgnoredFileBean
implements IgnoredFileDescriptor {
    private final String myPath;
    private final String myFilenameIfFile;
    private final String myMask;
    private final Pattern myPattern;
    private final IgnoreSettingsType myType;
    private final Project myProject;
    private volatile FilePath myCachedResolved;

    IgnoredFileBean(@NotNull @NlsSafe String path, @NotNull IgnoreSettingsType type, @Nullable Project project2) {
        if (path == null) {
            IgnoredFileBean.$$$reportNull$$$0(0);
        }
        if (type == null) {
            IgnoredFileBean.$$$reportNull$$$0(1);
        }
        this.myPath = path;
        this.myType = type;
        this.myFilenameIfFile = IgnoreSettingsType.FILE.equals((Object)type) ? PathUtilRt.getFileName((String)path) : null;
        this.myProject = project2;
        this.myMask = null;
        this.myPattern = null;
    }

    IgnoredFileBean(@NotNull @NonNls String mask, @Nullable String path) {
        if (mask == null) {
            IgnoredFileBean.$$$reportNull$$$0(2);
        }
        this.myType = IgnoreSettingsType.MASK;
        this.myMask = mask;
        this.myPattern = PatternUtil.fromMask((String)mask);
        this.myPath = path;
        this.myFilenameIfFile = null;
        this.myProject = null;
    }

    @Nullable
    Project getProject() {
        return this.myProject;
    }

    @Override
    @Nullable
    @NlsSafe
    public String getPath() {
        return this.myPath;
    }

    @Override
    @Nullable
    @NonNls
    public String getMask() {
        return this.myMask;
    }

    @Override
    @NotNull
    public IgnoreSettingsType getType() {
        IgnoreSettingsType ignoreSettingsType = this.myType;
        if (ignoreSettingsType == null) {
            IgnoredFileBean.$$$reportNull$$$0(3);
        }
        return ignoreSettingsType;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IgnoredFileBean that = (IgnoredFileBean)o;
        if (!Objects.equals(this.myPath, that.myPath)) {
            return false;
        }
        if (!Objects.equals(this.myMask, that.myMask)) {
            return false;
        }
        return this.myType == that.myType;
    }

    public int hashCode() {
        int result2 = this.myPath != null ? this.myPath.hashCode() : 0;
        result2 = 31 * result2 + (this.myMask != null ? this.myMask.hashCode() : 0);
        result2 = 31 * result2 + this.myType.hashCode();
        return result2;
    }

    @Override
    public boolean matchesFile(@NotNull VirtualFile file) {
        if (file == null) {
            IgnoredFileBean.$$$reportNull$$$0(4);
        }
        return this.matchesFile(VcsUtil.getFilePath(file));
    }

    @Override
    public boolean matchesFile(@NotNull FilePath filePath) {
        if (filePath == null) {
            IgnoredFileBean.$$$reportNull$$$0(5);
        }
        if (this.myType == IgnoreSettingsType.MASK) {
            return this.myPattern.matcher(filePath.getName()).matches();
        }
        if (IgnoreSettingsType.FILE.equals((Object)this.myType) && !StringUtil.equals((CharSequence)this.myFilenameIfFile, (CharSequence)filePath.getName())) {
            return false;
        }
        FilePath selector = this.resolve();
        if (selector == null) {
            return false;
        }
        if (this.myType == IgnoreSettingsType.FILE) {
            return Comparing.equal((Object)selector, (Object)filePath);
        }
        if ("./".equals(this.myPath)) {
            return !filePath.isDirectory() && Comparing.equal((Object)filePath.getParentPath(), (Object)selector);
        }
        return FileUtil.startsWith((String)filePath.getPath(), (String)selector.getPath());
    }

    @Nullable
    private FilePath resolve() {
        assert (this.myType != IgnoreSettingsType.MASK);
        if (this.myCachedResolved == null) {
            this.myCachedResolved = IgnoredFileBean.doResolve(this.myProject, this.myPath, this.myType == IgnoreSettingsType.UNDER_DIR);
        }
        return this.myCachedResolved;
    }

    @Nullable
    private static FilePath doResolve(@Nullable Project project2, @NotNull String rawPath, boolean isDirectory) {
        if (rawPath == null) {
            IgnoredFileBean.$$$reportNull$$$0(6);
        }
        if (project2 == null || project2.isDisposed()) {
            return null;
        }
        VirtualFile baseDir = project2.getBaseDir();
        String path = FileUtil.toSystemIndependentName((String)rawPath);
        if (baseDir == null) {
            return VcsUtil.getFilePath(path, isDirectory);
        }
        VirtualFile resolvedRelative = baseDir.findFileByRelativePath(path);
        if (resolvedRelative != null) {
            return VcsUtil.getFilePath(resolvedRelative);
        }
        return VcsUtil.getFilePath(path, isDirectory);
    }

    public void resetCache() {
        this.myCachedResolved = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mask";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/IgnoredFileBean";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/IgnoredFileBean";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matchesFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doResolve";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

