/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptCoreBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001eB'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\u0017\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0015H\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u001b\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001cj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;", "", "dialect", "Lcom/intellij/lang/javascript/JSLanguageDialect;", "resourceId", "", "descriptionId", "<init>", "(Ljava/lang/String;ILcom/intellij/lang/javascript/JSLanguageDialect;Ljava/lang/String;Ljava/lang/String;)V", "getDialect", "()Lcom/intellij/lang/javascript/JSLanguageDialect;", "ES5", "ES6", "FLOW", "labelPointer", "Ljava/util/function/Supplier;", "descriptionPointer", "id", "getId", "()Ljava/lang/String;", "description", "Lorg/jetbrains/annotations/Nls;", "getDescription", "toString", "isAtLeast", "", "level", "isES6Compatible", "()Z", "isXmlEnabled", "Companion", "intellij.javascript.frontback.impl"})
public final class JSLanguageLevel
extends Enum<JSLanguageLevel> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final JSLanguageDialect dialect;
    @NotNull
    private final Supplier<String> labelPointer;
    @NotNull
    private final Supplier<String> descriptionPointer;
    @JvmField
    @NotNull
    public static final Map<String, JSLanguageLevel> OBSOLETE_LEVELS;
    @JvmField
    @NotNull
    public static final JSLanguageLevel DEFAULT;
    public static final /* enum */ JSLanguageLevel ES5;
    public static final /* enum */ JSLanguageLevel ES6;
    public static final /* enum */ JSLanguageLevel FLOW;
    private static final /* synthetic */ JSLanguageLevel[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private JSLanguageLevel(@PropertyKey(resourceBundle="messages.JavaScriptCoreBundle") JSLanguageDialect dialect, String resourceId, String descriptionId) {
        this.dialect = dialect;
        this.labelPointer = JavaScriptCoreBundle.messagePointer(resourceId, new Object[0]);
        String string = descriptionId;
        this.descriptionPointer = string != null ? JavaScriptCoreBundle.messagePointer(string, new Object[0]) : JSLanguageLevel::descriptionPointer$lambda$0;
    }

    @NotNull
    public final JSLanguageDialect getDialect() {
        return this.dialect;
    }

    @NotNull
    public final String getId() {
        return super.toString();
    }

    @NotNull
    public final String getDescription() {
        String string = this.descriptionPointer.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        return string;
    }

    @NotNull
    public String toString() {
        String string = this.labelPointer.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        return string;
    }

    public final boolean isAtLeast(@NotNull JSLanguageLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        if (level == this) {
            return true;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1 -> false;
            case 2 -> ES5.isAtLeast(level);
            case 3 -> ES6.isAtLeast(level);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean isES6Compatible() {
        return this.isAtLeast(ES6);
    }

    public final boolean isXmlEnabled() {
        return this.dialect.getOptionHolder().hasFeature(JSLanguageFeature.E4X);
    }

    public static JSLanguageLevel[] values() {
        return (JSLanguageLevel[])$VALUES.clone();
    }

    public static JSLanguageLevel valueOf(String value) {
        return Enum.valueOf(JSLanguageLevel.class, value);
    }

    @NotNull
    public static EnumEntries<JSLanguageLevel> getEntries() {
        return $ENTRIES;
    }

    private static final String descriptionPointer$lambda$0() {
        return "";
    }

    @JvmStatic
    @Nullable
    public static final JSLanguageLevel ofDialect(@Nullable JSLanguageDialect dialect) {
        return Companion.ofDialect(dialect);
    }

    @JvmStatic
    @NotNull
    public static final JSLanguageLevel ofId(@Nullable String id) {
        return Companion.ofId(id);
    }

    @NotNull
    public static final List<JSLanguageLevel> getVisibleLevels() {
        return Companion.getVisibleLevels();
    }

    @JvmStatic
    @NotNull
    public static final JSLanguageLevel getLevelForJSX() {
        return Companion.getLevelForJSX();
    }

    static {
        ES5 = new JSLanguageLevel(JavascriptLanguage.INSTANCE, "js.language.version.combo.es5", null);
        ES6 = new JSLanguageLevel(JavaScriptSupportLoader.ECMA_SCRIPT_6, "js.language.version.combo.es6", "js.language.version.combo.es6.description");
        FLOW = new JSLanguageLevel(JavaScriptSupportLoader.FLOW_JS, "js.language.version.combo.flow", "js.language.version.combo.flow.description");
        $VALUES = jSLanguageLevelArray = new JSLanguageLevel[]{JSLanguageLevel.ES5, JSLanguageLevel.ES6, JSLanguageLevel.FLOW};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"JS_1_5", (Object)((Object)ES5)), TuplesKt.to((Object)"JS_1_6", (Object)((Object)ES6)), TuplesKt.to((Object)"JS_1_7", (Object)((Object)ES6)), TuplesKt.to((Object)"JS_1_8", (Object)((Object)ES6)), TuplesKt.to((Object)"JS_1_8_5", (Object)((Object)ES6)), TuplesKt.to((Object)"E4X", (Object)((Object)ES6)), TuplesKt.to((Object)"JSX", (Object)((Object)ES6)), TuplesKt.to((Object)"NASHORN", (Object)((Object)ES6))};
        OBSOLETE_LEVELS = MapsKt.mapOf((Pair[])pairArray);
        DEFAULT = ES6;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0012\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0007J\b\u0010\u0013\u001a\u00020\u0007H\u0007R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/javascript/dialects/JSLanguageLevel$Companion;", "", "<init>", "()V", "OBSOLETE_LEVELS", "", "", "Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;", "DEFAULT", "ofDialect", "dialect", "Lcom/intellij/lang/javascript/JSLanguageDialect;", "ofId", "id", "visibleLevels", "", "getVisibleLevels$annotations", "getVisibleLevels", "()Ljava/util/List;", "getLevelForJSX", "intellij.javascript.frontback.impl"})
    @SourceDebugExtension(value={"SMAP\nJSLanguageLevel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLanguageLevel.kt\ncom/intellij/lang/javascript/dialects/JSLanguageLevel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n295#2,2:114\n295#2,2:116\n*S KotlinDebug\n*F\n+ 1 JSLanguageLevel.kt\ncom/intellij/lang/javascript/dialects/JSLanguageLevel$Companion\n*L\n95#1:114,2\n101#1:116,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final JSLanguageLevel ofDialect(@Nullable JSLanguageDialect dialect) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = (Iterable)JSLanguageLevel.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JSLanguageLevel it = (JSLanguageLevel)((Object)element$iv);
                    boolean bl = false;
                    if (!(it.getDialect() == dialect)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @JvmStatic
        @NotNull
        public final JSLanguageLevel ofId(@Nullable String id) {
            JSLanguageLevel jSLanguageLevel;
            Object v0;
            block3: {
                if (id == null) {
                    return DEFAULT;
                }
                Iterable $this$firstOrNull$iv = (Iterable)JSLanguageLevel.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JSLanguageLevel it = (JSLanguageLevel)((Object)element$iv);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((jSLanguageLevel = (JSLanguageLevel)v0) == null) {
                jSLanguageLevel = OBSOLETE_LEVELS.getOrDefault(id, DEFAULT);
            }
            return jSLanguageLevel;
        }

        @NotNull
        public final List<JSLanguageLevel> getVisibleLevels() {
            return (List)JSLanguageLevel.getEntries();
        }

        @JvmStatic
        public static /* synthetic */ void getVisibleLevels$annotations() {
        }

        @JvmStatic
        @NotNull
        public final JSLanguageLevel getLevelForJSX() {
            return ES6;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JSLanguageLevel.values().length];
            try {
                nArray[JSLanguageLevel.ES5.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JSLanguageLevel.ES6.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JSLanguageLevel.FLOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

