/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 !*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001!B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0012\u0010\u0013\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0004J\u0012\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u001b\u001a\u00020\bH\u0016J\b\u0010\u001c\u001a\u00020\bH\u0002J\u0017\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010 R\u0014\u0010\u000e\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/intellij/lang/ecmascript6/parsing/ES6FunctionParser;", "T", "Lcom/intellij/lang/javascript/parsing/JavaScriptParser;", "Lcom/intellij/lang/javascript/parsing/FunctionParser;", "parser", "<init>", "(Lcom/intellij/lang/javascript/parsing/JavaScriptParser;)V", "parseFunctionNoMarker", "", "context", "Lcom/intellij/lang/javascript/parsing/FunctionParser$Context;", "functionMarker", "Lcom/intellij/lang/PsiBuilder$Marker;", "hasSupportDecorators", "isFunctionDeclarationStart", "()Z", "parseAttributesList", "parseArrowFunctionWithoutModifiers", "arrowFunction", "isValidFirstParameterStart", "next", "Lcom/intellij/psi/tree/IElementType;", "parseArrowFunctionAttributeList", "Ljava/util/EnumSet;", "Lcom/intellij/lang/javascript/parsing/modifiers/JSModifiersStructure$JSModifiersParseResult;", "isAcceptableLambdaTokenAfterAsync", "tokenType", "allowLastCommaInParameterAndArgumentList", "checkModifierAndSaveAsync", "restoreAsync", "", "wasAsync", "(Ljava/lang/Boolean;)V", "Companion", "intellij.javascript.parser"})
public class ES6FunctionParser<T extends JavaScriptParser>
extends FunctionParser<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Key<Boolean> HAD_ASYNC_MODIFIER_KEY;
    @NotNull
    private static final JSModifiersStructure ARROW_FUNCTION_MODIFIERS;

    public ES6FunctionParser(@NotNull T parser) {
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        super(parser);
    }

    @Override
    public boolean parseFunctionNoMarker(@NotNull FunctionParser.Context context, @NotNull PsiBuilder.Marker functionMarker) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Intrinsics.checkNotNullParameter((Object)functionMarker, (String)"functionMarker");
        boolean wasAsync = this.checkModifierAndSaveAsync();
        boolean result = super.parseFunctionNoMarker(context, functionMarker);
        this.restoreAsync(wasAsync);
        return result;
    }

    @Override
    public boolean hasSupportDecorators() {
        return true;
    }

    @Override
    public boolean isFunctionDeclarationStart() {
        IElementType tokenType = this.builder.getTokenType();
        return tokenType == JSTokenTypes.FUNCTION_KEYWORD || tokenType == JSTokenTypes.ASYNC_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.FUNCTION_KEYWORD;
    }

    @Override
    public boolean parseAttributesList() {
        if (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
            return false;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker modifierList = marker;
        boolean hadAttributes = this.tryParseES7Decorators();
        if (hadAttributes && this.parser.getStatementParser().isExportDefault()) {
            modifierList.done(this.getAttributeListElementType());
            return true;
        }
        boolean hadExport = false;
        if (this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD) {
            hadExport = true;
            this.builder.advanceLexer();
        }
        if (!hadAttributes) {
            this.tryParseES7Decorators();
        }
        if (this.builder.getTokenType() == JSTokenTypes.ASYNC_KEYWORD) {
            this.builder.advanceLexer();
            this.builder.putUserData(HAD_ASYNC_MODIFIER_KEY, (Object)true);
        }
        if (!hadExport && JSTokenTypes.GET_SET.contains(this.builder.getTokenType()) && this.parser.getExpressionParser().isPropertyNameStart(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
        }
        modifierList.done(this.getAttributeListElementType());
        return true;
    }

    @Override
    public boolean parseArrowFunctionWithoutModifiers(@NotNull PsiBuilder.Marker arrowFunction) {
        Intrinsics.checkNotNullParameter((Object)arrowFunction, (String)"arrowFunction");
        EnumSet<JSModifiersStructure.JSModifiersParseResult> modifiers = this.parseArrowFunctionAttributeList();
        EnumSet<JSModifiersStructure.JSModifiersParseResult> savedContext = JSParsingContextUtil.saveAndUpdateParsingContext(modifiers, this.builder);
        boolean result = super.parseArrowFunctionWithoutModifiers(arrowFunction);
        JSParsingContextUtil.restoreParsingContext(savedContext, this.builder);
        return result;
    }

    @Override
    public boolean isValidFirstParameterStart(@Nullable IElementType next) {
        if (!super.isValidFirstParameterStart(next)) {
            return false;
        }
        if (next != JSTokenTypes.ASYNC_KEYWORD) {
            return true;
        }
        IElementType nextLookAhead = this.builder.lookAhead(2);
        return nextLookAhead != JSTokenTypes.LPAR && nextLookAhead != JSTokenTypes.MULT;
    }

    @NotNull
    protected final EnumSet<JSModifiersStructure.JSModifiersParseResult> parseArrowFunctionAttributeList() {
        return this.parser.parseModifiers(ARROW_FUNCTION_MODIFIERS, false, arg_0 -> ES6FunctionParser.parseArrowFunctionAttributeList$lambda$1(arg_0 -> ES6FunctionParser.parseArrowFunctionAttributeList$lambda$0(this, arg_0), arg_0));
    }

    protected boolean isAcceptableLambdaTokenAfterAsync(@Nullable IElementType tokenType) {
        return tokenType == JSTokenTypes.LPAR || this.parser.isIdentifierName(tokenType);
    }

    @Override
    public boolean allowLastCommaInParameterAndArgumentList() {
        return true;
    }

    private final boolean checkModifierAndSaveAsync() {
        boolean hadAsyncModifier = Intrinsics.areEqual((Object)this.builder.getUserData(HAD_ASYNC_MODIFIER_KEY), (Object)true);
        this.builder.putUserData(HAD_ASYNC_MODIFIER_KEY, null);
        boolean wasAsync = JSParsingContextUtil.isAsyncContext(this.builder);
        this.builder.putUserData(JSParsingContextUtil.ASYNC_METHOD_KEY, (Object)hadAsyncModifier);
        return wasAsync;
    }

    private final void restoreAsync(Boolean wasAsync) {
        this.builder.putUserData(JSParsingContextUtil.ASYNC_METHOD_KEY, (Object)wasAsync);
    }

    private static final boolean parseArrowFunctionAttributeList$lambda$0(ES6FunctionParser this$0, PsiBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isAcceptableLambdaTokenAfterAsync(it.getTokenType());
    }

    private static final boolean parseArrowFunctionAttributeList$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Key key = Key.create((String)"js.asyncModifier");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        HAD_ASYNC_MODIFIER_KEY = key;
        ARROW_FUNCTION_MODIFIERS = new JSModifiersStructureLeaf(JSTokenTypes.ASYNC_KEYWORD, false, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/ecmascript6/parsing/ES6FunctionParser$Companion;", "", "<init>", "()V", "HAD_ASYNC_MODIFIER_KEY", "Lcom/intellij/openapi/util/Key;", "", "ARROW_FUNCTION_MODIFIERS", "Lcom/intellij/lang/javascript/parsing/modifiers/JSModifiersStructure;", "intellij.javascript.parser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

