/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.java.jdk;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.indexing.shared.download.SharedIndexAuthParams;
import com.intellij.indexing.shared.java.jdk.JdkAliases;
import com.intellij.indexing.shared.java.jdk.JdkIndexLookupRequest;
import com.intellij.indexing.shared.java.jdk.JdkSupport;
import com.intellij.indexing.shared.java.jdk.SharedJdkChunkStoreEntry;
import com.intellij.indexing.shared.java.jdk.SharedJdkChunkStoreState;
import com.intellij.openapi.components.SerializablePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@State(name="shared-index-jdk-hash", storages={@Storage(value="$CACHE_FILE$")}, allowLoadInTests=true)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/indexing/shared/java/jdk/SharedJdkChunkStore;", "Lcom/intellij/openapi/components/SerializablePersistentStateComponent;", "Lcom/intellij/indexing/shared/java/jdk/SharedJdkChunkStoreState;", "<init>", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "loadState", "", "state", "registerDownloadingJdkRequest", "lookupName", "", "home", "Lcom/intellij/openapi/vfs/VirtualFile;", "newState", "Lcom/intellij/indexing/shared/java/jdk/JdkIndexLookupRequest;", "getOrComputeJdkRequest", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "doComputeJdkRequest", "doComputeCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "doComputeAliases", "", "snapshot", "FileInfo", "intellij.indexing.shared.java"})
@SourceDebugExtension(value={"SMAP\nSharedJdkChunkStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedJdkChunkStore.kt\ncom/intellij/indexing/shared/java/jdk/SharedJdkChunkStore\n+ 2 SerializablePersistentStateComponent.kt\ncom/intellij/openapi/components/SerializablePersistentStateComponent\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n63#2,11:125\n63#2,11:138\n1#3:136\n1#3:137\n1#3:149\n1#3:150\n*S KotlinDebug\n*F\n+ 1 SharedJdkChunkStore.kt\ncom/intellij/indexing/shared/java/jdk/SharedJdkChunkStore\n*L\n52#1:125,11\n71#1:138,11\n52#1:136\n71#1:149\n*E\n"})
public final class SharedJdkChunkStore
extends SerializablePersistentStateComponent<SharedJdkChunkStoreState> {
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();
    @VisibleForTesting
    @JvmField
    @NotNull
    public final AtomicInteger doComputeCounter = new AtomicInteger();

    public SharedJdkChunkStore() {
        super((Object)new SharedJdkChunkStoreState(null, 1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull SharedJdkChunkStoreState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            super.loadState((Object)state);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void registerDownloadingJdkRequest(@NotNull String lookupName, @NotNull VirtualFile home, @NotNull JdkIndexLookupRequest newState) {
        Intrinsics.checkNotNullParameter((Object)lookupName, (String)"lookupName");
        Intrinsics.checkNotNullParameter((Object)home, (String)"home");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        String snapshotHash = this.snapshot(home);
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            SerializablePersistentStateComponent this_$iv = this;
            boolean $i$f$updateState = false;
            Object prev$iv = null;
            prev$iv = this_$iv.getState();
            SharedJdkChunkStoreState next$iv = null;
            boolean haveNext$iv = false;
            while (true) {
                void it$iv;
                Object object;
                if (!haveNext$iv) {
                    SharedJdkChunkStoreState oldState = (SharedJdkChunkStoreState)prev$iv;
                    boolean bl2 = false;
                    List entries = CollectionsKt.toMutableList((Collection)oldState.entries);
                    CollectionsKt.removeAll((List)entries, arg_0 -> SharedJdkChunkStore.registerDownloadingJdkRequest$lambda$3$lambda$2$lambda$1(snapshotHash, arg_0));
                    entries.add(new SharedJdkChunkStoreEntry(lookupName, snapshotHash, newState));
                    next$iv = new SharedJdkChunkStoreState(entries);
                }
                if (SerializablePersistentStateComponent.Companion.compareAndSet(this_$iv, prev$iv, next$iv)) break;
                Object object2 = object = this_$iv.getState();
                Object object3 = prev$iv;
                boolean bl3 = false;
                prev$iv = it$iv;
                haveNext$iv = object3 == object;
            }
            SharedJdkChunkStoreState sharedJdkChunkStoreState = next$iv;
            Intrinsics.checkNotNull(sharedJdkChunkStoreState);
            SharedJdkChunkStoreState sharedJdkChunkStoreState2 = sharedJdkChunkStoreState;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final JdkIndexLookupRequest getOrComputeJdkRequest(@NotNull Sdk sdk) {
        Object object;
        block14: {
            block13: {
                Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
                if (!JdkSupport.isJdk(sdk)) {
                    return null;
                }
                object = sdk.getHomeDirectory();
                if (object == null) break block13;
                VirtualFile it = object;
                boolean bl2 = false;
                String string = this.snapshot(it);
                object = string;
                if (string != null) break block14;
            }
            return null;
        }
        Object snapshotHash = object;
        Lock lock = this.lock;
        lock.lock();
        try {
            Object v2;
            block12: {
                boolean bl = false;
                Iterable iterable = ((SharedJdkChunkStoreState)this.getState()).entries;
                for (Object bl2 : iterable) {
                    SharedJdkChunkStoreEntry it = (SharedJdkChunkStoreEntry)bl2;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.snapshotHash, (Object)snapshotHash)) continue;
                    v2 = bl2;
                    break block12;
                }
                v2 = null;
            }
            SharedJdkChunkStoreEntry sharedJdkChunkStoreEntry = v2;
            if (sharedJdkChunkStoreEntry != null) {
                SharedJdkChunkStoreEntry it = sharedJdkChunkStoreEntry;
                boolean bl = false;
                JdkIndexLookupRequest jdkIndexLookupRequest = it.toJdkIndexRequest();
                return jdkIndexLookupRequest;
            }
            JdkIndexLookupRequest newState = this.doComputeJdkRequest(sdk);
            SerializablePersistentStateComponent this_$iv = this;
            boolean $i$f$updateState = false;
            Object prev$iv = null;
            prev$iv = this_$iv.getState();
            SharedJdkChunkStoreState next$iv = null;
            boolean haveNext$iv = false;
            while (true) {
                void it$iv;
                Object object2;
                if (!haveNext$iv) {
                    SharedJdkChunkStoreState oldState = (SharedJdkChunkStoreState)prev$iv;
                    boolean bl = false;
                    Collection collection = oldState.entries;
                    String string = sdk.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    List entries = CollectionsKt.plus((Collection)collection, (Object)new SharedJdkChunkStoreEntry(string, (String)snapshotHash, newState));
                    next$iv = new SharedJdkChunkStoreState(entries);
                }
                if (SerializablePersistentStateComponent.Companion.compareAndSet(this_$iv, prev$iv, next$iv)) break;
                Object object3 = object2 = this_$iv.getState();
                Object object4 = prev$iv;
                boolean bl = false;
                prev$iv = it$iv;
                haveNext$iv = object4 == object2;
            }
            Intrinsics.checkNotNull(next$iv);
            JdkIndexLookupRequest jdkIndexLookupRequest = newState;
            return jdkIndexLookupRequest;
        }
        finally {
            lock.unlock();
        }
    }

    private final JdkIndexLookupRequest doComputeJdkRequest(Sdk sdk) {
        CharSequence charSequence;
        if (!JdkSupport.isJdk(sdk)) {
            return null;
        }
        String jdkFingerprint = JdkSupport.computeJdkFingerprint(sdk);
        List<String> aliases = this.doComputeAliases(sdk);
        CharSequence charSequence2 = sdk.getName();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8;
        SharedIndexAuthParams sharedIndexAuthParams = null;
        List<String> list = aliases;
        String string = jdkFingerprint;
        String string2 = (String)charSequence;
        return new JdkIndexLookupRequest(string2, string, list, sharedIndexAuthParams, n, defaultConstructorMarker);
    }

    private final List<String> doComputeAliases(Sdk sdk) {
        this.doComputeCounter.incrementAndGet();
        return JdkAliases.INSTANCE.computeAliasesForJdk(sdk);
    }

    private final String snapshot(VirtualFile home) {
        TreeMap<String, FileInfo> allFiles = new TreeMap<String, FileInfo>();
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        VfsUtil.visitChildrenRecursively((VirtualFile)home, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(allFiles, optionArray){
            final /* synthetic */ TreeMap<String, FileInfo> $allFiles;
            {
                this.$allFiles = $allFiles;
                super($super_call_param$1);
            }

            public boolean visitFile(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!file.isDirectory()) {
                    ((Map)this.$allFiles).put(file.getPath(), new FileInfo(file.getLength(), file.getTimeStamp()));
                }
                ProgressManager.checkCanceled();
                return super.visitFile(file);
            }
        }));
        Hasher hasher = Hashing.sha256().newHasher();
        hasher.putUnencodedChars((CharSequence)JdkSupport.getSupportedSdkType().getName());
        for (Map.Entry entry : ((Map)allFiles).entrySet()) {
            String path = (String)entry.getKey();
            FileInfo info = (FileInfo)entry.getValue();
            hasher.putUnencodedChars((CharSequence)path);
            hasher.putLong(info.getSize());
            hasher.putLong(info.getTimestamp());
        }
        String string = hasher.hash().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final boolean registerDownloadingJdkRequest$lambda$3$lambda$2$lambda$1(String $snapshotHash, SharedJdkChunkStoreEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.snapshotHash, (Object)$snapshotHash);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/indexing/shared/java/jdk/SharedJdkChunkStore$FileInfo;", "", "size", "", "timestamp", "<init>", "(JJ)V", "getSize", "()J", "getTimestamp", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.indexing.shared.java"})
    private static final class FileInfo {
        private final long size;
        private final long timestamp;

        public FileInfo(long size, long timestamp) {
            this.size = size;
            this.timestamp = timestamp;
        }

        public final long getSize() {
            return this.size;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final long component1() {
            return this.size;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final FileInfo copy(long size, long timestamp) {
            return new FileInfo(size, timestamp);
        }

        public static /* synthetic */ FileInfo copy$default(FileInfo fileInfo, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = fileInfo.size;
            }
            if ((n & 2) != 0) {
                l2 = fileInfo.timestamp;
            }
            return fileInfo.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "FileInfo(size=" + this.size + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.size);
            result = result * 31 + Long.hashCode(this.timestamp);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileInfo)) {
                return false;
            }
            FileInfo fileInfo = (FileInfo)other;
            if (this.size != fileInfo.size) {
                return false;
            }
            return this.timestamp == fileInfo.timestamp;
        }
    }
}

