/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.powerfuldataviewer.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.python.scientific.powerfuldataviewer.DataViewTableImpl;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.containerview.ColumnFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetFilterAction
extends DumbAwareAction {
    private static final Dimension POPUP_MIN_SIZE = new Dimension(250, 0);
    private final DataViewTableImpl myTable;
    private final int myColumn;
    private JBPopup myPopup;
    AddFilterDialogWrapper myDialogWrapper;

    public SetFilterAction(DataViewTableImpl table, int column) {
        super(PyBundle.message((String)"debugger.dataviewer.action.set.filter.name", (Object[])new Object[0]), null, AllIcons.General.Filter);
        this.myTable = table;
        this.myColumn = column;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SetFilterAction.$$$reportNull$$$0(0);
        }
        this.doAction();
    }

    public void doAction() {
        this.invokePopup(this.myTable.getTableHeader(), this.myTable.getTableHeader().getHeaderRect(this.myColumn).getLocation());
    }

    public void invokePopup(Component invoker, Point point) {
        JPanel panel2 = new JPanel(new BorderLayout());
        MainComponent component = this.createMainComponent(() -> this.myPopup.cancel());
        panel2.setBackground(component.getComponent().getBackground());
        panel2.add(component.getComponent());
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)component.getTextField()).setMovable(true).setTitle(PyBundle.message((String)"debugger.dataviewer.action.set.filter.description", (Object[])new Object[]{this.myTable.getHeaderValueAt(this.myColumn)})).setFocusable(true).setRequestFocus(true).setCancelOnClickOutside(true).setAdText(PyBundle.message((String)"debugger.dataviewer.action.set.filter.ad.controls", (Object[])new Object[0])).setOkHandler(() -> this.changeFilter(component.getFilter())).setMinSize(new Dimension(POPUP_MIN_SIZE)).createPopup();
        component.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SetFilterAction.this.myPopup.closeOk((InputEvent)e);
                }
            }
        });
        this.myPopup.show(new RelativePoint(invoker, point));
    }

    public void invokeDialog() {
        MainComponent comp = this.createMainComponent(() -> this.myDialogWrapper.close(1));
        this.myDialogWrapper = new AddFilterDialogWrapper(comp);
        if (this.myDialogWrapper.showAndGet()) {
            this.changeFilter(comp.getFilter());
        }
    }

    private MainComponent createMainComponent(@NotNull Runnable close) {
        ColumnFilter filter;
        if (close == null) {
            SetFilterAction.$$$reportNull$$$0(1);
        }
        return new MainComponent((filter = this.myTable.getColumnFilter(this.myColumn)) != null ? filter : new ColumnFilter(this.myColumn, "", ColumnFilter.Mode.EXPRESSION), this.myTable.isStrSearchAvailable(), (AnAction)new RemoveFilterAction(this.myTable, this.myColumn, close));
    }

    private void changeFilter(ColumnFilter filter) {
        if (filter.isEmpty()) {
            this.myTable.removeFilter(filter.getColumn());
        } else {
            this.myTable.setFilter(filter);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "close";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/scientific/powerfuldataviewer/actions/SetFilterAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createMainComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MainComponent {
        private static final int TEXT_FIELD_HEIGHT = 35;
        private int mySelectedTab;
        private final JPanel myPanel;
        private final JBTextField myTextField;
        private final ColumnFilter myFilter;
        private boolean myRegex;
        private final HyperlinkLabel myHintLabel = new HyperlinkLabel();
        private final MyToggleAction action = new MyToggleAction(PyBundle.message((String)"debugger.dataviewer.action.set.filter.use.regex", (Object[])new Object[0]), AllIcons.Actions.Regex, AllIcons.Actions.RegexHovered, AllIcons.Actions.RegexSelected);
        private final ActionButton regexButton = new ActionButton((AnAction)this.action, this.action.getTemplatePresentation().clone(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            public Icon getIcon() {
                if (this.isSelected()) {
                    return this.myPresentation.getSelectedIcon();
                }
                return super.getIcon();
            }
        };
        private JPanel myTabsPanel;

        private MainComponent(ColumnFilter filter, boolean strSearchAvailable, AnAction removeFilterAction) {
            this.myFilter = filter;
            this.myRegex = filter.isRegex();
            this.myTextField = new JBTextField();
            this.myTextField.setText(filter.getFilter());
            this.myTextField.selectAll();
            this.myTextField.setBorder(null);
            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
            this.myPanel = panel2;
            panel2.setBackground(this.myTextField.getBackground());
            JPanel buttonPanel = new JPanel(new BorderLayout());
            buttonPanel.setBackground(this.myTextField.getBackground());
            buttonPanel.add((Component)this.regexButton, "West");
            if (!filter.isEmpty()) {
                ActionButton removeFilterButton = new ActionButton(removeFilterAction, removeFilterAction.getTemplatePresentation().clone(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
                buttonPanel.add((Component)removeFilterButton, "East");
            }
            this.setupTabs(strSearchAvailable);
            NonOpaquePanel textFieldPanel = new NonOpaquePanel();
            textFieldPanel.setLayout(new BorderLayout());
            textFieldPanel.add((Component)this.myTextField, "Center");
            textFieldPanel.add((Component)buttonPanel, "East");
            textFieldPanel.setPreferredSize(new Dimension(0, 35));
            textFieldPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 35));
            NonOpaquePanel wrapper1 = new NonOpaquePanel((JComponent)this.myHintLabel);
            wrapper1.setBorder((Border)JBUI.Borders.empty((int)1, (int)5));
            JPanel gridPanel = new JPanel();
            gridPanel.setLayout(new BoxLayout(gridPanel, 1));
            gridPanel.add((Component)textFieldPanel);
            gridPanel.add((Component)wrapper1);
            this.myPanel.add(gridPanel);
            this.changeTab(filter.isExpression() ? 0 : 1);
        }

        private void changeTab(int newTabIndex) {
            this.mySelectedTab = newTabIndex;
            if (newTabIndex == 0) {
                this.myHintLabel.setHtmlText(PyBundle.message((String)"debugger.dataviewer.action.set.filter.help.expression", (Object[])new Object[]{"x"}));
            } else {
                this.myHintLabel.setText("");
            }
            this.regexButton.setVisible(this.mySelectedTab == 1);
            this.myTabsPanel.repaint();
        }

        private void setupTabs(boolean strSearchAvailable) {
            this.myTabsPanel = new JPanel(new FlowLayout(0, 0, 0));
            this.myTabsPanel.add((Component)((Object)new MyTabLabel(PyBundle.message((String)"debugger.dataviewer.action.set.filter.item.expression", (Object[])new Object[0]), 0)));
            if (strSearchAvailable) {
                this.myTabsPanel.add((Component)((Object)new MyTabLabel(PyBundle.message((String)"debugger.dataviewer.action.set.filter.item.substring", (Object[])new Object[0]), 1)));
            }
            this.myPanel.add((Component)this.myTabsPanel, "North");
        }

        public ColumnFilter getFilter() {
            ColumnFilter.Mode mode = this.mySelectedTab == 0 ? ColumnFilter.Mode.EXPRESSION : (this.myRegex ? ColumnFilter.Mode.REGEX : ColumnFilter.Mode.SUBSTRING);
            return new ColumnFilter(this.myFilter.getColumn(), this.myTextField.getText(), mode);
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public JBTextField getTextField() {
            return this.myTextField;
        }

        public boolean isRegex() {
            return this.myRegex;
        }

        private class MyToggleAction
        extends ToggleAction {
            private MyToggleAction(String text, Icon icon, Icon hoveredIcon, Icon selectedIcon) {
                super(() -> text, icon);
                this.getTemplatePresentation().setHoveredIcon(hoveredIcon);
                this.getTemplatePresentation().setSelectedIcon(selectedIcon);
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyToggleAction.$$$reportNull$$$0(0);
                }
                return MainComponent.this.myRegex;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    MyToggleAction.$$$reportNull$$$0(1);
                }
                MainComponent.this.myRegex = state;
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    MyToggleAction.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/python/scientific/powerfuldataviewer/actions/SetFilterAction$MainComponent$MyToggleAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/python/scientific/powerfuldataviewer/actions/SetFilterAction$MainComponent$MyToggleAction";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }

        private class MyTabLabel
        extends JBLabel {
            private final int myIndex;

            private MyTabLabel(String text, final int index) {
                super(text);
                this.myIndex = index;
                this.setBorder(JBUI.Borders.empty((int)5));
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (index != MainComponent.this.mySelectedTab) {
                            MainComponent.this.changeTab(index);
                        }
                    }
                });
            }

            public Color getBackground() {
                if (this.myIndex == MainComponent.this.mySelectedTab) {
                    return JBUI.CurrentTheme.BigPopup.selectedTabColor();
                }
                return super.getBackground();
            }

            public boolean isOpaque() {
                return this.myIndex == MainComponent.this.mySelectedTab;
            }
        }
    }

    private static class AddFilterDialogWrapper
    extends DialogWrapper {
        private final MainComponent myComponent;

        protected AddFilterDialogWrapper(MainComponent component) {
            super(true);
            this.myComponent = component;
            this.init();
            this.setResizable(false);
            this.setTitle(PyBundle.message((String)"debugger.dataviewer.action.set.filter.name", (Object[])new Object[0]));
            this.setOKButtonText(PyBundle.message((String)"debugger.dataviewer.action.set.filter.button.set", (Object[])new Object[0]));
        }

        protected Action @NotNull [] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                AddFilterDialogWrapper.$$$reportNull$$$0(0);
            }
            return actionArray;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myComponent.getComponent();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myComponent.getTextField();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/python/scientific/powerfuldataviewer/actions/SetFilterAction$AddFilterDialogWrapper", "createActions"));
        }
    }

    public static class RemoveFilterAction
    extends DumbAwareAction {
        @NotNull
        private final DataViewTableImpl myTable;
        private final int myColumn;
        @Nullable
        private final Runnable myAfter;

        public RemoveFilterAction(@NotNull DataViewTableImpl table, int column, @Nullable Runnable doAfter) {
            if (table == null) {
                RemoveFilterAction.$$$reportNull$$$0(0);
            }
            super(PyBundle.message((String)"debugger.dataviewer.action.remove.filter.name", (Object[])new Object[0]), null, AllIcons.Actions.GC);
            this.myTable = table;
            this.myColumn = column;
            this.myAfter = doAfter;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveFilterAction.$$$reportNull$$$0(1);
            }
            this.myTable.removeFilter(this.myColumn);
            if (this.myAfter != null) {
                this.myAfter.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/python/scientific/powerfuldataviewer/actions/SetFilterAction$RemoveFilterAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

