/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff.codeinsight;

import com.intellij.codeInsight.hints.declarative.HintFormat;
import com.intellij.codeInsight.hints.declarative.InlayHintsCollector;
import com.intellij.codeInsight.hints.declarative.InlayHintsProvider;
import com.intellij.codeInsight.hints.declarative.InlayPosition;
import com.intellij.codeInsight.hints.declarative.InlayTreeSink;
import com.intellij.codeInsight.hints.declarative.InlineInlayPosition;
import com.intellij.codeInsight.hints.declarative.PresentationTreeBuilder;
import com.intellij.codeInsight.hints.declarative.SharedBypassCollector;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.python.ruff.RuffRuleInfo;
import com.intellij.python.ruff.RuffService;
import com.intellij.python.ruff.codeinsight.RuffDocumentationUtil;
import com.intellij.python.ruff.codeinsight.RuffDocumentationUtilKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlLiteral;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffTomlInlayHintsProvider;", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsProvider;", "<init>", "()V", "createCollector", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Collector", "intellij.python.ruff"})
public final class RuffTomlInlayHintsProvider
implements InlayHintsProvider {
    @Nullable
    public InlayHintsCollector createCollector(@NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!(file instanceof TomlFile)) {
            return null;
        }
        if (!RuffDocumentationUtilKt.isRuffConfigFile((TomlFile)file)) {
            return null;
        }
        return (InlayHintsCollector)new Collector();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffTomlInlayHintsProvider$Collector;", "Lcom/intellij/codeInsight/hints/declarative/SharedBypassCollector;", "<init>", "()V", "hintFormat", "Lcom/intellij/codeInsight/hints/declarative/HintFormat;", "getHintFormat", "()Lcom/intellij/codeInsight/hints/declarative/HintFormat;", "collectFromElement", "", "element", "Lcom/intellij/psi/PsiElement;", "sink", "Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;", "processRuffCode", "Lorg/toml/lang/psi/TomlLiteral;", "intellij.python.ruff"})
    @SourceDebugExtension(value={"SMAP\nRuffTomlInlayHintsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuffTomlInlayHintsProvider.kt\ncom/intellij/python/ruff/codeinsight/RuffTomlInlayHintsProvider$Collector\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,53:1\n30#2,2:54\n648#3,5:56\n*S KotlinDebug\n*F\n+ 1 RuffTomlInlayHintsProvider.kt\ncom/intellij/python/ruff/codeinsight/RuffTomlInlayHintsProvider$Collector\n*L\n37#1:54,2\n39#1:56,5\n*E\n"})
    private static final class Collector
    implements SharedBypassCollector {
        @NotNull
        private final HintFormat hintFormat = HintFormat.Companion.getDefault();

        @NotNull
        public final HintFormat getHintFormat() {
            return this.hintFormat;
        }

        public void collectFromElement(@NotNull PsiElement element, @NotNull InlayTreeSink sink) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (element instanceof TomlLiteral && RuffDocumentationUtil.INSTANCE.isRuffCodeElement((TomlLiteral)element)) {
                this.processRuffCode((TomlLiteral)element, sink);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processRuffCode(TomlLiteral element, InlayTreeSink sink) {
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            char[] cArray = new char[]{'\"', '\''};
            String code = StringsKt.trim((String)string, (char[])cArray);
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RuffService> serviceClass$iv = RuffService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            RuffService ruffService = (RuffService)object;
            Object object2 = ruffService.getRuleInformation().get(code);
            if (object2 == null || (object2 = ((RuffRuleInfo)object2).getName()) == null) {
                String string2;
                Map<String, String> map;
                block4: {
                    void $this$takeWhile$iv;
                    String string3 = code;
                    map = ruffService.getLinterInformation();
                    boolean $i$f$takeWhile = false;
                    int n = $this$takeWhile$iv.length();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        char it = $this$takeWhile$iv.charAt(index$iv);
                        boolean bl = false;
                        if (Character.isLetter(it)) continue;
                        void var12_14 = $this$takeWhile$iv;
                        int n2 = 0;
                        String string4 = var12_14.substring(n2, index$iv);
                        string2 = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        break block4;
                    }
                    string2 = $this$takeWhile$iv;
                }
                if ((object2 = map.get(string2)) == null) {
                    return;
                }
            }
            Object ruleName = object2;
            InlayTreeSink.addPresentation$default((InlayTreeSink)sink, (InlayPosition)((InlayPosition)new InlineInlayPosition(element.getTextRange().getEndOffset(), false, 0, 4, null)), null, null, (HintFormat)this.hintFormat, arg_0 -> Collector.processRuffCode$lambda$1((String)ruleName, arg_0), (int)6, null);
        }

        private static final Unit processRuffCode$lambda$1(String $ruleName, PresentationTreeBuilder $this$addPresentation) {
            Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
            PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)$ruleName, null, (int)2, null);
            return Unit.INSTANCE;
        }
    }
}

