/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff.codeinsight;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.python.ruff.RuffBundle;
import com.intellij.python.ruff.codeinsight.RuffDocumentationUtilKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkExtensionsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.toml.lang.psi.TomlFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003\u0014\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0003H\u0003\u00a8\u0006\u0017"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffConfigExternalAnnotator;", "Lcom/intellij/lang/annotation/ExternalAnnotator;", "Lcom/intellij/python/ruff/codeinsight/RuffConfigExternalAnnotator$State;", "Lcom/intellij/python/ruff/codeinsight/RuffConfigExternalAnnotator$Result;", "<init>", "()V", "collectInformation", "file", "Lcom/intellij/psi/PsiFile;", "doAnnotate", "state", "parseOutput", "output", "", "apply", "", "result", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "buildTooltip", "Companion", "State", "Result", "intellij.python.ruff"})
@SourceDebugExtension(value={"SMAP\nRuffConfigExternalAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuffConfigExternalAnnotator.kt\ncom/intellij/python/ruff/codeinsight/RuffConfigExternalAnnotator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,157:1\n1#2:158\n13#3:159\n*S KotlinDebug\n*F\n+ 1 RuffConfigExternalAnnotator.kt\ncom/intellij/python/ruff/codeinsight/RuffConfigExternalAnnotator\n*L\n33#1:159\n*E\n"})
public final class RuffConfigExternalAnnotator
extends ExternalAnnotator<State, Result> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Regex ERROR_PATTERN;
    @NotNull
    private static final Regex SUCCESS_PATTERN;

    @Nullable
    public State collectInformation(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof TomlFile)) {
            return null;
        }
        if (!RuffDocumentationUtilKt.isRuffConfigFile((TomlFile)file)) {
            return null;
        }
        VirtualFile virtualFile = ((TomlFile)file).getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Path tempDir = Files.createTempDirectory(null, new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)tempDir);
        Path path2 = tempDir;
        String string = ((TomlFile)file).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Path path3 = path2.resolve(string);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        Path tempFile = path3;
        String string2 = ((TomlFile)file).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        PathsKt.writeText$default((Path)tempFile, (CharSequence)string2, null, (OpenOption[])new OpenOption[0], (int)2, null);
        Project project = ((TomlFile)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new State(project, file, virtualFile2, tempFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Result doAnnotate(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)state.getVirtualFile(), (Project)state.getProject());
        Module module2 = module;
        if ((module2 == null || (module2 = PySdkExtKt.getPythonSdk((Module)module2)) == null) && (module2 = PySdkExtKt.getPythonSdk((Project)state.getProject())) == null) {
            return null;
        }
        Module sdk = module2;
        Path path2 = PySdkExtensionsKt.getExecutablePath((Sdk)sdk, (String)"ruff");
        if (path2 == null) {
            Result result;
            Result it = result = null;
            boolean bl = false;
            LOG.info("Could not find ruff executable in SDK: " + sdk.getName());
            return result;
        }
        Path ruffExecutable = path2;
        String string = state.getVirtualFile().getParent().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String workingDir = string;
        String[] it = new String[]{((Object)ruffExecutable.toAbsolutePath()).toString(), "check", "?", "--config", ((Object)state.getTempFile().toAbsolutePath()).toString()};
        ProcessBuilder processBuilder = new ProcessBuilder(it).directory(new File(workingDir)).redirectErrorStream(true);
        try {
            String string2;
            Process process = processBuilder.start();
            Closeable closeable = new BufferedReader(new InputStreamReader(process.getInputStream()));
            Throwable throwable = null;
            try {
                BufferedReader it2 = (BufferedReader)closeable;
                boolean bl = false;
                string2 = TextStreamsKt.readText((Reader)it2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String output = string2;
            return this.parseOutput(output);
        }
        catch (Exception e) {
            LOG.warn("Error executing ruff check ? command", (Throwable)e);
            return null;
        }
    }

    private final Result parseOutput(String output) {
        if (SUCCESS_PATTERN.matches((CharSequence)output)) {
            return null;
        }
        MatchResult matchResult = Regex.find$default((Regex)ERROR_PATTERN, (CharSequence)output, (int)0, (int)2, null);
        if (matchResult == null) {
            Result result;
            Result it = result = null;
            boolean bl = false;
            LOG.info("Could not parse `ruff check ?` output: " + output);
            return result;
        }
        MatchResult match = matchResult;
        MatchGroup matchGroup = match.getGroups().get(1);
        Intrinsics.checkNotNull((Object)matchGroup);
        int n = Integer.parseInt(matchGroup.getValue());
        MatchGroup matchGroup2 = match.getGroups().get(2);
        Intrinsics.checkNotNull((Object)matchGroup2);
        int n2 = Integer.parseInt(matchGroup2.getValue());
        MatchGroup matchGroup3 = match.getGroups().get(3);
        Intrinsics.checkNotNull((Object)matchGroup3);
        int n3 = matchGroup3.getValue().length();
        MatchGroup matchGroup4 = match.getGroups().get(4);
        Intrinsics.checkNotNull((Object)matchGroup4);
        return new Result(n, n2, n3, matchGroup4.getValue());
    }

    public void apply(@NotNull PsiFile file, @Nullable Result result, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (result == null) {
            return;
        }
        Document document = file.getViewProvider().getDocument();
        if (document == null) {
            return;
        }
        Document document2 = document;
        int lineStartOffset = document2.getLineStartOffset(result.getErrorLine() - 1);
        int startOffset = lineStartOffset + result.getErrorColumn() - 1;
        int endOffset = startOffset + result.getErrorWidth();
        Object[] objectArray = new Object[]{result.getErrorMessage()};
        String message = RuffBundle.INSTANCE.message("inspection.message.ruff.config.error", objectArray);
        holder.newAnnotation(HighlightSeverity.ERROR, message).range(new TextRange(startOffset, endOffset)).tooltip(this.buildTooltip(result)).create();
    }

    @NlsSafe
    private final String buildTooltip(Result result) {
        return StringsKt.trimIndent((String)("\n            <html>\n            <body>\n            <p><b>Ruff config error:</b> " + result.getErrorMessage() + "</p>\n            </body>\n            </html>\n        "));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RuffConfigExternalAnnotator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        ERROR_PATTERN = new Regex("ruff failed\n  (?:Cause: Failed to load configuration `.+`\n  )?Cause: Failed to parse .+\n  Cause: TOML parse error at line (\\d+), column (\\d+)\n \\s*\\|\n\\d+ \\| .*\n \\s*\\|\\s+(\\^+)\n(.+)");
        SUCCESS_PATTERN = new Regex("\\?:1:1: E902 No such file or directory \\(os error 2\\)\\s+Found 1 error\\.");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffConfigExternalAnnotator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "ERROR_PATTERN", "Lkotlin/text/Regex;", "SUCCESS_PATTERN", "intellij.python.ruff"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffConfigExternalAnnotator$Result;", "", "errorLine", "", "errorColumn", "errorWidth", "errorMessage", "", "<init>", "(IIILjava/lang/String;)V", "getErrorLine", "()I", "getErrorColumn", "getErrorWidth", "getErrorMessage", "()Ljava/lang/String;", "intellij.python.ruff"})
    public static final class Result {
        private final int errorLine;
        private final int errorColumn;
        private final int errorWidth;
        @NotNull
        private final String errorMessage;

        public Result(int errorLine, int errorColumn, int errorWidth, @NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            this.errorLine = errorLine;
            this.errorColumn = errorColumn;
            this.errorWidth = errorWidth;
            this.errorMessage = errorMessage;
        }

        public /* synthetic */ Result(int n, int n2, int n3, String string, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = -1;
            }
            if ((n4 & 2) != 0) {
                n2 = -1;
            }
            if ((n4 & 4) != 0) {
                n3 = -1;
            }
            if ((n4 & 8) != 0) {
                string = "";
            }
            this(n, n2, n3, string);
        }

        public final int getErrorLine() {
            return this.errorLine;
        }

        public final int getErrorColumn() {
            return this.errorColumn;
        }

        public final int getErrorWidth() {
            return this.errorWidth;
        }

        @NotNull
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public Result() {
            this(0, 0, 0, null, 15, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffConfigExternalAnnotator$State;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "tempFile", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/nio/file/Path;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/psi/PsiFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getTempFile", "()Ljava/nio/file/Path;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.python.ruff"})
    public static final class State {
        @NotNull
        private final Project project;
        @NotNull
        private final PsiFile file;
        @NotNull
        private final VirtualFile virtualFile;
        @NotNull
        private final Path tempFile;

        public State(@NotNull Project project, @NotNull PsiFile file, @NotNull VirtualFile virtualFile, @NotNull Path tempFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)tempFile, (String)"tempFile");
            this.project = project;
            this.file = file;
            this.virtualFile = virtualFile;
            this.tempFile = tempFile;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final PsiFile getFile() {
            return this.file;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        @NotNull
        public final Path getTempFile() {
            return this.tempFile;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final PsiFile component2() {
            return this.file;
        }

        @NotNull
        public final VirtualFile component3() {
            return this.virtualFile;
        }

        @NotNull
        public final Path component4() {
            return this.tempFile;
        }

        @NotNull
        public final State copy(@NotNull Project project, @NotNull PsiFile file, @NotNull VirtualFile virtualFile, @NotNull Path tempFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)tempFile, (String)"tempFile");
            return new State(project, file, virtualFile, tempFile);
        }

        public static /* synthetic */ State copy$default(State state, Project project, PsiFile psiFile, VirtualFile virtualFile, Path path2, int n, Object object) {
            if ((n & 1) != 0) {
                project = state.project;
            }
            if ((n & 2) != 0) {
                psiFile = state.file;
            }
            if ((n & 4) != 0) {
                virtualFile = state.virtualFile;
            }
            if ((n & 8) != 0) {
                path2 = state.tempFile;
            }
            return state.copy(project, psiFile, virtualFile, path2);
        }

        @NotNull
        public String toString() {
            return "State(project=" + this.project + ", file=" + this.file + ", virtualFile=" + this.virtualFile + ", tempFile=" + this.tempFile + ")";
        }

        public int hashCode() {
            int result = this.project.hashCode();
            result = result * 31 + this.file.hashCode();
            result = result * 31 + this.virtualFile.hashCode();
            result = result * 31 + ((Object)this.tempFile).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)state.project)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.file, (Object)state.file)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.virtualFile, (Object)state.virtualFile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tempFile, (Object)state.tempFile);
        }
    }
}

