/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.concurrencyVisualizer.tool;

import com.intellij.python.concurrencyVisualizer.model.ConcurrencyGraphBlock;
import com.intellij.python.concurrencyVisualizer.model.ConcurrencyGraphPresentationModel;
import com.intellij.python.concurrencyVisualizer.tool.ConcurrencyGraphSettings;
import com.intellij.python.concurrencyVisualizer.tool.ConcurrencyRenderingUtil;
import com.intellij.python.concurrencyVisualizer.tool.panels.ConcurrencyToolWindowPanel;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConcurrencyGraphCellRenderer
extends ColoredTableCellRenderer {
    @NotNull
    private final ConcurrencyGraphPresentationModel myPresentationModel;
    private int myRow;
    private int myPadding;
    @NotNull
    private final JTable myTable;
    @NotNull
    private final ConcurrencyToolWindowPanel myPanel;
    private int mySelected;
    private ConcurrencyGraphBlock[] myGraph;
    private HashMap<Integer, Image> myImages;

    public ConcurrencyGraphCellRenderer(@NotNull ConcurrencyGraphPresentationModel presentationModel, @NotNull JTable table, @NotNull ConcurrencyToolWindowPanel panel2) {
        if (presentationModel == null) {
            ConcurrencyGraphCellRenderer.$$$reportNull$$$0(0);
        }
        if (table == null) {
            ConcurrencyGraphCellRenderer.$$$reportNull$$$0(1);
        }
        if (panel2 == null) {
            ConcurrencyGraphCellRenderer.$$$reportNull$$$0(2);
        }
        this.mySelected = -1;
        this.myPresentationModel = presentationModel;
        this.myTable = table;
        this.myPanel = panel2;
        this.myImages = new HashMap();
        this.myPresentationModel.registerListener(new ConcurrencyGraphPresentationModel.PresentationListener(){

            @Override
            public void graphChanged(int leftPadding) {
                ConcurrencyGraphCellRenderer.this.myPadding = leftPadding;
                ConcurrencyGraphCellRenderer.this.myTable.repaint();
            }
        });
    }

    public int getPadding() {
        return this.myPadding;
    }

    protected void paintComponent(@NotNull Graphics g) {
        Image imageForDrawing;
        if (g == null) {
            ConcurrencyGraphCellRenderer.$$$reportNull$$$0(3);
        }
        super.paintComponent(g);
        if (this.myGraph == null || this.myGraph != this.myPresentationModel.getVisibleGraph()) {
            this.myGraph = this.myPresentationModel.getVisibleGraph();
            this.myImages = new HashMap();
        }
        if (!this.myImages.containsKey(this.myRow)) {
            BufferedImage image = ImageUtil.createImage((Graphics)g, (int)this.myPresentationModel.getVisualSettings().getHorizontalExtent(), (int)ConcurrencyGraphSettings.TABLE_ROW_HEIGHT, (int)1);
            ConcurrencyRenderingUtil.paintRow(image, 0, this.myGraph, this.myRow, this.mySelected == this.myRow, this.myPresentationModel.getGraphModel().isLockSelected());
            this.myImages.put(this.myRow, image);
        }
        if ((imageForDrawing = this.myImages.get(this.myRow)) != null) {
            StartupUiUtil.drawImage((Graphics)g, (Image)imageForDrawing, (int)this.myPadding, (int)0, null);
        }
    }

    protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value2, boolean selected, boolean hasFocus, int row, int column) {
        if (table == null) {
            ConcurrencyGraphCellRenderer.$$$reportNull$$$0(4);
        }
        this.myRow = row;
        if (selected && this.mySelected != row) {
            this.myImages.remove(this.mySelected);
            this.myImages.remove(row);
            this.mySelected = row;
            table.repaint();
        }
        this.myPadding = this.myPresentationModel.getPadding();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationModel";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/concurrencyVisualizer/tool/ConcurrencyGraphCellRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "paintComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

