/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridTablesModelBuilder;
import com.intellij.database.datagrid.JdbcGridColumn;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModTable;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.util.Case;
import com.intellij.database.util.ColoredDdlBuilder;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.GridTablesModel;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.vfs.DatabaseElementSourceVirtualFileImpl;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlSynonymDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbSqlUtil
extends DbSqlUtilCore {
    private DbSqlUtil() {
    }

    public static boolean isSqlFileCoarse(VirtualFile file) {
        if (!DbSqlUtil.isSqlFileValid(file)) {
            return false;
        }
        try (AccessToken ignore = SlowOperations.knownIssue((String)"DBE-23680");){
            boolean bl = FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SqlFileType.INSTANCE);
            return bl;
        }
    }

    private static boolean isSqlFileValid(VirtualFile file) {
        if (file.isDirectory() || !file.isValid()) {
            return false;
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            if (file instanceof DatabaseElementSourceVirtualFileImpl && ((DatabaseElementSourceVirtualFileImpl)file).isBusy()) {
                return false;
            }
            ObjectKind kind = ((DatabaseElementVirtualFileImpl)file).getObjectKind();
            if (kind == ObjectKind.NONE || kind == ObjectKind.DATABASE || kind == ObjectKind.SCHEMA) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static Condition<VirtualFile> SQL_FILE_FILTER(@Nullable Project project) {
        if (project == null) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                DbSqlUtil.$$$reportNull$$$0(0);
            }
            return condition;
        }
        Condition condition = file -> {
            if (DbSqlUtil.isSqlFileCoarse(file)) {
                return true;
            }
            return DbSqlUtil.isSqlFileValid(file) && LanguageUtil.getLanguageFileType((Language)LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file)) == SqlFileType.INSTANCE;
        };
        if (condition == null) {
            DbSqlUtil.$$$reportNull$$$0(1);
        }
        return condition;
    }

    @NotNull
    public static String sql2Html(@NotNull Project project, @NotNull Language language, @NotNull CharSequence sequence) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(2);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(3);
        }
        if (sequence == null) {
            DbSqlUtil.$$$reportNull$$$0(4);
        }
        ColoredDdlBuilder colored = new ColoredDdlBuilder();
        DatabaseDialectEx dialect = language instanceof SqlLanguageDialect ? (DatabaseDialectEx)((SqlLanguageDialect)language).getDatabaseDialect() : DatabaseDialects.getGenericDialect();
        colored.withDialect(dialect);
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, null);
        Lexer lexer = highlighter.getHighlightingLexer();
        lexer.start(sequence);
        while (lexer.getTokenType() != null) {
            TextAttributesKey[] keys;
            boolean pushed = false;
            IElementType type = lexer.getTokenType();
            if (type != null && (keys = highlighter.getTokenHighlights(type)).length > 0) {
                pushed = true;
                colored.pushStyle(keys[0]);
            }
            colored.plain(StringUtil.escapeXmlEntities((String)lexer.getTokenText()));
            lexer.advance();
            if (!pushed) continue;
            colored.popStyle();
        }
        String string = colored.getStatement();
        if (string == null) {
            DbSqlUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static GridTablesModel getGridTablesModel(@NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource, @Nullable SearchPath searchPath, @Nullable String queryText, @Nullable SqlTableType resultType, @NotNull List<? extends GridColumn> columns) {
        boolean isSqlDialect;
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(6);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(7);
        }
        if (columns == null) {
            DbSqlUtil.$$$reportNull$$$0(8);
        }
        if (!ContainerUtil.all(columns, column -> column instanceof JdbcGridColumn)) {
            return null;
        }
        Dbms dbms = dataSource == null ? DbSqlUtil.getDbms((Language)language) : dataSource.getDbms();
        GridTablesModelBuilder gridTablesModelBuilder = new GridTablesModelBuilder();
        boolean usingSmartGridEditor = Registry.is((String)"database.editor.smartMode", (boolean)false);
        boolean bl = isSqlDialect = language instanceof SqlLanguageDialect && !dbms.isMongo() && !dbms.getDisplayName().equals("Redis");
        if (!isSqlDialect || !usingSmartGridEditor) {
            DasTable table = DbSqlUtil.detectTable(project, language, dataSource, searchPath, queryText, resultType, columns);
            if (table != null) {
                return gridTablesModelBuilder.buildForSingleTable((DasObject)table);
            }
            return null;
        }
        return gridTablesModelBuilder.build(dbms, project, language, dataSource, searchPath, queryText, resultType, columns);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static DasTable detectTable(@NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource, @Nullable SearchPath searchPath, @Nullable String queryText, @Nullable SqlTableType resultType, @NotNull List<? extends GridColumn> columns) {
        void var9_15;
        void var9_13;
        boolean checkMetadata;
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(9);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(10);
        }
        if (columns == null) {
            DbSqlUtil.$$$reportNull$$$0(11);
        }
        if (!ContainerUtil.all(columns, column -> column instanceof JdbcGridColumn)) {
            return null;
        }
        JdbcGridColumn tableColumn = null;
        if (!columns.isEmpty()) {
            for (GridColumn gridColumn : columns) {
                JdbcGridColumn c = (JdbcGridColumn)gridColumn;
                if (StringUtil.isNotEmpty((String)c.getTable()) && (tableColumn == null || Objects.equals(c.getCatalog(), tableColumn.getCatalog()) && Objects.equals(c.getSchema(), tableColumn.getSchema()) && Objects.equals(c.getTable(), tableColumn.getTable()))) {
                    tableColumn = c;
                    continue;
                }
                tableColumn = null;
                break;
            }
        }
        Dbms dbms = dataSource == null ? DbSqlUtil.getDbms((Language)language) : dataSource.getDbms();
        Object var9_10 = null;
        if (queryText != null) {
            DasTable dasTable;
            SqlTableType type = resultType != null ? resultType : DbSqlUtil.parseQueryTableType(project, language, dataSource, searchPath, queryText, null);
            PsiElement element = type == null ? null : type.getTypeElement();
            DasTable dasTable2 = dasTable = element instanceof DasTable ? (DasTable)element : null;
            if (dasTable == null && language instanceof SqlLanguageDialect && element instanceof SqlReferenceExpression) {
                SqlReferenceExpression ref = (SqlReferenceExpression)element;
                String name = ref.getReferencePart(ObjectKind.TABLE);
                String refSchema = ref.getReferencePart(ObjectKind.SCHEMA);
                String refCatalog = ref.getReferencePart(ObjectKind.DATABASE);
                String schema = refSchema.isEmpty() && tableColumn != null && tableColumn.getSchema() != null ? tableColumn.getSchema() : refSchema;
                String catalog = refCatalog.isEmpty() && tableColumn != null && tableColumn.getCatalog() != null ? tableColumn.getCatalog() : refCatalog;
                BasicModTable mt = DbSqlUtil.sqlCreateFakeTable(dbms, catalog, schema, name);
                if (mt != null) {
                    DasTypeSystemBase dtService = DasTypeSystems.getTypeSystem((Dbms)dbms);
                    for (GridColumn gridColumn : columns) {
                        BasicModTableOrViewColumn c = (BasicModTableOrViewColumn)mt.getColumns().renewAt((short)gridColumn.getColumnNumber(), gridColumn.getName());
                        String tn = gridColumn.getTypeName();
                        if (tn == null) continue;
                        c.setStoredType(dtService.createDasType(DataTypeFactory.of((String)tn)));
                    }
                    BasicModTable basicModTable = mt;
                }
            }
        }
        boolean bl = checkMetadata = language instanceof SqlLanguageDialect || !dbms.isMongo();
        if (checkMetadata && tableColumn != null && var9_13 != null && !DbSqlUtil.checkMetadata(dbms, (DasTable)var9_13, tableColumn)) {
            Object var9_14 = null;
        }
        return var9_15;
    }

    private static boolean checkMetadata(Dbms dbms, DasTable table, JdbcGridColumn tableColumn) {
        boolean checkTableName = !dbms.is(Dbms.GREENPLUM) && !dbms.is(Dbms.SQLITE) && !dbms.is(Dbms.MEMSQL) || table.getKind() != ObjectKind.VIEW;
        boolean metadataMayReturnDifferentCase = dbms.in(Dbms.MYSQL_LIKE);
        String schema = DasUtil.getSchema((DasObject)table);
        String catalog = DasUtil.getCatalog((DasObject)table);
        return (!checkTableName || DbSqlUtil.matches(tableColumn.getTable(), table.getName(), metadataMayReturnDifferentCase)) && DbSqlUtil.matches(tableColumn.getSchema(), schema, metadataMayReturnDifferentCase) && (catalog.isEmpty() || DbSqlUtil.matches(tableColumn.getCatalog(), catalog, metadataMayReturnDifferentCase));
    }

    @Nullable
    public static BasicModTable sqlCreateFakeTable(Dbms dbms, String catalog, String schema, String name) {
        BasicModModel model = ModelFactory.BLACK_HOLE.createModel(dbms);
        Ref res = Ref.create();
        model.modify(BasicModRoot.class, r -> {
            BasicModElement db = (BasicModElement)Objects.requireNonNullElse(DbSqlUtil.createChild((BasicModElement)r, ObjectKind.DATABASE, catalog), r);
            String scName = dbms.isMysql() && db.getKind() != ObjectKind.DATABASE ? StringUtil.notNullize((String)StringUtil.nullize((String)schema), (String)catalog) : schema;
            BasicModElement sc = DbSqlUtil.createChild(db, ObjectKind.SCHEMA, scName);
            res.set((Object)((BasicModTable)ObjectUtils.tryCast((Object)DbSqlUtil.createChild(sc, ObjectKind.TABLE, name), BasicModTable.class)));
        });
        return (BasicModTable)res.get();
    }

    @Nullable
    private static BasicModElement createChild(@Nullable BasicModElement p2, @NotNull ObjectKind kind, @Nullable String name) {
        ModFamily dbf;
        if (kind == null) {
            DbSqlUtil.$$$reportNull$$$0(12);
        }
        ModFamily modFamily = dbf = p2 == null ? null : p2.familyOf(kind);
        if (dbf == null) {
            return null;
        }
        BasicModElement db = dbf.createNewOne();
        if (name != null && db instanceof BasicModNamedElement) {
            BasicModNamedElement ne = (BasicModNamedElement)db;
            ne.setName(name);
        }
        return db;
    }

    private static boolean matches(@Nullable String jdbcName, @Nullable String modelName, boolean metadataMayReturnDifferentCase) {
        return StringUtil.isEmpty((String)jdbcName) || StringUtilRt.equal((CharSequence)modelName, (CharSequence)jdbcName, (!metadataMayReturnDifferentCase ? 1 : 0) != 0);
    }

    @NotNull
    public static List<DataConsumer.Column> createColumnsFromType(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @Nullable String catalog, @Nullable String schema, @NotNull String tableName) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(13);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(14);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(15);
        }
        if (tableName == null) {
            DbSqlUtil.$$$reportNull$$$0(16);
        }
        ArrayList<DataConsumer.Column> columns = new ArrayList<DataConsumer.Column>(type.getColumnCount());
        List<String> columnNames = DbSqlUtil.getUnambiguousColumnNames(project, dialect, type, null);
        int count = type.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String name = columnNames.get(i);
            String typeName = type.getColumnDasType(i).getDescription();
            columns.add(new DataConsumer.Column(i, name, 1111, typeName, null, 0, 0, catalog, schema, tableName));
        }
        ArrayList<DataConsumer.Column> arrayList = columns;
        if (arrayList == null) {
            DbSqlUtil.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(18);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(19);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(20);
        }
        List<String> columnNames = DbSqlUtil.getColumnNames(type);
        Set<String> duplicates = DbSqlUtil.getDuplicateNames(columnNames);
        DbSqlUtil.makeUnambiguousColumnNames(project, dialect, type, columnNames, duplicates, forceQualify);
        List<String> list = columnNames;
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public static List<String> getUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType partType, @NotNull SqlTableType fullType, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(22);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(23);
        }
        if (partType == null) {
            DbSqlUtil.$$$reportNull$$$0(24);
        }
        if (fullType == null) {
            DbSqlUtil.$$$reportNull$$$0(25);
        }
        List<String> partColumnNames = DbSqlUtil.getColumnNames(partType);
        List<String> fullColumnNames = DbSqlUtil.getColumnNames(fullType);
        Set<String> duplicates = DbSqlUtil.getDuplicateNames(fullColumnNames);
        DbSqlUtil.makeUnambiguousColumnNames(project, dialect, partType, partColumnNames, duplicates, forceQualify);
        List<String> list = partColumnNames;
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(26);
        }
        return list;
    }

    private static void makeUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @NotNull List<String> columnNames, @NotNull Set<String> duplicates, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(27);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(28);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(29);
        }
        if (columnNames == null) {
            DbSqlUtil.$$$reportNull$$$0(30);
        }
        if (duplicates == null) {
            DbSqlUtil.$$$reportNull$$$0(31);
        }
        DdlBuilder builder = new DdlBuilder(new StringBuilder()).configureBuilder(project, DbSqlUtil.getSqlDialect((DatabaseDialect)dialect)).withDialect(dialect);
        for (int i = 0; i < columnNames.size(); ++i) {
            String name = columnNames.get(i);
            String typeAlias = type.getColumnTypeAlias(i);
            if (typeAlias != null && (duplicates.contains(name) || forceQualify != null && ((Boolean)forceQualify.fun((Object)type, (Object)i)).booleanValue())) {
                builder.suppressQuoteIdentifiers(!type.isColumnTypeAliasQuoted(i));
                builder.columnRef(typeAlias).symbol(".");
            }
            builder.suppressQuoteIdentifiers(!type.isColumnQuoted(i));
            builder.columnRef(name);
            columnNames.set(i, builder.getStatement());
            builder.clear();
        }
    }

    private static List<String> getColumnNames(SqlTableType type) {
        ArrayList<String> columnNames = new ArrayList<String>(type.getColumnCount());
        for (int i = 0; i < type.getColumnCount(); ++i) {
            columnNames.add(StringUtil.notNullize((String)type.getColumnName(i)));
        }
        return columnNames;
    }

    private static Set<String> getDuplicateNames(List<String> names) {
        Set duplicates = CollectionFactory.createCaseInsensitiveStringSet();
        Set distinctNames = CollectionFactory.createCaseInsensitiveStringSet();
        for (String name : names) {
            if (distinctNames.add(name)) continue;
            duplicates.add(name);
        }
        return duplicates;
    }

    @Nullable
    public static SqlTableType parseQueryTableType(@NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String queryText, @Nullable Language hostLanguage) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(32);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(33);
        }
        if (queryText == null) {
            DbSqlUtil.$$$reportNull$$$0(34);
        }
        return ((EvaluationHelper)EvaluationHelper.EP.forLanguage(language)).parseQueryTableType(project, language, dataSource, searchPath, queryText, hostLanguage);
    }

    @Nullable
    public static SqlTableType parseQueryTableType(@NotNull JdbcConsoleBase console, @NotNull Language language, @NotNull String queryText) {
        if (console == null) {
            DbSqlUtil.$$$reportNull$$$0(35);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(36);
        }
        if (queryText == null) {
            DbSqlUtil.$$$reportNull$$$0(37);
        }
        return DbSqlUtil.parseQueryTableType(console.getProject(), language, DbSqlUtil.getDbDataSource((Project)console.getProject(), (DasDataSource)console.getDataSource()), console.getSearchPath(), queryText, null);
    }

    public static boolean isResultEditable(@Nullable GridDataRequest request2, SqlTableType tableType, GridTablesModel gridTablesModel) {
        DasObject[] tables;
        if (!(request2 instanceof DataRequest.QueryRequest)) {
            return false;
        }
        if (!(request2 instanceof ConsoleDataRequest)) {
            return true;
        }
        if (tableType == null) {
            return false;
        }
        PsiElement element = tableType.getTypeElement();
        if (element instanceof DasObject) {
            DasObject dasObject = (DasObject)element;
            DasObject[] dasObjectArray = new DasObject[1];
            v1 = dasObjectArray;
            dasObjectArray[0] = dasObject;
        } else {
            v1 = tables = gridTablesModel != null ? gridTablesModel.getDasTables() : null;
        }
        if (tables == null) {
            return false;
        }
        boolean resultEditable = true;
        for (DasObject table : tables) {
            resultEditable &= table != null && DbImplUtilCore.isDataTable((ObjectKind)table.getKind());
        }
        return resultEditable;
    }

    @Nullable
    public static IntrospectionScopeUpdater getScopeUpdater(@NotNull SyntaxTraverser<PsiElement> s, @Nullable ObjectPath ns, @NotNull DasModel model) {
        if (s == null) {
            DbSqlUtil.$$$reportNull$$$0(38);
        }
        if (model == null) {
            DbSqlUtil.$$$reportNull$$$0(39);
        }
        IntrospectionScopeUpdater res = null;
        ObjectPath db = ns != null ? DbSqlUtil.getCurrentDatabase(ns) : DbSqlUtil.getCurrentDatabase(model);
        for (SqlStatement statement : s.filter(SqlStatement.class)) {
            ObjectKind kind;
            SqlDropStatement dropStatement;
            SqlReferenceExpression expression;
            ObjectPath objectName;
            if (statement instanceof SqlAlterStatement) {
                for (SqlSynonymDefinition synonymDefinition : SyntaxTraverser.psiApi().children((Object)statement).filter(SqlSynonymDefinition.class)) {
                    ObjectKind kind2 = synonymDefinition.getKind();
                    if (kind2 != ObjectKind.DATABASE && kind2 != ObjectKind.SCHEMA) continue;
                    SqlNameElement newName = synonymDefinition.getNameElement();
                    SqlReferenceExpression oldName = synonymDefinition.getTargetReference();
                    if (newName == null || oldName == null) continue;
                    if (res == null) {
                        res = new IntrospectionScopeUpdater();
                    }
                    ObjectPath parent = kind2 == ObjectKind.SCHEMA ? db : null;
                    ObjectPath oldObjectName = ObjectPath.create((String)oldName.getName(), (ObjectKind)kind2, (boolean)oldName.isQuotedIdentifier(), null, (ObjectPath)parent);
                    ObjectPath newObjectName = ObjectPath.create((String)newName.getName(), (ObjectKind)kind2, (boolean)newName.isQuotedIdentifier(), null, (ObjectPath)parent);
                    res.toRemove(oldObjectName);
                    res.toAdd(newObjectName);
                }
                continue;
            }
            if (statement instanceof SqlCreateStatement) {
                SqlNameElement element;
                SqlCreateStatement createStatement = (SqlCreateStatement)statement;
                ObjectKind kind3 = createStatement.getKind();
                if (kind3 != ObjectKind.DATABASE && kind3 != ObjectKind.SCHEMA || (element = createStatement.getNameElement()) == null) continue;
                if (res == null) {
                    res = new IntrospectionScopeUpdater();
                }
                objectName = ObjectPath.create((String)element.getName(), (ObjectKind)kind3, (boolean)element.isQuotedIdentifier(), null, (ObjectPath)(kind3 == ObjectKind.SCHEMA ? db : null));
                res.toAdd(objectName);
                continue;
            }
            if (!(statement instanceof SqlDropStatement) || (expression = (dropStatement = (SqlDropStatement)statement).getTargetExpression()) == null || (kind = expression.getReferenceElementType().getTargetKind()) != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) continue;
            if (res == null) {
                res = new IntrospectionScopeUpdater();
            }
            objectName = ObjectPath.create((String)expression.getName(), (ObjectKind)kind, (boolean)expression.isQuotedIdentifier(), null, (ObjectPath)(kind == ObjectKind.SCHEMA ? db : null));
            res.toRemove(objectName);
        }
        return res;
    }

    @Nullable
    public static ObjectPath getCurrentDatabase(@NotNull DasModel model) {
        DasNamespace cur;
        if (model == null) {
            DbSqlUtil.$$$reportNull$$$0(40);
        }
        if ((cur = model.getCurrentRootNamespace()) == null) {
            Iterator it = model.getModelRoots().filter(DasNamespace.class).iterator();
            if (!it.hasNext()) {
                return null;
            }
            cur = (DasNamespace)it.next();
            if (it.hasNext()) {
                return null;
            }
        }
        return cur.getKind() == ObjectKind.DATABASE ? ObjectPaths.of((DasObject)cur) : null;
    }

    @Nullable
    private static ObjectPath getCurrentDatabase(@NotNull ObjectPath ns) {
        if (ns == null) {
            DbSqlUtil.$$$reportNull$$$0(41);
        }
        return ns.findParent(ObjectKind.DATABASE, false);
    }

    public static boolean isSqlElement(@NotNull DbElement element) {
        DbDataSource dataSource;
        if (element == null) {
            DbSqlUtil.$$$reportNull$$$0(42);
        }
        return element != (dataSource = element.getDataSource()) && dataSource.getDelegate() instanceof SqlDataSource;
    }

    @Nullable
    public static DasObject getSqlSourceElement(@Nullable DbElement element) {
        DasObject dasObject;
        DasObject dasObject2 = dasObject = element == null ? null : (DasObject)ObjectUtils.tryCast((Object)element.getDelegate(), DasObject.class);
        if (dasObject == null) {
            return null;
        }
        return DbSqlUtil.getSqlSourceElement(element.getDataSource(), dasObject);
    }

    @Nullable
    public static DasObject getSqlSourceElement(@Nullable DbDataSource dataSource, @Nullable DasObject dasObject) {
        if (dataSource == null || dasObject == null) {
            return null;
        }
        SqlDataSource source = (SqlDataSource)ObjectUtils.tryCast((Object)dataSource.getDelegate(), SqlDataSource.class);
        return source == null ? null : source.fromModel(dasObject);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull DatabaseDialect dialect) {
        SqlLanguageDialect res;
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(43);
        }
        SqlLanguageDialect sqlLanguageDialect = (res = DbSqlUtil.findSqlDialect((DatabaseDialect)dialect)) == null ? SqlDialects.getGenericDialect() : res;
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(44);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static Language getLanguage(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtil.$$$reportNull$$$0(45);
        }
        Object object = dbms == Dbms.MONGO ? MongoJSLanguage.INSTANCE : DbSqlUtil.getSqlDialect((Dbms)dbms);
        if (object == null) {
            DbSqlUtil.$$$reportNull$$$0(46);
        }
        return object;
    }

    @NotNull
    public static Language getLanguage(@Nullable DbDataSource dataSource) {
        Language language = dataSource == null ? null : dataSource.getQueryLanguage();
        Object object = language == null ? SqlDialects.getGenericDialect() : language;
        if (object == null) {
            DbSqlUtil.$$$reportNull$$$0(47);
        }
        return object;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DatabaseDriver driver) {
        SqlLanguageDialect dialect = DbSqlUtil.findSqlDialect(driver);
        SqlLanguageDialect sqlLanguageDialect = dialect == null ? SqlDialects.getGenericDialect() : dialect;
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(48);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@Nullable DatabaseDriver driver) {
        if (driver == null) {
            return null;
        }
        String dialectId = driver.getSqlDialect();
        SqlLanguageDialect result = StringUtil.isEmpty((String)dialectId) ? null : SqlDialects.findDialectById((String)dialectId);
        return result != null ? result : DbSqlUtil.getSqlDialect((Dbms)DbImplUtilCore.getDbms((DatabaseDriver)driver));
    }

    @Deprecated(forRemoval=true)
    public static boolean areKeywordsLowerCase(@Nullable Project project) {
        SqlCodeStyleSettings codeStyleSettings = SqlCodeStyles.getGeneralSqlSettings((Project)project);
        Case keywordCaseMode = codeStyleSettings.getKeywordCase();
        return keywordCaseMode == Case.LOWER || keywordCaseMode == Case.MIXED;
    }

    public static boolean areKeywordsLowerCase(@Nullable Project project, @NotNull Language dialect) {
        SqlCodeStyleSettings codeStyleSettings;
        Case keywordCaseMode;
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(49);
        }
        return (keywordCaseMode = (codeStyleSettings = SqlCodeStyles.getSqlSettings((Project)project, (Language)dialect)).getKeywordCase()) == Case.LOWER || keywordCaseMode == Case.MIXED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 22, 23, 24, 25, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 49 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbSqlUtil";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 22: 
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 14: 
            case 19: 
            case 23: 
            case 28: 
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 15: 
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "SQL_FILE_FILTER";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbSqlUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sql2Html";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumnsFromType";
                break;
            }
            case 21: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnambiguousColumnNames";
                break;
            }
            case 44: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sql2Html";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGridTablesModel";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "detectTable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createChild";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createColumnsFromType";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getUnambiguousColumnNames";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "makeUnambiguousColumnNames";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "parseQueryTableType";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getScopeUpdater";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentDatabase";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isSqlElement";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "areKeywordsLowerCase";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 22, 23, 24, 25, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 49 -> new IllegalArgumentException(string);
        };
    }
}

